/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.api.computer.IMultiBlockCoreOrController;
import cr0s.warpdrive.block.ItemBlockAbstractBase;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ItemBlockController
extends ItemBlockAbstractBase {
    public ItemBlockController(Block block) {
        super(block, false, false);
        this.func_77625_d(1);
    }

    protected static String getName(@Nonnull ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemBlockController)) {
            return "";
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            return "";
        }
        String name = tagCompound.func_74779_i("name");
        UUID uuid = new UUID(tagCompound.func_74763_f("uuidMost"), tagCompound.func_74763_f("uuidLeast"));
        if (uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() == 0L) {
            return "";
        }
        return name;
    }

    @Nullable
    protected static UUID getSignature(@Nonnull ItemStack itemStack) {
        if (!(itemStack.func_77973_b() instanceof ItemBlockController)) {
            return null;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        UUID uuid = new UUID(tagCompound.func_74763_f("uuidMost"), tagCompound.func_74763_f("uuidLeast"));
        if (uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() == 0L) {
            return null;
        }
        return uuid;
    }

    protected static ItemStack setNameAndSignature(@Nonnull ItemStack itemStack, @Nullable String name, @Nullable UUID uuid) {
        if (!(itemStack.func_77973_b() instanceof ItemBlockController)) {
            return itemStack;
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (name == null || name.isEmpty()) {
            tagCompound.func_82580_o("name");
        } else {
            tagCompound.func_74778_a("name", name);
        }
        if (uuid == null || uuid.getMostSignificantBits() == 0L && uuid.getLeastSignificantBits() == 0L) {
            tagCompound.func_82580_o("uuidMost");
            tagCompound.func_82580_o("uuidLeast");
        } else {
            tagCompound.func_74772_a("uuidMost", uuid.getMostSignificantBits());
            tagCompound.func_74772_a("uuidLeast", uuid.getLeastSignificantBits());
        }
        itemStack.func_77982_d(tagCompound);
        return itemStack;
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer entityPlayer, @Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        ItemStack itemStackHeld = entityPlayer.func_184586_b(hand);
        if (itemStackHeld.func_190926_b()) {
            return EnumActionResult.FAIL;
        }
        IBlockState blockState = world.func_180495_p(blockPos);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (!(tileEntity instanceof IMultiBlockCoreOrController)) {
            return super.func_180614_a(entityPlayer, world, blockPos, hand, facing, hitX, hitY, hitZ);
        }
        if (!entityPlayer.func_175151_a(blockPos, facing, itemStackHeld)) {
            return EnumActionResult.FAIL;
        }
        UUID uuidSignatureFromItem = ItemBlockController.getSignature(itemStackHeld);
        String nameSignatureFromItem = ItemBlockController.getName(itemStackHeld);
        UUID uuidSignatureFromBlock = ((IMultiBlockCoreOrController)tileEntity).getSignatureUUID();
        String nameSignatureFromBlock = ((IMultiBlockCoreOrController)tileEntity).getSignatureName();
        String nameItem = itemStackHeld.func_82833_r();
        String nameBlock = Commons.format(blockState, world, blockPos);
        if (entityPlayer.func_70093_af()) {
            if (uuidSignatureFromBlock == null || nameSignatureFromBlock == null || nameSignatureFromBlock.isEmpty()) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.core_signature.get_missing", null, nameItem, nameBlock));
            } else if (uuidSignatureFromBlock.equals(uuidSignatureFromItem)) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.core_signature.get_same", nameSignatureFromItem, nameItem, nameBlock));
            } else {
                ItemStack itemStackNew = ItemBlockController.setNameAndSignature(itemStackHeld, nameSignatureFromBlock, uuidSignatureFromBlock);
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.core_signature.get", nameSignatureFromBlock, nameItem, nameBlock));
                world.func_184134_a(entityPlayer.field_70165_t + 0.5, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v + 0.5, SoundEvents.field_187942_hp, SoundCategory.PLAYERS, 1.0f, 1.8f + 0.2f * world.field_73012_v.nextFloat(), false);
            }
        } else if (uuidSignatureFromItem == null) {
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.core_signature.set_missing", null, nameItem, nameBlock));
        } else if (uuidSignatureFromItem.equals(uuidSignatureFromBlock)) {
            Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.core_signature.set_same", nameSignatureFromItem, nameItem, nameBlock));
        } else {
            boolean isSuccess = ((IMultiBlockCoreOrController)tileEntity).setSignature(uuidSignatureFromItem, nameSignatureFromItem);
            if (isSuccess) {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.core_signature.set", nameSignatureFromItem, nameItem, nameBlock));
                world.func_184134_a(entityPlayer.field_70165_t + 0.5, entityPlayer.field_70163_u + 0.5, entityPlayer.field_70161_v + 0.5, SoundEvents.field_187941_ho, SoundCategory.PLAYERS, 1.0f, 1.2f + 0.2f * world.field_73012_v.nextFloat(), false);
            } else {
                Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)new WarpDriveText(Commons.getStyleWarning(), "warpdrive.core_signature.set_not_supported", null, nameItem, nameBlock));
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

