/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.block.BlockSecurityStation;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

class ShipScanner {
    private final IBlockAccess blockAccess;
    private final int minX;
    private final int minY;
    private final int minZ;
    private final int maxX;
    private final int maxY;
    private final int maxZ;
    private int x;
    private int y;
    private int z;
    private final BlockPos.MutableBlockPos mutableBlockPos;
    public int mass = 0;
    public int volume = 0;
    public BlockPos posSecurityStation = null;

    ShipScanner(IBlockAccess blockAccess, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.blockAccess = blockAccess;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.x = this.minX;
        this.y = this.minY;
        this.z = this.minZ;
        this.mutableBlockPos = new BlockPos.MutableBlockPos(this.x, this.y, this.z);
    }

    boolean tick() {
        int countBlocks = 0;
        try {
            while (countBlocks < WarpDriveConfig.SHIP_VOLUME_SCAN_BLOCKS_PER_TICK) {
                this.mutableBlockPos.func_181079_c(this.x, this.y, this.z);
                Block block = this.blockAccess.func_180495_p((BlockPos)this.mutableBlockPos).func_177230_c();
                ++countBlocks;
                if (block != Blocks.field_150350_a && !Dictionary.BLOCKS_LEFTBEHIND.contains(block)) {
                    ++this.volume;
                    if (!Dictionary.BLOCKS_NOMASS.contains(block)) {
                        ++this.mass;
                        if (block instanceof BlockSecurityStation) {
                            this.posSecurityStation = this.mutableBlockPos.func_185334_h();
                        }
                    }
                }
                ++this.y;
                if (this.y <= this.maxY) continue;
                this.y = this.minY;
                ++this.z;
                if (this.z <= this.maxZ) continue;
                this.z = this.minZ;
                ++this.x;
                if (this.x <= this.maxX) continue;
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
        }
        return false;
    }
}

