/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.api.computer.IMultiBlockCore;
import cr0s.warpdrive.api.computer.IShipController;
import cr0s.warpdrive.block.TileEntityAbstractEnergyCoreOrController;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumShipCommand;
import cr0s.warpdrive.data.VectorI;
import javax.annotation.Nonnull;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraftforge.fml.common.Optional;

public abstract class TileEntityAbstractShipController
extends TileEntityAbstractEnergyCoreOrController
implements IShipController {
    private int front;
    private int right;
    private int up;
    private int back;
    private int left;
    private int down;
    private int moveFront = 0;
    private int moveUp = 0;
    private int moveRight = 0;
    private byte rotationSteps = 0;
    protected String nameTarget = "";
    protected EnumShipCommand enumShipCommand = EnumShipCommand.IDLE;
    protected boolean isCommandConfirmed = false;

    public TileEntityAbstractShipController() {
        this.addMethods(new String[]{"getOrientation", "isInSpace", "isInHyperspace", "dim_positive", "dim_negative", "command", "getShipSize", "getMaxJumpDistance", "movement", "rotationSteps", "targetName"});
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.setFront(tagCompound.func_74762_e("front"));
        this.setRight(tagCompound.func_74762_e("right"));
        this.setUp(tagCompound.func_74762_e("up"));
        this.setBack(tagCompound.func_74762_e("back"));
        this.setLeft(tagCompound.func_74762_e("left"));
        this.setDown(tagCompound.func_74762_e("down"));
        this.setMovement(tagCompound.func_74762_e("moveFront"), tagCompound.func_74762_e("moveUp"), tagCompound.func_74762_e("moveRight"));
        this.setRotationSteps(tagCompound.func_74771_c("rotationSteps"));
        this.nameTarget = tagCompound.func_74779_i("nameTarget");
        boolean isConfirmed = tagCompound.func_74764_b("commandConfirmed") && tagCompound.func_74767_n("commandConfirmed");
        this.setCommand(tagCompound.func_74779_i("commandName"), isConfirmed);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("front", this.getFront());
        tagCompound.func_74768_a("right", this.getRight());
        tagCompound.func_74768_a("up", this.getUp());
        tagCompound.func_74768_a("back", this.getBack());
        tagCompound.func_74768_a("left", this.getLeft());
        tagCompound.func_74768_a("down", this.getDown());
        tagCompound.func_74768_a("moveFront", this.moveFront);
        tagCompound.func_74768_a("moveUp", this.moveUp);
        tagCompound.func_74768_a("moveRight", this.moveRight);
        tagCompound.func_74774_a("rotationSteps", this.rotationSteps);
        tagCompound.func_74778_a("nameTarget", this.nameTarget);
        tagCompound.func_74778_a("commandName", this.enumShipCommand.func_176610_l());
        tagCompound.func_74757_a("commandConfirmed", this.isCommandConfirmed);
        return tagCompound;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = super.func_189517_E_();
        tagCompound.func_74768_a("moveFront", this.moveFront);
        tagCompound.func_74768_a("moveUp", this.moveUp);
        tagCompound.func_74768_a("moveRight", this.moveRight);
        tagCompound.func_74774_a("rotationSteps", this.rotationSteps);
        return tagCompound;
    }

    @Override
    public void onDataPacket(@Nonnull NetworkManager networkManager, @Nonnull SPacketUpdateTileEntity packet) {
        super.onDataPacket(networkManager, packet);
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.setMovement(tagCompound.func_74762_e("moveFront"), tagCompound.func_74762_e("moveUp"), tagCompound.func_74762_e("moveRight"));
        this.setRotationSteps(tagCompound.func_74771_c("rotationSteps"));
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        tagCompound.func_82580_o("front");
        tagCompound.func_82580_o("right");
        tagCompound.func_82580_o("up");
        tagCompound.func_82580_o("back");
        tagCompound.func_82580_o("left");
        tagCompound.func_82580_o("down");
        tagCompound.func_82580_o("moveFront");
        tagCompound.func_82580_o("moveUp");
        tagCompound.func_82580_o("moveRight");
        tagCompound.func_82580_o("rotationSteps");
        tagCompound.func_82580_o("nameTarget");
        tagCompound.func_82580_o("commandName");
        tagCompound.func_82580_o("commandConfirmed");
        return tagCompound;
    }

    protected void cooldownDone() {
        this.sendEvent("shipCoreCooldownDone", new Object[0]);
    }

    public EnumShipCommand getCommand() {
        return this.enumShipCommand;
    }

    protected void setCommand(String command, boolean isConfirmed) {
        for (EnumShipCommand enumShipCommand : EnumShipCommand.values()) {
            if (!enumShipCommand.name().equalsIgnoreCase(command)) continue;
            this.isCommandConfirmed = false;
            this.enumShipCommand = enumShipCommand;
            this.isCommandConfirmed = isConfirmed;
            this.func_70296_d();
            if (!WarpDriveConfig.LOGGING_LUA || !this.func_145830_o() || this.field_145850_b.field_72995_K) break;
            WarpDrive.logger.info(String.format("%s Command set to %s (%s)", new Object[]{this, this.enumShipCommand, this.isCommandConfirmed}));
            break;
        }
    }

    protected void commandDone(boolean success, WarpDriveText reason) {
        this.isCommandConfirmed = false;
        this.enumShipCommand = EnumShipCommand.IDLE;
    }

    protected int getFront() {
        return this.front;
    }

    private void setFront(int front) {
        this.front = front;
        this.markDirtyParameters();
    }

    protected int getRight() {
        return this.right;
    }

    private void setRight(int right) {
        this.right = right;
        this.markDirtyParameters();
    }

    protected int getUp() {
        return this.up;
    }

    private void setUp(int up) {
        this.up = up;
        this.markDirtyParameters();
    }

    protected int getBack() {
        return this.back;
    }

    private void setBack(int back) {
        this.back = back;
        this.markDirtyParameters();
    }

    protected int getLeft() {
        return this.left;
    }

    private void setLeft(int left) {
        this.left = left;
        this.markDirtyParameters();
    }

    protected int getDown() {
        return this.down;
    }

    private void setDown(int down) {
        this.down = down;
        this.markDirtyParameters();
    }

    protected VectorI getMovement() {
        return new VectorI(this.moveFront, this.moveUp, this.moveRight);
    }

    protected void setMovement(int moveFront, int moveUp, int moveRight) {
        this.moveFront = moveFront;
        this.moveUp = moveUp;
        this.moveRight = moveRight;
        this.func_70296_d();
    }

    protected byte getRotationSteps() {
        return this.rotationSteps;
    }

    private void setRotationSteps(byte rotationSteps) {
        this.rotationSteps = (byte)((rotationSteps + 4) % 4);
        this.func_70296_d();
    }

    @Override
    public void onCoreUpdated(@Nonnull IMultiBlockCore multiblockCore) {
        super.onCoreUpdated(multiblockCore);
        assert (multiblockCore instanceof TileEntityShipCore);
        TileEntityShipCore tileEntityShipCore = (TileEntityShipCore)multiblockCore;
        this.front = tileEntityShipCore.getFront();
        this.right = tileEntityShipCore.getRight();
        this.up = tileEntityShipCore.getUp();
        this.back = tileEntityShipCore.getBack();
        this.left = tileEntityShipCore.getLeft();
        this.down = tileEntityShipCore.getDown();
    }

    String getTargetName() {
        return this.nameTarget;
    }

    @Override
    public abstract Object[] getOrientation();

    @Override
    public abstract Object[] isInSpace();

    @Override
    public abstract Object[] isInHyperspace();

    @Override
    public Object[] dim_positive(Object[] arguments) {
        block3: {
            try {
                if (arguments != null && arguments.length == 3) {
                    int argInt0 = Commons.clamp(0, WarpDriveConfig.SHIP_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()], Math.abs(Commons.toInt(arguments[0])));
                    int argInt1 = Commons.clamp(0, WarpDriveConfig.SHIP_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()], Math.abs(Commons.toInt(arguments[1])));
                    int argInt2 = Commons.clamp(0, WarpDriveConfig.SHIP_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()], Math.abs(Commons.toInt(arguments[2])));
                    this.setFront(argInt0);
                    this.setRight(argInt1);
                    this.setUp(Math.min(255 - this.field_174879_c.func_177956_o(), argInt2));
                }
            }
            catch (Exception exception) {
                if (!WarpDriveConfig.LOGGING_LUA) break block3;
                WarpDrive.logger.info(String.format("%s Invalid arguments to dim_positive(): %s", this, Commons.format(arguments)));
            }
        }
        return new Integer[]{this.getFront(), this.getRight(), this.getUp()};
    }

    @Override
    public Object[] dim_negative(Object[] arguments) {
        block3: {
            try {
                if (arguments != null && arguments.length == 3) {
                    int argInt0 = Commons.clamp(0, WarpDriveConfig.SHIP_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()], Math.abs(Commons.toInt(arguments[0])));
                    int argInt1 = Commons.clamp(0, WarpDriveConfig.SHIP_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()], Math.abs(Commons.toInt(arguments[1])));
                    int argInt2 = Commons.clamp(0, WarpDriveConfig.SHIP_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()], Math.abs(Commons.toInt(arguments[2])));
                    this.setBack(argInt0);
                    this.setLeft(argInt1);
                    this.setDown(Math.min(this.field_174879_c.func_177956_o(), argInt2));
                }
            }
            catch (Exception exception) {
                if (!WarpDriveConfig.LOGGING_LUA) break block3;
                WarpDrive.logger.info(String.format("%s Invalid arguments to dim_negative(): %s", this, Commons.format(arguments)));
            }
        }
        return new Integer[]{this.getBack(), this.getLeft(), this.getDown()};
    }

    @Override
    public Object[] command(Object[] arguments) {
        try {
            if (arguments.length == 2 && arguments[0] != null) {
                this.setCommand(arguments[0].toString(), Commons.toBool(arguments[1]));
            }
        }
        catch (Exception exception) {
            return new Object[]{this.enumShipCommand.toString()};
        }
        return new Object[]{this.enumShipCommand.toString()};
    }

    @Override
    public abstract Object[] getShipSize();

    @Override
    public Object[] movement(Object[] arguments) {
        try {
            if (arguments.length == 3) {
                this.setMovement(Commons.toInt(arguments[0]), Commons.toInt(arguments[1]), Commons.toInt(arguments[2]));
            }
        }
        catch (Exception exception) {
            return new Integer[]{this.moveFront, this.moveUp, this.moveRight};
        }
        return new Integer[]{this.moveFront, this.moveUp, this.moveRight};
    }

    @Override
    public abstract Object[] getMaxJumpDistance();

    @Override
    public Object[] rotationSteps(Object[] arguments) {
        try {
            if (arguments.length == 1 && arguments[0] != null) {
                this.setRotationSteps((byte)Commons.toInt(arguments[0]));
            }
        }
        catch (Exception exception) {
            return new Integer[]{this.rotationSteps};
        }
        return new Integer[]{this.rotationSteps};
    }

    @Override
    public Object[] targetName(Object[] arguments) {
        if (arguments.length == 1 && arguments[0] != null) {
            this.nameTarget = (String)arguments[0];
        }
        return new Object[]{this.nameTarget};
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getOrientation(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getOrientation();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] isInSpace(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.isInSpace();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] isInHyperspace(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.isInHyperspace();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] dim_positive(Context context, Arguments arguments) {
        return this.dim_positive(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] dim_negative(Context context, Arguments arguments) {
        return this.dim_negative(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] command(Context context, Arguments arguments) {
        return this.command(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getShipSize(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getShipSize();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] getMaxJumpDistance(Context context, Arguments arguments) {
        this.OC_convertArgumentsAndLogCall(context, arguments);
        return this.getMaxJumpDistance();
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] movement(Context context, Arguments arguments) {
        return this.movement(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] rotationSteps(Context context, Arguments arguments) {
        return this.rotationSteps(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Callback(direct=true)
    @Optional.Method(modid="opencomputers")
    public Object[] targetName(Context context, Arguments arguments) {
        return this.targetName(this.OC_convertArgumentsAndLogCall(context, arguments));
    }

    @Override
    @Optional.Method(modid="computercraft")
    protected Object[] CC_callMethod(@Nonnull String methodName, @Nonnull Object[] arguments) {
        switch (methodName) {
            case "getOrientation": {
                return this.getOrientation();
            }
            case "isInSpace": {
                return this.isInSpace();
            }
            case "isInHyperspace": {
                return this.isInHyperspace();
            }
            case "dim_positive": {
                return this.dim_positive(arguments);
            }
            case "dim_negative": {
                return this.dim_negative(arguments);
            }
            case "command": {
                return this.command(arguments);
            }
            case "getShipSize": {
                return this.getShipSize();
            }
            case "getMaxJumpDistance": {
                return this.getMaxJumpDistance();
            }
            case "movement": {
                return this.movement(arguments);
            }
            case "rotationSteps": {
                return this.rotationSteps(arguments);
            }
            case "targetName": {
                return this.targetName(arguments);
            }
        }
        return super.CC_callMethod(methodName, arguments);
    }
}

