/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IGlobalRegionProvider;
import cr0s.warpdrive.block.TileEntityAbstractEnergyCoreOrController;
import cr0s.warpdrive.block.movement.JumpGateScanner;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.render.EntityFXBoundingBox;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityJumpGateCore
extends TileEntityAbstractEnergyCoreOrController
implements IGlobalRegionProvider {
    private static final int BOUNDING_BOX_INTERVAL_TICKS = 60;
    private int maxX;
    private int maxY;
    private int maxZ;
    private int minX;
    private int minY;
    private int minZ;
    protected boolean showBoundingBox = false;
    private int ticksBoundingBoxUpdate = 0;
    private long timeLastScanDone = -1L;
    private JumpGateScanner jumpGateScanner = null;
    public int volume;
    public double occupancy;

    public TileEntityJumpGateCore() {
        this.peripheralName = "warpdriveJumpGate";
    }

    @SideOnly(value=Side.CLIENT)
    private void doShowBoundingBox() {
        --this.ticksBoundingBoxUpdate;
        if (this.ticksBoundingBoxUpdate > 0) {
            return;
        }
        this.ticksBoundingBoxUpdate = 60;
        Vector3 vector3 = new Vector3(this);
        vector3.translate(0.5);
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)new EntityFXBoundingBox(this.field_145850_b, vector3, new Vector3((double)this.minX - 0.0, (double)this.minY - 0.0, (double)this.minZ - 0.0), new Vector3((double)this.maxX + 1.0, (double)this.maxY + 1.0, (double)this.maxZ + 1.0), 1.0f, 0.8f, 0.3f, 61));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            if (this.showBoundingBox) {
                this.doShowBoundingBox();
            }
            return;
        }
        if (this.timeLastScanDone <= 0L) {
            this.timeLastScanDone = this.field_145850_b.func_82737_E();
            this.jumpGateScanner = new JumpGateScanner((IBlockAccess)this.field_145850_b, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info(String.format("%s scanning started", this));
            }
        }
        if (this.jumpGateScanner != null) {
            if (!this.jumpGateScanner.tick()) {
                return;
            }
            this.volume = this.maxX - this.minX * this.maxY - this.minY * this.maxZ - this.minZ;
            this.occupancy = (float)this.volume / (float)this.jumpGateScanner.volumeUsed;
            this.jumpGateScanner = null;
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info(String.format("%s scanning done: volume %d, occupancy %.3f", this, this.volume, this.occupancy));
            }
        }
    }

    @Override
    protected void doUpdateParameters(boolean isDirty) {
    }

    public boolean isBusy() {
        return this.timeLastScanDone < 0L || this.jumpGateScanner != null;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.minX = tagCompound.func_74762_e("minX");
        this.maxX = tagCompound.func_74762_e("maxX");
        this.minY = tagCompound.func_74762_e("minY");
        this.maxY = tagCompound.func_74762_e("maxY");
        this.minZ = tagCompound.func_74762_e("minZ");
        this.maxZ = tagCompound.func_74762_e("maxZ");
        this.volume = tagCompound.func_74762_e("volume");
        this.occupancy = tagCompound.func_74769_h("occupancy");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("minX", this.minX);
        tagCompound.func_74768_a("maxX", this.maxX);
        tagCompound.func_74768_a("minY", this.minY);
        tagCompound.func_74768_a("maxY", this.maxY);
        tagCompound.func_74768_a("minZ", this.minZ);
        tagCompound.func_74768_a("maxZ", this.maxZ);
        tagCompound.func_74768_a("volume", this.volume);
        tagCompound.func_74780_a("occupancy", this.occupancy);
        return tagCompound;
    }

    @Override
    public EnumGlobalRegionType getGlobalRegionType() {
        return EnumGlobalRegionType.JUMP_GATE;
    }

    @Override
    public AxisAlignedBB getGlobalRegionArea() {
        return new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
    }

    @Override
    public int getMass() {
        return this.volume;
    }

    @Override
    public double getIsolationRate() {
        return 0.0;
    }

    @Override
    public boolean onBlockUpdatingInArea(@Nullable Entity entity, BlockPos blockPos, IBlockState blockState) {
        return true;
    }

    @Override
    public Object[] getEnergyRequired() {
        return new Object[0];
    }

    public Object[] area(Object[] arguments) {
        block4: {
            try {
                if (arguments != null && arguments.length == 6) {
                    int sizeMax = WarpDriveConfig.JUMP_GATE_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()];
                    int minX_new = Commons.clamp(this.field_174879_c.func_177958_n() - sizeMax, this.field_174879_c.func_177958_n() + sizeMax, Math.abs(Commons.toInt(arguments[0])));
                    int minY_new = Commons.clamp(this.field_174879_c.func_177956_o() - sizeMax, this.field_174879_c.func_177956_o() + sizeMax, Math.abs(Commons.toInt(arguments[1])));
                    int minZ_new = Commons.clamp(this.field_174879_c.func_177952_p() - sizeMax, this.field_174879_c.func_177952_p() + sizeMax, Math.abs(Commons.toInt(arguments[2])));
                    int maxX_new = Commons.clamp(this.field_174879_c.func_177958_n() - sizeMax, this.field_174879_c.func_177958_n() + sizeMax, Math.abs(Commons.toInt(arguments[3])));
                    int maxY_new = Commons.clamp(this.field_174879_c.func_177956_o() - sizeMax, this.field_174879_c.func_177956_o() + sizeMax, Math.abs(Commons.toInt(arguments[4])));
                    int maxZ_new = Commons.clamp(this.field_174879_c.func_177952_p() - sizeMax, this.field_174879_c.func_177952_p() + sizeMax, Math.abs(Commons.toInt(arguments[5])));
                    if (minX_new != this.minX || minY_new != this.minY || minZ_new != this.minZ || maxX_new != this.maxX || maxY_new != this.maxY || maxZ_new != this.maxZ) {
                        this.minX = minX_new;
                        this.minY = minY_new;
                        this.minZ = minZ_new;
                        this.maxX = maxX_new;
                        this.maxY = maxY_new;
                        this.maxZ = maxZ_new;
                        this.timeLastScanDone = -1L;
                        this.jumpGateScanner = null;
                    }
                }
            }
            catch (Exception exception) {
                if (!WarpDriveConfig.LOGGING_LUA) break block4;
                WarpDrive.logger.info(String.format("%s Invalid arguments to area(): %s", this, Commons.format(arguments)));
            }
        }
        return new Integer[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ};
    }
}

