/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.movement.BlockShipController;
import cr0s.warpdrive.block.movement.TileEntityAbstractShipController;
import cr0s.warpdrive.block.movement.TileEntityShipCore;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.GlobalRegion;
import cr0s.warpdrive.data.GlobalRegionManager;
import java.lang.ref.WeakReference;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class TileEntityShipController
extends TileEntityAbstractShipController {
    private int tickBooting = 20;
    private WeakReference<TileEntityShipCore> tileEntityShipCoreWeakReference = null;

    public TileEntityShipController() {
        this.peripheralName = "warpdriveShipController";
        this.CC_scripts = Collections.singletonList("startup");
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tickBooting > 0) {
            --this.tickBooting;
            if (this.tileEntityShipCoreWeakReference == null) {
                this.markDirtyAssembly();
            }
        }
    }

    @Override
    protected boolean doScanAssembly(boolean isDirty, WarpDriveText textReason) {
        boolean isSynchronized;
        TileEntityShipCore tileEntityShipCore;
        boolean isValid = super.doScanAssembly(isDirty, textReason);
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference != null ? (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get() : null;
        if (tileEntityShipCore == null || tileEntityShipCore.func_145837_r() || this.uuid == null || !this.uuid.equals(tileEntityShipCore.getSignatureUUID())) {
            tileEntityShipCore = null;
            this.tileEntityShipCoreWeakReference = null;
        }
        if (tileEntityShipCore == null) {
            GlobalRegion globalRegion = GlobalRegionManager.getByUUID(EnumGlobalRegionType.SHIP, this.uuid);
            if (globalRegion == null) {
                textReason.append(Commons.getStyleWarning(), "warpdrive.core_signature.status_line.unknown_core_signature", new Object[0]);
                return false;
            }
            WorldServer worldServer = globalRegion.getWorldServerIfLoaded();
            if (worldServer == null) {
                textReason.append(Commons.getStyleWarning(), "warpdrive.core_signature.status_line.world_not_loaded", new Object[0]);
                return false;
            }
            TileEntity tileEntity = worldServer.func_175625_s(globalRegion.getBlockPos());
            if (!(tileEntity instanceof TileEntityShipCore) || tileEntity.func_145837_r() || this.uuid == null || !this.uuid.equals(((TileEntityShipCore)tileEntity).getSignatureUUID())) {
                textReason.append(Commons.getStyleWarning(), "warpdrive.core_signature.status_line.unknown_core_signature", new Object[0]);
                return false;
            }
            tileEntityShipCore = (TileEntityShipCore)tileEntity;
            this.tileEntityShipCoreWeakReference = new WeakReference<TileEntityShipCore>(tileEntityShipCore);
        }
        if (isSynchronized = tileEntityShipCore.refreshLink(this)) {
            this.onCoreUpdated(tileEntityShipCore);
            if (!tileEntityShipCore.isCommandConfirmed && this.isCommandConfirmed) {
                tileEntityShipCore.command(new Object[]{this.enumShipCommand.func_176610_l(), true});
            }
        }
        this.updateBlockState((IBlockState)null, BlockShipController.COMMAND, this.enumShipCommand);
        return isValid;
    }

    @Override
    protected void doUpdateParameters(boolean isDirty) {
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        return tagCompound;
    }

    @Override
    public NBTTagCompound writeItemDropNBT(NBTTagCompound tagCompound) {
        tagCompound = super.writeItemDropNBT(tagCompound);
        return tagCompound;
    }

    @Override
    @Nonnull
    protected WarpDriveText getCoreSignatureStatus(String nameSignature) {
        if (nameSignature == null || nameSignature.isEmpty()) {
            return new WarpDriveText(Commons.getStyleWarning(), "warpdrive.core_signature.status_line.undefined", new Object[0]);
        }
        return super.getCoreSignatureStatus(nameSignature);
    }

    @Override
    public Object[] getLocalPosition() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return null;
        }
        return tileEntityShipCore.getLocalPosition();
    }

    @Override
    public Object[] getAssemblyStatus() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return new Object[]{false, "No core detected"};
        }
        return tileEntityShipCore.getAssemblyStatus();
    }

    @Override
    public Object[] getOrientation() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return null;
        }
        return tileEntityShipCore.getOrientation();
    }

    @Override
    public Object[] isInSpace() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return null;
        }
        return tileEntityShipCore.isInSpace();
    }

    @Override
    public Object[] isInHyperspace() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return null;
        }
        return tileEntityShipCore.isInHyperspace();
    }

    @Override
    public String[] name(Object[] arguments) {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return super.name(null);
        }
        return tileEntityShipCore.name(arguments);
    }

    @Override
    public Object[] dim_positive(Object[] arguments) {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return super.dim_positive(null);
        }
        return tileEntityShipCore.dim_positive(arguments);
    }

    @Override
    public Object[] dim_negative(Object[] arguments) {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return super.dim_negative(null);
        }
        return tileEntityShipCore.dim_negative(arguments);
    }

    @Override
    public Object[] energyDisplayUnits(Object[] arguments) {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return null;
        }
        return tileEntityShipCore.energyDisplayUnits(arguments);
    }

    @Override
    public Object[] getEnergyStatus() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return null;
        }
        return tileEntityShipCore.getEnergyStatus();
    }

    @Override
    public Object[] command(Object[] arguments) {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return null;
        }
        return tileEntityShipCore.command(arguments);
    }

    @Override
    public Object[] getShipSize() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return null;
        }
        return tileEntityShipCore.getShipSize();
    }

    @Override
    public Object[] movement(Object[] arguments) {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return super.movement(arguments);
        }
        return tileEntityShipCore.movement(arguments);
    }

    @Override
    public Object[] getMaxJumpDistance() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return new Object[]{false, "No ship core detected"};
        }
        return tileEntityShipCore.getMaxJumpDistance();
    }

    @Override
    public Object[] rotationSteps(Object[] arguments) {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return super.rotationSteps(arguments);
        }
        return tileEntityShipCore.rotationSteps(arguments);
    }

    @Override
    public Object[] targetName(Object[] arguments) {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return super.targetName(arguments);
        }
        return tileEntityShipCore.targetName(arguments);
    }

    @Override
    public Object[] getEnergyRequired() {
        TileEntityShipCore tileEntityShipCore;
        TileEntityShipCore tileEntityShipCore2 = tileEntityShipCore = this.tileEntityShipCoreWeakReference == null ? null : (TileEntityShipCore)this.tileEntityShipCoreWeakReference.get();
        if (tileEntityShipCore == null) {
            return new Object[]{false, "No ship core detected"};
        }
        return tileEntityShipCore.getEnergyRequired();
    }
}

