/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.block.movement;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.EventWarpDrive;
import cr0s.warpdrive.api.IGlobalRegionProvider;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.api.computer.IMultiBlockCore;
import cr0s.warpdrive.api.computer.IMultiBlockCoreOrController;
import cr0s.warpdrive.block.TileEntitySecurityStation;
import cr0s.warpdrive.block.detection.BlockWarpIsolation;
import cr0s.warpdrive.block.movement.ShipScanner;
import cr0s.warpdrive.block.movement.TileEntityAbstractShipController;
import cr0s.warpdrive.block.movement.TileEntityShipController;
import cr0s.warpdrive.config.Dictionary;
import cr0s.warpdrive.config.ShipMovementCosts;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.BlockProperties;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.EnergyWrapper;
import cr0s.warpdrive.data.EnumGlobalRegionType;
import cr0s.warpdrive.data.EnumShipCommand;
import cr0s.warpdrive.data.EnumShipCoreState;
import cr0s.warpdrive.data.EnumShipMovementType;
import cr0s.warpdrive.data.GlobalRegion;
import cr0s.warpdrive.data.GlobalRegionManager;
import cr0s.warpdrive.data.SoundEvents;
import cr0s.warpdrive.data.Transformation;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import cr0s.warpdrive.event.JumpSequencer;
import cr0s.warpdrive.render.EntityFXBoundingBox;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityShipCore
extends TileEntityAbstractShipController
implements IGlobalRegionProvider,
IMultiBlockCore {
    private static final int LOG_INTERVAL_TICKS = 3600;
    private static final int BOUNDING_BOX_INTERVAL_TICKS = 60;
    public EnumFacing facing;
    private double isolationRate = 0.0;
    private final Set<BlockPos> blockPosShipControllers = new CopyOnWriteArraySet<BlockPos>();
    private int ticksCooldown = 0;
    private int warmupTime_ticks = 0;
    protected int jumpCount = 0;
    public int maxX;
    public int maxY;
    public int maxZ;
    public int minX;
    public int minY;
    public int minZ;
    private AxisAlignedBB cache_aabbArea;
    protected boolean showBoundingBox = false;
    private int ticksBoundingBoxUpdate = 0;
    private EnumShipCoreState stateCurrent = EnumShipCoreState.IDLE;
    private EnumShipCommand commandCurrent = EnumShipCommand.IDLE;
    private long timeLastShipScanDone = -1L;
    private ShipScanner shipScanner = null;
    public int shipMass;
    public int shipVolume;
    private BlockPos posSecurityStation = null;
    private EnumShipMovementType shipMovementType;
    private ShipMovementCosts shipMovementCosts;
    private long distanceSquared = 0L;
    private boolean isCooldownReported = false;
    private boolean isMotionSicknessApplied = false;
    private boolean isSoundPlayed = false;
    private boolean isWarmupReported = false;
    protected int randomWarmupAddition_ticks = 0;
    private int logTicks = 120;
    private int isolationBlocksCount = 0;
    private static final VectorI[] SUMMON_OFFSETS = new VectorI[]{new VectorI(-1, 0, 0), new VectorI(1, 0, 0), new VectorI(-1, 0, 1), new VectorI(-1, 0, -1), new VectorI(1, 0, 1), new VectorI(1, 0, -1), new VectorI(0, 0, 1), new VectorI(0, 0, -1), new VectorI(-2, 0, 0), new VectorI(2, 0, 0)};

    public TileEntityShipCore() {
        this.peripheralName = "warpdriveShipCore";
        this.CC_scripts = Collections.singletonList("startup");
    }

    @SideOnly(value=Side.CLIENT)
    private void doShowBoundingBox() {
        --this.ticksBoundingBoxUpdate;
        if (this.ticksBoundingBoxUpdate > 0) {
            return;
        }
        this.ticksBoundingBoxUpdate = 60;
        Vector3 vector3 = new Vector3(this);
        vector3.translate(0.5);
        Vector3 vMin = new Vector3((double)this.minX - 0.0, (double)this.minY - 0.0, (double)this.minZ - 0.0);
        Vector3 vMax = new Vector3((double)this.maxX + 1.0, (double)this.maxY + 1.0, (double)this.maxZ + 1.0);
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)new EntityFXBoundingBox(this.field_145850_b, vector3, vMin, vMax, 1.0f, 0.8f, 0.3f, 61));
        VectorI vMovement = this.getMovement();
        if (vMovement.getMagnitudeSquared() > 0) {
            VectorI movement = this.getMovement();
            VectorI shipSize = new VectorI(this.getFront() + 1 + this.getBack(), this.getUp() + 1 + this.getDown(), this.getRight() + 1 + this.getLeft());
            int maxDistance = 256;
            if (Math.abs(movement.x) - shipSize.x > 256) {
                movement.x = (int)Math.signum(movement.x) * (shipSize.x + 256);
            }
            if (Math.abs(movement.y) - shipSize.y > 256) {
                movement.y = (int)Math.signum(movement.y) * (shipSize.y + 256);
            }
            if (Math.abs(movement.z) - shipSize.z > 256) {
                movement.z = (int)Math.signum(movement.z) * (shipSize.z + 256);
            }
            this.facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL);
            int moveX = this.facing.func_82601_c() * movement.x - this.facing.func_82599_e() * movement.z;
            int moveY = movement.y;
            int moveZ = this.facing.func_82599_e() * movement.x + this.facing.func_82601_c() * movement.z;
            Transformation transformation = new Transformation(this, moveX, moveY, moveZ, this.getRotationSteps());
            Vec3d vMinTarget = transformation.apply(vMin.x, vMin.y, vMin.z);
            Vec3d vMaxTarget = transformation.apply(vMax.x, vMax.y, vMax.z);
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)new EntityFXBoundingBox(this.field_145850_b, vector3, new Vector3(Math.min(vMinTarget.field_72450_a, vMaxTarget.field_72450_a), Math.min(vMinTarget.field_72448_b, vMaxTarget.field_72448_b), Math.min(vMinTarget.field_72449_c, vMaxTarget.field_72449_c)), new Vector3(Math.max(vMinTarget.field_72450_a, vMaxTarget.field_72450_a), Math.max(vMinTarget.field_72448_b, vMaxTarget.field_72448_b), Math.max(vMinTarget.field_72449_c, vMaxTarget.field_72449_c)), 0.3f, 0.8f, 1.0f, 61));
        }
    }

    @Override
    protected void onConstructed() {
        super.onConstructed();
        this.energy_setParameters(WarpDriveConfig.SHIP_MAX_ENERGY_STORED_BY_TIER[this.enumTier.getIndex()], 65536, 0, "EV", 2, "EV", 0);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            if (this.showBoundingBox) {
                this.doShowBoundingBox();
            }
            return;
        }
        if (this.ticksCooldown > 0) {
            --this.ticksCooldown;
            if (this.isEnabled && this.isCommandConfirmed && this.enumShipCommand.isMovement() && this.ticksCooldown % 20 == 0) {
                int seconds = this.ticksCooldown / 20;
                if (!this.isCooldownReported || seconds < 5 || seconds < 30 && seconds % 5 == 0 || seconds % 10 == 0) {
                    this.isCooldownReported = true;
                    Commons.messageToAllPlayersInArea(this, new WarpDriveText(null, "warpdrive.ship.guide.cooling_countdown", seconds));
                }
            }
            if (this.ticksCooldown == 0) {
                this.cooldownDone();
            }
        } else {
            this.isCooldownReported = false;
        }
        if (!this.isEnabled || this.isCommandConfirmed && this.enumShipCommand == EnumShipCommand.OFFLINE) {
            this.stateCurrent = EnumShipCoreState.IDLE;
        }
        --this.logTicks;
        if (this.logTicks <= 0) {
            this.logTicks = 3600;
            if (WarpDriveConfig.LOGGING_JUMP) {
                WarpDrive.logger.info(String.format("%s, %s, %s, %d controllers, warm-up %d, cool down %d", new Object[]{this, this.stateCurrent, this.isEnabled ? "Enabled" : "Disabled", this.blockPosShipControllers.size(), this.warmupTime_ticks, this.ticksCooldown}));
            }
        }
        boolean isActive = this.commandCurrent != EnumShipCommand.OFFLINE;
        this.updateBlockState((IBlockState)null, BlockProperties.ACTIVE, isActive);
        if (this.timeLastShipScanDone <= 0L) {
            this.timeLastShipScanDone = this.field_145850_b.func_82737_E();
            if (this.getBack() == 0 && this.getFront() == 0 && this.getLeft() == 0 && this.getRight() == 0 && this.getDown() == 0 && this.getUp() == 0) {
                this.textValidityIssues = new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.no_dimension_set", new Object[0]);
                this.isAssemblyValid = false;
                return;
            }
            if (this.getBack() + this.getFront() > WarpDriveConfig.SHIP_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()] || this.getLeft() + this.getRight() > WarpDriveConfig.SHIP_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()] || this.getDown() + this.getUp() > WarpDriveConfig.SHIP_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()]) {
                this.textValidityIssues = new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.too_large_side_for_tier", WarpDriveConfig.SHIP_SIZE_MAX_PER_SIDE_BY_TIER[this.enumTier.getIndex()]);
                this.isAssemblyValid = false;
                return;
            }
            this.shipScanner = new ShipScanner((IBlockAccess)this.field_145850_b, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info(String.format("%s scanning started", this));
            }
        }
        if (this.shipScanner != null) {
            if (!this.shipScanner.tick()) {
                return;
            }
            this.shipMass = this.shipScanner.mass;
            this.shipVolume = this.shipScanner.volume;
            this.posSecurityStation = this.shipScanner.posSecurityStation;
            this.shipScanner = null;
            if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                WarpDrive.logger.info(String.format("%s scanning done: mass %d, volume %d", this, this.shipMass, this.shipVolume));
            }
            boolean isUnlimited = false;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX + 0.99, (double)this.maxY + 0.99, (double)this.maxZ + 0.99);
            List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
            for (Entity entity : list) {
                if (!(entity instanceof EntityPlayer)) continue;
                String playerName = entity.func_70005_c_();
                for (String nameUnlimited : WarpDriveConfig.SHIP_MASS_UNLIMITED_PLAYER_NAMES) {
                    isUnlimited = isUnlimited || nameUnlimited.equals(playerName);
                }
            }
            if (!isUnlimited) {
                if (this.shipMass > WarpDriveConfig.SHIP_MASS_MAX_ON_PLANET_SURFACE && CelestialObjectManager.isPlanet(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p())) {
                    this.textValidityIssues = new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.too_much_mass_for_planet", WarpDriveConfig.SHIP_MASS_MAX_ON_PLANET_SURFACE, this.shipMass);
                    this.isAssemblyValid = false;
                    if (this.isEnabled) {
                        this.commandDone(false, this.textValidityIssues);
                    }
                    return;
                }
                if (this.shipMass < WarpDriveConfig.SHIP_MASS_MIN_FOR_HYPERSPACE && CelestialObjectManager.isInHyperspace(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p())) {
                    this.textValidityIssues = new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.insufficient_mass_for_hyperspace", WarpDriveConfig.SHIP_MASS_MIN_FOR_HYPERSPACE, this.shipMass);
                    this.isAssemblyValid = false;
                    if (this.isEnabled) {
                        this.commandDone(false, this.textValidityIssues);
                    }
                    return;
                }
                if (this.shipMass < WarpDriveConfig.SHIP_MASS_MIN_BY_TIER[this.enumTier.getIndex()]) {
                    this.textValidityIssues = new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.insufficient_mass_for_tier", WarpDriveConfig.SHIP_MASS_MIN_BY_TIER[this.enumTier.getIndex()], this.shipMass);
                    this.isAssemblyValid = false;
                    if (this.isEnabled) {
                        this.commandDone(false, this.textValidityIssues);
                    }
                    return;
                }
                if (this.shipMass > WarpDriveConfig.SHIP_MASS_MAX_BY_TIER[this.enumTier.getIndex()]) {
                    this.textValidityIssues = new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.too_much_mass_for_tier", WarpDriveConfig.SHIP_MASS_MAX_BY_TIER[this.enumTier.getIndex()], this.shipMass);
                    this.isAssemblyValid = false;
                    if (this.isEnabled) {
                        this.commandDone(false, this.textValidityIssues);
                    }
                    return;
                }
            }
            this.textValidityIssues = new WarpDriveText();
            this.isAssemblyValid = true;
        }
        if (this.isCooling()) {
            return;
        }
        WarpDriveText reason = new WarpDriveText();
        block0 : switch (this.stateCurrent) {
            case IDLE: {
                if (!this.isCommandConfirmed || !this.enumShipCommand.isMovement()) break;
                this.commandCurrent = this.enumShipCommand;
                this.stateCurrent = EnumShipCoreState.ONLINE;
                break;
            }
            case ONLINE: {
                switch (this.commandCurrent) {
                    case MANUAL: 
                    case HYPERDRIVE: 
                    case GATE: {
                        if (WarpDriveConfig.LOGGING_JUMPBLOCKS) {
                            WarpDrive.logger.info(String.format("%s state ONLINE -> initiating jump", this));
                        }
                        this.distanceSquared = this.getMovement().getMagnitudeSquared();
                        if (this.timeLastShipScanDone + (long)(WarpDriveConfig.SHIP_VOLUME_SCAN_AGE_TOLERANCE_SECONDS * 20) < this.field_145850_b.func_82737_E()) {
                            this.timeLastShipScanDone = -1L;
                            break block0;
                        }
                        Commons.messageToAllPlayersInArea(this, new WarpDriveText(null, "warpdrive.ship.guide.pre_jumping", new Object[0]));
                        if (!this.isAssemblyValid) {
                            this.commandDone(false, this.textValidityIssues);
                            return;
                        }
                        if (!this.validateShipMovementParameters(reason)) {
                            this.commandDone(false, reason);
                            return;
                        }
                        this.randomWarmupAddition_ticks = this.field_145850_b.field_73012_v.nextInt(WarpDriveConfig.SHIP_WARMUP_RANDOM_TICKS);
                        this.stateCurrent = EnumShipCoreState.WARMING_UP;
                        this.warmupTime_ticks = this.shipMovementCosts.warmup_seconds * 20 + this.randomWarmupAddition_ticks;
                        this.isMotionSicknessApplied = false;
                        this.isSoundPlayed = false;
                        this.isWarmupReported = false;
                        break block0;
                    }
                }
                WarpDrive.logger.error(String.format("%s Invalid controller command %s for current state %s", new Object[]{this, this.enumShipCommand, this.stateCurrent}));
                this.stateCurrent = EnumShipCoreState.IDLE;
                break;
            }
            case WARMING_UP: {
                SoundEvent soundEvent;
                int soundThreshold;
                if (this.shipMovementCosts.sickness_seconds > 0) {
                    int motionSicknessThreshold_ticks = this.shipMovementCosts.sickness_seconds * 20 - this.randomWarmupAddition_ticks / 4;
                    if (!this.isMotionSicknessApplied && motionSicknessThreshold_ticks >= this.warmupTime_ticks) {
                        if (WarpDriveConfig.LOGGING_JUMP) {
                            WarpDrive.logger.info(this + " Giving warp sickness to on-board players");
                        }
                        this.makePlayersOnShipDrunk(this.shipMovementCosts.sickness_seconds * 20 + WarpDriveConfig.SHIP_WARMUP_RANDOM_TICKS);
                        this.isMotionSicknessApplied = true;
                    }
                }
                if (this.shipMovementCosts.warmup_seconds < 10) {
                    soundThreshold = 80 - this.randomWarmupAddition_ticks;
                    soundEvent = SoundEvents.WARP_4_SECONDS;
                } else if (this.shipMovementCosts.warmup_seconds > 29) {
                    soundThreshold = 600 - this.randomWarmupAddition_ticks;
                    soundEvent = SoundEvents.WARP_30_SECONDS;
                } else {
                    soundThreshold = 200 - this.randomWarmupAddition_ticks;
                    soundEvent = SoundEvents.WARP_10_SECONDS;
                }
                if (!this.isSoundPlayed && soundThreshold >= this.warmupTime_ticks) {
                    if (WarpDriveConfig.LOGGING_JUMP) {
                        WarpDrive.logger.info(this + " Playing sound effect '" + soundEvent + "' soundThreshold " + soundThreshold + " warmupTime " + this.warmupTime_ticks);
                    }
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, soundEvent, SoundCategory.BLOCKS, 4.0f, 1.0f);
                    this.isSoundPlayed = true;
                }
                if (this.warmupTime_ticks % 20 == 0) {
                    int seconds = this.warmupTime_ticks / 20;
                    if (!this.isWarmupReported || seconds >= 60 && seconds % 15 == 0 || seconds < 60 && seconds > 30 && seconds % 10 == 0) {
                        this.isWarmupReported = true;
                        Commons.messageToAllPlayersInArea(this, new WarpDriveText(null, "warpdrive.ship.guide.warming_up", seconds));
                    }
                }
                if (this.warmupTime_ticks > 0) {
                    --this.warmupTime_ticks;
                    break;
                }
                this.warmupTime_ticks = 0;
                this.isMotionSicknessApplied = false;
                this.isSoundPlayed = false;
                this.isWarmupReported = false;
                if (!this.isAssemblyValid) {
                    this.commandDone(false, this.textValidityIssues);
                    return;
                }
                TileEntityShipCore shipCoreIntersecting = GlobalRegionManager.getIntersectingShipCore(this);
                if (shipCoreIntersecting != null) {
                    this.commandDone(false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.warp_field_overlapping", shipCoreIntersecting.getSignatureName()));
                    return;
                }
                if (WarpDrive.cloaks.isCloaked(this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c)) {
                    this.commandDone(false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.cloaking_field_overlapping", new Object[0]));
                    return;
                }
                this.doJump();
                this.setCooldown(this.shipMovementCosts.cooldown_seconds * 20);
                this.commandDone(true, new WarpDriveText(Commons.getStyleCorrect(), "warpdrive.ship.guide.pre_jump_success", new Object[0]));
                ++this.jumpCount;
                this.stateCurrent = EnumShipCoreState.IDLE;
                this.isCooldownReported = false;
                break;
            }
        }
    }

    public boolean isOffline() {
        return this.enumShipCommand == EnumShipCommand.OFFLINE;
    }

    public boolean isUnderMaintenance() {
        return this.enumShipCommand == EnumShipCommand.MAINTENANCE;
    }

    public boolean isBusy() {
        return this.timeLastShipScanDone < 0L || this.shipScanner != null || this.isCooling() || this.stateCurrent == EnumShipCoreState.WARMING_UP;
    }

    private void setCooldown(int ticksCooldown) {
        this.ticksCooldown = Math.max(1, Math.max(this.ticksCooldown, ticksCooldown));
        this.isCooldownReported = false;
    }

    private int getCooldown() {
        return this.ticksCooldown;
    }

    private boolean isCooling() {
        return this.ticksCooldown > 0;
    }

    @Override
    public boolean refreshLink(IMultiBlockCoreOrController multiblockController) {
        assert (multiblockController instanceof TileEntityShipController);
        TileEntityShipController tileEntityShipController = (TileEntityShipController)multiblockController;
        boolean isValid = !this.isUpgradeable();
        BlockPos blockPos = tileEntityShipController.func_174877_v();
        if (this.blockPosShipControllers.contains(blockPos)) {
            if (!isValid) {
                this.blockPosShipControllers.remove(blockPos);
                WarpDrive.logger.info(String.format("%s link removed to %s", this, tileEntityShipController));
            }
        } else if (isValid) {
            this.blockPosShipControllers.add(blockPos);
            WarpDrive.logger.info(String.format("%s link added to %s", this, tileEntityShipController));
        }
        return isValid;
    }

    @Override
    public void removeLink(IMultiBlockCoreOrController multiblockController) {
        assert (multiblockController instanceof TileEntityShipController);
        TileEntityShipController tileEntityShipController = (TileEntityShipController)multiblockController;
        BlockPos blockPos = tileEntityShipController.func_174877_v();
        this.blockPosShipControllers.remove(blockPos);
        WarpDrive.logger.info(String.format("%s link removed to %s", this, tileEntityShipController));
    }

    @Override
    protected void commandDone(boolean success, @Nonnull WarpDriveText reasonRaw) {
        assert (success || !reasonRaw.func_150260_c().isEmpty());
        WarpDriveText reason = success || !this.commandCurrent.isMovement() ? reasonRaw : new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.movement_aborted", new Object[0]).append((ITextComponent)reasonRaw);
        super.commandDone(success, reason);
        if (!success) {
            Commons.messageToAllPlayersInArea(this, reason);
            this.stateCurrent = EnumShipCoreState.IDLE;
        }
        for (BlockPos blockPos : this.blockPosShipControllers) {
            if (!this.field_145850_b.func_175668_a(blockPos, false)) continue;
            TileEntity tileEntity = this.field_145850_b.func_175625_s(blockPos);
            if (!(tileEntity instanceof TileEntityShipController)) {
                this.blockPosShipControllers.remove(blockPos);
                WarpDrive.logger.info(String.format("%s link removed to invalid instance of TileEntityShipController %s", this, tileEntity));
                continue;
            }
            ((TileEntityShipController)tileEntity).commandDone(success, reason);
        }
    }

    public String getFirstOnlineCrew() {
        if (this.posSecurityStation == null) {
            return null;
        }
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.posSecurityStation);
        if (!(tileEntity instanceof TileEntitySecurityStation) || tileEntity.func_145837_r()) {
            this.timeLastShipScanDone = -1L;
            return "-busy-";
        }
        return ((TileEntitySecurityStation)tileEntity).getFirstOnlinePlayer();
    }

    @Override
    protected boolean doScanAssembly(boolean isDirty, WarpDriveText textReason) {
        boolean isValid = super.doScanAssembly(isDirty, textReason);
        this.facing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockProperties.FACING_HORIZONTAL);
        int xMin = this.field_174879_c.func_177958_n() - WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE;
        int xMax = this.field_174879_c.func_177958_n() + WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE;
        int zMin = this.field_174879_c.func_177952_p() - WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE;
        int zMax = this.field_174879_c.func_177952_p() + WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE;
        int yMin = Math.max(0, this.field_174879_c.func_177956_o() - WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE + 1);
        int yMax = Math.min(255, this.field_174879_c.func_177956_o() + WarpDriveConfig.RADAR_MAX_ISOLATION_RANGE + 1);
        int newCount = 0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int y = yMin; y <= yMax; ++y) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    mutableBlockPos.func_181079_c(x, y, z);
                    if (!(this.field_145850_b.func_180495_p((BlockPos)mutableBlockPos).func_177230_c() instanceof BlockWarpIsolation)) continue;
                    ++newCount;
                }
            }
        }
        this.isolationBlocksCount = newCount;
        double legacy_isolationRate = this.isolationRate;
        this.isolationRate = this.isolationBlocksCount >= WarpDriveConfig.RADAR_MIN_ISOLATION_BLOCKS ? Math.min(1.0, WarpDriveConfig.RADAR_MIN_ISOLATION_EFFECT + (double)(this.isolationBlocksCount - WarpDriveConfig.RADAR_MIN_ISOLATION_BLOCKS) * (WarpDriveConfig.RADAR_MAX_ISOLATION_EFFECT - WarpDriveConfig.RADAR_MIN_ISOLATION_EFFECT) / (double)(WarpDriveConfig.RADAR_MAX_ISOLATION_BLOCKS - WarpDriveConfig.RADAR_MIN_ISOLATION_BLOCKS)) : 0.0;
        if (legacy_isolationRate != this.isolationRate) {
            this.markDirtyGlobalRegion();
            if (WarpDriveConfig.LOGGING_RADAR && WarpDrive.isDev) {
                WarpDrive.logger.info(String.format("%s Isolation updated to %d (%.1f%%)", this, this.isolationBlocksCount, this.isolationRate * 100.0));
            }
        }
        return isValid;
    }

    @Override
    protected void doUpdateParameters(boolean isDirty) {
        int old_minX = this.minX;
        int old_maxX = this.maxX;
        int old_minY = this.minY;
        int old_maxY = this.maxY;
        int old_minZ = this.minZ;
        int old_maxZ = this.maxZ;
        if (this.facing.func_82601_c() == 1) {
            this.minX = this.field_174879_c.func_177958_n() - this.getBack();
            this.maxX = this.field_174879_c.func_177958_n() + this.getFront();
            this.minZ = this.field_174879_c.func_177952_p() - this.getLeft();
            this.maxZ = this.field_174879_c.func_177952_p() + this.getRight();
        } else if (this.facing.func_82601_c() == -1) {
            this.minX = this.field_174879_c.func_177958_n() - this.getFront();
            this.maxX = this.field_174879_c.func_177958_n() + this.getBack();
            this.minZ = this.field_174879_c.func_177952_p() - this.getRight();
            this.maxZ = this.field_174879_c.func_177952_p() + this.getLeft();
        } else if (this.facing.func_82599_e() == 1) {
            this.minZ = this.field_174879_c.func_177952_p() - this.getBack();
            this.maxZ = this.field_174879_c.func_177952_p() + this.getFront();
            this.minX = this.field_174879_c.func_177958_n() - this.getRight();
            this.maxX = this.field_174879_c.func_177958_n() + this.getLeft();
        } else if (this.facing.func_82599_e() == -1) {
            this.minZ = this.field_174879_c.func_177952_p() - this.getFront();
            this.maxZ = this.field_174879_c.func_177952_p() + this.getBack();
            this.minX = this.field_174879_c.func_177958_n() - this.getLeft();
            this.maxX = this.field_174879_c.func_177958_n() + this.getRight();
        }
        this.minY = this.field_174879_c.func_177956_o() - this.getDown();
        this.maxY = this.field_174879_c.func_177956_o() + this.getUp();
        boolean isDirty2 = false;
        if (!(this.minX == old_minX && this.maxX == old_maxX && this.minY == old_minY && this.maxY == old_maxY && this.minZ == old_minZ && this.maxZ == old_maxZ || isDirty)) {
            WarpDrive.logger.error(String.format("Dimensions changed but not dirty, please report this to mod author!\n%s", this.getInternalStatus()));
            isDirty2 = true;
        }
        if (!isDirty) {
            this.func_70296_d();
        }
        if (isDirty || isDirty2) {
            this.shipMass = 0;
            this.shipVolume = 0;
            this.cache_aabbArea = null;
            this.timeLastShipScanDone = -1L;
        }
    }

    private void makePlayersOnShipDrunk(int tickDuration) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ);
        List list = this.field_145850_b.func_72839_b(null, axisalignedbb);
        for (Entity entity : list) {
            if (!(entity instanceof EntityPlayer)) continue;
            ((EntityPlayer)entity).func_70690_d(new PotionEffect(MobEffects.field_76431_k, tickDuration, 0, true, true));
        }
    }

    private TileEntitySecurityStation findSecurityStation() {
        return null;
    }

    public boolean summonOwnerOnDeploy(EntityPlayerMP entityPlayerMP) {
        AxisAlignedBB aabb;
        if (entityPlayerMP == null) {
            WarpDrive.logger.warn(this + " No player given to summonOwnerOnDeploy()");
            return false;
        }
        this.doUpdateParameters(false);
        if (!this.isAssemblyValid) {
            Commons.addChatMessage((ICommandSender)entityPlayerMP, (ITextComponent)new WarpDriveText(Commons.getStyleHeader(), !this.name.isEmpty() ? this.name : "ShipCore", new Object[0]).appendSibling(this.textValidityIssues));
            return false;
        }
        TileEntitySecurityStation tileEntitySecurityStation = this.findSecurityStation();
        if (tileEntitySecurityStation != null) {
            tileEntitySecurityStation.players.clear();
            tileEntitySecurityStation.players.add(entityPlayerMP.func_70005_c_());
        }
        if (TileEntityShipCore.isOutsideBB(aabb = new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX, (double)this.maxY, (double)this.maxZ), MathHelper.func_76128_c((double)entityPlayerMP.field_70165_t), MathHelper.func_76128_c((double)entityPlayerMP.field_70163_u), MathHelper.func_76128_c((double)entityPlayerMP.field_70161_v))) {
            this.summonPlayer(entityPlayerMP);
        }
        return true;
    }

    private void summonPlayer(@Nonnull EntityPlayerMP entityPlayer) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.field_174879_c);
        for (VectorI vOffset : SUMMON_OFFSETS) {
            mutableBlockPos.func_181079_c(this.field_174879_c.func_177958_n() + this.facing.func_82601_c() * vOffset.x + this.facing.func_82599_e() * vOffset.z, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + this.facing.func_82599_e() * vOffset.x + this.facing.func_82601_c() * vOffset.z);
            if (this.field_145850_b.func_175623_d((BlockPos)mutableBlockPos)) {
                if (this.field_145850_b.func_175623_d(mutableBlockPos.func_177982_a(0, 1, 0))) {
                    this.summonPlayer(entityPlayer, (BlockPos)mutableBlockPos);
                    return;
                }
                mutableBlockPos.func_189536_c(EnumFacing.DOWN);
                if (!this.field_145850_b.func_175623_d((BlockPos)mutableBlockPos)) continue;
                this.summonPlayer(entityPlayer, (BlockPos)mutableBlockPos);
                return;
            }
            if (this.field_145850_b.func_175623_d(mutableBlockPos.func_177982_a(0, -1, 0)) && this.field_145850_b.func_175623_d(mutableBlockPos.func_177982_a(0, -2, 0)) && !this.field_145850_b.func_175623_d(mutableBlockPos.func_177982_a(0, -3, 0))) {
                this.summonPlayer(entityPlayer, mutableBlockPos.func_177982_a(0, -2, 0));
                return;
            }
            if (!this.field_145850_b.func_175623_d(mutableBlockPos.func_177982_a(0, 1, 0)) || !this.field_145850_b.func_175623_d(mutableBlockPos.func_177982_a(0, 2, 0)) || this.field_145850_b.func_175623_d((BlockPos)mutableBlockPos)) continue;
            this.summonPlayer(entityPlayer, mutableBlockPos.func_177982_a(0, 1, 0));
            return;
        }
        WarpDriveText message = new WarpDriveText(Commons.getStyleWarning(), "warpdrive.teleportation.guide.no_safe_spot", entityPlayer.func_145748_c_());
        Commons.messageToAllPlayersInArea(this, message);
        Commons.addChatMessage((ICommandSender)entityPlayer, (ITextComponent)message);
    }

    private void summonPlayer(@Nonnull EntityPlayerMP player, @Nonnull BlockPos blockPos) {
        Commons.moveEntity((Entity)player, this.field_145850_b, new Vector3((double)blockPos.func_177958_n() + 0.5, blockPos.func_177956_o(), (double)blockPos.func_177952_p() + 0.5));
    }

    private boolean validateShipMovementParameters(WarpDriveText reason) {
        this.shipMovementType = EnumShipMovementType.compute(this.field_145850_b, this.field_174879_c.func_177958_n(), this.minY, this.maxY, this.field_174879_c.func_177952_p(), this.commandCurrent, this.getMovement().y, reason);
        if (this.shipMovementType == null) {
            return false;
        }
        this.shipMovementCosts = new ShipMovementCosts(this.field_145850_b, this.field_174879_c, this, this.shipMovementType, this.shipMass, (int)Math.ceil(Math.sqrt(this.distanceSquared)));
        EventWarpDrive.Ship.PreJump preJump = new EventWarpDrive.Ship.PreJump(this.field_145850_b, this.field_174879_c, this, this.shipMovementType.func_176610_l());
        MinecraftForge.EVENT_BUS.post((Event)preJump);
        if (preJump.isCanceled()) {
            reason.append((ITextComponent)preJump.getReason());
            return false;
        }
        return true;
    }

    protected int getMaxJumpDistance(EnumShipCommand command, WarpDriveText reason) {
        EnumShipMovementType shipMovementType = EnumShipMovementType.compute(this.field_145850_b, this.field_174879_c.func_177958_n(), this.minY, this.maxY, this.field_174879_c.func_177952_p(), command, this.getMovement().y, reason);
        if (shipMovementType == null) {
            this.commandDone(false, reason);
            return -1;
        }
        ShipMovementCosts shipMovementCosts = new ShipMovementCosts(this.field_145850_b, this.field_174879_c, this, shipMovementType, this.shipMass, (int)Math.ceil(Math.sqrt(this.distanceSquared)));
        return shipMovementCosts.maximumDistance_blocks;
    }

    protected int getEnergyRequired(EnumShipCommand command, WarpDriveText reason) {
        EnumShipMovementType shipMovementType = EnumShipMovementType.compute(this.field_145850_b, this.field_174879_c.func_177958_n(), this.minY, this.maxY, this.field_174879_c.func_177952_p(), command, this.getMovement().y, reason);
        if (shipMovementType == null) {
            this.commandDone(false, reason);
            return -1;
        }
        ShipMovementCosts shipMovementCosts = new ShipMovementCosts(this.field_145850_b, this.field_174879_c, this, shipMovementType, this.shipMass, (int)Math.ceil(Math.sqrt(this.distanceSquared)));
        return shipMovementCosts.energyRequired;
    }

    private boolean isShipInJumpgate(@Nonnull GlobalRegion jumpGate, @Nonnull WarpDriveText reason) {
        assert (jumpGate.type == EnumGlobalRegionType.JUMP_GATE);
        AxisAlignedBB aabb = jumpGate.getArea();
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Jumpgate " + jumpGate.name + " AABB is " + aabb);
        }
        int countBlocksInside = 0;
        int countBlocksTotal = 0;
        if (aabb.func_72318_a(new Vec3d((double)this.minX, (double)this.minY, (double)this.minZ)) && aabb.func_72318_a(new Vec3d((double)this.maxX, (double)this.maxY, (double)this.maxZ))) {
            return true;
        }
        for (int x = this.minX; x <= this.maxX; ++x) {
            for (int z = this.minZ; z <= this.maxZ; ++z) {
                for (int y = this.minY; y <= this.maxY; ++y) {
                    IBlockState blockState = this.field_145850_b.func_180495_p(new BlockPos(x, y, z));
                    if (blockState.func_177230_c() == Blocks.field_150350_a || Dictionary.BLOCKS_LEFTBEHIND.contains(blockState.func_177230_c()) || Dictionary.BLOCKS_NOMASS.contains(blockState.func_177230_c())) continue;
                    if (aabb.field_72340_a <= (double)x && aabb.field_72336_d >= (double)x && aabb.field_72338_b <= (double)y && aabb.field_72337_e >= (double)y && aabb.field_72339_c <= (double)z && aabb.field_72334_f >= (double)z) {
                        ++countBlocksInside;
                    }
                    ++countBlocksTotal;
                }
            }
        }
        float percent = 0.0f;
        if (this.shipMass != 0) {
            percent = (float)Math.round((float)countBlocksInside * 1.0f / (float)this.shipMass * 100.0f * 10.0f) / 10.0f;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            if (this.shipMass != countBlocksTotal) {
                WarpDrive.logger.warn(String.format("%s Ship mass has changed from %d to %d blocks", this, this.shipMass, countBlocksTotal));
            }
            WarpDrive.logger.info(String.format("%s Ship has %d / %d blocks (%.1f %%) in jump gate '%s'", this, countBlocksInside, this.shipMass, Float.valueOf(percent), jumpGate.name));
        }
        if (percent > 80.0f) {
            return true;
        }
        if ((double)percent <= 0.001) {
            reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.jumpgate_is_too_far", new Object[0]);
            return false;
        }
        reason.append(Commons.getStyleWarning(), "warpdrive.ship.guide.jumpgate_partially_entered", Float.valueOf(percent));
        return false;
    }

    private boolean isFreePlaceForShip(int destX, int destY, int destZ) {
        if (destY + this.getUp() > 255 || destY - this.getDown() < 5) {
            return false;
        }
        int moveX = destX - this.field_174879_c.func_177958_n();
        int moveY = destY - this.field_174879_c.func_177956_o();
        int moveZ = destZ - this.field_174879_c.func_177952_p();
        for (int x = this.minX; x <= this.maxX; ++x) {
            int newX = moveX + x;
            for (int z = this.minZ; z <= this.maxZ; ++z) {
                int newZ = moveZ + z;
                for (int y = this.minY; y <= this.maxY; ++y) {
                    if (moveY + y < 0 || moveY + y > 255) {
                        return false;
                    }
                    Block blockSource = this.field_145850_b.func_180495_p(new BlockPos(x, y, z)).func_177230_c();
                    Block blockTarget = this.field_145850_b.func_180495_p(new BlockPos(newX, moveY + y, newZ)).func_177230_c();
                    if (blockSource == Blocks.field_150350_a || Dictionary.BLOCKS_EXPANDABLE.contains(blockSource) || blockTarget == Blocks.field_150350_a || Dictionary.BLOCKS_EXPANDABLE.contains(blockTarget)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void doGateJump() {
        String targetName = this.getTargetName();
        GlobalRegion jumpGate_target = GlobalRegionManager.getByName(EnumGlobalRegionType.JUMP_GATE, targetName);
        if (jumpGate_target == null) {
            this.commandDone(false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.jumpgate_not_defined", targetName));
            return;
        }
        int gateX = jumpGate_target.x;
        int gateY = jumpGate_target.y;
        int gateZ = jumpGate_target.z;
        int destX = gateX;
        int destY = gateY;
        int destZ = gateZ;
        GlobalRegion jumpGate_nearest = GlobalRegionManager.getNearest(EnumGlobalRegionType.JUMP_GATE, this.field_145850_b, this.field_174879_c);
        WarpDriveText reason = new WarpDriveText();
        if (jumpGate_nearest == null || !this.isShipInJumpgate(jumpGate_nearest, reason)) {
            this.commandDone(false, reason);
            return;
        }
        if (!this.isFreePlaceForShip(gateX, gateY, gateZ)) {
            int numTries;
            boolean placeFound = false;
            for (numTries = 10; numTries > 0; --numTries) {
                destX = gateX + (this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1) * (20 + this.field_145850_b.field_73012_v.nextInt(100));
                destZ = gateZ + (this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1) * (20 + this.field_145850_b.field_73012_v.nextInt(100));
                destY = gateY + (this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1) * (20 + this.field_145850_b.field_73012_v.nextInt(50));
                if (!this.isFreePlaceForShip(destX, destY, destZ)) continue;
                placeFound = true;
                break;
            }
            if (!placeFound) {
                this.commandDone(false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.jumpgate_blocked", new Object[0]));
                return;
            }
            WarpDrive.logger.info(String.format("%s Gate exit found after %d trials.", this, 10 - numTries));
        }
        if (this.energy_consume(this.shipMovementCosts.energyRequired, false)) {
            WarpDrive.logger.info(String.format("%s Moving ship to a place around gate '%s' (%d %d %d)", this, jumpGate_target.name, destX, destY, destZ));
            JumpSequencer jump = new JumpSequencer(this, EnumShipMovementType.GATE_ACTIVATING, targetName, 0, 0, 0, 0, destX, destY, destZ);
            jump.enable();
        } else {
            String units = WarpDriveConfig.ENERGY_DISPLAY_UNITS;
            Commons.messageToAllPlayersInArea(this, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.insufficient_energy", EnergyWrapper.format(this.energy_getEnergyStored(), units), EnergyWrapper.format(this.shipMovementCosts.energyRequired, units), units));
        }
    }

    private void doJump() {
        int requiredEnergy = this.shipMovementCosts.energyRequired;
        if (!this.energy_consume(requiredEnergy, true)) {
            String units = WarpDriveConfig.ENERGY_DISPLAY_UNITS;
            this.commandDone(false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.insufficient_energy", EnergyWrapper.format(this.energy_getEnergyStored(), units), EnergyWrapper.format(requiredEnergy, units), units));
            return;
        }
        String shipInfo = String.format("%d blocks inside (%d %d %d) to (%d %d %d) with an actual mass of %d blocks", this.shipVolume, this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ, this.shipMass);
        switch (this.commandCurrent) {
            case GATE: {
                WarpDrive.logger.info(this + " Performing gate jump of " + shipInfo);
                this.doGateJump();
                return;
            }
            case HYPERDRIVE: {
                WarpDrive.logger.info(this + " Performing hyperdrive jump of " + shipInfo);
                if (this.shipMass >= WarpDriveConfig.SHIP_MASS_MIN_FOR_HYPERSPACE) break;
                GlobalRegion jumpGate_nearest = GlobalRegionManager.getNearest(EnumGlobalRegionType.JUMP_GATE, this.field_145850_b, this.field_174879_c);
                WarpDriveText reason = new WarpDriveText();
                if (jumpGate_nearest != null && this.isShipInJumpgate(jumpGate_nearest, reason)) break;
                this.commandDone(false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.insufficient_mass_for_hyperspace", WarpDriveConfig.SHIP_MASS_MIN_FOR_HYPERSPACE, this.shipMass));
                return;
            }
            case MANUAL: {
                WarpDrive.logger.info(String.format("%s Performing manual jump of %s, %s, movement %s, rotationSteps %d", new Object[]{this, shipInfo, this.shipMovementType, this.getMovement(), this.getRotationSteps()}));
                break;
            }
            default: {
                WarpDrive.logger.error(String.format("%s Aborting while trying to perform invalid jump command %s", new Object[]{this, this.commandCurrent}));
                this.commandDone(false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.error.internal_check_console", new Object[0]));
                this.commandCurrent = EnumShipCommand.IDLE;
                this.stateCurrent = EnumShipCoreState.IDLE;
                return;
            }
        }
        if (!this.energy_consume(requiredEnergy, false)) {
            String units = WarpDriveConfig.ENERGY_DISPLAY_UNITS;
            this.commandDone(false, new WarpDriveText(Commons.getStyleWarning(), "warpdrive.ship.guide.insufficient_energy", EnergyWrapper.format(this.energy_getEnergyStored(), units), EnergyWrapper.format(requiredEnergy, units), units));
            return;
        }
        int moveX = 0;
        int moveY = 0;
        int moveZ = 0;
        if (this.commandCurrent != EnumShipCommand.HYPERDRIVE) {
            VectorI movement = this.getMovement();
            VectorI shipSize = new VectorI(this.getFront() + 1 + this.getBack(), this.getUp() + 1 + this.getDown(), this.getRight() + 1 + this.getLeft());
            int maxDistance = this.shipMovementCosts.maximumDistance_blocks;
            if (Math.abs(movement.x) - shipSize.x > maxDistance) {
                movement.x = (int)Math.signum(movement.x) * (shipSize.x + maxDistance);
            }
            if (Math.abs(movement.y) - shipSize.y > maxDistance) {
                movement.y = (int)Math.signum(movement.y) * (shipSize.y + maxDistance);
            }
            if (Math.abs(movement.z) - shipSize.z > maxDistance) {
                movement.z = (int)Math.signum(movement.z) * (shipSize.z + maxDistance);
            }
            moveX = this.facing.func_82601_c() * movement.x - this.facing.func_82599_e() * movement.z;
            moveY = movement.y;
            moveZ = this.facing.func_82599_e() * movement.x + this.facing.func_82601_c() * movement.z;
        }
        if (WarpDriveConfig.LOGGING_JUMP) {
            WarpDrive.logger.info(this + " Movement adjusted to (" + moveX + " " + moveY + " " + moveZ + ") blocks.");
        }
        JumpSequencer jump = new JumpSequencer(this, this.shipMovementType, null, moveX, moveY, moveZ, this.getRotationSteps(), 0, 0, 0);
        jump.enable();
    }

    private static boolean isOutsideBB(@Nonnull AxisAlignedBB axisalignedbb, int x, int y, int z) {
        return axisalignedbb.field_72340_a > (double)x || axisalignedbb.field_72336_d < (double)x || axisalignedbb.field_72338_b > (double)y || axisalignedbb.field_72337_e < (double)y || axisalignedbb.field_72339_c > (double)z || axisalignedbb.field_72334_f < (double)z;
    }

    @Override
    public WarpDriveText getStatus() {
        WarpDriveText textStatus = super.getStatus();
        if (this.ticksCooldown > 0) {
            textStatus.append(null, "warpdrive.ship.status_line.cooling", this.ticksCooldown / 20);
        }
        if (this.isolationBlocksCount > 0) {
            String strIsolationRate = String.format("%.1f", this.isolationRate * 100.0);
            textStatus.append(null, "warpdrive.ship.status_line.isolation", this.isolationBlocksCount, strIsolationRate);
        }
        return textStatus;
    }

    public ITextComponent getBoundingBoxStatus() {
        return super.getStatusPrefix().func_150257_a((ITextComponent)new TextComponentTranslation(this.showBoundingBox ? "tile.warpdrive.movement.ship_core.bounding_box.enabled" : "tile.warpdrive.movement.ship_core.bounding_box.disabled", new Object[0]));
    }

    @Override
    public String getInternalStatus() {
        return String.format("%s\nmax %d %d %d min %d %d %d mass %d volume %d aabb %s\nstate %s command %s shipMovementType %s timeLastShipScanDone %d shipScanner %s shipMovementCosts %s\ndistanceSquared %d isCooldownReported %s isMotionSicknessApplied %s isSoundPlayed %s isWarmupReported %s randomWarmupAddition_ticks %d\n", new Object[]{super.getInternalStatus(), this.maxX, this.maxY, this.maxZ, this.minX, this.minY, this.minZ, this.shipMass, this.shipVolume, this.cache_aabbArea, this.stateCurrent, this.commandCurrent, this.shipMovementType, this.timeLastShipScanDone, this.shipScanner, this.shipMovementCosts, this.distanceSquared, this.isCooldownReported, this.isMotionSicknessApplied, this.isSoundPlayed, this.isWarmupReported, this.randomWarmupAddition_ticks});
    }

    @Override
    public boolean energy_canInput(EnumFacing from) {
        return true;
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.isolationRate = tagCompound.func_74769_h("isolationRate");
        this.ticksCooldown = tagCompound.func_74762_e("cooldownTime");
        this.warmupTime_ticks = tagCompound.func_74762_e("warmupTime");
        this.jumpCount = tagCompound.func_74762_e("jumpCount");
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        tagCompound.func_74780_a("isolationRate", this.isolationRate);
        tagCompound.func_74768_a("cooldownTime", this.ticksCooldown);
        tagCompound.func_74768_a("warmupTime", this.warmupTime_ticks);
        tagCompound.func_74768_a("jumpCount", this.jumpCount);
        return tagCompound;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tagCompound = super.func_189517_E_();
        tagCompound.func_74768_a("minX", this.minX);
        tagCompound.func_74768_a("maxX", this.maxX);
        tagCompound.func_74768_a("minY", this.minY);
        tagCompound.func_74768_a("maxY", this.maxY);
        tagCompound.func_74768_a("minZ", this.minZ);
        tagCompound.func_74768_a("maxZ", this.maxZ);
        return tagCompound;
    }

    @Override
    public void onDataPacket(@Nonnull NetworkManager networkManager, @Nonnull SPacketUpdateTileEntity packet) {
        super.onDataPacket(networkManager, packet);
        NBTTagCompound tagCompound = packet.func_148857_g();
        this.minX = tagCompound.func_74762_e("minX");
        this.maxX = tagCompound.func_74762_e("maxX");
        this.minY = tagCompound.func_74762_e("minY");
        this.maxY = tagCompound.func_74762_e("maxY");
        this.minZ = tagCompound.func_74762_e("minZ");
        this.maxZ = tagCompound.func_74762_e("maxZ");
        this.cache_aabbArea = null;
    }

    @Override
    public String getSignatureName() {
        return this.name;
    }

    @Override
    public EnumGlobalRegionType getGlobalRegionType() {
        return EnumGlobalRegionType.SHIP;
    }

    @Override
    public AxisAlignedBB getGlobalRegionArea() {
        if (this.cache_aabbArea == null) {
            this.cache_aabbArea = new AxisAlignedBB((double)this.minX, (double)this.minY, (double)this.minZ, (double)this.maxX + 1.0, (double)this.maxY + 1.0, (double)this.maxZ + 1.0);
        }
        return this.cache_aabbArea;
    }

    @Override
    public int getMass() {
        return this.shipMass;
    }

    @Override
    public double getIsolationRate() {
        return this.isolationRate;
    }

    @Override
    public boolean onBlockUpdatingInArea(@Nullable Entity entity, BlockPos blockPos, IBlockState blockState) {
        return true;
    }

    @Override
    public Object[] getOrientation() {
        return new Object[]{this.facing.func_82601_c(), 0, this.facing.func_82599_e()};
    }

    @Override
    public Object[] isInSpace() {
        return new Boolean[]{CelestialObjectManager.isInSpace(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p())};
    }

    @Override
    public Object[] isInHyperspace() {
        return new Boolean[]{CelestialObjectManager.isInHyperspace(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177952_p())};
    }

    @Override
    public Object[] getEnergyRequired() {
        WarpDriveText reason = new WarpDriveText();
        int energyRequired = this.getEnergyRequired(this.enumShipCommand, reason);
        if (energyRequired < 0) {
            return new Object[]{false, Commons.removeFormatting(reason.func_150260_c())};
        }
        String units = this.energy_getDisplayUnits();
        return new Object[]{true, EnergyWrapper.convert(energyRequired, units)};
    }

    @Override
    public Object[] getShipSize() {
        return new Object[]{this.shipMass, this.shipVolume};
    }

    @Override
    public Object[] getMaxJumpDistance() {
        WarpDriveText reason = new WarpDriveText();
        int maximumDistance_blocks = this.getMaxJumpDistance(this.enumShipCommand, reason);
        if (maximumDistance_blocks < 0) {
            return new Object[]{false, reason.toString()};
        }
        return new Object[]{true, maximumDistance_blocks};
    }
}

