/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.client;

import cr0s.warpdrive.CommonProxy;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockBase;
import cr0s.warpdrive.api.IItemBase;
import cr0s.warpdrive.block.breathing.BlockColorAirShield;
import cr0s.warpdrive.client.SpriteManager;
import cr0s.warpdrive.entity.EntityNPC;
import cr0s.warpdrive.entity.EntityOfflineAvatar;
import cr0s.warpdrive.entity.EntityParticleBunch;
import cr0s.warpdrive.event.ClientHandler;
import cr0s.warpdrive.event.ModelBakeEventHandler;
import cr0s.warpdrive.event.TooltipHandler;
import cr0s.warpdrive.render.ClientCameraHandler;
import cr0s.warpdrive.render.RenderEntityNPC;
import cr0s.warpdrive.render.RenderEntityOfflineAvatar;
import cr0s.warpdrive.render.RenderEntityParticleBunch;
import cr0s.warpdrive.render.RenderOverlayAir;
import cr0s.warpdrive.render.RenderOverlayCamera;
import cr0s.warpdrive.render.RenderOverlayLocation;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
extends CommonProxy {
    @Override
    public boolean isDedicatedServer() {
        return false;
    }

    @Override
    public void onForgePreInitialisation() {
        super.onForgePreInitialisation();
        OBJLoader.INSTANCE.addDomain("warpdrive");
        MinecraftForge.EVENT_BUS.register((Object)ModelBakeEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)SpriteManager.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityNPC.class, (IRenderFactory)new IRenderFactory<EntityNPC>(){

            @Nonnull
            public Render<EntityNPC> createRenderFor(RenderManager manager) {
                return new RenderEntityNPC(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityOfflineAvatar.class, (IRenderFactory)new IRenderFactory<EntityOfflineAvatar>(){

            @Nonnull
            public Render<EntityOfflineAvatar> createRenderFor(RenderManager manager) {
                return new RenderEntityOfflineAvatar(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityParticleBunch.class, (IRenderFactory)new IRenderFactory<EntityParticleBunch>(){

            @Nonnull
            public Render<Entity> createRenderFor(RenderManager manager) {
                return new RenderEntityParticleBunch(manager);
            }
        });
    }

    @Override
    public void onForgeInitialisation() {
        super.onForgeInitialisation();
        MinecraftForge.EVENT_BUS.register((Object)new ClientHandler());
        MinecraftForge.EVENT_BUS.register((Object)new TooltipHandler());
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new BlockColorAirShield(), new Block[]{WarpDrive.blockAirShield});
        MinecraftForge.EVENT_BUS.register((Object)new RenderOverlayAir());
        MinecraftForge.EVENT_BUS.register((Object)new RenderOverlayCamera());
        MinecraftForge.EVENT_BUS.register((Object)new RenderOverlayLocation());
        MinecraftForge.EVENT_BUS.register((Object)new ClientCameraHandler());
    }

    @Override
    public void onModelInitialisation(Object object) {
        if (object instanceof IBlockBase) {
            ((IBlockBase)object).modelInitialisation();
        } else if (object instanceof IItemBase) {
            ((IItemBase)object).modelInitialisation();
        } else {
            throw new RuntimeException(String.format("Unsupported object, expecting an IBlockBase or IItemBase instance: %s", object));
        }
    }

    @Nonnull
    public static ModelResourceLocation getModelResourceLocation(@Nonnull ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        ResourceLocation resourceLocation = item.getRegistryName();
        assert (resourceLocation != null);
        if (item instanceof ItemBlock) {
            int damage = itemStack.func_77952_i();
            if (damage < 0 || damage > 15) {
                throw new IllegalArgumentException(String.format("Invalid damage %d for %s", damage, itemStack.func_77973_b()));
            }
            Block block = ((ItemBlock)item).func_179223_d();
            IBlockState blockState = block.func_176203_a(damage);
            Collection properties = blockState.func_177227_a();
            if (!properties.isEmpty()) {
                String[] blockStateStrings = blockState.toString().split("[\\[\\]]");
                String variant = blockStateStrings[1];
                return new ModelResourceLocation(resourceLocation, variant);
            }
        }
        if (item.func_77614_k()) {
            resourceLocation = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a() + "-" + itemStack.func_77952_i());
        }
        return new ModelResourceLocation(resourceLocation, "inventory");
    }

    public static void modelInitialisation(@Nonnull Item item) {
        if (!(item instanceof IItemBase)) {
            throw new RuntimeException(String.format("Unable to initialize item's model, expecting an IItemBase instance: %s", item));
        }
        if (!item.func_77614_k()) {
            ModelResourceLocation modelResourceLocation = ((IItemBase)item).getModelResourceLocation(new ItemStack(item));
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)modelResourceLocation);
        } else {
            NonNullList listItemStacks = NonNullList.func_191196_a();
            assert (item.func_77640_w() != null);
            item.func_150895_a(item.func_77640_w(), listItemStacks);
            for (ItemStack itemStack : listItemStacks) {
                ModelResourceLocation modelResourceLocation = ((IItemBase)item).getModelResourceLocation(itemStack);
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)itemStack.func_77960_j(), (ModelResourceLocation)modelResourceLocation);
            }
        }
    }
}

