/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.client;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import java.util.HashMap;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class PlayerTextureManager {
    private static final PlayerTextureManager INSTANCE = new PlayerTextureManager();
    private static HashMap<UUID, PlayerTextures> mapIdPlayerTextures = new HashMap(0);
    public static final ResourceLocation RESOURCE_LOCATION_DEFAULT = new ResourceLocation("textures/entity/steve.png");
    public static final ResourceLocation RESOURCE_LOCATION_SLIM = new ResourceLocation("textures/entity/alex.png");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ResourceLocation getPlayerSkin(@Nonnull UUID uuidPlayer, @Nonnull String namePlayer) {
        PlayerTextures playerTextures = mapIdPlayerTextures.get(uuidPlayer);
        if (playerTextures != null) {
            if (playerTextures.resourceLocationSkin == null) {
                return RESOURCE_LOCATION_DEFAULT;
            }
            return playerTextures.resourceLocationSkin;
        }
        PlayerTextureManager playerTextureManager = INSTANCE;
        synchronized (playerTextureManager) {
            PlayerTextures playerTextures2 = new PlayerTextures();
            HashMap<UUID, PlayerTextures> mapIdTypeTextureNew = new HashMap<UUID, PlayerTextures>(mapIdPlayerTextures.size() + 1);
            mapIdTypeTextureNew.putAll(mapIdPlayerTextures);
            mapIdTypeTextureNew.put(uuidPlayer, playerTextures2);
            mapIdPlayerTextures = mapIdTypeTextureNew;
            Commons.getGameProfile(uuidPlayer, namePlayer, gameProfileFilled -> Minecraft.func_71410_x().func_152342_ad().func_152790_a(gameProfileFilled, (type, location, profileTexture) -> {
                switch (type) {
                    case SKIN: {
                        playerTextures.resourceLocationSkin = location;
                        String skinType = profileTexture.getMetadata("model");
                        if (skinType == null) {
                            playerTextures.skinType = "default";
                            break;
                        }
                        playerTextures.skinType = skinType;
                        break;
                    }
                    case CAPE: {
                        playerTextures.resourceLocationCape = location;
                        break;
                    }
                    default: {
                        WarpDrive.logger.warn(String.format("Unsupported texture type %s with location %s profile %s for %s", type, location, profileTexture, gameProfileFilled));
                    }
                }
            }, true));
            return RESOURCE_LOCATION_DEFAULT;
        }
    }

    private static class PlayerTextures {
        public ResourceLocation resourceLocationSkin;
        public String skinType = "default";
        public ResourceLocation resourceLocationCape;

        private PlayerTextures() {
        }
    }
}

