/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.command;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.command.AbstractCommand;
import cr0s.warpdrive.data.CelestialObjectManager;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CommandDebug
extends AbstractCommand {
    @Nonnull
    public String func_71517_b() {
        return "wdebug";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender commandSender) {
        return "/" + this.func_71517_b() + " <dimension> <x> <y> <z> <blockId> <Metadata> <action><action>...\ndimension: 0/world, 2/space, 3/hyperspace\ncoordinates: x,y,z\naction: I(nvalidate), V(alidate), A(set air), R(emoveEntity), P(setBlock), S(etEntity)";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender commandSender, @Nonnull String[] args) {
        String actions;
        int metadata;
        int block;
        int z;
        int y;
        int x;
        int dim;
        if (args.length <= 6) {
            Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
            return;
        }
        try {
            dim = CelestialObjectManager.getDimensionId(args[0], (Entity)((EntityPlayer)commandSender));
            x = Integer.parseInt(args[1]);
            y = Integer.parseInt(args[2]);
            z = Integer.parseInt(args[3]);
            block = Integer.parseInt(args[4]);
            metadata = Integer.parseInt(args[5]);
            actions = args[6];
        }
        catch (Exception exception) {
            exception.printStackTrace(WarpDrive.printStreamError);
            Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
            return;
        }
        WarpDrive.logger.info(String.format("/%s %d (%d %d %d) %s:%d %s", this.func_71517_b(), dim, x, y, z, block, metadata, actions));
        WorldServer world = DimensionManager.getWorld((int)dim);
        BlockPos blockPos = new BlockPos(x, y, z);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        WarpDrive.logger.info(String.format("[%s] %s, Current block is %s, tile entity is %s", this.func_71517_b(), Commons.format((World)world), world.func_180495_p(blockPos), tileEntity == null ? "undefined" : "defined"));
        String side = FMLCommonHandler.instance().getEffectiveSide().isClient() ? "Client" : "Server";
        block12: for (char cAction : actions.toUpperCase().toCharArray()) {
            switch (cAction) {
                case 'I': {
                    WarpDrive.logger.info(String.format("[%s] %s: invalidating", this.func_71517_b(), side));
                    if (tileEntity == null) continue block12;
                    tileEntity.func_145843_s();
                    continue block12;
                }
                case 'V': {
                    WarpDrive.logger.info(String.format("[%s] %s: validating", this.func_71517_b(), side));
                    if (tileEntity == null) continue block12;
                    tileEntity.func_145829_t();
                    continue block12;
                }
                case 'A': {
                    WarpDrive.logger.info(String.format("[%s] %s: setting to Air", this.func_71517_b(), side));
                    boolean bReturn = world.func_175698_g(blockPos);
                    WarpDrive.logger.info(String.format("[%s] %s: returned %s", this.func_71517_b(), side, bReturn));
                    continue block12;
                }
                case 'R': {
                    WarpDrive.logger.info(String.format("[%s] %s: remove entity", this.func_71517_b(), side));
                    world.func_175713_t(blockPos);
                    continue block12;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    WarpDrive.logger.info(String.format("[%s] %s: set block (%d %d %d) to %s:%s", this.func_71517_b(), side, x, y, z, block, metadata));
                    boolean bReturn = world.func_180501_a(blockPos, Block.func_149729_e((int)block).func_176203_a(metadata), cAction - 48);
                    WarpDrive.logger.info(String.format("[%s] %s: returned %s", this.func_71517_b(), side, bReturn));
                    continue block12;
                }
                case 'P': {
                    WarpDrive.logger.info(String.format("[%s] %s: set block (%d %d %d) to %s:%s", this.func_71517_b(), side, x, y, z, block, metadata));
                    boolean bReturn = world.func_180501_a(blockPos, Block.func_149729_e((int)block).func_176203_a(metadata), 2);
                    WarpDrive.logger.info(String.format("[%s] %s: returned %s", this.func_71517_b(), side, bReturn));
                    continue block12;
                }
                case 'S': {
                    WarpDrive.logger.info(String.format("[%s] %s: set entity", this.func_71517_b(), side));
                    world.func_175690_a(blockPos, tileEntity);
                    continue block12;
                }
                case 'C': {
                    WarpDrive.logger.info(String.format("[%s] %s: update containing block info", this.func_71517_b(), side));
                    if (tileEntity == null) continue block12;
                    tileEntity.func_145836_u();
                    continue block12;
                }
                default: {
                    WarpDrive.logger.info(String.format("[%s] %s: invalid step '%s", this.func_71517_b(), side, Character.valueOf(cAction)));
                }
            }
        }
    }
}

