/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.command;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.command.AbstractCommand;
import cr0s.warpdrive.entity.EntityNPC;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CommandNPC
extends AbstractCommand {
    @Nonnull
    public String func_71517_b() {
        return "wnpc";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender commandSender) {
        return String.format("/%s <name> (<scale>) (<texture>) ({<nbt>})\nName may contain space using _ character", this.func_71517_b());
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender commandSender, @Nonnull String[] args) {
        World world = commandSender.func_130014_f_();
        BlockPos blockPos = commandSender.func_180425_c();
        if (world == null || blockPos == null) {
            Commons.addChatMessage(commandSender, this.getPrefix().func_150257_a(new TextComponentTranslation("warpdrive.command.invalid_location", new Object[0]).func_150255_a(Commons.getStyleWarning())));
            return;
        }
        if (args.length < 1 || args.length > 4) {
            Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
            return;
        }
        if (!FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            return;
        }
        String name = args[0].replace("_", " ");
        float scale = 1.0f;
        String texturePath = "";
        String stringNBT = "";
        int indexArg = 1;
        if (args.length > indexArg) {
            try {
                scale = Commons.toFloat(args[indexArg]);
                ++indexArg;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (args.length > indexArg) {
            texturePath = args[indexArg];
            ++indexArg;
        }
        if (args.length > indexArg) {
            stringNBT = args[indexArg];
            ++indexArg;
        }
        if (args.length > indexArg) {
            Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
            return;
        }
        EntityNPC entityNPC = new EntityNPC(world);
        entityNPC.func_70107_b((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.1, (double)blockPos.func_177952_p() + 0.5);
        entityNPC.func_96094_a(name);
        entityNPC.setSizeScale(scale);
        entityNPC.setTextureString(texturePath);
        if (!stringNBT.isEmpty()) {
            NBTTagCompound tagCompound;
            try {
                tagCompound = JsonToNBT.func_180713_a((String)stringNBT);
            }
            catch (NBTException exception) {
                WarpDrive.logger.error(exception.getMessage());
                Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
                return;
            }
            entityNPC.deserializeNBT(tagCompound);
        }
        world.func_72838_d((Entity)entityNPC);
        Commons.addChatMessage(commandSender, this.getPrefix().func_150257_a((ITextComponent)new TextComponentTranslation("Added NPC %1$s", new Object[]{entityNPC})));
    }
}

