/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.command;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.command.AbstractCommand;
import cr0s.warpdrive.data.CelestialObject;
import cr0s.warpdrive.data.CelestialObjectManager;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.data.VectorI;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CommandSpace
extends AbstractCommand {
    @Nonnull
    public String func_71517_b() {
        return "space";
    }

    public int func_82362_a() {
        return 2;
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender commandSender) {
        return "/space (<playerName>) ([overworld|nether|end|theend|space|hyper|hyperspace|<dimensionId>])";
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender commandSender, @Nonnull String[] args) {
        int dimensionIdTarget = Integer.MAX_VALUE;
        EntityPlayerMP[] entityPlayerMPs = null;
        if (commandSender instanceof EntityPlayerMP) {
            entityPlayerMPs = new EntityPlayerMP[]{(EntityPlayerMP)commandSender};
        }
        if (args.length != 0) {
            EntityPlayerMP[] entityPlayerMPs_found;
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("help") || args[0].equalsIgnoreCase("?")) {
                    Commons.addChatMessage(commandSender, (ITextComponent)new TextComponentString(this.func_71518_a(commandSender)));
                    return;
                }
                entityPlayerMPs_found = Commons.getOnlinePlayerByNameOrSelector(commandSender, args[0]);
                if (entityPlayerMPs_found != null) {
                    entityPlayerMPs = entityPlayerMPs_found;
                } else {
                    if (!(commandSender instanceof EntityPlayer)) {
                        Commons.addChatMessage(commandSender, this.getPrefix().func_150257_a(new TextComponentTranslation("warpdrive.command.player_not_found", new Object[]{args[0]}).func_150255_a(Commons.getStyleWarning())));
                        return;
                    }
                    dimensionIdTarget = CelestialObjectManager.getDimensionId(args[0], (Entity)((EntityPlayer)commandSender));
                }
            } else {
                if (args.length != 2) {
                    Commons.addChatMessage(commandSender, this.getPrefix().func_150257_a(new TextComponentTranslation("warpdrive.command.too_many_arguments", new Object[]{args.length}).func_150255_a(Commons.getStyleWarning())));
                    return;
                }
                entityPlayerMPs_found = Commons.getOnlinePlayerByNameOrSelector(commandSender, args[0]);
                if (entityPlayerMPs_found == null) {
                    Commons.addChatMessage(commandSender, this.getPrefix().func_150257_a(new TextComponentTranslation("warpdrive.command.player_not_found", new Object[]{args[0]}).func_150255_a(Commons.getStyleWarning())));
                    return;
                }
                entityPlayerMPs = entityPlayerMPs_found;
                dimensionIdTarget = CelestialObjectManager.getDimensionId(args[1], (Entity)entityPlayerMPs[0]);
            }
        }
        if (entityPlayerMPs == null || entityPlayerMPs.length <= 0) {
            Commons.addChatMessage(commandSender, this.getPrefix().func_150257_a(new TextComponentTranslation("warpdrive.command.player_not_found", new Object[]{args[0]}).func_150255_a(Commons.getStyleWarning())));
            return;
        }
        EntityPlayerMP[] entityPlayerMPArray = entityPlayerMPs;
        int n = entityPlayerMPArray.length;
        int n2 = 0;
        while (true) {
            block30: {
                WorldServer worldTarget;
                int zTarget;
                int yTarget;
                int xTarget;
                EntityPlayerMP entityPlayerMP;
                block27: {
                    VectorI vEntry;
                    VectorI vEntry2;
                    CelestialObject celestialObjectChild;
                    CelestialObject celestialObjectCurrent;
                    block28: {
                        block31: {
                            block33: {
                                block32: {
                                    block29: {
                                        if (n2 >= n) {
                                            return;
                                        }
                                        entityPlayerMP = entityPlayerMPArray[n2];
                                        xTarget = MathHelper.func_76128_c((double)entityPlayerMP.field_70165_t);
                                        yTarget = Math.min(255, Math.max(0, MathHelper.func_76128_c((double)entityPlayerMP.field_70163_u)));
                                        zTarget = MathHelper.func_76128_c((double)entityPlayerMP.field_70161_v);
                                        celestialObjectCurrent = CelestialObjectManager.get(entityPlayerMP.field_70170_p, (int)entityPlayerMP.field_70165_t, (int)entityPlayerMP.field_70161_v);
                                        if (dimensionIdTarget != Integer.MAX_VALUE) break block28;
                                        if (celestialObjectCurrent != null) break block29;
                                        Commons.addChatMessage(commandSender, this.getPrefix().func_150257_a(new TextComponentTranslation("warpdrive.command.player_in_unknown_dimension", new Object[]{entityPlayerMP.func_70005_c_(), entityPlayerMP.field_70170_p.field_73011_w.getDimension()}).func_150255_a(Commons.getStyleWarning())));
                                        Commons.addChatMessage(commandSender, new TextComponentTranslation("warpdrive.command.specify_explicit_dimension", new Object[0]).func_150255_a(Commons.getStyleCorrect()));
                                        break block30;
                                    }
                                    if (!celestialObjectCurrent.isSpace() && !celestialObjectCurrent.isHyperspace()) break block31;
                                    celestialObjectChild = CelestialObjectManager.getClosestChild(entityPlayerMP.field_70170_p, (int)entityPlayerMP.field_70165_t, (int)entityPlayerMP.field_70161_v);
                                    if (celestialObjectChild != null) break block32;
                                    dimensionIdTarget = 0;
                                    break block27;
                                }
                                if (!celestialObjectChild.isVirtual()) break block33;
                                Commons.addChatMessage(commandSender, this.getPrefix().func_150257_a(new TextComponentTranslation("warpdrive.command.player_can_t_go_virtual", new Object[]{entityPlayerMP.func_70005_c_(), celestialObjectChild.getDisplayName()}).func_150255_a(Commons.getStyleWarning())));
                                Commons.addChatMessage(commandSender, new TextComponentTranslation("warpdrive.command.specify_explicit_dimension", new Object[0]).func_150255_a(Commons.getStyleCorrect()));
                                break block30;
                            }
                            dimensionIdTarget = celestialObjectChild.dimensionId;
                            vEntry2 = celestialObjectChild.getEntryOffset();
                            xTarget += vEntry2.x;
                            yTarget += vEntry2.y;
                            zTarget += vEntry2.z;
                            break block27;
                        }
                        if (celestialObjectCurrent.parent == null || celestialObjectCurrent.parent.isVirtual()) {
                            dimensionIdTarget = 0;
                            break block27;
                        } else {
                            dimensionIdTarget = celestialObjectCurrent.parent.dimensionId;
                            vEntry = celestialObjectCurrent.getEntryOffset();
                            xTarget -= vEntry.x;
                            yTarget -= vEntry.y;
                            zTarget -= vEntry.z;
                        }
                        break block27;
                    }
                    if (celestialObjectCurrent != null && celestialObjectCurrent.parent != null && celestialObjectCurrent.parent.dimensionId == dimensionIdTarget) {
                        vEntry = celestialObjectCurrent.getEntryOffset();
                        xTarget -= vEntry.x;
                        yTarget -= vEntry.y;
                        zTarget -= vEntry.z;
                    } else {
                        celestialObjectChild = CelestialObjectManager.getClosestChild(entityPlayerMP.field_70170_p, (int)entityPlayerMP.field_70165_t, (int)entityPlayerMP.field_70161_v);
                        if (celestialObjectChild != null && celestialObjectChild.dimensionId == dimensionIdTarget) {
                            vEntry2 = celestialObjectChild.getEntryOffset();
                            xTarget += vEntry2.x;
                            yTarget += vEntry2.y;
                            zTarget += vEntry2.z;
                        }
                    }
                }
                CelestialObject celestialObjectTarget = CelestialObjectManager.get(false, dimensionIdTarget, xTarget, zTarget);
                if (celestialObjectTarget != null && !celestialObjectTarget.isInsideBorder(xTarget, zTarget)) {
                    xTarget = celestialObjectTarget.dimensionCenterX;
                    zTarget = celestialObjectTarget.dimensionCenterZ;
                }
                if ((worldTarget = Commons.getOrCreateWorldServer(dimensionIdTarget)) == null) {
                    Commons.addChatMessage(commandSender, this.getPrefix().func_150257_a(new TextComponentTranslation("warpdrive.command.undefined_dimension", new Object[]{dimensionIdTarget}).func_150255_a(Commons.getStyleWarning())));
                } else {
                    ITextComponent textComponent = new TextComponentTranslation("warpdrive.command.teleporting_player_x_to_y", new Object[]{entityPlayerMP.func_70005_c_(), Commons.format((World)worldTarget)}).func_150255_a(Commons.getStyleCorrect());
                    Commons.addChatMessage(commandSender, textComponent);
                    WarpDrive.logger.info(textComponent.func_150260_c());
                    if (commandSender != entityPlayerMP) {
                        Commons.addChatMessage((ICommandSender)entityPlayerMP, new TextComponentTranslation("warpdrive.command.teleporting_by_x_to_y", new Object[]{commandSender.func_70005_c_(), Commons.format((World)worldTarget), dimensionIdTarget}).func_150255_a(Commons.getStyleCorrect()));
                    }
                    if (worldTarget.func_175623_d(new BlockPos(xTarget, yTarget - 1, zTarget)) && !entityPlayerMP.field_71075_bZ.field_75101_c || !worldTarget.func_175623_d(new BlockPos(xTarget, yTarget, zTarget)) || !worldTarget.func_175623_d(new BlockPos(xTarget, yTarget + 1, zTarget))) {
                        if ((yTarget = worldTarget.func_175672_r(new BlockPos(xTarget, yTarget, zTarget)).func_177956_o() + 1) == 0) {
                            yTarget = 128;
                        } else {
                            for (int safeY = yTarget - 3; safeY > Math.max(1, yTarget - 20); --safeY) {
                                if (worldTarget.func_175623_d(new BlockPos(xTarget, safeY - 1, zTarget)) || !worldTarget.func_175623_d(new BlockPos(xTarget, safeY, zTarget)) || !worldTarget.func_175623_d(new BlockPos(xTarget, safeY + 1, zTarget))) continue;
                                yTarget = safeY;
                                break;
                            }
                        }
                    }
                    Commons.moveEntity((Entity)entityPlayerMP, (World)worldTarget, new Vector3((double)xTarget + 0.5, (double)yTarget + 0.2, (double)zTarget + 0.5));
                }
            }
            ++n2;
        }
    }
}

