/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatActuallyAdditions
implements IBlockTransformer {
    private static Class<?> classBlockInputter;
    private static final byte[] rotInputter;

    public static void register() {
        try {
            classBlockInputter = Class.forName("de.ellpeck.actuallyadditions.mod.blocks.BlockInputter");
            WarpDriveConfig.registerBlockTransformer("ActuallyAdditions", new CompatActuallyAdditions());
        }
        catch (ClassNotFoundException | RuntimeException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockInputter.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        int side;
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || nbtTileEntity == null) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("SideToPull") && (side = nbtTileEntity.func_74762_e("SideToPull")) > 1) {
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("SideToPull", (int)rotInputter[side]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("SideToPull", (int)rotInputter[rotInputter[side]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("SideToPull", (int)rotInputter[rotInputter[rotInputter[side]]]);
                    break;
                }
            }
        }
        if (nbtTileEntity.func_74764_b("SideToPut") && (side = nbtTileEntity.func_74762_e("SideToPut")) > 1) {
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("SideToPut", (int)rotInputter[side]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("SideToPut", (int)rotInputter[rotInputter[side]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("SideToPut", (int)rotInputter[rotInputter[rotInputter[side]]]);
                    break;
                }
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotInputter = new byte[]{0, 1, 3, 4, 5, 2};
    }
}

