/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatBlockcraftery
implements IBlockTransformer {
    private static Class<?> classBlockCornerBase;
    private static Class<?> classBlockSlantBase;
    private static final byte[] rotCorner;
    private static final byte[] rotSlope;

    public static void register() {
        try {
            classBlockCornerBase = Class.forName("epicsquid.mysticallib.block.BlockCornerBase");
            classBlockSlantBase = Class.forName("epicsquid.mysticallib.block.BlockSlantBase");
            WarpDriveConfig.registerBlockTransformer("Blockcraftery", new CompatBlockcraftery());
        }
        catch (ClassNotFoundException | RuntimeException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockCornerBase.isInstance(block) || classBlockSlantBase.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (classBlockCornerBase.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotCorner[metadata];
                }
                case 2: {
                    return rotCorner[rotCorner[metadata]];
                }
                case 3: {
                    return rotCorner[rotCorner[rotCorner[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockSlantBase.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotSlope[metadata];
                }
                case 2: {
                    return rotSlope[rotSlope[metadata]];
                }
                case 3: {
                    return rotSlope[rotSlope[rotSlope[metadata]]];
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotCorner = new byte[]{1, 2, 3, 0, 5, 6, 7, 4, 8, 9, 10, 11, 12, 13, 14, 15};
        rotSlope = new byte[]{3, 2, 0, 1, 5, 6, 7, 4, 11, 10, 8, 9, 12, 13, 14, 15};
    }
}

