/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class CompatBuildCraft
implements IBlockTransformer {
    private static Class<?> classBlockBCBase_Neptune;
    private static Class<?> classBlockPipeHolder;
    private static Class<?> classBlockArchitectTable;
    private static Class<?> classBlockBuilder;
    private static Class<?> classBlockFiller;
    private static Class<?> classBlockQuarry;
    private static Class<?> classBlockReplacer;
    private static Class<?> classBlockZonePlanner;
    private static final int[] rotFacing;
    private static final int[] rotHorizontal;
    private static final int[] rotHorizontalOr4;
    private static final int[] rotWire;
    private static final Map<String, String> rotNames;
    private static final Map<Integer, Integer> maskFacing;

    public static void register() {
        try {
            classBlockBCBase_Neptune = Class.forName("buildcraft.lib.block.BlockBCBase_Neptune");
            classBlockPipeHolder = Class.forName("buildcraft.transport.block.BlockPipeHolder");
            classBlockArchitectTable = Class.forName("buildcraft.builders.block.BlockArchitectTable");
            classBlockBuilder = Class.forName("buildcraft.builders.block.BlockBuilder");
            classBlockFiller = Class.forName("buildcraft.builders.block.BlockFiller");
            classBlockQuarry = Class.forName("buildcraft.builders.block.BlockQuarry");
            classBlockReplacer = Class.forName("buildcraft.builders.block.BlockReplacer");
            classBlockZonePlanner = Class.forName("buildcraft.robotics.block.BlockZonePlanner");
            WarpDriveConfig.registerBlockTransformer("BuildCraft", new CompatBuildCraft());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockBCBase_Neptune.isInstance(block) || classBlockPipeHolder.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        if (classBlockArchitectTable.isInstance(block) || classBlockBuilder.isInstance(block) || classBlockFiller.isInstance(block) || classBlockQuarry.isInstance(block) || classBlockReplacer.isInstance(block) || classBlockZonePlanner.isInstance(block)) {
            reason.append(Commons.getStyleWarning(), "warpdrive.compat.guide.block_detected_on_board", new TextComponentTranslation(block.func_149739_a(), new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        String idTileEntity;
        byte rotationSteps = transformation.getRotationSteps();
        if (nbtTileEntity == null) {
            return metadata;
        }
        switch (idTileEntity = nbtTileEntity.func_74779_i("id")) {
            case "buildcraftcore:engine.wood": 
            case "buildcraftenergy:engine.stone": 
            case "buildcraftenergy:engine.iron": 
            case "buildcraftcore:engine.creative": {
                if (nbtTileEntity.func_74764_b("currentDirection")) {
                    String nameDirection = nbtTileEntity.func_74779_i("currentDirection");
                    switch (rotationSteps) {
                        case 1: {
                            nbtTileEntity.func_74778_a("currentDirection", rotNames.get(nameDirection));
                            return metadata;
                        }
                        case 2: {
                            nbtTileEntity.func_74778_a("currentDirection", rotNames.get(rotNames.get(nameDirection)));
                            return metadata;
                        }
                        case 3: {
                            nbtTileEntity.func_74778_a("currentDirection", rotNames.get(rotNames.get(rotNames.get(nameDirection))));
                            return metadata;
                        }
                    }
                    return metadata;
                }
                return metadata;
            }
            case "buildcraftcore:marker.volume": 
            case "buildcraftcore:marker.path": 
            case "buildcraftfactory:chute": 
            case "buildcraftsilicon:laser": {
                switch (rotationSteps) {
                    case 1: {
                        return rotFacing[metadata];
                    }
                    case 2: {
                        return rotFacing[rotFacing[metadata]];
                    }
                    case 3: {
                        return rotFacing[rotFacing[rotFacing[metadata]]];
                    }
                }
                return metadata;
            }
            case "buildcraftbuilders:builder": 
            case "buildcraftbuilders:filler": 
            case "buildcraftbuilders:library": 
            case "buildcraftbuilders:quarry": 
            case "buildcraftbuilders:replacer": 
            case "buildcraftfactory:distiller": 
            case "buildcraftfactory:heat_exchange": 
            case "buildcraftfactory:mining_well": 
            case "buildcraftrobotics:zone_planner": {
                switch (rotationSteps) {
                    case 1: {
                        return rotHorizontal[metadata];
                    }
                    case 2: {
                        return rotHorizontal[rotHorizontal[metadata]];
                    }
                    case 3: {
                        return rotHorizontal[rotHorizontal[rotHorizontal[metadata]]];
                    }
                }
                return metadata;
            }
            case "buildcraftbuilders:architect": {
                switch (rotationSteps) {
                    case 1: {
                        return rotHorizontalOr4[metadata];
                    }
                    case 2: {
                        return rotHorizontalOr4[rotHorizontalOr4[metadata]];
                    }
                    case 3: {
                        return rotHorizontalOr4[rotHorizontalOr4[rotHorizontalOr4[metadata]]];
                    }
                }
                return metadata;
            }
            case "buildcraftfactory:flood_gate": {
                byte openSidesOld = nbtTileEntity.func_74771_c("openSides");
                int openSidesNew = 0;
                block77: for (int maskOld : maskFacing.keySet()) {
                    boolean isClosed;
                    boolean bl = isClosed = (openSidesOld & maskOld) == 0;
                    if (isClosed) continue;
                    switch (rotationSteps) {
                        case 1: {
                            openSidesNew |= maskFacing.get(maskOld).intValue();
                            continue block77;
                        }
                        case 2: {
                            openSidesNew |= maskFacing.get(maskFacing.get(maskOld)).intValue();
                            continue block77;
                        }
                        case 3: {
                            openSidesNew |= maskFacing.get(maskFacing.get(maskFacing.get(maskOld))).intValue();
                            continue block77;
                        }
                    }
                    openSidesNew |= maskOld;
                }
                nbtTileEntity.func_74774_a("openSides", (byte)openSidesNew);
                break;
            }
            case "buildcrafttransport:pipe_holder": {
                int[] partsOld;
                NBTTagCompound tagCompoundWireManager;
                NBTTagCompound tagCompoundPipe;
                if (nbtTileEntity.func_74764_b("pipe") && (tagCompoundPipe = nbtTileEntity.func_74775_l("pipe")).func_74764_b("beh")) {
                    NBTTagCompound tagCompoundBehaviour = tagCompoundPipe.func_74775_l("beh");
                    if (tagCompoundBehaviour.func_74764_b("currentDir")) {
                        void var14_22;
                        String currentDirOld = tagCompoundBehaviour.func_74779_i("currentDir");
                        switch (rotationSteps) {
                            case 1: {
                                String string = rotNames.get(currentDirOld);
                                break;
                            }
                            case 2: {
                                String string = rotNames.get(rotNames.get(currentDirOld));
                                break;
                            }
                            case 3: {
                                String string = rotNames.get(rotNames.get(rotNames.get(currentDirOld)));
                                break;
                            }
                            default: {
                                String string = currentDirOld;
                            }
                        }
                        tagCompoundBehaviour.func_74778_a("currentDir", (String)var14_22);
                    }
                    if (tagCompoundBehaviour.func_74764_b("filters")) {
                        NBTTagCompound tagCompoundFilters = tagCompoundBehaviour.func_74775_l("filters");
                        NBTTagList nBTTagList = tagCompoundFilters.func_150295_c("items", 10);
                        int count = nBTTagList.func_74745_c();
                        NBTBase[] filterItemsNew = new NBTBase[count];
                        for (int indexOld = 0; indexOld < count; ++indexOld) {
                            int facingNew;
                            int position = indexOld % 9;
                            int facingOld = (indexOld - position) / 9;
                            switch (rotationSteps) {
                                case 1: {
                                    facingNew = rotFacing[facingOld];
                                    break;
                                }
                                case 2: {
                                    facingNew = rotFacing[rotFacing[facingOld]];
                                    break;
                                }
                                case 3: {
                                    facingNew = rotFacing[rotFacing[rotFacing[facingOld]]];
                                    break;
                                }
                                default: {
                                    facingNew = facingOld;
                                }
                            }
                            int indexNew = facingNew * 9 + position;
                            filterItemsNew[indexNew] = nBTTagList.func_150305_b(indexOld);
                        }
                        NBTTagList tagListFilterItemsNew = new NBTTagList();
                        for (int indexNew = 0; indexNew < count; ++indexNew) {
                            tagListFilterItemsNew.func_74742_a(filterItemsNew[indexNew]);
                        }
                        tagCompoundFilters.func_74782_a("items", (NBTBase)tagListFilterItemsNew);
                    }
                }
                if (nbtTileEntity.func_74764_b("wireManager") && (tagCompoundWireManager = nbtTileEntity.func_74775_l("wireManager")).func_74764_b("parts") && (partsOld = tagCompoundWireManager.func_74759_k("parts")).length > 0) {
                    void var14_26;
                    int[] partsNew = new int[partsOld.length];
                    boolean bl = false;
                    while (var14_26 < partsOld.length) {
                        int positionNew;
                        int positionOld = partsOld[var14_26];
                        switch (rotationSteps) {
                            case 1: {
                                positionNew = rotWire[positionOld];
                                break;
                            }
                            case 2: {
                                positionNew = rotWire[rotWire[positionOld]];
                                break;
                            }
                            case 3: {
                                positionNew = rotWire[rotWire[rotWire[positionOld]]];
                                break;
                            }
                            default: {
                                positionNew = positionOld;
                            }
                        }
                        partsNew[var14_26] = positionNew;
                        partsNew[var14_26 + true] = partsOld[var14_26 + true];
                        var14_26 += 2;
                    }
                    tagCompoundWireManager.func_74783_a("parts", partsNew);
                }
                if (nbtTileEntity.func_74764_b("plugs")) {
                    NBTTagCompound tagCompoundPlugs = nbtTileEntity.func_74775_l("plugs");
                    HashMap<String, NBTBase> mapNew = new HashMap<String, NBTBase>(rotNames.size());
                    for (String string : rotNames.keySet()) {
                        String nameNew;
                        if (!tagCompoundPlugs.func_74764_b(string)) continue;
                        NBTBase tagValue = tagCompoundPlugs.func_74781_a(string);
                        switch (rotationSteps) {
                            case 1: {
                                nameNew = rotNames.get(string);
                                break;
                            }
                            case 2: {
                                nameNew = rotNames.get(rotNames.get(string));
                                break;
                            }
                            case 3: {
                                nameNew = rotNames.get(rotNames.get(rotNames.get(string)));
                                break;
                            }
                            default: {
                                nameNew = string;
                            }
                        }
                        mapNew.put(nameNew, tagValue);
                        tagCompoundPlugs.func_82580_o(string);
                    }
                    for (Map.Entry entry : mapNew.entrySet()) {
                        tagCompoundPlugs.func_74782_a((String)entry.getKey(), (NBTBase)entry.getValue());
                    }
                }
                return metadata;
            }
            case "buildcraftfactory:pump": {
                nbtTileEntity.func_82580_o("currentPos");
                nbtTileEntity.func_74768_a("progress", 0);
                nbtTileEntity.func_74768_a("wantedLength", 0);
                return metadata;
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotFacing = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotHorizontal = new int[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotHorizontalOr4 = new int[]{1, 2, 3, 0, 5, 6, 7, 8, 8, 9, 10, 11, 12, 13, 14, 15};
        rotWire = new int[]{4, 0, 6, 2, 5, 1, 7, 3, 8, 9, 10, 11, 12, 13, 14, 15};
        HashMap<String, String> stringMap = new HashMap<String, String>();
        stringMap.put("DOWN", "DOWN");
        stringMap.put("UP", "UP");
        stringMap.put("NORTH", "EAST");
        stringMap.put("EAST", "SOUTH");
        stringMap.put("SOUTH", "WEST");
        stringMap.put("WEST", "NORTH");
        stringMap.put("down", "down");
        stringMap.put("up", "up");
        stringMap.put("north", "east");
        stringMap.put("east", "south");
        stringMap.put("south", "west");
        stringMap.put("west", "north");
        rotNames = Collections.unmodifiableMap(stringMap);
        HashMap<Integer, Integer> integerMap = new HashMap<Integer, Integer>();
        integerMap.put(1, 1);
        integerMap.put(2, 2);
        integerMap.put(4, 32);
        integerMap.put(8, 16);
        integerMap.put(16, 4);
        integerMap.put(32, 8);
        maskFacing = Collections.unmodifiableMap(integerMap);
    }
}

