/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatComputerCraft
implements IBlockTransformer {
    private static Class<?> classBlockGeneric;
    private static Class<?> classBlockAdvancedModem;
    private static Class<?> classBlockComputerBase;
    private static Class<?> classBlockCable;
    private static Class<?> classBlockPeripheral;
    private static Class<?> classBlockTurtle;
    private static Class<?> classBlockWiredModemFull;
    private static final int[] mrotComputer;
    private static final int[] mrotPeripheral;
    private static final int[] mrotWiredModem;
    private static final int[] mrotAdvancedModem;
    private static final int[] rotDir;

    public static void register(boolean isCCTweakedLoaded) {
        try {
            if (!isCCTweakedLoaded) {
                WarpDrive.logger.info("Loading ComputerCraft compatibility with its original flavor...");
                classBlockGeneric = Class.forName("dan200.computercraft.shared.common.BlockGeneric");
                classBlockAdvancedModem = Class.forName("dan200.computercraft.shared.peripheral.modem.BlockAdvancedModem");
                classBlockComputerBase = Class.forName("dan200.computercraft.shared.computer.blocks.BlockComputerBase");
                classBlockCable = Class.forName("dan200.computercraft.shared.peripheral.common.BlockCable");
                classBlockPeripheral = Class.forName("dan200.computercraft.shared.peripheral.common.BlockPeripheral");
                classBlockTurtle = Class.forName("dan200.computercraft.shared.turtle.blocks.BlockTurtle");
                classBlockWiredModemFull = null;
            } else {
                WarpDrive.logger.info("Loading ComputerCraft compatibility with its CC-Tweaked fork...");
                classBlockGeneric = Class.forName("dan200.computercraft.shared.common.BlockGeneric");
                classBlockAdvancedModem = Class.forName("dan200.computercraft.shared.peripheral.modem.wireless.BlockAdvancedModem");
                classBlockComputerBase = Class.forName("dan200.computercraft.shared.computer.blocks.BlockComputerBase");
                classBlockCable = Class.forName("dan200.computercraft.shared.peripheral.modem.wired.BlockCable");
                classBlockPeripheral = Class.forName("dan200.computercraft.shared.peripheral.common.BlockPeripheral");
                classBlockTurtle = Class.forName("dan200.computercraft.shared.turtle.blocks.BlockTurtle");
                classBlockWiredModemFull = Class.forName("dan200.computercraft.shared.peripheral.modem.wired.BlockWiredModemFull");
            }
            WarpDriveConfig.registerBlockTransformer("computercraft", new CompatComputerCraft());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockGeneric.isInstance(block) && (classBlockWiredModemFull == null || !classBlockWiredModemFull.isInstance(block));
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (classBlockComputerBase.isInstance(block) && !classBlockTurtle.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotComputer[metadata];
                }
                case 2: {
                    return mrotComputer[mrotComputer[metadata]];
                }
                case 3: {
                    return mrotComputer[mrotComputer[mrotComputer[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockCable.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotWiredModem[metadata];
                }
                case 2: {
                    return mrotWiredModem[mrotWiredModem[metadata]];
                }
                case 3: {
                    return mrotWiredModem[mrotWiredModem[mrotWiredModem[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockAdvancedModem.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotAdvancedModem[metadata];
                }
                case 2: {
                    return mrotAdvancedModem[mrotAdvancedModem[metadata]];
                }
                case 3: {
                    return mrotAdvancedModem[mrotAdvancedModem[mrotAdvancedModem[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockPeripheral.isInstance(block)) {
            if (metadata >= 0 && metadata <= 9) {
                switch (rotationSteps) {
                    case 1: {
                        return mrotPeripheral[metadata];
                    }
                    case 2: {
                        return mrotPeripheral[mrotPeripheral[metadata]];
                    }
                    case 3: {
                        return mrotPeripheral[mrotPeripheral[mrotPeripheral[metadata]]];
                    }
                }
                return metadata;
            }
            if (!nbtTileEntity.func_74764_b("dir")) {
                WarpDrive.logger.error(String.format("Unknown ComputerCraft Peripheral block %s with metadata %d and tile entity %s", block, metadata, nbtTileEntity));
                return metadata;
            }
        } else if (!nbtTileEntity.func_74764_b("dir")) {
            WarpDrive.logger.error(String.format("Unknown ComputerCraft directional block %s with metadata %d and tile entity %s", block, metadata, nbtTileEntity));
            return metadata;
        }
        int dir = nbtTileEntity.func_74762_e("dir");
        switch (rotationSteps) {
            case 1: {
                nbtTileEntity.func_74768_a("dir", rotDir[dir]);
                return metadata;
            }
            case 2: {
                nbtTileEntity.func_74768_a("dir", rotDir[rotDir[dir]]);
                return metadata;
            }
            case 3: {
                nbtTileEntity.func_74768_a("dir", rotDir[rotDir[rotDir[dir]]]);
                return metadata;
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotComputer = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 13, 12, 10, 11, 14, 15};
        mrotPeripheral = new int[]{0, 1, 5, 4, 2, 3, 9, 8, 6, 7, 10, 11, 12, 13, 14, 15};
        mrotWiredModem = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 11, 10, 8, 9, 12, 13, 14, 15};
        mrotAdvancedModem = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotDir = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 11, 10, 8, 9, 12, 13, 17, 16, 14, 15};
    }
}

