/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatCustomNPCs
implements IBlockTransformer {
    private static Class<?> classBlockBorder;
    private static Class<?> classBlockCarpentryBench;
    private static Class<?> classBlockBuilder;
    private static Class<?> classBlockMailbox;
    private static Class<?> classBlockNpcRedstone;
    private static final int[] mrot4;
    private static final int[] mrotMailbox;

    public static void register() {
        try {
            classBlockBorder = Class.forName("noppes.npcs.blocks.BlockBorder");
            classBlockBuilder = Class.forName("noppes.npcs.blocks.BlockBuilder");
            classBlockCarpentryBench = Class.forName("noppes.npcs.blocks.BlockCarpentryBench");
            classBlockMailbox = Class.forName("noppes.npcs.blocks.BlockMailbox");
            classBlockNpcRedstone = Class.forName("noppes.npcs.blocks.BlockNpcRedstone");
            WarpDriveConfig.registerBlockTransformer("CustomNPCs", new CompatCustomNPCs());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockBorder.isInstance(block) || classBlockBuilder.isInstance(block) || classBlockCarpentryBench.isInstance(block) || classBlockMailbox.isInstance(block) || classBlockNpcRedstone.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (nbtTileEntity != null && nbtTileEntity.func_74764_b("BorderRotation")) {
            int BorderRotation = nbtTileEntity.func_74762_e("BorderRotation");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("BorderRotation", mrot4[BorderRotation]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("BorderRotation", mrot4[mrot4[BorderRotation]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("BorderRotation", mrot4[mrot4[mrot4[BorderRotation]]]);
                    break;
                }
            }
        }
        if (nbtTileEntity != null && nbtTileEntity.func_74764_b("BlockOnRangeX")) {
            int BlockOnRangeX = nbtTileEntity.func_74762_e("BlockOnRangeX");
            int BlockOnRangeZ = nbtTileEntity.func_74762_e("BlockOnRangeZ");
            int BlockOffRangeX = nbtTileEntity.func_74762_e("BlockOffRangeX");
            int BlockOffRangeZ = nbtTileEntity.func_74762_e("BlockOffRangeZ");
            switch (rotationSteps) {
                case 1: 
                case 3: {
                    nbtTileEntity.func_74768_a("BlockOnRangeX", BlockOnRangeZ);
                    nbtTileEntity.func_74768_a("BlockOnRangeZ", BlockOnRangeX);
                    nbtTileEntity.func_74768_a("BlockOffRangeX", BlockOffRangeZ);
                    nbtTileEntity.func_74768_a("BlockOffRangeZ", BlockOffRangeX);
                    break;
                }
            }
        }
        if (classBlockBorder.isInstance(block) || classBlockBuilder.isInstance(block) || classBlockCarpentryBench.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrot4[metadata];
                }
                case 2: {
                    return mrot4[mrot4[metadata]];
                }
                case 3: {
                    return mrot4[mrot4[mrot4[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockMailbox.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotMailbox[metadata];
                }
                case 2: {
                    return mrotMailbox[mrotMailbox[metadata]];
                }
                case 3: {
                    return mrotMailbox[mrotMailbox[mrotMailbox[metadata]]];
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrot4 = new int[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        mrotMailbox = new int[]{1, 2, 3, 0, 5, 6, 7, 4, 9, 10, 11, 8, 12, 13, 14, 15};
    }
}

