/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatDecocraft
implements IBlockTransformer {
    private static Class<?> classBlockFake;
    private static Class<?> classBlockProps;
    private static final int[] mrotProps;
    private static final int[] rotBlockRotation;

    public static void register() {
        try {
            classBlockFake = Class.forName("com.mia.props.common.BlockFake");
            classBlockProps = Class.forName("com.mia.props.common.BlockProps");
            WarpDriveConfig.registerBlockTransformer("Decocraft", new CompatDecocraft());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockFake.isInstance(block) || classBlockProps.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (nbtTileEntity.func_74764_b("BlockRotation")) {
            int blockRotation = nbtTileEntity.func_74762_e("BlockRotation");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("BlockRotation", rotBlockRotation[blockRotation]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("BlockRotation", rotBlockRotation[rotBlockRotation[blockRotation]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("BlockRotation", rotBlockRotation[rotBlockRotation[rotBlockRotation[blockRotation]]]);
                    break;
                }
            }
        }
        if (nbtTileEntity.func_150297_b("slaves", 9)) {
            NBTTagList listOldSlaves = nbtTileEntity.func_150295_c("slaves", 11);
            for (int index = 0; index < listOldSlaves.func_74745_c(); ++index) {
                int[] intSlavePos = listOldSlaves.func_150306_c(index);
                if (intSlavePos.length == 3) {
                    int x = intSlavePos[0];
                    int y = intSlavePos[1];
                    int z = intSlavePos[2];
                    if (transformation.isInside(x, y, z)) {
                        BlockPos blockPosSlave = transformation.apply(x, y, z);
                        intSlavePos[0] = blockPosSlave.func_177958_n();
                        intSlavePos[1] = blockPosSlave.func_177956_o();
                        intSlavePos[2] = blockPosSlave.func_177952_p();
                        continue;
                    }
                    intSlavePos[0] = 0;
                    intSlavePos[1] = 0;
                    intSlavePos[2] = 0;
                    continue;
                }
                WarpDrive.logger.error(String.format("Unexpected context for slaves[%d] int array in %s for %s", index, nbtTileEntity, block));
            }
        }
        if (nbtTileEntity.func_150297_b("master", 11)) {
            int[] intMasterPos = nbtTileEntity.func_74759_k("master");
            if (intMasterPos.length == 3) {
                int x = intMasterPos[0];
                int y = intMasterPos[1];
                int z = intMasterPos[2];
                if (transformation.isInside(x, y, z)) {
                    BlockPos blockPosMaster = transformation.apply(x, y, z);
                    intMasterPos[0] = blockPosMaster.func_177958_n();
                    intMasterPos[1] = blockPosMaster.func_177956_o();
                    intMasterPos[2] = blockPosMaster.func_177952_p();
                } else {
                    intMasterPos[0] = 0;
                    intMasterPos[1] = 0;
                    intMasterPos[2] = 0;
                }
            } else {
                WarpDrive.logger.error(String.format("Unexpected context for master int array in %s for %s", nbtTileEntity, block));
            }
        }
        if (classBlockProps.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotProps[metadata];
                }
                case 2: {
                    return mrotProps[mrotProps[metadata]];
                }
                case 3: {
                    return mrotProps[mrotProps[mrotProps[metadata]]];
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotProps = new int[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotBlockRotation = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3};
    }
}

