/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatDeepResonance
implements IBlockTransformer {
    private static Method methodBaseBlock_getRotationType;
    private static Class<Enum> classEnumRotationType;
    private static Enum RotationType_ROTATION;
    private static Enum RotationType_HORIZROTATION;
    private static Enum RotationType_NONE;
    private static Class<?> classGenericDRBlock;
    private static final int[] rotFacing;
    private static final int[] rotFacingHorizontal;

    public static void register() {
        try {
            Class<?> classBaseBlock = Class.forName("mcjty.lib.blocks.BaseBlock");
            methodBaseBlock_getRotationType = classBaseBlock.getMethod("getRotationType", new Class[0]);
            Class<?> classRotationType = Class.forName("mcjty.lib.blocks.BaseBlock$RotationType");
            if (!classRotationType.isEnum()) {
                throw new RuntimeException("Invalid non-enum class, please report to mod author!");
            }
            classEnumRotationType = classRotationType;
            RotationType_ROTATION = Enum.valueOf(classEnumRotationType, "ROTATION");
            RotationType_HORIZROTATION = Enum.valueOf(classEnumRotationType, "HORIZROTATION");
            RotationType_NONE = Enum.valueOf(classEnumRotationType, "NONE");
            classGenericDRBlock = Class.forName("mcjty.deepresonance.blocks.GenericDRBlock");
            WarpDriveConfig.registerBlockTransformer("DeepResonance", new CompatDeepResonance());
        }
        catch (ClassNotFoundException | NoSuchMethodException | RuntimeException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classGenericDRBlock.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        Enum enumRotationType;
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (nbtTileEntity != null && nbtTileEntity.func_74764_b("settings")) {
            int mode;
            int dir;
            NBTTagCompound tagCompound;
            int index;
            NBTTagList list = nbtTileEntity.func_150295_c("settings", 10);
            HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(6);
            block17: for (index = 0; index < list.func_74745_c(); ++index) {
                tagCompound = list.func_150305_b(index);
                dir = tagCompound.func_74762_e("dir");
                mode = tagCompound.func_74762_e("n");
                map.put(rotFacing[dir], mode);
                switch (rotationSteps) {
                    case 1: {
                        map.put(rotFacing[dir], mode);
                        continue block17;
                    }
                    case 2: {
                        map.put(rotFacing[rotFacing[dir]], mode);
                        continue block17;
                    }
                    case 3: {
                        map.put(rotFacing[rotFacing[rotFacing[dir]]], mode);
                        continue block17;
                    }
                }
            }
            for (index = 0; index < list.func_74745_c(); ++index) {
                tagCompound = list.func_150305_b(index);
                dir = tagCompound.func_74762_e("dir");
                mode = (Integer)map.get(dir);
                tagCompound.func_74768_a("n", mode);
            }
        }
        try {
            Object object = methodBaseBlock_getRotationType.invoke((Object)block, new Object[0]);
            if (!classEnumRotationType.isInstance(object)) {
                WarpDrive.logger.error(String.format("Block %s has invalid non-Enum return value to getRotationType: %s", block.getRegistryName(), object));
                return metadata;
            }
            enumRotationType = (Enum)object;
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            exception.printStackTrace();
            return metadata;
        }
        if (enumRotationType == RotationType_HORIZROTATION) {
            switch (rotationSteps) {
                case 1: {
                    return rotFacingHorizontal[metadata];
                }
                case 2: {
                    return rotFacingHorizontal[rotFacingHorizontal[metadata]];
                }
                case 3: {
                    return rotFacingHorizontal[rotFacingHorizontal[rotFacingHorizontal[metadata]]];
                }
            }
            return metadata;
        }
        if (enumRotationType == RotationType_ROTATION) {
            switch (rotationSteps) {
                case 1: {
                    return rotFacing[metadata];
                }
                case 2: {
                    return rotFacing[rotFacing[metadata]];
                }
                case 3: {
                    return rotFacing[rotFacing[rotFacing[metadata]]];
                }
            }
            return metadata;
        }
        if (enumRotationType != RotationType_NONE) {
            WarpDrive.logger.error(String.format("Invalid rotation type %s for block %s", enumRotationType, block.getRegistryName()));
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotFacing = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotFacingHorizontal = new int[]{3, 2, 0, 1, 7, 6, 4, 5, 11, 10, 8, 9, 15, 14, 12, 13};
    }
}

