/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatExtraUtilities2
implements IBlockTransformer {
    private static Class<?> classBlockIndexer;
    private static Class<?> classBlockMachine;
    private static Class<?> classBlockPlayerChest;
    private static Class<?> classBlockScreen;
    private static Class<?> classBlockWardChunkLoader;
    private static Class<?> classBlockXUBlockFull;
    private static Class<?> classBlockXUBlockStaticRotation;
    private static Class<?> classBlockAdvInteractor;
    private static Class<?> classBlockOneWay;
    private static Class<?> classBlockPowerTransmitter;
    private static Class<?> classBlockQuarryProxy;
    private static Class<?> classBlockSpike;
    private static Class<?> classBlockSpotlight;
    private static Class<?> classBlockTransferHolder;
    private static final byte[] rotFacing;
    private static final byte[] rotFacingHorizontal;
    private static final Map<String, String> rotPipeTagName;

    public static void register() {
        try {
            classBlockIndexer = Class.forName("com.rwtema.extrautils2.transfernodes.BlockIndexer");
            classBlockMachine = Class.forName("com.rwtema.extrautils2.machine.BlockMachine");
            classBlockPlayerChest = Class.forName("com.rwtema.extrautils2.blocks.BlockPlayerChest");
            classBlockScreen = Class.forName("com.rwtema.extrautils2.blocks.BlockScreen");
            classBlockWardChunkLoader = Class.forName("com.rwtema.extrautils2.blocks.BlockWardChunkLoader");
            classBlockXUBlockFull = Class.forName("com.rwtema.extrautils2.backend.XUBlockFull");
            classBlockXUBlockStaticRotation = Class.forName("com.rwtema.extrautils2.backend.XUBlockStaticRotation");
            classBlockAdvInteractor = Class.forName("com.rwtema.extrautils2.blocks.BlockAdvInteractor");
            classBlockOneWay = Class.forName("com.rwtema.extrautils2.blocks.BlockOneWay");
            classBlockPowerTransmitter = Class.forName("com.rwtema.extrautils2.power.energy.BlockPowerTransmitter");
            classBlockQuarryProxy = Class.forName("com.rwtema.extrautils2.quarry.BlockQuarryProxy");
            classBlockSpike = Class.forName("com.rwtema.extrautils2.blocks.BlockSpike");
            classBlockSpotlight = Class.forName("com.rwtema.extrautils2.blocks.BlockSpotlight");
            classBlockTransferHolder = Class.forName("com.rwtema.extrautils2.transfernodes.BlockTransferHolder");
            WarpDriveConfig.registerBlockTransformer("ExtraUtilities2", new CompatExtraUtilities2());
        }
        catch (ClassNotFoundException | RuntimeException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockIndexer.isInstance(block) || classBlockMachine.isInstance(block) || classBlockPlayerChest.isInstance(block) || classBlockScreen.isInstance(block) || classBlockWardChunkLoader.isInstance(block) || classBlockXUBlockFull.isInstance(block) || classBlockXUBlockStaticRotation.isInstance(block) || classBlockQuarryProxy.isInstance(block) || classBlockOneWay.isInstance(block) || classBlockPowerTransmitter.isInstance(block) || classBlockAdvInteractor.isInstance(block) || classBlockSpotlight.isInstance(block) || classBlockSpike.isInstance(block) || classBlockTransferHolder.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (classBlockIndexer.isInstance(block) || classBlockMachine.isInstance(block) || classBlockPlayerChest.isInstance(block) || classBlockScreen.isInstance(block) || classBlockWardChunkLoader.isInstance(block) || classBlockXUBlockFull.isInstance(block) || classBlockXUBlockStaticRotation.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotFacingHorizontal[metadata];
                }
                case 2: {
                    return rotFacingHorizontal[rotFacingHorizontal[metadata]];
                }
                case 3: {
                    return rotFacingHorizontal[rotFacingHorizontal[rotFacingHorizontal[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockQuarryProxy.isInstance(block) || classBlockOneWay.isInstance(block) || classBlockPowerTransmitter.isInstance(block) || classBlockAdvInteractor.isInstance(block) || classBlockSpotlight.isInstance(block) || classBlockSpike.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotFacing[metadata];
                }
                case 2: {
                    return rotFacing[rotFacing[metadata]];
                }
                case 3: {
                    return rotFacing[rotFacing[rotFacing[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockTransferHolder.isInstance(block)) {
            HashMap<String, NBTBase> map = new HashMap<String, NBTBase>();
            for (String string : rotPipeTagName.keySet()) {
                if (!nbtTileEntity.func_74764_b(string)) continue;
                NBTBase tagBase = nbtTileEntity.func_74781_a(string);
                switch (rotationSteps) {
                    case 1: {
                        map.put(rotPipeTagName.get(string), tagBase);
                        break;
                    }
                    case 2: {
                        map.put(rotPipeTagName.get(rotPipeTagName.get(string)), tagBase);
                        break;
                    }
                    case 3: {
                        map.put(rotPipeTagName.get(rotPipeTagName.get(rotPipeTagName.get(string))), tagBase);
                        break;
                    }
                    default: {
                        map.put(string, tagBase);
                    }
                }
                nbtTileEntity.func_82580_o(string);
            }
            if (!map.isEmpty()) {
                for (Map.Entry entry : map.entrySet()) {
                    nbtTileEntity.func_74782_a((String)entry.getKey(), (NBTBase)entry.getValue());
                }
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotFacing = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotFacingHorizontal = new byte[]{3, 2, 0, 1, 7, 6, 4, 5, 11, 10, 8, 9, 15, 14, 12, 13};
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Grocket_2", "Grocket_5");
        map.put("Grocket_5", "Grocket_3");
        map.put("Grocket_3", "Grocket_4");
        map.put("Grocket_4", "Grocket_2");
        map.put("Type_2", "Type_5");
        map.put("Type_5", "Type_3");
        map.put("Type_3", "Type_4");
        map.put("Type_4", "Type_2");
        rotPipeTagName = Collections.unmodifiableMap(map);
    }
}

