/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatGregTech
implements IBlockTransformer {
    private static Class<?> classMetaTileEntityHolder;
    private static Class<?> classTileEntityPipeBase;
    private static final int[] rotFacing;

    public static void register() {
        try {
            classMetaTileEntityHolder = Class.forName("gregtech.api.metatileentity.MetaTileEntityHolder");
            classTileEntityPipeBase = Class.forName("gregtech.api.pipenet.tile.TileEntityPipeBase");
            WarpDriveConfig.registerBlockTransformer("gregtech", new CompatGregTech());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classMetaTileEntityHolder.isInstance(tileEntity) || classTileEntityPipeBase.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        NBTTagCompound tagCompoundMetaTileEntity;
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || nbtTileEntity == null) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("BlockedConnections")) {
            int blockedConnectionsOld = nbtTileEntity.func_74762_e("BlockedConnections");
            int blockedConnectionsNew = blockedConnectionsOld & 3;
            for (EnumFacing enumFacing : EnumFacing.field_176754_o) {
                int indexFacingNew;
                boolean isBlocked;
                int indexFacingOld = enumFacing.func_176745_a();
                boolean bl = isBlocked = (blockedConnectionsOld & 1 << indexFacingOld) != 0;
                if (!isBlocked) continue;
                switch (rotationSteps) {
                    case 1: {
                        indexFacingNew = rotFacing[indexFacingOld];
                        break;
                    }
                    case 2: {
                        indexFacingNew = rotFacing[rotFacing[indexFacingOld]];
                        break;
                    }
                    case 3: {
                        indexFacingNew = rotFacing[rotFacing[rotFacing[indexFacingOld]]];
                        break;
                    }
                    default: {
                        indexFacingNew = indexFacingOld;
                    }
                }
                blockedConnectionsNew |= 1 << indexFacingNew;
            }
            nbtTileEntity.func_74768_a("BlockedConnections", blockedConnectionsNew);
        }
        if (nbtTileEntity.func_74764_b("MetaTileEntity") && (tagCompoundMetaTileEntity = nbtTileEntity.func_74775_l("MetaTileEntity")).func_74764_b("FrontFacing")) {
            int frontFacing = tagCompoundMetaTileEntity.func_74762_e("FrontFacing");
            switch (rotationSteps) {
                case 1: {
                    tagCompoundMetaTileEntity.func_74768_a("FrontFacing", rotFacing[frontFacing]);
                    break;
                }
                case 2: {
                    tagCompoundMetaTileEntity.func_74768_a("FrontFacing", rotFacing[rotFacing[frontFacing]]);
                    break;
                }
                case 3: {
                    tagCompoundMetaTileEntity.func_74768_a("FrontFacing", rotFacing[rotFacing[rotFacing[frontFacing]]]);
                    break;
                }
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotFacing = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

