/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatMekanism
implements IBlockTransformer {
    private static Class<?> tileEntityBasicBlock;
    private static Class<?> tileEntityBoundingBlock;
    private static Class<?> tileEntityGlowPanel;
    private static Class<?> tileEntitySidedPipe;
    private static final int[] rotFacing;
    private static final Map<String, String> rotConnectionNames;

    public static void register() {
        try {
            tileEntityBasicBlock = Class.forName("mekanism.common.tile.prefab.TileEntityBasicBlock");
            tileEntityBoundingBlock = Class.forName("mekanism.common.tile.TileEntityBoundingBlock");
            tileEntityGlowPanel = Class.forName("mekanism.common.tile.TileEntityGlowPanel");
            tileEntitySidedPipe = Class.forName("mekanism.common.tile.transmitter.TileEntitySidedPipe");
            WarpDriveConfig.registerBlockTransformer("Mekanism", new CompatMekanism());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return tileEntityBasicBlock.isInstance(tileEntity) || tileEntityBoundingBlock.isInstance(tileEntity) || tileEntityGlowPanel.isInstance(tileEntity) || tileEntitySidedPipe.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || nbtTileEntity == null) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("facing")) {
            int facing = nbtTileEntity.func_74762_e("facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("facing", rotFacing[facing]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("facing", rotFacing[rotFacing[facing]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("facing", rotFacing[rotFacing[rotFacing[facing]]]);
                    break;
                }
            }
        }
        if (nbtTileEntity.func_74764_b("side")) {
            int side = nbtTileEntity.func_74762_e("side");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("side", rotFacing[side]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("side", rotFacing[rotFacing[side]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("side", rotFacing[rotFacing[rotFacing[side]]]);
                    break;
                }
            }
        }
        HashMap<String, NBTBase> mapRotated = new HashMap<String, NBTBase>(rotConnectionNames.size());
        block15: for (String string : rotConnectionNames.keySet()) {
            if (!nbtTileEntity.func_74764_b(string)) continue;
            NBTBase nbtBase = nbtTileEntity.func_74781_a(string);
            nbtTileEntity.func_82580_o(string);
            switch (rotationSteps) {
                case 1: {
                    mapRotated.put(rotConnectionNames.get(string), nbtBase);
                    continue block15;
                }
                case 2: {
                    mapRotated.put(rotConnectionNames.get(rotConnectionNames.get(string)), nbtBase);
                    continue block15;
                }
                case 3: {
                    mapRotated.put(rotConnectionNames.get(rotConnectionNames.get(rotConnectionNames.get(string))), nbtBase);
                    continue block15;
                }
            }
            mapRotated.put(string, nbtBase);
        }
        for (Map.Entry entry : mapRotated.entrySet()) {
            nbtTileEntity.func_74782_a((String)entry.getKey(), (NBTBase)entry.getValue());
        }
        if (nbtTileEntity.func_74764_b("mainX") && nbtTileEntity.func_74764_b("mainY") && nbtTileEntity.func_74764_b("mainZ")) {
            BlockPos mainTarget = transformation.apply(nbtTileEntity.func_74762_e("mainX"), nbtTileEntity.func_74762_e("mainY"), nbtTileEntity.func_74762_e("mainZ"));
            nbtTileEntity.func_74768_a("mainX", mainTarget.func_177958_n());
            nbtTileEntity.func_74768_a("mainY", mainTarget.func_177956_o());
            nbtTileEntity.func_74768_a("mainZ", mainTarget.func_177952_p());
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotFacing = new int[]{0, 1, 5, 4, 2, 3};
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("connection2", "connection5");
        map.put("connection5", "connection3");
        map.put("connection3", "connection4");
        map.put("connection4", "connection2");
        rotConnectionNames = Collections.unmodifiableMap(map);
    }
}

