/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatMetalChests
implements IBlockTransformer {
    private static Class<?> classBlockMetalChest;
    private static final Map<String, String> rotFacingNames;

    public static void register() {
        try {
            classBlockMetalChest = Class.forName("t145.metalchests.blocks.BlockMetalChest");
            WarpDriveConfig.registerBlockTransformer("MetalChests", new CompatMetalChests());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockMetalChest.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || nbtTileEntity == null) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("Front")) {
            String facing = nbtTileEntity.func_74779_i("Front");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74778_a("Front", rotFacingNames.get(facing));
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74778_a("Front", rotFacingNames.get(rotFacingNames.get(facing)));
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74778_a("Front", rotFacingNames.get(rotFacingNames.get(rotFacingNames.get(facing))));
                    break;
                }
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("north", "east");
        map.put("east", "south");
        map.put("south", "west");
        map.put("west", "north");
        rotFacingNames = Collections.unmodifiableMap(map);
    }
}

