/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatMysticalAgriculture
implements IBlockTransformer {
    private static Class<?> classBlockInferiumFurnace;
    private static Class<?> classBlockIntermediumFurnace;
    private static Class<?> classBlockPrudentiumFurnace;
    private static Class<?> classBlockSuperiumFurnace;
    private static Class<?> classBlockSupremiumFurnace;
    private static Class<?> classBlockUltimateFurnace;
    private static final byte[] rotFacing;

    public static void register() {
        try {
            classBlockInferiumFurnace = Class.forName("com.blakebr0.mysticalagriculture.blocks.furnace.BlockInferiumFurnace");
            classBlockIntermediumFurnace = Class.forName("com.blakebr0.mysticalagriculture.blocks.furnace.BlockIntermediumFurnace");
            classBlockPrudentiumFurnace = Class.forName("com.blakebr0.mysticalagriculture.blocks.furnace.BlockPrudentiumFurnace");
            classBlockSuperiumFurnace = Class.forName("com.blakebr0.mysticalagriculture.blocks.furnace.BlockSuperiumFurnace");
            classBlockSupremiumFurnace = Class.forName("com.blakebr0.mysticalagriculture.blocks.furnace.BlockSupremiumFurnace");
            classBlockUltimateFurnace = Class.forName("com.blakebr0.mysticalagriculture.blocks.furnace.BlockUltimateFurnace");
            WarpDriveConfig.registerBlockTransformer("MysticalAgriculture", new CompatMysticalAgriculture());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockInferiumFurnace.isInstance(block) || classBlockIntermediumFurnace.isInstance(block) || classBlockPrudentiumFurnace.isInstance(block) || classBlockSuperiumFurnace.isInstance(block) || classBlockSupremiumFurnace.isInstance(block) || classBlockUltimateFurnace.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || nbtTileEntity == null) {
            return metadata;
        }
        switch (rotationSteps) {
            case 1: {
                return rotFacing[metadata];
            }
            case 2: {
                return rotFacing[rotFacing[metadata]];
            }
            case 3: {
                return rotFacing[rotFacing[rotFacing[metadata]]];
            }
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotFacing = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

