/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatPneumaticCraft
implements IBlockTransformer {
    private static Class<?> classBlockPneumaticCraft;
    private static Method methodBlockPneumaticCraft_isRotatable;
    private static Class<?> classBlockPneumaticDoor;
    private static Class<?> classBlockPressureChamberWall;
    private static Class<?> classBlockPressureChamberValve;
    private static final byte[] mrotFacing;
    private static final byte[] mrotChamberWall;
    private static final byte[] mrotChamberValve;
    private static final byte[] mrotPneumaticDoor;
    private static final byte[] mrotTextRotation;

    public static void register() {
        try {
            classBlockPneumaticCraft = Class.forName("me.desht.pneumaticcraft.common.block.BlockPneumaticCraft");
            methodBlockPneumaticCraft_isRotatable = classBlockPneumaticCraft.getMethod("isRotatable", new Class[0]);
            classBlockPneumaticDoor = Class.forName("me.desht.pneumaticcraft.common.block.BlockPneumaticDoor");
            classBlockPressureChamberWall = Class.forName("me.desht.pneumaticcraft.common.block.BlockPressureChamberWall");
            classBlockPressureChamberValve = Class.forName("me.desht.pneumaticcraft.common.block.BlockPressureChamberValve");
            WarpDriveConfig.registerBlockTransformer("pneumaticcraft", new CompatPneumaticCraft());
        }
        catch (ClassNotFoundException | NoSuchMethodException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockPneumaticCraft.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        boolean isRotatable;
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 && !nbtTileEntity.func_74764_b("valveX") && !nbtTileEntity.func_74764_b("multiBlockX")) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("textRot")) {
            if (metadata == 0 || metadata == 1) {
                int textRotation = nbtTileEntity.func_74762_e("textRot");
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74768_a("textRot", (int)mrotTextRotation[textRotation]);
                        return metadata;
                    }
                    case 2: {
                        nbtTileEntity.func_74768_a("textRot", (int)mrotTextRotation[mrotTextRotation[textRotation]]);
                        return metadata;
                    }
                    case 3: {
                        nbtTileEntity.func_74768_a("textRot", (int)mrotTextRotation[mrotTextRotation[mrotTextRotation[textRotation]]]);
                        return metadata;
                    }
                }
                return metadata;
            }
            switch (rotationSteps) {
                case 1: {
                    return mrotFacing[metadata];
                }
                case 2: {
                    return mrotFacing[mrotFacing[metadata]];
                }
                case 3: {
                    return mrotFacing[mrotFacing[mrotFacing[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("inputDir")) {
            int inputDir = nbtTileEntity.func_74762_e("inputDir");
            int outputDir = nbtTileEntity.func_74762_e("outputDir");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("inputDir", (int)mrotFacing[inputDir]);
                    nbtTileEntity.func_74768_a("outputDir", (int)mrotFacing[outputDir]);
                    return mrotFacing[metadata];
                }
                case 2: {
                    nbtTileEntity.func_74768_a("inputDir", (int)mrotFacing[mrotFacing[inputDir]]);
                    nbtTileEntity.func_74768_a("outputDir", (int)mrotFacing[mrotFacing[outputDir]]);
                    return mrotFacing[mrotFacing[metadata]];
                }
                case 3: {
                    nbtTileEntity.func_74768_a("inputDir", (int)mrotFacing[mrotFacing[mrotFacing[inputDir]]]);
                    nbtTileEntity.func_74768_a("outputDir", (int)mrotFacing[mrotFacing[mrotFacing[outputDir]]]);
                    return mrotFacing[mrotFacing[mrotFacing[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockPneumaticDoor.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotPneumaticDoor[metadata];
                }
                case 2: {
                    return mrotPneumaticDoor[mrotPneumaticDoor[metadata]];
                }
                case 3: {
                    return mrotPneumaticDoor[mrotPneumaticDoor[mrotPneumaticDoor[metadata]]];
                }
            }
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("valveX")) {
            BlockPos target = transformation.apply(nbtTileEntity.func_74762_e("valveX"), nbtTileEntity.func_74762_e("valveY"), nbtTileEntity.func_74762_e("valveZ"));
            nbtTileEntity.func_74768_a("valveX", target.func_177958_n());
            nbtTileEntity.func_74768_a("valveY", target.func_177956_o());
            nbtTileEntity.func_74768_a("valveZ", target.func_177952_p());
        }
        if (nbtTileEntity.func_74764_b("multiBlockX")) {
            int multiBlockSize = nbtTileEntity.func_74762_e("multiBlockSize");
            if (multiBlockSize != 0) {
                BlockPos sourceMin = new BlockPos(nbtTileEntity.func_74762_e("multiBlockX"), nbtTileEntity.func_74762_e("multiBlockY"), nbtTileEntity.func_74762_e("multiBlockZ"));
                BlockPos sourceMax = new BlockPos(sourceMin.func_177958_n() + multiBlockSize - 1, sourceMin.func_177956_o() + multiBlockSize - 1, sourceMin.func_177952_p() + multiBlockSize - 1);
                BlockPos target1 = transformation.apply(sourceMin);
                BlockPos target2 = transformation.apply(sourceMax);
                nbtTileEntity.func_74768_a("multiBlockX", Math.min(target1.func_177958_n(), target2.func_177958_n()));
                nbtTileEntity.func_74768_a("multiBlockY", Math.min(target1.func_177956_o(), target2.func_177956_o()));
                nbtTileEntity.func_74768_a("multiBlockZ", Math.min(target1.func_177952_p(), target2.func_177952_p()));
            }
            NBTTagList tagListOld = nbtTileEntity.func_150295_c("Valves", 10);
            NBTTagList tagListNew = new NBTTagList();
            for (int index = 0; index < tagListOld.func_74745_c(); ++index) {
                NBTTagCompound tagCompound = tagListOld.func_150305_b(index);
                if (tagCompound == null) continue;
                BlockPos coordinates = transformation.apply(tagCompound.func_74762_e("xCoord"), tagCompound.func_74762_e("yCoord"), tagCompound.func_74762_e("zCoord"));
                tagCompound.func_74768_a("xCoord", coordinates.func_177958_n());
                tagCompound.func_74768_a("yCoord", coordinates.func_177956_o());
                tagCompound.func_74768_a("zCoord", coordinates.func_177952_p());
                tagListNew.func_74742_a((NBTBase)tagCompound);
            }
            nbtTileEntity.func_74782_a("Valves", (NBTBase)tagListNew);
        }
        if (nbtTileEntity.func_74764_b("sideConnected0")) {
            int side;
            byte[] connectedOldSides = new byte[6];
            for (side = 2; side < 6; ++side) {
                connectedOldSides[side] = nbtTileEntity.func_74771_c("sideConnected" + side);
            }
            block49: for (side = 2; side < 6; ++side) {
                byte connected = connectedOldSides[side];
                switch (rotationSteps) {
                    case 1: {
                        nbtTileEntity.func_74774_a("sideConnected" + mrotFacing[side], connected);
                        continue block49;
                    }
                    case 2: {
                        nbtTileEntity.func_74774_a("sideConnected" + mrotFacing[mrotFacing[side]], connected);
                        continue block49;
                    }
                    case 3: {
                        nbtTileEntity.func_74774_a("sideConnected" + mrotFacing[mrotFacing[mrotFacing[side]]], connected);
                        continue block49;
                    }
                }
            }
            if (nbtTileEntity.func_74764_b("sideClosed0")) {
                int side2;
                byte[] closedOldSides = new byte[6];
                for (side2 = 2; side2 < 6; ++side2) {
                    closedOldSides[side2] = nbtTileEntity.func_74771_c("sideClosed" + side2);
                }
                block51: for (side2 = 2; side2 < 6; ++side2) {
                    byte connected = closedOldSides[side2];
                    switch (rotationSteps) {
                        case 1: {
                            nbtTileEntity.func_74774_a("sideClosed" + mrotFacing[side2], connected);
                            continue block51;
                        }
                        case 2: {
                            nbtTileEntity.func_74774_a("sideClosed" + mrotFacing[mrotFacing[side2]], connected);
                            continue block51;
                        }
                        case 3: {
                            nbtTileEntity.func_74774_a("sideClosed" + mrotFacing[mrotFacing[mrotFacing[side2]]], connected);
                            continue block51;
                        }
                    }
                }
            }
        }
        if (classBlockPressureChamberWall.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotChamberWall[metadata];
                }
                case 2: {
                    return mrotChamberWall[mrotChamberWall[metadata]];
                }
                case 3: {
                    return mrotChamberWall[mrotChamberWall[mrotChamberWall[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockPressureChamberValve.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotChamberValve[metadata];
                }
                case 2: {
                    return mrotChamberValve[mrotChamberValve[metadata]];
                }
                case 3: {
                    return mrotChamberValve[mrotChamberValve[mrotChamberValve[metadata]]];
                }
            }
            return metadata;
        }
        try {
            Object object = methodBlockPneumaticCraft_isRotatable.invoke((Object)block, new Object[0]);
            if (!(object instanceof Boolean)) {
                WarpDrive.logger.error(String.format("Block %s has invalid non-Boolean return value to isRotatable: %s", block.getRegistryName(), object));
                return metadata;
            }
            isRotatable = (Boolean)object;
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            exception.printStackTrace();
            return metadata;
        }
        WarpDrive.logger.info(String.format("Block %s isRotatable %s", block.getRegistryName(), isRotatable));
        if (isRotatable) {
            switch (rotationSteps) {
                case 1: {
                    return mrotFacing[metadata];
                }
                case 2: {
                    return mrotFacing[mrotFacing[metadata]];
                }
                case 3: {
                    return mrotFacing[mrotFacing[mrotFacing[metadata]]];
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotFacing = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        mrotChamberWall = new byte[]{0, 1, 3, 2, 4, 8, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15};
        mrotChamberValve = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 11, 10, 8, 9, 12, 13, 14, 15};
        mrotPneumaticDoor = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 11, 10, 8, 9, 12, 13, 14, 15};
        mrotTextRotation = new byte[]{1, 2, 3, 0};
    }
}

