/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import com.raoulvdberge.refinedstorage.api.IRSAPI;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeFactory;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNodeManager;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileBase;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

public class CompatRefinedStorage
implements IBlockTransformer {
    private static final String NBT_DIRECTION = "Direction";
    private static final String NBT_NODE = "Node";
    private static final String NBT_NODE_ID = "NodeID";
    private static Class<?> classBlockBase;
    private static final int[] rotFacing;

    public static void register() {
        try {
            classBlockBase = Class.forName("com.raoulvdberge.refinedstorage.block.BlockBase");
            WarpDriveConfig.registerBlockTransformer("RefinedStorage", new CompatRefinedStorage());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockBase.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    @Optional.Method(modid="refinedstorage")
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        INetworkNode networkNode;
        if (!(tileEntity instanceof TileBase)) {
            return null;
        }
        IRSAPI refinedStorageAPI = API.instance();
        if (refinedStorageAPI == null) {
            WarpDrive.logger.error("Invalid API instance while saving externals for RefinedStorage, please report to mod author");
            networkNode = null;
        } else {
            INetworkNodeManager networkNodeManager = refinedStorageAPI.getNetworkNodeManager(world);
            networkNode = networkNodeManager.getNode(tileEntity.func_174877_v());
            if (networkNode == null) {
                WarpDrive.logger.debug(String.format("No network node, nothing to save for %s %s", tileEntity, Commons.format(world, x, y, z)));
            }
        }
        TileBase tileBase = (TileBase)tileEntity;
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a(NBT_DIRECTION, tileBase.getDirection().ordinal());
        if (networkNode != null) {
            tagCompound.func_74782_a(NBT_NODE, (NBTBase)networkNode.write(new NBTTagCompound()));
            tagCompound.func_74778_a(NBT_NODE_ID, networkNode.getId());
        }
        return tagCompound;
    }

    @Override
    @Optional.Method(modid="refinedstorage")
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        if (!(tileEntity instanceof TileBase)) {
            return;
        }
        IRSAPI refinedStorageAPI = API.instance();
        if (refinedStorageAPI == null) {
            WarpDrive.logger.error("Invalid API instance while removing externals for RefinedStorage, please report to mod author");
            return;
        }
        INetworkNodeManager networkNodeManager = refinedStorageAPI.getNetworkNodeManager(world);
        networkNodeManager.removeNode(tileEntity.func_174877_v());
        networkNodeManager.markForSaving();
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        return metadata;
    }

    @Override
    @Optional.Method(modid="refinedstorage")
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
        IRSAPI refinedStorageAPI;
        if (!(tileEntity instanceof TileBase)) {
            return;
        }
        if (!(nbtBase instanceof NBTTagCompound)) {
            WarpDrive.logger.error(String.format("Unexpected external NBT while restoring RefinedStorage, please report to mod author: %s %s %s", blockState, nbtBase, Commons.format(world, blockPos)));
            return;
        }
        byte rotationSteps = transformation.getRotationSteps();
        NBTTagCompound tagCompound = (NBTTagCompound)nbtBase;
        NBTTagCompound tagCompoundNode = tagCompound.func_74775_l(NBT_NODE);
        if (tagCompoundNode.func_150297_b("Covers", 9)) {
            NBTTagList tagListCovers = tagCompoundNode.func_150295_c("Covers", 10);
            for (int index = 0; index < tagListCovers.func_74745_c(); ++index) {
                int directionCoverNew;
                NBTTagCompound compoundTagCover = tagListCovers.func_150305_b(index);
                int directionCoverOld = compoundTagCover.func_74762_e(NBT_DIRECTION);
                switch (rotationSteps) {
                    case 1: {
                        directionCoverNew = rotFacing[directionCoverOld];
                        break;
                    }
                    case 2: {
                        directionCoverNew = rotFacing[rotFacing[directionCoverOld]];
                        break;
                    }
                    case 3: {
                        directionCoverNew = rotFacing[rotFacing[rotFacing[directionCoverOld]]];
                        break;
                    }
                    default: {
                        directionCoverNew = directionCoverOld;
                    }
                }
                compoundTagCover.func_74768_a(NBT_DIRECTION, directionCoverNew);
            }
        }
        if ((refinedStorageAPI = API.instance()) == null) {
            WarpDrive.logger.error(String.format("Invalid API instance while restoring RefinedStorage, please report to mod author: %s", nbtBase));
            return;
        }
        INetworkNodeManager manager = refinedStorageAPI.getNetworkNodeManager(world);
        if (tagCompoundNode.func_150297_b(NBT_NODE_ID, 8)) {
            INetworkNodeFactory networkNodeFactory = refinedStorageAPI.getNetworkNodeRegistry().get(tagCompound.func_74779_i(NBT_NODE_ID));
            if (networkNodeFactory == null) {
                WarpDrive.logger.error(String.format("Invalid NodeId in external NBT while restoring externals for RefinedStorage, please report to mod author: %s", nbtBase));
                return;
            }
            NetworkNode networkNode = (NetworkNode)networkNodeFactory.create(tagCompoundNode, world, blockPos);
            networkNode.setThrottlingDisabled();
            manager.setNode(blockPos, (INetworkNode)networkNode);
        }
        manager.markForSaving();
        if (!tagCompound.func_150297_b(NBT_DIRECTION, 99)) {
            WarpDrive.logger.error(String.format("Missing direction in external NBT while restoring externals for RefinedStorage, please report to mod author: %s", nbtBase));
        } else {
            int directionNew;
            int directionOld = tagCompound.func_74762_e(NBT_DIRECTION);
            switch (rotationSteps) {
                case 1: {
                    directionNew = rotFacing[directionOld];
                    break;
                }
                case 2: {
                    directionNew = rotFacing[rotFacing[directionOld]];
                    break;
                }
                case 3: {
                    directionNew = rotFacing[rotFacing[rotFacing[directionOld]]];
                    break;
                }
                default: {
                    directionNew = directionOld;
                }
            }
            ((TileBase)tileEntity).setDirection(EnumFacing.func_82600_a((int)directionNew));
        }
        tileEntity.func_70296_d();
        world.func_184138_a(blockPos, blockState, blockState, 4);
    }

    static {
        rotFacing = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

