/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatRustic
implements IBlockTransformer {
    private static Class<?> classBlockApiary;
    private static Class<?> classBlockBrewingBarrel;
    private static Class<?> classBlockCabinet;
    private static Class<?> classBlockCandle;
    private static Class<?> classBlockChair;
    private static Class<?> classBlockClayWallDiag;
    private static Class<?> classBlockCondenser;
    private static Class<?> classBlockCondenserAdvanced;
    private static Class<?> classBlockGargoyle;
    private static Class<?> classBlockLantern;
    private static Class<?> classBlockRetort;
    private static Class<?> classBlockRopeBase;
    private static Class<?> classBlockStakeTied;
    private static HashSet<Block> setBlockRope;
    private static final byte[] rotCabinet;
    private static final byte[] rotCandle;
    private static final byte[] rotCondenser;
    private static final byte[] rotFacing;
    private static final byte[] rotFacingHorizontal;
    private static final byte[] rotRetort;
    private static final byte[] rotRopeBase;

    public static void register() {
        try {
            classBlockApiary = Class.forName("rustic.common.blocks.BlockApiary");
            classBlockBrewingBarrel = Class.forName("rustic.common.blocks.BlockBrewingBarrel");
            classBlockCabinet = Class.forName("rustic.common.blocks.BlockCabinet");
            classBlockCandle = Class.forName("rustic.common.blocks.BlockCandle");
            classBlockChair = Class.forName("rustic.common.blocks.BlockChair");
            classBlockClayWallDiag = Class.forName("rustic.common.blocks.BlockClayWallDiag");
            classBlockCondenser = Class.forName("rustic.common.blocks.BlockCondenser");
            classBlockCondenserAdvanced = Class.forName("rustic.common.blocks.BlockCondenserAdvanced");
            classBlockGargoyle = Class.forName("rustic.common.blocks.BlockGargoyle");
            classBlockLantern = Class.forName("rustic.common.blocks.BlockLantern");
            classBlockRetort = Class.forName("rustic.common.blocks.BlockRetort");
            classBlockRopeBase = Class.forName("rustic.common.blocks.BlockRopeBase");
            classBlockStakeTied = Class.forName("rustic.common.blocks.crops.BlockStakeTied");
            Block blockRope = IBlockTransformer.getBlockOrThrowException("rustic:rope");
            setBlockRope = new HashSet(1);
            setBlockRope.add(blockRope);
            WarpDriveConfig.registerBlockTransformer("Rustic", new CompatRustic());
        }
        catch (ClassNotFoundException | RuntimeException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockApiary.isInstance(block) || classBlockBrewingBarrel.isInstance(block) || classBlockCabinet.isInstance(block) || classBlockCandle.isInstance(block) || classBlockChair.isInstance(block) || classBlockClayWallDiag.isInstance(block) || classBlockCondenser.isInstance(block) || classBlockCondenserAdvanced.isInstance(block) || classBlockGargoyle.isInstance(block) || classBlockLantern.isInstance(block) || classBlockRetort.isInstance(block) || classBlockRopeBase.isInstance(block) || classBlockStakeTied.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        if (classBlockStakeTied.isInstance(block)) {
            return new NBTTagString("stake_tied");
        }
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        if (classBlockStakeTied.isInstance(block)) {
            BlockPos blockPos = new BlockPos(x, y, z);
            Set<BlockPos> setBlockPosHorizontalRopes = Commons.getConnectedBlocks(world, blockPos, Commons.DIRECTIONS_HORIZONTAL, setBlockRope, 16, new BlockPos[0]);
            for (BlockPos blockPosHorizontalRope : setBlockPosHorizontalRopes) {
                Set<BlockPos> setBlockPosVerticalRopes = Commons.getConnectedBlocks(world, blockPosHorizontalRope, Commons.DIRECTIONS_VERTICAL, setBlockRope, 16, new BlockPos[0]);
                for (BlockPos blockPosVerticalRope : setBlockPosVerticalRopes) {
                    boolean isDone = world.func_175698_g(blockPosVerticalRope);
                    if (isDone) continue;
                    WarpDrive.logger.error(String.format("Failed to remove hanging rope at %s", blockPosVerticalRope));
                }
                boolean isDone = world.func_175698_g(blockPosHorizontalRope);
                if (isDone) continue;
                WarpDrive.logger.error(String.format("Failed to remove tension rope at %s", blockPosHorizontalRope));
            }
            boolean isDone = world.func_175698_g(blockPos);
            if (!isDone) {
                WarpDrive.logger.error(String.format("Failed to remove tied rope at %s", blockPos));
            }
        }
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0) {
            return metadata;
        }
        if (classBlockApiary.isInstance(block) || classBlockBrewingBarrel.isInstance(block) || classBlockChair.isInstance(block) || classBlockClayWallDiag.isInstance(block) || classBlockGargoyle.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotFacingHorizontal[metadata];
                }
                case 2: {
                    return rotFacingHorizontal[rotFacingHorizontal[metadata]];
                }
                case 3: {
                    return rotFacingHorizontal[rotFacingHorizontal[rotFacingHorizontal[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockCabinet.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotCabinet[metadata];
                }
                case 2: {
                    return rotCabinet[rotCabinet[metadata]];
                }
                case 3: {
                    return rotCabinet[rotCabinet[rotCabinet[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockCandle.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotCandle[metadata];
                }
                case 2: {
                    return rotCandle[rotCandle[metadata]];
                }
                case 3: {
                    return rotCandle[rotCandle[rotCandle[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockCondenser.isInstance(block) || classBlockCondenserAdvanced.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotCondenser[metadata];
                }
                case 2: {
                    return rotCondenser[rotCondenser[metadata]];
                }
                case 3: {
                    return rotCondenser[rotCondenser[rotCondenser[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockLantern.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotFacing[metadata];
                }
                case 2: {
                    return rotFacing[rotFacing[metadata]];
                }
                case 3: {
                    return rotFacing[rotFacing[rotFacing[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockRetort.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotRetort[metadata];
                }
                case 2: {
                    return rotRetort[rotRetort[metadata]];
                }
                case 3: {
                    return rotRetort[rotRetort[rotRetort[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockRopeBase.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return rotRopeBase[metadata];
                }
                case 2: {
                    return rotRopeBase[rotRopeBase[metadata]];
                }
                case 3: {
                    return rotRopeBase[rotRopeBase[rotRopeBase[metadata]]];
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotCabinet = new byte[]{2, 3, 1, 0, 6, 7, 5, 4, 10, 11, 9, 8, 14, 15, 13, 12};
        rotCandle = new byte[]{0, 3, 4, 2, 1, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotCondenser = new byte[]{2, 3, 1, 0, 6, 7, 5, 4, 8, 9, 10, 11, 12, 13, 14, 15};
        rotFacing = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotFacingHorizontal = new byte[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotRetort = new byte[]{2, 3, 1, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotRopeBase = new byte[]{0, 2, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

