/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatSGCraft
implements IBlockTransformer {
    private static Class<?> classBaseTileEntity;
    private static Class<?> classDHDBlock;
    private static Class<?> classSGBaseBlock;
    private static Class<?> classSGBaseTE;
    private static Method methodSGBaseTE_sgStateDescription;
    private static final byte[] mrotSGBase;
    private static final int[] rotFacingDirectionOfBase;

    public static void register() {
        try {
            classBaseTileEntity = Class.forName("gcewing.sg.BaseTileEntity");
            classDHDBlock = Class.forName("gcewing.sg.block.DHDBlock");
            classSGBaseBlock = Class.forName("gcewing.sg.block.SGBaseBlock");
            classSGBaseTE = Class.forName("gcewing.sg.tileentity.SGBaseTE");
            methodSGBaseTE_sgStateDescription = classSGBaseTE.getMethod("sgStateDescription", new Class[0]);
            WarpDriveConfig.registerBlockTransformer("SGCraft", new CompatSGCraft());
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBaseTileEntity.isInstance(tileEntity);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        if (classSGBaseTE.isInstance(tileEntity)) {
            try {
                Object object = methodSGBaseTE_sgStateDescription.invoke((Object)tileEntity, new Object[0]);
                String state = (String)object;
                if (!state.equalsIgnoreCase("Idle")) {
                    reason.append(Commons.getStyleWarning(), "warpdrive.compat.guide.stargate_is_active", state);
                    return false;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        BlockPos targetLink;
        byte rotationSteps = transformation.getRotationSteps();
        if (nbtTileEntity.func_74764_b("isLinkedToStargate") && nbtTileEntity.func_74767_n("isLinkedToStargate") && nbtTileEntity.func_74764_b("linkedX") && nbtTileEntity.func_74764_b("linkedY") && nbtTileEntity.func_74764_b("linkedZ")) {
            if (transformation.isInside(nbtTileEntity.func_74762_e("linkedX"), nbtTileEntity.func_74762_e("linkedY"), nbtTileEntity.func_74762_e("linkedZ"))) {
                targetLink = transformation.apply(nbtTileEntity.func_74762_e("linkedX"), nbtTileEntity.func_74762_e("linkedY"), nbtTileEntity.func_74762_e("linkedZ"));
                nbtTileEntity.func_74768_a("linkedX", targetLink.func_177958_n());
                nbtTileEntity.func_74768_a("linkedY", targetLink.func_177956_o());
                nbtTileEntity.func_74768_a("linkedZ", targetLink.func_177952_p());
            } else {
                nbtTileEntity.func_74757_a("isLinkedToController", false);
                nbtTileEntity.func_74768_a("linkedX", 0);
                nbtTileEntity.func_74768_a("linkedY", 0);
                nbtTileEntity.func_74768_a("linkedZ", 0);
            }
        }
        if (nbtTileEntity.func_74764_b("isLinkedToController") && nbtTileEntity.func_74767_n("isLinkedToController") && nbtTileEntity.func_74764_b("linkedX") && nbtTileEntity.func_74764_b("linkedY") && nbtTileEntity.func_74764_b("linkedZ")) {
            if (transformation.isInside(nbtTileEntity.func_74762_e("linkedX"), nbtTileEntity.func_74762_e("linkedY"), nbtTileEntity.func_74762_e("linkedZ"))) {
                targetLink = transformation.apply(nbtTileEntity.func_74762_e("linkedX"), nbtTileEntity.func_74762_e("linkedY"), nbtTileEntity.func_74762_e("linkedZ"));
                nbtTileEntity.func_74768_a("linkedX", targetLink.func_177958_n());
                nbtTileEntity.func_74768_a("linkedY", targetLink.func_177956_o());
                nbtTileEntity.func_74768_a("linkedZ", targetLink.func_177952_p());
            } else {
                nbtTileEntity.func_74757_a("isLinkedToController", false);
                nbtTileEntity.func_74768_a("linkedX", 0);
                nbtTileEntity.func_74768_a("linkedY", 0);
                nbtTileEntity.func_74768_a("linkedZ", 0);
            }
        }
        if (nbtTileEntity.func_74764_b("isMerged") && nbtTileEntity.func_74767_n("isMerged") && nbtTileEntity.func_74764_b("baseX") && nbtTileEntity.func_74764_b("baseY") && nbtTileEntity.func_74764_b("baseZ")) {
            targetLink = transformation.apply(nbtTileEntity.func_74762_e("baseX"), nbtTileEntity.func_74762_e("baseY"), nbtTileEntity.func_74762_e("baseZ"));
            nbtTileEntity.func_74768_a("baseX", targetLink.func_177958_n());
            nbtTileEntity.func_74768_a("baseY", targetLink.func_177956_o());
            nbtTileEntity.func_74768_a("baseZ", targetLink.func_177952_p());
        }
        if (nbtTileEntity.func_74764_b("facingDirectionOfBase")) {
            byte facing = nbtTileEntity.func_74771_c("facingDirectionOfBase");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("facingDirectionOfBase", rotFacingDirectionOfBase[facing]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("facingDirectionOfBase", rotFacingDirectionOfBase[rotFacingDirectionOfBase[facing]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("facingDirectionOfBase", rotFacingDirectionOfBase[rotFacingDirectionOfBase[rotFacingDirectionOfBase[facing]]]);
                    break;
                }
            }
        }
        if (classDHDBlock.isInstance(block) || classSGBaseBlock.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotSGBase[metadata];
                }
                case 2: {
                    return mrotSGBase[mrotSGBase[metadata]];
                }
                case 3: {
                    return mrotSGBase[mrotSGBase[mrotSGBase[metadata]]];
                }
            }
            return metadata;
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotSGBase = new byte[]{3, 2, 0, 1, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotFacingDirectionOfBase = new int[]{3, 0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

