/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatThaumcraft
implements IBlockTransformer {
    private static Class<?> interfaceIBlockFacing;
    private static Class<?> interfaceIBlockFacingHorizontal;
    private static Class<?> classBlockPillar;
    private static Class<?> classBlockChestHungry;
    private static Class<?> classBlockBannerTC;
    private static Class<?> classBlockMirror;
    private static Class<?> classBlockAlembic;
    private static Class<?> classBlockJar;
    private static Class<?> classBlockTube;
    private static final int[] mrotFacingEnable;
    private static final int[] mrotFacingHorizontal;
    private static final byte[] rotForgeByte;
    private static final int[] rotForgeInt;
    private static final byte[] rotBanner;

    public static void register() {
        try {
            interfaceIBlockFacing = Class.forName("thaumcraft.common.blocks.IBlockFacing");
            interfaceIBlockFacingHorizontal = Class.forName("thaumcraft.common.blocks.IBlockFacingHorizontal");
            classBlockPillar = Class.forName("thaumcraft.common.blocks.basic.BlockPillar");
            classBlockChestHungry = Class.forName("thaumcraft.common.blocks.devices.BlockHungryChest");
            classBlockBannerTC = Class.forName("thaumcraft.common.blocks.basic.BlockBannerTC");
            classBlockMirror = Class.forName("thaumcraft.common.blocks.devices.BlockMirror");
            classBlockAlembic = Class.forName("thaumcraft.common.blocks.essentia.BlockAlembic");
            classBlockJar = Class.forName("thaumcraft.common.blocks.essentia.BlockJar");
            classBlockTube = Class.forName("thaumcraft.common.blocks.essentia.BlockTube");
            WarpDriveConfig.registerBlockTransformer("thaumcraft", new CompatThaumcraft());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return interfaceIBlockFacing.isInstance(block) || interfaceIBlockFacingHorizontal.isInstance(block) || classBlockPillar.isInstance(block) || classBlockChestHungry.isInstance(block) || classBlockBannerTC.isInstance(block) || classBlockMirror.isInstance(block) || classBlockAlembic.isInstance(block) || classBlockJar.isInstance(block) || classBlockTube.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (interfaceIBlockFacing.isInstance(block) || interfaceIBlockFacingHorizontal.isInstance(block) || classBlockChestHungry.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotFacingEnable[metadata];
                }
                case 2: {
                    return mrotFacingEnable[mrotFacingEnable[metadata]];
                }
                case 3: {
                    return mrotFacingEnable[mrotFacingEnable[mrotFacingEnable[metadata]]];
                }
            }
            return metadata;
        }
        if (classBlockPillar.isInstance(block)) {
            switch (rotationSteps) {
                case 1: {
                    return mrotFacingHorizontal[metadata];
                }
                case 2: {
                    return mrotFacingHorizontal[mrotFacingHorizontal[metadata]];
                }
                case 3: {
                    return mrotFacingHorizontal[mrotFacingHorizontal[mrotFacingHorizontal[metadata]]];
                }
            }
            return metadata;
        }
        if ((classBlockAlembic.isInstance(block) || classBlockJar.isInstance(block)) && nbtTileEntity.func_74764_b("facing")) {
            short facing = nbtTileEntity.func_74771_c("facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("facing", rotForgeByte[facing]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("facing", rotForgeByte[rotForgeByte[facing]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("facing", rotForgeByte[rotForgeByte[rotForgeByte[facing]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (classBlockBannerTC.isInstance(block) && nbtTileEntity.func_74764_b("facing")) {
            short facing = nbtTileEntity.func_74771_c("facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74774_a("facing", rotBanner[facing]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74774_a("facing", rotBanner[rotBanner[facing]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74774_a("facing", rotBanner[rotBanner[rotBanner[facing]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (classBlockTube.isInstance(block) && nbtTileEntity.func_74764_b("side")) {
            int side = nbtTileEntity.func_74762_e("side");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("side", rotForgeInt[side]);
                    return metadata;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("side", rotForgeInt[rotForgeInt[side]]);
                    return metadata;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("side", rotForgeInt[rotForgeInt[rotForgeInt[side]]]);
                    return metadata;
                }
            }
            return metadata;
        }
        if (classBlockMirror.isInstance(block) && nbtTileEntity.func_74764_b("linkX") && nbtTileEntity.func_74764_b("linkY") && nbtTileEntity.func_74764_b("linkZ") && nbtTileEntity.func_74764_b("linkDim")) {
            BlockPos targetLink = transformation.apply(nbtTileEntity.func_74762_e("linkX"), nbtTileEntity.func_74762_e("linkY"), nbtTileEntity.func_74762_e("linkZ"));
            nbtTileEntity.func_74768_a("linkX", targetLink.func_177958_n());
            nbtTileEntity.func_74768_a("linkY", targetLink.func_177956_o());
            nbtTileEntity.func_74768_a("linkZ", targetLink.func_177952_p());
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrotFacingEnable = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 13, 12, 10, 11, 14, 15};
        mrotFacingHorizontal = new int[]{1, 2, 3, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotForgeByte = new byte[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotForgeInt = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        rotBanner = new byte[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 0, 1, 2, 3};
    }
}

