/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatThermalDynamics
implements IBlockTransformer {
    private static Class<?> classBlockTDBase;
    private static final int[] rotSide;

    public static void register() {
        try {
            classBlockTDBase = Class.forName("cofh.thermaldynamics.block.BlockTDBase");
            WarpDriveConfig.registerBlockTransformer("ThermalDynamics", new CompatThermalDynamics());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockTDBase.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    private void rotateComponent(NBTTagCompound nbtTileEntity, byte rotationSteps, String nameComponents) {
        if (nbtTileEntity.func_74764_b(nameComponents)) {
            NBTTagList nbtOldComponents = nbtTileEntity.func_150295_c(nameComponents, 10);
            NBTTagList nbtNewComponents = new NBTTagList();
            for (int index = 0; index < nbtOldComponents.func_74745_c(); ++index) {
                NBTTagCompound nbtOldComponent = nbtOldComponents.func_150305_b(index);
                NBTTagCompound nbtNewComponent = nbtOldComponent.func_74737_b();
                int side = nbtOldComponent.func_74762_e("side");
                switch (rotationSteps) {
                    case 1: {
                        nbtNewComponent.func_74768_a("side", rotSide[side]);
                        break;
                    }
                    case 2: {
                        nbtNewComponent.func_74768_a("side", rotSide[rotSide[side]]);
                        break;
                    }
                    case 3: {
                        nbtNewComponent.func_74768_a("side", rotSide[rotSide[rotSide[side]]]);
                        break;
                    }
                }
                nbtNewComponents.func_74742_a((NBTBase)nbtNewComponent);
            }
            nbtTileEntity.func_74782_a(nameComponents, (NBTBase)nbtNewComponents);
        }
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || nbtTileEntity == null) {
            return metadata;
        }
        this.rotateComponent(nbtTileEntity, rotationSteps, "Attachments");
        this.rotateComponent(nbtTileEntity, rotationSteps, "Covers");
        if (nbtTileEntity.func_74764_b("Connections")) {
            byte[] bytesOldConnections = nbtTileEntity.func_74770_j("Connections");
            byte[] bytesNewConnections = (byte[])bytesOldConnections.clone();
            block5: for (int sideOld = 0; sideOld < 6; ++sideOld) {
                byte byteConnection = bytesOldConnections[sideOld];
                switch (rotationSteps) {
                    case 1: {
                        bytesNewConnections[CompatThermalDynamics.rotSide[sideOld]] = byteConnection;
                        continue block5;
                    }
                    case 2: {
                        bytesNewConnections[CompatThermalDynamics.rotSide[CompatThermalDynamics.rotSide[sideOld]]] = byteConnection;
                        continue block5;
                    }
                    case 3: {
                        bytesNewConnections[CompatThermalDynamics.rotSide[CompatThermalDynamics.rotSide[CompatThermalDynamics.rotSide[sideOld]]]] = byteConnection;
                        continue block5;
                    }
                }
            }
            nbtTileEntity.func_74773_a("Connections", bytesNewConnections);
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        rotSide = new int[]{0, 1, 5, 4, 2, 3, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }
}

