/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.compat;

import cr0s.warpdrive.api.IBlockTransformer;
import cr0s.warpdrive.api.ITransformation;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CompatThermalExpansion
implements IBlockTransformer {
    private static Class<?> classBlockTEBase;
    private static final short[] mrot;
    private static final int[] rotFacing;

    public static void register() {
        try {
            classBlockTEBase = Class.forName("cofh.thermalexpansion.block.BlockTEBase");
            WarpDriveConfig.registerBlockTransformer("thermalexpansion", new CompatThermalExpansion());
        }
        catch (ClassNotFoundException exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public boolean isApplicable(Block block, int metadata, TileEntity tileEntity) {
        return classBlockTEBase.isInstance(block);
    }

    @Override
    public boolean isJumpReady(Block block, int metadata, TileEntity tileEntity, WarpDriveText reason) {
        return true;
    }

    @Override
    public NBTBase saveExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
        return null;
    }

    @Override
    public void removeExternals(World world, int x, int y, int z, Block block, int blockMeta, TileEntity tileEntity) {
    }

    private byte[] rotate_byteArray(byte rotationSteps, byte[] data) {
        byte[] newData = (byte[])data.clone();
        block5: for (int index = 0; index < data.length; ++index) {
            switch (rotationSteps) {
                case 1: {
                    newData[CompatThermalExpansion.mrot[index]] = data[index];
                    continue block5;
                }
                case 2: {
                    newData[CompatThermalExpansion.mrot[CompatThermalExpansion.mrot[index]]] = data[index];
                    continue block5;
                }
                case 3: {
                    newData[CompatThermalExpansion.mrot[CompatThermalExpansion.mrot[CompatThermalExpansion.mrot[index]]]] = data[index];
                    continue block5;
                }
            }
        }
        return newData;
    }

    @Override
    public int rotate(Block block, int metadata, NBTTagCompound nbtTileEntity, ITransformation transformation) {
        byte rotationSteps = transformation.getRotationSteps();
        if (rotationSteps == 0 || nbtTileEntity == null) {
            return metadata;
        }
        if (nbtTileEntity.func_74764_b("Facing")) {
            int facing = nbtTileEntity.func_74762_e("Facing");
            switch (rotationSteps) {
                case 1: {
                    nbtTileEntity.func_74768_a("Facing", rotFacing[facing]);
                    break;
                }
                case 2: {
                    nbtTileEntity.func_74768_a("Facing", rotFacing[rotFacing[facing]]);
                    break;
                }
                case 3: {
                    nbtTileEntity.func_74768_a("Facing", rotFacing[rotFacing[rotFacing[facing]]]);
                    break;
                }
            }
        }
        if (nbtTileEntity.func_74764_b("SideCache")) {
            nbtTileEntity.func_74773_a("SideCache", this.rotate_byteArray(rotationSteps, nbtTileEntity.func_74770_j("SideCache")));
        }
        return metadata;
    }

    @Override
    public void restoreExternals(World world, BlockPos blockPos, IBlockState blockState, TileEntity tileEntity, ITransformation transformation, NBTBase nbtBase) {
    }

    static {
        mrot = new short[]{0, 1, 5, 4, 2, 3};
        rotFacing = new int[]{0, 1, 5, 4, 2, 3};
    }
}

