/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.FastSetBlockState;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IXmlRepresentableUnit;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.data.JumpBlock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.w3c.dom.Element;

public class Filler
implements IXmlRepresentableUnit {
    public static final Filler DEFAULT = new Filler();
    private String name;
    public Block block;
    public int metadata;
    public NBTTagCompound tagCompound = null;

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        if (!element.hasAttribute("block")) {
            throw new InvalidXmlException(String.format("Filler %s is missing a block attribute!", element));
        }
        String nameBlock = element.getAttribute("block");
        this.block = Block.func_149684_b((String)nameBlock);
        if (this.block == null) {
            WarpDrive.logger.warn(String.format("Skipping missing block %s", nameBlock));
            return false;
        }
        this.metadata = 0;
        String stringMetadata = element.getAttribute("metadata");
        if (!stringMetadata.isEmpty()) {
            try {
                this.metadata = Integer.parseInt(stringMetadata);
            }
            catch (NumberFormatException exception) {
                throw new InvalidXmlException(String.format("Invalid metadata for block %s: %s", nameBlock, stringMetadata));
            }
        }
        this.tagCompound = null;
        String stringNBT = element.getAttribute("nbt");
        if (!stringNBT.isEmpty()) {
            try {
                this.tagCompound = JsonToNBT.func_180713_a((String)stringNBT);
            }
            catch (NBTException exception) {
                WarpDrive.logger.error(exception.getMessage());
                throw new InvalidXmlException(String.format("Invalid nbt for block %s: %s", nameBlock, stringNBT));
            }
        }
        this.name = nameBlock + "@" + this.metadata + (this.tagCompound == null ? "" : "{" + this.tagCompound + "}");
        return true;
    }

    public boolean loadFromName(String nameToLoad) {
        String stringNBT;
        Matcher matcher;
        Pattern patternNameToLoadWithoutNBT = Pattern.compile("(.*)@(\\d*)");
        Pattern patternNameToLoadWithNBT = Pattern.compile("(.*)@(\\d*)(\\{.*)");
        boolean hasNBT = nameToLoad.contains("{");
        Matcher matcher2 = matcher = hasNBT ? patternNameToLoadWithNBT.matcher(nameToLoad) : patternNameToLoadWithoutNBT.matcher(nameToLoad);
        if (!matcher.matches()) {
            throw new RuntimeException(String.format("Failed to load filler from name %s: unrecognized format", nameToLoad));
        }
        String nameBlock = matcher.group(1);
        this.block = Block.func_149684_b((String)nameBlock);
        if (this.block == null) {
            WarpDrive.logger.warn(String.format("Failed to load filler from name %s: block %s is missing", nameToLoad, nameBlock));
            return false;
        }
        this.metadata = 0;
        String stringMetadata = matcher.group(2);
        if (!stringMetadata.isEmpty()) {
            try {
                this.metadata = Integer.parseInt(stringMetadata);
            }
            catch (NumberFormatException exception) {
                throw new RuntimeException(String.format("Failed to load filler from name %s: invalid metadata %s", nameToLoad, stringMetadata));
            }
        }
        this.tagCompound = null;
        String string = stringNBT = hasNBT ? matcher.group(3) : "";
        if (!stringNBT.isEmpty()) {
            try {
                this.tagCompound = JsonToNBT.func_180713_a((String)stringNBT);
            }
            catch (NBTException exception) {
                WarpDrive.logger.error(exception.getMessage());
                throw new RuntimeException(String.format("Failed to load filler from name %s: invalid nbt %s", nameToLoad, stringNBT));
            }
        }
        this.name = nameBlock + "@" + this.metadata + (this.tagCompound == null ? "" : "{" + this.tagCompound + "}");
        return true;
    }

    public void setBlock(World world, BlockPos blockPos) {
        try {
            IBlockState blockState = this.block.func_176203_a(this.metadata);
            FastSetBlockState.setBlockStateNoLight(world, blockPos, blockState, 2);
        }
        catch (Throwable throwable) {
            WarpDrive.logger.error(String.format("Throwable detected in Filler.setBlock(%s), check your configuration for that block!", this.func_176610_l()));
            throw throwable;
        }
        if (this.tagCompound != null) {
            TileEntity tileEntity = world.func_175625_s(blockPos);
            if (tileEntity == null) {
                WarpDrive.logger.error(String.format("No TileEntity found for Filler %s %s, unable to apply NBT properties", this.func_176610_l(), Commons.format(world, blockPos)));
                return;
            }
            NBTTagCompound nbtTagCompoundTileEntity = new NBTTagCompound();
            tileEntity.func_189515_b(nbtTagCompoundTileEntity);
            for (Object key : this.tagCompound.func_150296_c()) {
                if (!(key instanceof String)) continue;
                nbtTagCompoundTileEntity.func_74782_a((String)key, this.tagCompound.func_74781_a((String)key));
            }
            tileEntity.onChunkUnload();
            tileEntity.func_145839_a(nbtTagCompoundTileEntity);
            tileEntity.func_145829_t();
            tileEntity.func_70296_d();
            JumpBlock.refreshBlockStateOnClient(world, blockPos);
        }
    }

    @Override
    public IXmlRepresentableUnit constructor() {
        return new Filler();
    }

    public boolean equals(Object object) {
        return !(!(object instanceof Filler) || this.block != null && !this.block.equals(((Filler)object).block) || this.metadata != ((Filler)object).metadata || this.tagCompound != null && !this.tagCompound.equals((Object)((Filler)object).tagCompound));
    }

    public String toString() {
        return "Filler(" + this.block.getRegistryName() + "@" + this.metadata + ")";
    }

    public int hashCode() {
        return Block.func_149682_b((Block)this.block) * 16 + this.metadata + (this.tagCompound == null ? 0 : this.tagCompound.hashCode() * 4096 * 16);
    }

    static {
        Filler.DEFAULT.name = "-default-";
        Filler.DEFAULT.block = Blocks.field_150350_a;
        Filler.DEFAULT.metadata = 0;
        Filler.DEFAULT.tagCompound = null;
    }
}

