/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IXmlRepresentable;
import cr0s.warpdrive.api.IXmlRepresentableUnit;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.XmlFileManager;
import cr0s.warpdrive.config.XmlRandomCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.w3c.dom.Element;

public class GenericSet<E extends IXmlRepresentableUnit>
implements IXmlRepresentable,
Comparable {
    protected String group;
    protected String name;
    private final E unitDefault;
    private final String nameElementUnit;
    private final XmlRandomCollection<E> units;
    private final ArrayList<String> importGroupNames;
    private final ArrayList<String> importGroups;

    public String getFullName() {
        return this.group + ":" + this.name;
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    public GenericSet(String group, String name, E unitDefault, String nameElementUnit) {
        this.group = group;
        this.name = name;
        this.unitDefault = unitDefault;
        this.nameElementUnit = nameElementUnit;
        this.units = new XmlRandomCollection();
        this.importGroupNames = new ArrayList();
        this.importGroups = new ArrayList();
    }

    public GenericSet(NBTTagCompound tagCompound, E unitDefault, String nameElementUnit) {
        this.group = tagCompound.func_74764_b("group") ? tagCompound.func_74779_i("group") : null;
        this.name = tagCompound.func_74779_i("name");
        this.unitDefault = unitDefault;
        this.nameElementUnit = nameElementUnit;
        this.units = new XmlRandomCollection();
        this.units.loadFromNBT(tagCompound.func_74775_l("units"), name -> {
            Filler filler;
            if (unitDefault instanceof Filler && (filler = new Filler()).loadFromName(name)) {
                return filler;
            }
            return unitDefault;
        });
        NBTTagList listImportGroupNames = tagCompound.func_150295_c("importGroupNames", 8);
        this.importGroupNames = new ArrayList();
        for (int indexImportGroupName = 0; indexImportGroupName < listImportGroupNames.func_74745_c(); ++indexImportGroupName) {
            String importGroupName = listImportGroupNames.func_150307_f(indexImportGroupName);
            this.importGroupNames.add(importGroupName);
        }
        NBTTagList listImportGroups = tagCompound.func_150295_c("importGroups", 8);
        this.importGroups = new ArrayList();
        for (int indexImportGroup = 0; indexImportGroup < listImportGroups.func_74745_c(); ++indexImportGroup) {
            String importGroup = listImportGroups.func_150307_f(indexImportGroup);
            this.importGroups.add(importGroup);
        }
    }

    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        if (this.group != null) {
            tagCompound.func_74778_a("group", this.group);
        }
        tagCompound.func_74778_a("name", this.name);
        tagCompound.func_74782_a("units", (NBTBase)this.units.writeToNBT(new NBTTagCompound()));
        if (!this.importGroupNames.isEmpty()) {
            NBTTagList listImportGroupNames = new NBTTagList();
            for (String importGroupName : this.importGroupNames) {
                listImportGroupNames.func_74742_a((NBTBase)new NBTTagString(importGroupName));
            }
            tagCompound.func_74782_a("importGroupNames", (NBTBase)listImportGroupNames);
        }
        if (!this.importGroups.isEmpty()) {
            NBTTagList listImportGroups = new NBTTagList();
            for (String importGroup : this.importGroups) {
                listImportGroups.func_74742_a((NBTBase)new NBTTagString(importGroup));
            }
            tagCompound.func_74782_a("importGroups", (NBTBase)listImportGroups);
        }
        return tagCompound;
    }

    public boolean isEmpty() {
        return this.units.isEmpty();
    }

    public E getRandomUnit(Random random) {
        IXmlRepresentableUnit unit = (IXmlRepresentableUnit)this.units.getRandomEntry(random);
        if (unit == null) {
            WarpDrive.logger.error(String.format("null %s encountered in set %s of %d elements, using default %s instead", this.nameElementUnit, this.getFullName(), this.units.elements().size(), this.unitDefault));
            unit = this.unitDefault;
        }
        return (E)unit;
    }

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        List<Element> listChildren = XmlFileManager.getChildrenElementByTagName(element, this.nameElementUnit);
        for (Element elementChild : listChildren) {
            IXmlRepresentableUnit unit = this.unitDefault.constructor();
            this.units.loadFromXML(unit, elementChild);
        }
        List<Element> listImports = XmlFileManager.getChildrenElementByTagName(element, "import");
        if (!listImports.isEmpty()) {
            for (Element elementImport : listImports) {
                String importGroup = elementImport.getAttribute("group");
                String importName = elementImport.getAttribute("name");
                if (!importGroup.isEmpty()) {
                    if (!importName.isEmpty()) {
                        this.importGroupNames.add(importGroup + ":" + importName);
                        continue;
                    }
                    this.importGroups.add(importGroup);
                    continue;
                }
                WarpDrive.logger.warn(String.format("Ignoring import with no group definition in import element from %s", this.getFullName()));
            }
        }
        return true;
    }

    public int compareTo(@Nonnull Object object) {
        return this.name.compareTo(((GenericSet)object).name);
    }

    public String toString() {
        return this.getFullName() + "(" + (this.units == null ? "-empty-" : Integer.valueOf(this.units.elements().size())) + ")";
    }

    public void loadFrom(GenericSet<E> genericSet) {
        this.units.loadFrom(genericSet.units);
    }

    public Collection<String> getImportGroupNames() {
        return this.importGroupNames;
    }

    public Collection<String> getImportGroups() {
        return this.importGroups;
    }
}

