/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IStringSerializable;

public class RandomCollection<E extends IStringSerializable> {
    private final NavigableMap<Integer, E> weightMap = new TreeMap<Integer, E>();
    private int totalWeight = 0;
    private final NavigableMap<Double, E> ratioMap = new TreeMap<Double, E>();
    private double totalRatio = 0.0;
    private final ArrayList<E> list = new ArrayList();

    public void loadFromNBT(NBTTagCompound tagCompound, StringDeserializable<E> deserializer) {
        NBTTagList tagListWeights = tagCompound.func_150295_c("weights", 10);
        for (NBTBase tagBase : tagListWeights) {
            NBTTagCompound tagCompoundWeight = (NBTTagCompound)tagBase;
            int weight = tagCompoundWeight.func_74762_e("key");
            String name = tagCompoundWeight.func_74779_i("name");
            E object = deserializer.deserialize(name);
            this.addWeight(weight, object);
        }
        NBTTagList tagListRatios = tagCompound.func_150295_c("ratios", 10);
        for (NBTBase tagBase : tagListRatios) {
            NBTTagCompound tagCompoundWeight = (NBTTagCompound)tagBase;
            double ratio = tagCompoundWeight.func_74769_h("key");
            String name = tagCompoundWeight.func_74779_i("name");
            E object = deserializer.deserialize(name);
            this.addRatio(ratio, object);
        }
    }

    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        NBTTagList tagListWeights = new NBTTagList();
        int weightPrevious = 0;
        for (Map.Entry entry : this.weightMap.entrySet()) {
            NBTTagCompound tagCompoundWeight = new NBTTagCompound();
            int weightEntry = (Integer)entry.getKey();
            tagCompoundWeight.func_74768_a("key", weightEntry - weightPrevious);
            tagCompoundWeight.func_74778_a("name", ((IStringSerializable)entry.getValue()).func_176610_l());
            tagListWeights.func_74742_a((NBTBase)tagCompoundWeight);
            weightPrevious = weightEntry;
        }
        tagCompound.func_74782_a("weights", (NBTBase)tagListWeights);
        NBTTagList tagListRatios = new NBTTagList();
        double ratioPrevious = 0.0;
        for (Map.Entry entry : this.ratioMap.entrySet()) {
            NBTTagCompound tagCompoundRatio = new NBTTagCompound();
            double ratioEntry = (Double)entry.getKey();
            tagCompoundRatio.func_74780_a("key", ratioEntry - ratioPrevious);
            tagCompoundRatio.func_74778_a("name", ((IStringSerializable)entry.getValue()).func_176610_l());
            tagListRatios.func_74742_a((NBTBase)tagCompoundRatio);
            ratioPrevious = ratioEntry;
        }
        tagCompound.func_74782_a("ratios", (NBTBase)tagListRatios);
        return tagCompound;
    }

    public void addWeight(int weight, E object) {
        if (weight <= 0) {
            WarpDrive.logger.warn(String.format("Weight is negative or zero, skipping %s with weight %d", object, weight));
            return;
        }
        if (this.weightMap.containsValue(object)) {
            if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                WarpDrive.logger.trace(String.format("Object already has a weight defined, skipping %s with weight %s", object, weight));
            }
            return;
        }
        this.totalWeight += weight;
        this.weightMap.put(this.totalWeight, object);
        this.list.add(object);
    }

    public void addRatio(double ratio, E object) {
        if (ratio <= 0.0 || ratio >= 1.0) {
            WarpDrive.logger.warn(String.format("Ratio isn't in ]0, 1.0] bounds, skipping %s with ratio %.3f", object, ratio));
            return;
        }
        if (this.ratioMap.containsValue(object)) {
            if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                WarpDrive.logger.warn(String.format("Object already has a ratio defined, skipping %s with ratio %.3f", object, ratio));
            }
            return;
        }
        if (this.totalRatio + ratio > 1.0) {
            WarpDrive.logger.warn(String.format("Total ratio is greater than 1.0, skipping %s with ratio %.3f", object, ratio));
            return;
        }
        this.totalRatio += ratio;
        this.ratioMap.put(this.totalRatio, object);
        this.list.add(object);
    }

    public E getRandomEntry(Random random) {
        double value = random.nextDouble();
        if ((double)this.totalWeight == 0.0) {
            value *= this.totalRatio;
        }
        if (value < this.totalRatio) {
            return (E)((IStringSerializable)this.ratioMap.ceilingEntry(value).getValue());
        }
        int weight = (int)Math.round((value - this.totalRatio) * (double)this.totalWeight);
        Map.Entry<Integer, E> entry = this.weightMap.ceilingEntry(weight);
        if (entry != null) {
            return (E)((IStringSerializable)entry.getValue());
        }
        return null;
    }

    public E getNamedEntry(String name) {
        for (IStringSerializable object : this.list) {
            if (!object.func_176610_l().equals(name)) continue;
            return (E)object;
        }
        return null;
    }

    public String getNames() {
        if (this.list.isEmpty()) {
            return "-none defined-";
        }
        StringBuilder names = new StringBuilder();
        for (IStringSerializable object : this.list) {
            if (names.length() > 0) {
                names.append(", ");
            }
            names.append(object.func_176610_l());
        }
        return names.toString();
    }

    public ArrayList<E> elements() {
        return this.list;
    }

    public void add(E object, String stringRatio, String stringWeight) throws InvalidParameterException {
        E existing = this.getNamedEntry(object.func_176610_l());
        if (existing != null) {
            if (existing.equals(object)) {
                if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                    WarpDrive.logger.info(String.format("Object already exists in collection, skipping %s", object.func_176610_l()));
                }
                return;
            }
            throw new InvalidParameterException(String.format("Invalid merge of different objects with the same name %s\nnew entry is %s\nwhile existing entry is %s", object.func_176610_l(), object, existing));
        }
        if (stringRatio != null && !stringRatio.isEmpty()) {
            double ratio;
            try {
                ratio = Double.parseDouble(stringRatio);
            }
            catch (NumberFormatException exceptionRatio) {
                throw new InvalidParameterException("Ratio must be double!");
            }
            this.addRatio(ratio, object);
        } else {
            int weight = 1;
            if (stringWeight != null && !stringWeight.isEmpty()) {
                try {
                    weight = Integer.parseInt(stringWeight);
                }
                catch (NumberFormatException exceptionWeight) {
                    throw new InvalidParameterException("Weight must be an integer!");
                }
                weight = Math.max(1, weight);
            }
            this.addWeight(weight, object);
        }
    }

    public void loadFrom(RandomCollection<E> objects) {
        int previousWeight = 0;
        for (Map.Entry entry : objects.weightMap.entrySet()) {
            this.addWeight((Integer)entry.getKey() - previousWeight, (IStringSerializable)entry.getValue());
            previousWeight = (Integer)entry.getKey();
        }
        double previousRatio = 0.0;
        for (Map.Entry entry : objects.ratioMap.entrySet()) {
            this.addRatio((Double)entry.getKey() - previousRatio, (IStringSerializable)entry.getValue());
            previousRatio = (Double)entry.getKey();
        }
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public static interface StringDeserializable<E extends IStringSerializable> {
        public E deserialize(String var1);
    }
}

