/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Recipes;
import cr0s.warpdrive.item.ItemTuningDriver;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeTuningDriver
implements IRecipe {
    private ResourceLocation resourceLocation;
    private final ItemStack itemStackTool;
    private final ItemStack itemStackConsumable;
    private final int countDyesExpected;
    private ItemStack itemStackResult = ItemStack.field_190927_a;
    private final int size;
    private final ResourceLocation group;

    public RecipeTuningDriver(@Nonnull ResourceLocation group, @Nonnull ItemStack itemStackTool, @Nonnull ItemStack itemStackConsumable, int countDyesExpected, @Nonnull String suffix) {
        this.group = group;
        this.itemStackTool = itemStackTool.func_77946_l();
        this.itemStackConsumable = itemStackConsumable.func_77946_l();
        this.countDyesExpected = countDyesExpected;
        this.size = 1 + (itemStackConsumable.func_190926_b() ? 0 : 1) + countDyesExpected;
        Object[] recipe = new Object[this.size];
        recipe[0] = itemStackTool;
        recipe[1] = itemStackConsumable;
        for (int index = 0; index < countDyesExpected; ++index) {
            recipe[2 + index] = "dye";
        }
        WarpDrive.register(new ShapelessOreRecipe(group, itemStackTool, recipe), suffix);
    }

    public IRecipe setRegistryName(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.resourceLocation;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }

    @Nonnull
    public String func_193358_e() {
        return this.group.toString();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.size;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inventoryCrafting) {
        return this.itemStackResult.func_77946_l();
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return this.itemStackResult;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inventoryCrafting, @Nonnull World world) {
        ItemStack itemStackInput = null;
        boolean isConsumableFound = false;
        int dye = 0;
        int countDyesFound = 0;
        for (int indexSlot = 0; indexSlot < inventoryCrafting.func_70302_i_(); ++indexSlot) {
            ItemStack itemStackSlot = inventoryCrafting.func_70301_a(indexSlot);
            if (itemStackSlot.func_190926_b()) continue;
            if (OreDictionary.itemMatches((ItemStack)itemStackSlot, (ItemStack)this.itemStackTool, (boolean)false)) {
                if (itemStackInput != null) {
                    return false;
                }
                itemStackInput = itemStackSlot;
                continue;
            }
            if (OreDictionary.itemMatches((ItemStack)itemStackSlot, (ItemStack)this.itemStackConsumable, (boolean)true)) {
                if (isConsumableFound) {
                    return false;
                }
                isConsumableFound = true;
                continue;
            }
            boolean matched = false;
            for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
                NonNullList itemStackDyes = OreDictionary.getOres((String)Recipes.oreDyes.get(enumDyeColor));
                for (ItemStack itemStackDye : itemStackDyes) {
                    if (!OreDictionary.itemMatches((ItemStack)itemStackSlot, (ItemStack)itemStackDye, (boolean)true)) continue;
                    matched = true;
                    ++countDyesFound;
                    dye = dye * 16 + enumDyeColor.func_176767_b();
                }
            }
            if (matched) continue;
            return false;
        }
        if (itemStackInput == null) {
            return false;
        }
        if (countDyesFound != this.countDyesExpected) {
            return false;
        }
        if (this.itemStackConsumable != null && !isConsumableFound || this.itemStackConsumable == null && isConsumableFound) {
            return false;
        }
        this.itemStackResult = ItemTuningDriver.setValue(itemStackInput.func_77946_l(), dye);
        return true;
    }
}

