/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.ParticleRegistry;
import cr0s.warpdrive.block.decoration.BlockDecorative;
import cr0s.warpdrive.config.RecipeParticleShapedOre;
import cr0s.warpdrive.config.RecipeTuningDriver;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumAirTankTier;
import cr0s.warpdrive.data.EnumComponentType;
import cr0s.warpdrive.data.EnumDecorativeType;
import cr0s.warpdrive.data.EnumForceFieldShape;
import cr0s.warpdrive.data.EnumForceFieldUpgrade;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.item.ItemComponent;
import cr0s.warpdrive.item.ItemElectromagneticCell;
import cr0s.warpdrive.item.ItemForceFieldShape;
import cr0s.warpdrive.item.ItemForceFieldUpgrade;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.ForgeRegistry;

public class Recipes {
    private static final ResourceLocation groupComponents = new ResourceLocation("components");
    private static final ResourceLocation groupDecorations = new ResourceLocation("decoration");
    private static final ResourceLocation groupMachines = new ResourceLocation("machines");
    private static final ResourceLocation groupTools = new ResourceLocation("tools");
    private static final ResourceLocation groupHulls = new ResourceLocation("hulls");
    private static final ResourceLocation groupTaintedHulls = new ResourceLocation("tainted_hulls");
    public static final HashMap<EnumDyeColor, String> oreDyes = new HashMap(16);
    private static ItemStack[] itemStackMachineCasings;
    private static ItemStack[] itemStackMotors;
    private static Object barsIron;
    private static Object ingotIronOrSteel;
    private static Object rubber;
    private static Object goldNuggetOrBasicCircuit;
    private static Object goldIngotOrAdvancedCircuit;
    private static Object emeraldOrSuperiorCircuit;

    public static void initOreDictionary() {
        int index;
        Recipes.registerOreDictionary("blockMushroom", new ItemStack(Blocks.field_150420_aW));
        Recipes.registerOreDictionary("blockMushroom", new ItemStack(Blocks.field_150419_aX));
        Recipes.registerOreDictionary("itemRubber", ItemComponent.getItemStack(EnumComponentType.RUBBER));
        Recipes.registerOreDictionary("itemBiofiber", ItemComponent.getItemStack(EnumComponentType.BIOFIBER));
        Recipes.registerOreDictionary("itemCeramic", ItemComponent.getItemStack(EnumComponentType.CERAMIC));
        Recipes.registerOreDictionary("plateCarbon", ItemComponent.getItemStack(EnumComponentType.CARBON_FIBER));
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            Recipes.registerOreDictionary("blockAirShield", new ItemStack(WarpDrive.blockAirShield, 1, enumDyeColor.func_176765_a()));
        }
        Recipes.registerOreDictionary("warpDecorative", BlockDecorative.getItemStack(EnumDecorativeType.PLAIN));
        Recipes.registerOreDictionary("warpDecorative", BlockDecorative.getItemStack(EnumDecorativeType.GLASS));
        Recipes.registerOreDictionary("warpDecorative", BlockDecorative.getItemStack(EnumDecorativeType.GRATED));
        Recipes.registerOreDictionary("warpDecorative", BlockDecorative.getItemStack(EnumDecorativeType.STRIPES_BLACK_DOWN));
        Recipes.registerOreDictionary("warpDecorative", BlockDecorative.getItemStack(EnumDecorativeType.STRIPES_BLACK_UP));
        Recipes.registerOreDictionary("warpDecorative", BlockDecorative.getItemStack(EnumDecorativeType.STRIPES_YELLOW_DOWN));
        Recipes.registerOreDictionary("warpDecorative", BlockDecorative.getItemStack(EnumDecorativeType.STRIPES_YELLOW_UP));
        for (int dyeColor = 0; dyeColor < 16; ++dyeColor) {
            Recipes.registerOreDictionary("itemTuningFork", new ItemStack((Item)WarpDrive.itemTuningFork, 1, dyeColor));
        }
        if (WarpDriveConfig.ACCELERATOR_ENABLE) {
            Recipes.registerOreDictionary("blockVoidShell", new ItemStack(WarpDrive.blockVoidShellPlain, 1));
            Recipes.registerOreDictionary("blockVoidShell", new ItemStack(WarpDrive.blockVoidShellGlass, 1));
            for (EnumTier enumTier : EnumTier.nonCreative()) {
                index = enumTier.getIndex();
                Recipes.registerOreDictionary("blockElectromagnet" + index, new ItemStack(WarpDrive.blockElectromagnets_plain[index], 1));
                Recipes.registerOreDictionary("blockElectromagnet" + index, new ItemStack(WarpDrive.blockElectromagnets_glass[index], 1));
            }
        }
        for (EnumTier enumTier : EnumTier.nonCreative()) {
            index = enumTier.getIndex();
            for (int woolColor = 0; woolColor < 16; ++woolColor) {
                Recipes.registerOreDictionary("blockHull" + index + "_plain", new ItemStack(WarpDrive.blockHulls_plain[index][0], 1, woolColor));
                Recipes.registerOreDictionary("blockHull" + index + "_glass", new ItemStack(WarpDrive.blockHulls_glass[index], 1, woolColor));
                Recipes.registerOreDictionary("blockHull" + index + "_stairs", new ItemStack(WarpDrive.blockHulls_stairs[index][woolColor], 1));
                Recipes.registerOreDictionary("blockHull" + index + "_tiled", new ItemStack(WarpDrive.blockHulls_plain[index][1], 1, woolColor));
                Recipes.registerOreDictionary("blockHull" + index + "_slab", new ItemStack(WarpDrive.blockHulls_slab[index][woolColor], 1, 0));
                Recipes.registerOreDictionary("blockHull" + index + "_slab", new ItemStack(WarpDrive.blockHulls_slab[index][woolColor], 1, 2));
                Recipes.registerOreDictionary("blockHull" + index + "_slab", new ItemStack(WarpDrive.blockHulls_slab[index][woolColor], 1, 6));
                Recipes.registerOreDictionary("blockHull" + index + "_slab", new ItemStack(WarpDrive.blockHulls_slab[index][woolColor], 1, 8));
                Recipes.registerOreDictionary("blockHull" + index + "_omnipanel", new ItemStack(WarpDrive.blockHulls_omnipanel[index], 1, woolColor));
            }
        }
        if ((!OreDictionary.doesOreNameExist((String)"plateAlloyIridium") || OreDictionary.getOres((String)"plateAlloyIridium").isEmpty()) && WarpDriveConfig.isIndustrialCraft2Loaded) {
            ItemStack iridiumAlloy = (ItemStack)WarpDriveConfig.getOreOrItemStack("ic2:crafting", 4, "ic2:itemmisc", 258);
            OreDictionary.registerOre((String)"plateAlloyIridium", (ItemStack)iridiumAlloy);
        }
    }

    private static void registerOreDictionary(String name, @Nonnull ItemStack itemStack) {
        if (!itemStack.func_190926_b()) {
            OreDictionary.registerOre((String)name, (ItemStack)itemStack);
        }
    }

    private static void initIngredients() {
        ItemStack itemStackIridiumAlloy;
        ItemStack itemStackMachineCasingEV;
        ItemStack itemStackMachineCasingHV;
        ItemStack itemStackMachineCasingMV;
        ItemStack itemStackMachineCasingLV;
        ItemStack itemStackMotorLV = ItemComponent.getItemStack(EnumComponentType.MOTOR);
        ItemStack itemStackMotorMV = ItemComponent.getItemStack(EnumComponentType.MOTOR);
        ItemStack itemStackMotorHV = ItemComponent.getItemStack(EnumComponentType.MOTOR);
        ItemStack itemStackMotorEV = ItemComponent.getItemStack(EnumComponentType.MOTOR);
        if (WarpDriveConfig.isGregtechLoaded) {
            itemStackMachineCasingLV = WarpDriveConfig.getItemStackOrFire("gregtech:machine_casing", 1);
            itemStackMachineCasingMV = WarpDriveConfig.getItemStackOrFire("gregtech:machine_casing", 2);
            itemStackMachineCasingHV = WarpDriveConfig.getItemStackOrFire("gregtech:machine_casing", 3);
            itemStackMachineCasingEV = WarpDriveConfig.getItemStackOrFire("gregtech:machine_casing", 4);
            itemStackMotorLV = WarpDriveConfig.getItemStackOrFire("gregtech:meta_item_1", 32600);
            itemStackMotorMV = WarpDriveConfig.getItemStackOrFire("gregtech:meta_item_1", 32601);
            itemStackMotorHV = WarpDriveConfig.getItemStackOrFire("gregtech:meta_item_1", 32602);
            itemStackMotorEV = WarpDriveConfig.getItemStackOrFire("gregtech:meta_item_1", 32603);
        } else if (WarpDriveConfig.isIndustrialCraft2Loaded) {
            itemStackMachineCasingLV = (ItemStack)WarpDriveConfig.getOreOrItemStack("ic2:resource", 12, "ic2:blockmachinelv", 0);
            itemStackMachineCasingMV = (ItemStack)WarpDriveConfig.getOreOrItemStack("ic2:resource", 13, "ic2:blackmachinemv", 0);
            itemStackMachineCasingHV = new ItemStack(WarpDrive.blockHighlyAdvancedMachine);
            itemStackMachineCasingEV = new ItemStack(WarpDrive.blockHighlyAdvancedMachine);
            ItemStack itemStackMotor = WarpDriveConfig.getItemStackOrFire("ic2:crafting", 6);
            if (!itemStackMotor.func_190926_b()) {
                itemStackMotorHV = itemStackMotor;
                itemStackMotorEV = itemStackMotor;
            }
            WarpDrive.register(new ShapedOreRecipe(groupComponents, new ItemStack(WarpDrive.blockHighlyAdvancedMachine), new Object[]{false, "iii", "imi", "iii", Character.valueOf('i'), "plateAlloyIridium", Character.valueOf('m'), itemStackMachineCasingMV}));
        } else if (WarpDriveConfig.isThermalFoundationLoaded) {
            itemStackMachineCasingLV = WarpDriveConfig.getItemStackOrFire("thermalfoundation:upgrade", 0);
            itemStackMachineCasingMV = WarpDriveConfig.getItemStackOrFire("thermalfoundation:upgrade", 1);
            itemStackMachineCasingHV = WarpDriveConfig.getItemStackOrFire("thermalfoundation:upgrade", 2);
            itemStackMachineCasingEV = WarpDriveConfig.getItemStackOrFire("thermalfoundation:upgrade", 3);
        } else if (WarpDriveConfig.isEnderIOLoaded) {
            itemStackMachineCasingLV = WarpDriveConfig.getItemStackOrFire("enderio:item_material", 0);
            itemStackMachineCasingMV = WarpDriveConfig.getItemStackOrFire("enderio:item_material", 1);
            itemStackMachineCasingHV = WarpDriveConfig.getItemStackOrFire("enderio:item_material", 54);
            itemStackMachineCasingEV = WarpDriveConfig.getItemStackOrFire("enderio:item_material", 55);
        } else {
            itemStackMachineCasingLV = new ItemStack(Blocks.field_150339_S);
            itemStackMachineCasingMV = new ItemStack(Blocks.field_150484_ah);
            itemStackMachineCasingHV = new ItemStack(WarpDrive.blockHighlyAdvancedMachine);
            itemStackMachineCasingEV = new ItemStack((Block)Blocks.field_150461_bJ);
            WarpDrive.register(new ShapedOreRecipe(groupComponents, new ItemStack(WarpDrive.blockHighlyAdvancedMachine, 4), new Object[]{"pep", "ede", "pep", Character.valueOf('e'), Items.field_151166_bC, Character.valueOf('p'), Items.field_151061_bv, Character.valueOf('d'), Blocks.field_150484_ah}));
        }
        itemStackMachineCasings = new ItemStack[]{itemStackMachineCasingLV, itemStackMachineCasingMV, itemStackMachineCasingHV, itemStackMachineCasingEV};
        itemStackMotors = new ItemStack[]{itemStackMotorLV, itemStackMotorMV, itemStackMotorHV, itemStackMotorEV};
        barsIron = WarpDriveConfig.getOreOrItemStack("ore:barsIron", 0, "minecraft:iron_bars", 0);
        ingotIronOrSteel = WarpDriveConfig.getOreOrItemStack("ore:ingotSteel", 0, "ore:ingotAluminium", 0, "ore:ingotAluminum", 0, "ore:ingotIron", 0);
        rubber = WarpDriveConfig.getOreOrItemStack("ore:plateRubber", 0, "ore:itemRubber", 0);
        goldNuggetOrBasicCircuit = WarpDriveConfig.getOreOrItemStack("ore:circuitBasic", 0, "ore:nuggetGold", 0);
        goldIngotOrAdvancedCircuit = WarpDriveConfig.getOreOrItemStack("ore:circuitAdvanced", 0, "ore:ingotGold", 0);
        emeraldOrSuperiorCircuit = WarpDriveConfig.getOreOrItemStack("ore:circuitElite", 0, "ore:gemEmerald", 0);
        if (WarpDriveConfig.isGregtechLoaded) {
            WarpDrive.register(new ShapedOreRecipe(groupComponents, new ItemStack(WarpDrive.blockIridium), new Object[]{"iii", "iii", "iii", Character.valueOf('i'), "plateIridium"}));
            itemStackIridiumAlloy = WarpDriveConfig.getOreDictionaryEntry("plateIridium");
            WarpDrive.register(new ShapelessOreRecipe(groupComponents, new ItemStack(itemStackIridiumAlloy.func_77973_b(), 9), new Object[]{new ItemStack(WarpDrive.blockIridium)}));
        } else if (OreDictionary.doesOreNameExist((String)"plateAlloyIridium") && !OreDictionary.getOres((String)"plateAlloyIridium").isEmpty()) {
            WarpDrive.register(new ShapedOreRecipe(groupComponents, new ItemStack(WarpDrive.blockIridium), new Object[]{"iii", "iii", "iii", Character.valueOf('i'), "plateAlloyIridium"}));
            itemStackIridiumAlloy = WarpDriveConfig.getOreDictionaryEntry("plateAlloyIridium");
            WarpDrive.register(new ShapelessOreRecipe(groupComponents, new ItemStack(itemStackIridiumAlloy.func_77973_b(), 9), new Object[]{new ItemStack(WarpDrive.blockIridium)}));
        } else if (WarpDriveConfig.isThermalFoundationLoaded || WarpDriveConfig.isEnderIOLoaded) {
            if (WarpDriveConfig.isThermalFoundationLoaded) {
                WarpDrive.register(new ShapedOreRecipe(groupComponents, new ItemStack(WarpDrive.blockIridium, 2), new Object[]{"ses", "ele", "ses", Character.valueOf('l'), "ingotLumium", Character.valueOf('s'), "ingotSignalum", Character.valueOf('e'), "ingotEnderium"}), "_thermal");
            }
            if (OreDictionary.doesOreNameExist((String)"plateIridium") && !OreDictionary.getOres((String)"plateIridium").isEmpty()) {
                WarpDrive.register(new ShapedOreRecipe(groupComponents, new ItemStack(WarpDrive.blockIridium), new Object[]{"iii", "iii", "iii", Character.valueOf('i'), "plateIridium"}), "_plates");
            }
            if (WarpDriveConfig.isEnderIOLoaded) {
                ItemStack itemStackVibrantAlloy = WarpDriveConfig.getItemStackOrFire("enderio:item_alloy_ingot", 2);
                ItemStack itemStackRedstoneAlloy = WarpDriveConfig.getItemStackOrFire("enderio:item_alloy_ingot", 3);
                ItemStack itemStackFranckNZombie = WarpDriveConfig.getItemStackOrFire("enderio:item_material", 42);
                WarpDrive.register(new ShapedOreRecipe(groupComponents, new ItemStack(WarpDrive.blockIridium, 4), new Object[]{"ses", "ele", "ses", Character.valueOf('l'), itemStackFranckNZombie, Character.valueOf('s'), itemStackRedstoneAlloy, Character.valueOf('e'), itemStackVibrantAlloy}), "_enderio");
            }
        } else {
            WarpDrive.register(new ShapedOreRecipe(groupComponents, new ItemStack(WarpDrive.blockIridium), new Object[]{"ded", "yty", "ded", Character.valueOf('t'), Items.field_151073_bk, Character.valueOf('d'), Items.field_151045_i, Character.valueOf('e'), Items.field_151166_bC, Character.valueOf('y'), Items.field_151061_bv}));
        }
        ItemStack itemStackWaterBottle = WarpDriveConfig.getItemStackOrFire("minecraft:potion", 0, "{Potion: \"minecraft:water\"}");
        ItemStack itemStackAwkwardPotion = WarpDriveConfig.getItemStackOrFire("minecraft:potion", 0, "{Potion: \"minecraft:awkward\"}");
        WarpDrive.register(new RecipeParticleShapedOre(groupMachines, new ItemStack(WarpDrive.blockLaserMediums[EnumTier.BASIC.getIndex()]), false, "   ", "dwd", "pm ", Character.valueOf('d'), "dye", Character.valueOf('w'), itemStackWaterBottle, Character.valueOf('p'), "nuggetGold", Character.valueOf('m'), itemStackMachineCasings[0]));
        WarpDrive.register(new RecipeParticleShapedOre(groupMachines, new ItemStack(WarpDrive.blockLaserMediums[EnumTier.ADVANCED.getIndex()]), false, "rAr", "lBl", "pm ", Character.valueOf('r'), "dustRedstone", Character.valueOf('A'), itemStackAwkwardPotion, Character.valueOf('l'), "gemLapis", Character.valueOf('B'), ItemComponent.getItemStack(EnumComponentType.GLASS_TANK), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('m'), itemStackMachineCasings[1]));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockLaserMediums[EnumTier.SUPERIOR.getIndex()]), new Object[]{false, "lrl", "rmr", "lrl", Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.LASER_MEDIUM_EMPTY), Character.valueOf('r'), "blockRedstone", Character.valueOf('l'), "blockLapis"}));
    }

    private static void initComponents() {
        Object memory = WarpDriveConfig.getOreOrItemStack("ore:circuitPrimitive", 0, "ore:oc:ram2", 0, "opencomputers:components", 8, "minecraft:comparator", 0);
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL), new Object[]{false, "gmg", "gmg", "prp", Character.valueOf('g'), "paneGlassColorless", Character.valueOf('m'), memory, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('p'), Items.field_151121_aF}));
        WarpDrive.register(new ShapelessOreRecipe(groupComponents, ItemComponent.getItemStack(EnumComponentType.MEMORY_CLUSTER), new Object[]{ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStack(EnumComponentType.DIAMOND_CRYSTAL), new Object[]{false, " d ", "BBB", "prp", Character.valueOf('d'), Items.field_151045_i, Character.valueOf('B'), barsIron, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('p'), Items.field_151121_aF}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL), new Object[]{false, " e ", "BBB", "qrq", Character.valueOf('e'), Items.field_151166_bC, Character.valueOf('B'), barsIron, Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('q'), Items.field_151128_bU}));
        Object lithiumOrElectrum = WarpDriveConfig.getOreOrItemStack("ore:dustLithium", 0, "ore:dustElectrum", 0, "ore:ingotElectricalSteel", 0, "ore:ingotGold", 0);
        ItemStack itemStackStrongRegeneration = WarpDriveConfig.getItemStackOrFire("minecraft:potion", 0, "{Potion: \"minecraft:strong_regeneration\"}");
        WarpDrive.register(new RecipeParticleShapedOre(groupComponents, ItemComponent.getItemStackNoCache(EnumComponentType.CAPACITIVE_CRYSTAL, 2), false, "prp", "lRl", "prp", Character.valueOf('R'), itemStackStrongRegeneration, Character.valueOf('r'), "blockRedstone", Character.valueOf('l'), lithiumOrElectrum, Character.valueOf('p'), Items.field_151121_aF));
        WarpDrive.register(new ShapelessOreRecipe(groupComponents, ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CLUSTER), new Object[]{ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL)}));
        Object nuggetGoldOrSilver = WarpDriveConfig.getOreOrItemStack("ore:nuggetElectrum", 0, "ore:nuggetSilver", 0, "ore:nuggetGold", 0);
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStackNoCache(EnumComponentType.ENDER_COIL, 2), new Object[]{false, "GGg", "rer", "gGG", Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('G'), "paneGlassColorless", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('g'), nuggetGoldOrSilver}));
        Object ingotGoldOrSilver = WarpDriveConfig.getOreOrItemStack("ore:ingotElectrum", 0, "ore:ingotSilver", 0, "ore:ingotGold", 0);
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStackNoCache(EnumComponentType.DIAMOND_COIL, 12), new Object[]{false, "bbg", "bdb", "gbb", Character.valueOf('b'), barsIron, Character.valueOf('g'), ingotGoldOrSilver, Character.valueOf('d'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_CRYSTAL)}));
        Item redstoneOrModem = Items.field_151137_ax;
        if (WarpDriveConfig.isComputerCraftLoaded) {
            redstoneOrModem = WarpDriveConfig.getItemStackOrFire("computercraft:cable", 1);
        }
        Object controlUnitOrBasicCircuit = WarpDriveConfig.getOreOrItemStack("ore:oc:materialCU", 0, "opencomputers:material", 11, "ore:circuitBasic", 0, "minecraft:light_weighted_pressure_plate", 0);
        if (OreDictionary.doesOreNameExist((String)"ingotSolderingAlloy") && !OreDictionary.getOres((String)"ingotSolderingAlloy").isEmpty()) {
            WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStackNoCache(EnumComponentType.COMPUTER_INTERFACE, 4), new Object[]{false, "   ", "rar", "gGg", Character.valueOf('G'), controlUnitOrBasicCircuit, Character.valueOf('g'), "ingotGold", Character.valueOf('r'), redstoneOrModem, Character.valueOf('a'), "ingotSolderingAlloy"}));
        }
        Object slimeOrTinOrLead = WarpDriveConfig.getOreOrItemStack("ore:ingotTin", 0, "ore:ingotLead", 0, "ore:slimeball", 0);
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStackNoCache(EnumComponentType.COMPUTER_INTERFACE, 2), new Object[]{false, "   ", "rar", "gGg", Character.valueOf('G'), controlUnitOrBasicCircuit, Character.valueOf('g'), "ingotGold", Character.valueOf('r'), redstoneOrModem, Character.valueOf('a'), slimeOrTinOrLead}));
        GameRegistry.addSmelting((Item)Items.field_151103_aS, (ItemStack)ItemComponent.getItemStackNoCache(EnumComponentType.BONE_CHARCOAL, 1), (float)1.0f);
        Object leaves = WarpDriveConfig.getOreOrItemStack("ore:treeLeaves", 0, "minecraft:leaves", 0);
        Object gunpowderOrSulfur = WarpDriveConfig.getOreOrItemStack("ore:dustSulfur", 0, "ore:gunpowder", 0, "minecraft:gunpowder", 0);
        ItemStack itemStackWaterBottle = WarpDriveConfig.getItemStackOrFire("minecraft:potion", 0, "{Potion: \"minecraft:water\"}");
        WarpDrive.register(new RecipeParticleShapedOre(groupComponents, ItemComponent.getItemStack(EnumComponentType.ACTIVATED_CARBON), false, "lll", "aaa", "wgw", Character.valueOf('l'), leaves, Character.valueOf('a'), ItemComponent.getItemStack(EnumComponentType.BONE_CHARCOAL), Character.valueOf('w'), itemStackWaterBottle, Character.valueOf('g'), gunpowderOrSulfur));
        Object woolPurple = WarpDriveConfig.getOreOrItemStack("ore:blockWoolPurple", 0, "minecraft:wool", 10);
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStackNoCache(EnumComponentType.AIR_CANISTER, 4), new Object[]{false, "iyi", "rgr", "iyi", Character.valueOf('r'), rubber, Character.valueOf('g'), ItemComponent.getItemStack(EnumComponentType.GLASS_TANK), Character.valueOf('y'), woolPurple, Character.valueOf('i'), barsIron}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStack(EnumComponentType.FLAT_SCREEN), new Object[]{false, "gRp", "gGd", "gBp", Character.valueOf('R'), "dyeRed", Character.valueOf('G'), "dyeLime", Character.valueOf('B'), "dyeBlue", Character.valueOf('d'), "dustGlowstone", Character.valueOf('g'), "paneGlassColorless", Character.valueOf('p'), Items.field_151121_aF}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStack(EnumComponentType.HOLOGRAPHIC_PROJECTOR), new Object[]{false, "ssM", "szc", "ssE", Character.valueOf('s'), ItemComponent.getItemStack(EnumComponentType.FLAT_SCREEN), Character.valueOf('z'), ItemComponent.getItemStack(EnumComponentType.ZOOM), Character.valueOf('M'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL), Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE), Character.valueOf('E'), ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStackNoCache(EnumComponentType.GLASS_TANK, 4), new Object[]{false, "sgs", "g g", "sgs", Character.valueOf('s'), "slimeball", Character.valueOf('g'), "blockGlass"}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStack(EnumComponentType.MOTOR), new Object[]{false, "bbn", "iii", "bbn", Character.valueOf('b'), barsIron, Character.valueOf('i'), "ingotIron", Character.valueOf('n'), "nuggetGold"}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStackNoCache(EnumComponentType.PUMP, 2), new Object[]{false, "sst", "mim", "tss", Character.valueOf('s'), rubber, Character.valueOf('i'), ingotIronOrSteel, Character.valueOf('m'), itemStackMotors[0], Character.valueOf('t'), ItemComponent.getItemStack(EnumComponentType.GLASS_TANK)}));
        Object diamondLensOrGem = WarpDriveConfig.getOreOrItemStack("ore:lensDiamond", 0, "ore:demDiamond", 0);
        Object whiteLensOrGlassPane = WarpDriveConfig.getOreOrItemStack("ore:craftingLensWhite", 0, "ore:paneGlassColorless", 0);
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStackNoCache(EnumComponentType.LENS, 2), new Object[]{false, "ggg", "pdp", "ggg", Character.valueOf('g'), "nuggetGold", Character.valueOf('p'), whiteLensOrGlassPane, Character.valueOf('d'), diamondLensOrGem}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStack(EnumComponentType.ZOOM), new Object[]{false, "dir", "lll", "dit", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('i'), ingotIronOrSteel, Character.valueOf('l'), ItemComponent.getItemStack(EnumComponentType.LENS), Character.valueOf('t'), itemStackMotors[0], Character.valueOf('d'), "dye"}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStack(EnumComponentType.DIFFRACTION_GRATING), new Object[]{false, " t ", "iii", "ggg", Character.valueOf('t'), Items.field_151073_bk, Character.valueOf('i'), barsIron, Character.valueOf('g'), Blocks.field_150426_aN}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStackNoCache(EnumComponentType.POWER_INTERFACE, 3), new Object[]{false, "rgr", "RgR", "rgr", Character.valueOf('g'), "ingotGold", Character.valueOf('R'), rubber, Character.valueOf('r'), Items.field_151137_ax}));
        Object coolant = WarpDriveConfig.getOreOrItemStack("ore:dustCryotheum", 0, "ic2:heat_storage", 0, "ic2:itemheatstorage", 0, "ore:blockLapis", 0);
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStack(EnumComponentType.SUPERCONDUCTOR), new Object[]{false, " c ", "pep", " c ", Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL), Character.valueOf('c'), coolant}), "_direct");
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemComponent.getItemStack(EnumComponentType.SUPERCONDUCTOR), new Object[]{false, " p ", "cec", " p ", Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL), Character.valueOf('c'), coolant}), "_rotated");
        ItemStack itemStackAwkwardPotion = WarpDriveConfig.getItemStackOrFire("minecraft:potion", 0, "{Potion: \"minecraft:awkward\"}");
        WarpDrive.register(new RecipeParticleShapedOre(groupMachines, ItemComponent.getItemStack(EnumComponentType.LASER_MEDIUM_EMPTY), false, "   ", "gBg", "pm ", Character.valueOf('B'), itemStackAwkwardPotion, Character.valueOf('g'), ItemComponent.getItemStack(EnumComponentType.GLASS_TANK), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('m'), itemStackMachineCasings[2]));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, ItemComponent.getItemStack(EnumComponentType.ELECTROMAGNETIC_PROJECTOR), new Object[]{false, "CCm", "Cpc", "CCm", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('m'), itemStackMotors[2], Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE)}));
        if (!WarpDriveConfig.ACCELERATOR_ENABLE) {
            WarpDrive.register(new ShapedOreRecipe(groupMachines, ItemComponent.getItemStack(EnumComponentType.REACTOR_CORE), new Object[]{false, "shs", "hmh", "shs", Character.valueOf('s'), Items.field_151156_bN, Character.valueOf('h'), "blockHull3_plain", Character.valueOf('m'), itemStackMachineCasings[2]}));
        } else {
            WarpDrive.register(new RecipeParticleShapedOre(groupMachines, ItemComponent.getItemStack(EnumComponentType.REACTOR_CORE), false, "chc", "hph", "cec", Character.valueOf('p'), ItemElectromagneticCell.getItemStackNoCache(EnumTier.ADVANCED, ParticleRegistry.ION, 1000), Character.valueOf('h'), "blockHull3_plain", Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL), Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL)));
        }
        GameRegistry.addSmelting((ItemStack)ItemComponent.getItemStack(EnumComponentType.RAW_RUBBER), (ItemStack)ItemComponent.getItemStack(EnumComponentType.RUBBER), (float)0.0f);
        WarpDrive.register(new ShapedOreRecipe(groupMachines, ItemComponent.getItemStackNoCache(EnumComponentType.BIOPULP, 9), new Object[]{false, "lll", "lml", "lll", Character.valueOf('l'), leaves, Character.valueOf('m'), "blockMushroom"}), "_block");
        Object oreOrBrownMushroom = WarpDriveConfig.getOreOrItemStack("ore:listAllmushroom", 0, "minecraft:brown_mushroom", 0);
        Object oreOrRedMushroom = WarpDriveConfig.getOreOrItemStack("ore:listAllmushroom", 0, "minecraft:red_mushroom", 0);
        WarpDrive.register(new ShapedOreRecipe(groupMachines, ItemComponent.getItemStackNoCache(EnumComponentType.BIOPULP, 2), new Object[]{false, "lll", "mbM", "lll", Character.valueOf('b'), Items.field_151120_aE, Character.valueOf('l'), leaves, Character.valueOf('m'), oreOrBrownMushroom, Character.valueOf('M'), oreOrRedMushroom}), "_sugarcane");
        GameRegistry.addSmelting((ItemStack)ItemComponent.getItemStack(EnumComponentType.BIOPULP), (ItemStack)ItemComponent.getItemStack(EnumComponentType.BIOFIBER), (float)0.0f);
        WarpDrive.register(new ShapelessOreRecipe(groupMachines, ItemComponent.getItemStackNoCache(EnumComponentType.RAW_CERAMIC, 4), new Object[]{Items.field_151119_aD, Items.field_151119_aD, Items.field_151119_aD, "sand"}));
        GameRegistry.addSmelting((ItemStack)ItemComponent.getItemStack(EnumComponentType.RAW_CERAMIC), (ItemStack)ItemComponent.getItemStack(EnumComponentType.CERAMIC), (float)0.0f);
        Object coalDustOrCoal = WarpDriveConfig.getOreOrItemStack("ore:dustCoal", 0, "minecraft:coal", 0);
        WarpDrive.register(new ShapelessOreRecipe(groupMachines, ItemComponent.getItemStackNoCache(EnumComponentType.RAW_CARBON_FIBER, 4), new Object[]{Items.field_151065_br, coalDustOrCoal, coalDustOrCoal, coalDustOrCoal, coalDustOrCoal, coalDustOrCoal, coalDustOrCoal, coalDustOrCoal, coalDustOrCoal}), "coal");
        Object coalDustOrCharcoal = WarpDriveConfig.getOreOrItemStack("ore:dustCharcoal", 0, "minecraft:coal", 1);
        WarpDrive.register(new ShapelessOreRecipe(groupMachines, ItemComponent.getItemStack(EnumComponentType.RAW_CARBON_FIBER), new Object[]{Items.field_151065_br, coalDustOrCharcoal, coalDustOrCharcoal, coalDustOrCharcoal, coalDustOrCharcoal}), "charcoal");
        WarpDrive.register(new ShapedOreRecipe(groupMachines, ItemComponent.getItemStackNoCache(EnumComponentType.RAW_CARBON_MESH, 4), new Object[]{false, "fcf", "ccc", "fcf", Character.valueOf('f'), ItemComponent.getItemStack(EnumComponentType.BIOFIBER), Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.RAW_CARBON_FIBER)}));
        GameRegistry.addSmelting((ItemStack)ItemComponent.getItemStack(EnumComponentType.RAW_CARBON_MESH), (ItemStack)ItemComponent.getItemStack(EnumComponentType.CARBON_FIBER), (float)0.0f);
    }

    private static void initToolsAndArmor() {
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemWarpArmor[EnumTier.BASIC.getIndex()][EntityEquipmentSlot.HEAD.func_188454_b()], new Object[]{false, "mmm", "mgm", "ici", Character.valueOf('m'), "itemRubber", Character.valueOf('g'), "blockHull1_glass", Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.AIR_CANISTER), Character.valueOf('i'), "nuggetIron"}));
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemWarpArmor[EnumTier.ADVANCED.getIndex()][EntityEquipmentSlot.HEAD.func_188454_b()], new Object[]{false, "fmf", "mam", "   ", Character.valueOf('a'), WarpDrive.itemWarpArmor[EnumTier.BASIC.getIndex()][EntityEquipmentSlot.HEAD.func_188454_b()], Character.valueOf('m'), "itemCeramic", Character.valueOf('f'), "itemBiofiber"}));
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemWarpArmor[EnumTier.SUPERIOR.getIndex()][EntityEquipmentSlot.HEAD.func_188454_b()], new Object[]{false, "mmm", "mam", "   ", Character.valueOf('a'), WarpDrive.itemWarpArmor[EnumTier.ADVANCED.getIndex()][EntityEquipmentSlot.HEAD.func_188454_b()], Character.valueOf('m'), "plateCarbon"}));
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemWarpArmor[EnumTier.BASIC.getIndex()][EntityEquipmentSlot.CHEST.func_188454_b()], new Object[]{false, "i i", "mmm", "mim", Character.valueOf('m'), "itemRubber", Character.valueOf('i'), "nuggetIron"}));
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemWarpArmor[EnumTier.ADVANCED.getIndex()][EntityEquipmentSlot.CHEST.func_188454_b()], new Object[]{false, "faf", "mmm", "mfm", Character.valueOf('a'), WarpDrive.itemWarpArmor[EnumTier.BASIC.getIndex()][EntityEquipmentSlot.CHEST.func_188454_b()], Character.valueOf('m'), "itemCeramic", Character.valueOf('f'), "itemBiofiber"}));
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemWarpArmor[EnumTier.SUPERIOR.getIndex()][EntityEquipmentSlot.CHEST.func_188454_b()], new Object[]{false, "mam", "mpm", "mcm", Character.valueOf('a'), WarpDrive.itemWarpArmor[EnumTier.ADVANCED.getIndex()][EntityEquipmentSlot.CHEST.func_188454_b()], Character.valueOf('m'), "plateCarbon", Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.PUMP), Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.AIR_CANISTER)}));
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemWarpArmor[EnumTier.BASIC.getIndex()][EntityEquipmentSlot.LEGS.func_188454_b()], new Object[]{false, "imi", "m m", "m m", Character.valueOf('m'), "itemRubber", Character.valueOf('i'), "nuggetIron"}));
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemWarpArmor[EnumTier.ADVANCED.getIndex()][EntityEquipmentSlot.LEGS.func_188454_b()], new Object[]{false, "faf", "mMm", "w w", Character.valueOf('a'), WarpDrive.itemWarpArmor[EnumTier.BASIC.getIndex()][EntityEquipmentSlot.LEGS.func_188454_b()], Character.valueOf('m'), "itemCeramic", Character.valueOf('f'), "itemBiofiber", Character.valueOf('w'), Blocks.field_150325_L, Character.valueOf('M'), itemStackMotors[1]}));
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemWarpArmor[EnumTier.SUPERIOR.getIndex()][EntityEquipmentSlot.LEGS.func_188454_b()], new Object[]{false, "mam", "m m", "m m", Character.valueOf('a'), WarpDrive.itemWarpArmor[EnumTier.ADVANCED.getIndex()][EntityEquipmentSlot.LEGS.func_188454_b()], Character.valueOf('m'), "plateCarbon"}));
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemWarpArmor[EnumTier.BASIC.getIndex()][EntityEquipmentSlot.FEET.func_188454_b()], new Object[]{false, "i i", "m m", "   ", Character.valueOf('m'), "itemRubber", Character.valueOf('i'), "nuggetIron"}));
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemWarpArmor[EnumTier.ADVANCED.getIndex()][EntityEquipmentSlot.FEET.func_188454_b()], new Object[]{false, "mam", "fMf", "w w", Character.valueOf('a'), WarpDrive.itemWarpArmor[EnumTier.BASIC.getIndex()][EntityEquipmentSlot.FEET.func_188454_b()], Character.valueOf('m'), "itemCeramic", Character.valueOf('f'), "itemBiofiber", Character.valueOf('w'), Blocks.field_150325_L, Character.valueOf('M'), itemStackMotors[1]}));
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemWarpArmor[EnumTier.SUPERIOR.getIndex()][EntityEquipmentSlot.FEET.func_188454_b()], new Object[]{false, "mam", "m m", "   ", Character.valueOf('a'), WarpDrive.itemWarpArmor[EnumTier.ADVANCED.getIndex()][EntityEquipmentSlot.FEET.func_188454_b()], Character.valueOf('m'), "plateCarbon"}));
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemWrench, new Object[]{false, "n n", "nin", " m ", Character.valueOf('m'), "itemRubber", Character.valueOf('i'), "ingotIron", Character.valueOf('n'), "nuggetIron"}));
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            int damageColor = enumDyeColor.func_176767_b();
            WarpDrive.register(new ShapedOreRecipe(groupTools, new ItemStack((Item)WarpDrive.itemTuningFork, 1, damageColor), new Object[]{false, "  q", "iX ", " i ", Character.valueOf('q'), "gemQuartz", Character.valueOf('i'), "ingotIron", Character.valueOf('X'), oreDyes.get(enumDyeColor)}));
            WarpDrive.register(new ShapelessOreRecipe(groupTools, new ItemStack((Item)WarpDrive.itemTuningFork, 1, damageColor), new Object[]{oreDyes.get(enumDyeColor), "itemTuningFork"}), "_dye");
        }
        WarpDrive.register(new ShapedOreRecipe(groupTools, new ItemStack((Item)WarpDrive.itemTuningDriver, 1, 0), new Object[]{false, "  q", "pm ", "d  ", Character.valueOf('q'), "gemQuartz", Character.valueOf('p'), Blocks.field_150443_bT, Character.valueOf('d'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_CRYSTAL), Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL)}));
        WarpDrive.register(new RecipeTuningDriver(groupTools, new ItemStack((Item)WarpDrive.itemTuningDriver, 1, 0), new ItemStack(Items.field_151137_ax), 7, "_video2"), "_video1");
        WarpDrive.register(new RecipeTuningDriver(groupTools, new ItemStack((Item)WarpDrive.itemTuningDriver, 1, 1), new ItemStack(Items.field_151137_ax), 4, "_bream_frequency2"), "_bream_frequency1");
        WarpDrive.register(new RecipeTuningDriver(groupTools, new ItemStack((Item)WarpDrive.itemTuningDriver, 1, 2), new ItemStack(Items.field_151137_ax), 7, "_control_channel2"), "_control_channel1");
    }

    public static void initDynamic() {
        Recipes.initIngredients();
        Recipes.initComponents();
        Recipes.initToolsAndArmor();
        if (WarpDriveConfig.ACCELERATOR_ENABLE) {
            Recipes.initAtomic();
        }
        Recipes.initBreathing();
        Recipes.initCollection();
        Recipes.initDecoration();
        Recipes.initDetection();
        Recipes.initEnergy();
        Recipes.initForceField();
        Recipes.initHull();
        Recipes.initMovement();
        Recipes.initWeapon();
    }

    private static void initAtomic() {
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockVoidShellPlain, 6), new Object[]{"psh", "s s", "hsp", Character.valueOf('h'), "blockHull1_plain", Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('s'), ingotIronOrSteel}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockVoidShellGlass, 6), new Object[]{"psh", "s s", "hsp", Character.valueOf('h'), "blockHull1_glass", Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('s'), ingotIronOrSteel}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockVoidShellGlass, 2), new Object[]{"g g", "sfs", "g g", Character.valueOf('g'), "blockGlass", Character.valueOf('f'), "dustGlowstone", Character.valueOf('s'), WarpDrive.blockVoidShellPlain}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack((Item)WarpDrive.itemElectromagneticCell[EnumTier.BASIC.getIndex()], 2), new Object[]{"iri", "i i", "ici", Character.valueOf('i'), barsIron, Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL), Character.valueOf('r'), Items.field_151137_ax}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack((Item)WarpDrive.itemElectromagneticCell[EnumTier.ADVANCED.getIndex()], 2), new Object[]{"iei", "iei", "gcg", Character.valueOf('e'), WarpDrive.itemElectromagneticCell[EnumTier.BASIC.getIndex()], Character.valueOf('i'), barsIron, Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack((Item)WarpDrive.itemElectromagneticCell[EnumTier.SUPERIOR.getIndex()], 2), new Object[]{"geg", "geg", "gcg", Character.valueOf('e'), WarpDrive.itemElectromagneticCell[EnumTier.ADVANCED.getIndex()], Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockAcceleratorControlPoint), new Object[]{"hd ", "vc ", "he ", Character.valueOf('h'), Blocks.field_150438_bZ, Character.valueOf('d'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_CRYSTAL), Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL), Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE), Character.valueOf('v'), "blockVoidShell"}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockParticlesInjector), new Object[]{"mm ", "vvp", "mmc", Character.valueOf('p'), Blocks.field_150331_J, Character.valueOf('m'), "blockElectromagnet1", Character.valueOf('c'), WarpDrive.blockAcceleratorControlPoint, Character.valueOf('v'), "blockVoidShell"}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockAcceleratorCore), new Object[]{"MmM", "mcm", "MmM", Character.valueOf('M'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL), Character.valueOf('m'), "blockElectromagnet1", Character.valueOf('c'), WarpDrive.blockAcceleratorControlPoint}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockParticlesCollider), new Object[]{"hoh", "odo", "hoh", Character.valueOf('h'), "blockHull1_plain", Character.valueOf('o'), Blocks.field_150343_Z, Character.valueOf('d'), Items.field_151045_i}));
        Block snowOrIce = Blocks.field_150433_aE;
        if (OreDictionary.doesOreNameExist((String)"dustCryotheum") && !OreDictionary.getOres((String)"dustCryotheum").isEmpty()) {
            snowOrIce = Blocks.field_150432_aD;
        }
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockChillers[EnumTier.BASIC.getIndex()]), new Object[]{"wgw", "sms", "bMb", Character.valueOf('w'), snowOrIce, Character.valueOf('g'), Items.field_151073_bk, Character.valueOf('s'), ingotIronOrSteel, Character.valueOf('m'), itemStackMotors[0], Character.valueOf('b'), barsIron, Character.valueOf('M'), "blockElectromagnet1"}));
        Block nitrogen = Blocks.field_150432_aD;
        if (OreDictionary.doesOreNameExist((String)"dustCryotheum") && !OreDictionary.getOres((String)"dustCryotheum").isEmpty()) {
            nitrogen = Blocks.field_150403_cj;
        }
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockChillers[EnumTier.ADVANCED.getIndex()]), new Object[]{"ngn", "dmd", "bMb", Character.valueOf('n'), nitrogen, Character.valueOf('g'), Items.field_151073_bk, Character.valueOf('d'), Items.field_151045_i, Character.valueOf('m'), itemStackMotors[1], Character.valueOf('b'), barsIron, Character.valueOf('M'), "blockElectromagnet2"}));
        Object helium = Blocks.field_150403_cj;
        if (OreDictionary.doesOreNameExist((String)"dustCryotheum") && !OreDictionary.getOres((String)"dustCryotheum").isEmpty()) {
            helium = "dustCryotheum";
        }
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockChillers[EnumTier.SUPERIOR.getIndex()]), new Object[]{"hgh", "eme", "bMb", Character.valueOf('h'), helium, Character.valueOf('g'), Items.field_151073_bk, Character.valueOf('e'), Items.field_151166_bC, Character.valueOf('m'), itemStackMotors[2], Character.valueOf('b'), barsIron, Character.valueOf('M'), "blockElectromagnet3"}));
        Object ironIngotOrCopperIngotOrCoil1 = WarpDriveConfig.getOreOrItemStack("ic2:crafting", 5, "immersiveengineering:wirecoil", 1, "enderio:item_power_conduit", 1, "ore:ingotCopper", 0, "ore:ingotSteel", 0, "minecraft:iron_ingot", 0);
        Object ironIngotOrCopperIngotOrCoil2 = WarpDriveConfig.getOreOrItemStack("gregtech:wire_coil", 0, "ic2:crafting", 5, "thermalfoundation:material", 513, "immersiveengineering:wirecoil", 1, "enderio:item_power_conduit", 1, "ore:ingotCopper", 0, "ore:ingotSteel", 0, "minecraft:iron_ingot", 0);
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockElectromagnets_plain[EnumTier.BASIC.getIndex()], 4), new Object[]{"   ", "cdc", "Cmt", Character.valueOf('c'), ironIngotOrCopperIngotOrCoil1, Character.valueOf('d'), ironIngotOrCopperIngotOrCoil2, Character.valueOf('t'), ItemComponent.getItemStack(EnumComponentType.GLASS_TANK), Character.valueOf('m'), itemStackMotors[0], Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockElectromagnets_glass[EnumTier.BASIC.getIndex()], 4), new Object[]{"mgm", "g g", "mgm", Character.valueOf('g'), Blocks.field_150359_w, Character.valueOf('m'), WarpDrive.blockElectromagnets_plain[EnumTier.BASIC.getIndex()]}));
        WarpDrive.register(new RecipeParticleShapedOre(groupMachines, new ItemStack(WarpDrive.blockElectromagnets_plain[EnumTier.ADVANCED.getIndex()], 6), "mpm", "pip", "mpm", Character.valueOf('i'), ItemElectromagneticCell.getItemStackNoCache(EnumTier.BASIC, ParticleRegistry.ION, 200), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('m'), WarpDrive.blockElectromagnets_plain[EnumTier.BASIC.getIndex()]));
        WarpDrive.register(new RecipeParticleShapedOre(groupMachines, new ItemStack(WarpDrive.blockElectromagnets_glass[EnumTier.ADVANCED.getIndex()], 6), "mpm", "pip", "mpm", Character.valueOf('i'), ItemElectromagneticCell.getItemStackNoCache(EnumTier.BASIC, ParticleRegistry.ION, 200), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('m'), WarpDrive.blockElectromagnets_glass[EnumTier.BASIC.getIndex()]));
        WarpDrive.register(new RecipeParticleShapedOre(groupMachines, new ItemStack(WarpDrive.blockElectromagnets_plain[EnumTier.SUPERIOR.getIndex()], 6), "mtm", "sps", "mMm", Character.valueOf('t'), ItemComponent.getItemStack(EnumComponentType.GLASS_TANK), Character.valueOf('s'), ItemComponent.getItemStack(EnumComponentType.SUPERCONDUCTOR), Character.valueOf('p'), ItemElectromagneticCell.getItemStackNoCache(EnumTier.BASIC, ParticleRegistry.PROTON, 24), Character.valueOf('M'), itemStackMotors[2], Character.valueOf('m'), WarpDrive.blockElectromagnets_plain[EnumTier.ADVANCED.getIndex()]));
        WarpDrive.register(new RecipeParticleShapedOre(groupMachines, new ItemStack(WarpDrive.blockElectromagnets_glass[EnumTier.SUPERIOR.getIndex()], 6), "mtm", "sps", "mMm", Character.valueOf('t'), ItemComponent.getItemStack(EnumComponentType.GLASS_TANK), Character.valueOf('s'), ItemComponent.getItemStack(EnumComponentType.SUPERCONDUCTOR), Character.valueOf('p'), ItemElectromagneticCell.getItemStackNoCache(EnumTier.BASIC, ParticleRegistry.PROTON, 24), Character.valueOf('M'), itemStackMotors[2], Character.valueOf('m'), WarpDrive.blockElectromagnets_glass[EnumTier.ADVANCED.getIndex()]));
        if (WarpDriveConfig.isICBMClassicLoaded) {
            ItemStack itemStackAntimatterExplosive = WarpDriveConfig.getItemStackOrFire("icbmclassic:explosives", 22);
            Recipes.removeRecipe(itemStackAntimatterExplosive);
            WarpDrive.register(new RecipeParticleShapedOre(groupComponents, itemStackAntimatterExplosive, "aaa", "ana", "aaa", Character.valueOf('a'), ItemElectromagneticCell.getItemStackNoCache(EnumTier.ADVANCED, ParticleRegistry.ANTIMATTER, 1000), Character.valueOf('n'), WarpDriveConfig.getItemStackOrFire("icbmclassic:explosives", 15)));
            ItemStack itemStackRedMatterExplosive = WarpDriveConfig.getItemStackOrFire("icbmclassic:explosives", 23);
            Recipes.removeRecipe(itemStackRedMatterExplosive);
            WarpDrive.register(new RecipeParticleShapedOre(groupComponents, itemStackRedMatterExplosive, "sss", "sas", "sss", Character.valueOf('s'), ItemElectromagneticCell.getItemStackNoCache(EnumTier.ADVANCED, ParticleRegistry.STRANGE_MATTER, 1000), Character.valueOf('a'), WarpDriveConfig.getItemStackOrFire("icbmclassic:explosives", 22)));
        }
    }

    private static void initBreathing() {
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemAirTanks[EnumAirTankTier.BASIC.getIndex()], new Object[]{false, "rnr", "tpt", "rcr", Character.valueOf('r'), rubber, Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.PUMP), Character.valueOf('t'), ItemComponent.getItemStack(EnumComponentType.AIR_CANISTER), Character.valueOf('c'), goldNuggetOrBasicCircuit, Character.valueOf('n'), "nuggetGold"}));
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemAirTanks[EnumAirTankTier.ADVANCED.getIndex()], new Object[]{false, "rnr", "tpt", "rcr", Character.valueOf('r'), rubber, Character.valueOf('p'), itemStackMotors[1], Character.valueOf('t'), WarpDrive.itemAirTanks[EnumAirTankTier.BASIC.getIndex()], Character.valueOf('c'), goldIngotOrAdvancedCircuit, Character.valueOf('n'), "nuggetGold"}));
        WarpDrive.register(new ShapedOreRecipe(groupTools, (Item)WarpDrive.itemAirTanks[EnumAirTankTier.SUPERIOR.getIndex()], new Object[]{false, "rnr", "tpt", "rcr", Character.valueOf('r'), rubber, Character.valueOf('p'), itemStackMotors[2], Character.valueOf('t'), WarpDrive.itemAirTanks[EnumAirTankTier.ADVANCED.getIndex()], Character.valueOf('c'), emeraldOrSuperiorCircuit, Character.valueOf('n'), "nuggetGold"}));
        WarpDrive.register(new ShapelessOreRecipe(groupComponents, ItemComponent.getItemStackNoCache(EnumComponentType.GLASS_TANK, 1), new Object[]{WarpDrive.itemAirTanks[EnumAirTankTier.CANISTER.getIndex()], WarpDrive.itemAirTanks[EnumAirTankTier.CANISTER.getIndex()], WarpDrive.itemAirTanks[EnumAirTankTier.CANISTER.getIndex()], WarpDrive.itemAirTanks[EnumAirTankTier.CANISTER.getIndex()]}), "_uncrafting");
        WarpDrive.register(new ShapelessOreRecipe(groupComponents, ItemComponent.getItemStackNoCache(EnumComponentType.AIR_CANISTER, 2), new Object[]{WarpDrive.itemAirTanks[EnumAirTankTier.BASIC.getIndex()]}), "_uncrafting");
        WarpDrive.register(new ShapelessOreRecipe(groupComponents, ItemComponent.getItemStackNoCache(EnumComponentType.AIR_CANISTER, 4), new Object[]{WarpDrive.itemAirTanks[EnumAirTankTier.ADVANCED.getIndex()]}), "_uncrafting");
        WarpDrive.register(new ShapelessOreRecipe(groupComponents, ItemComponent.getItemStackNoCache(EnumComponentType.AIR_CANISTER, 8), new Object[]{WarpDrive.itemAirTanks[EnumAirTankTier.SUPERIOR.getIndex()]}), "_uncrafting");
        Object bronzeRotorOrIronBars = WarpDriveConfig.getOreOrItemStack("ore:rotorBronze", 0, "ore:plateBronze", 8, "ore:gearIronInfinity", 0, "ore:barsIron", 0, "minecraft:iron_bars", 0);
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockAirGeneratorTiered[EnumTier.BASIC.getIndex()]), new Object[]{false, "aba", "ata", "gmp", Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('a'), ItemComponent.getItemStack(EnumComponentType.ACTIVATED_CARBON), Character.valueOf('t'), ItemComponent.getItemStack(EnumComponentType.PUMP), Character.valueOf('g'), ItemComponent.getItemStack(EnumComponentType.GLASS_TANK), Character.valueOf('m'), itemStackMachineCasings[1], Character.valueOf('b'), bronzeRotorOrIronBars}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockAirGeneratorTiered[EnumTier.ADVANCED.getIndex()]), new Object[]{false, "aaa", "ata", "ama", Character.valueOf('a'), WarpDrive.blockAirGeneratorTiered[EnumTier.BASIC.getIndex()], Character.valueOf('t'), itemStackMotors[2], Character.valueOf('m'), itemStackMachineCasings[2]}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockAirGeneratorTiered[EnumTier.SUPERIOR.getIndex()]), new Object[]{false, "aaa", "ata", "ama", Character.valueOf('a'), WarpDrive.blockAirGeneratorTiered[EnumTier.ADVANCED.getIndex()], Character.valueOf('t'), itemStackMotors[3], Character.valueOf('m'), itemStackMachineCasings[3]}));
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            int metadataColor = enumDyeColor.func_176765_a();
            WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockAirShield, 4, metadataColor), new Object[]{false, "gog", "oco", "gog", Character.valueOf('g'), "dustGlowstone", Character.valueOf('o'), new ItemStack(WarpDrive.blockHulls_omnipanel[EnumTier.BASIC.getIndex()], 1, metadataColor), Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL)}));
            WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockAirShield, 6, metadataColor), new Object[]{false, "###", "gXg", "###", Character.valueOf('#'), "blockAirShield", Character.valueOf('g'), Items.field_151074_bl, Character.valueOf('X'), oreDyes.get(enumDyeColor)}));
            WarpDrive.register(new ShapelessOreRecipe(groupMachines, new ItemStack(WarpDrive.blockAirShield, 1, metadataColor), new Object[]{"blockAirShield", oreDyes.get(enumDyeColor)}));
        }
    }

    private static void initCollection() {
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockMiningLaser), new Object[]{false, " mp", "tdt", "glg", Character.valueOf('t'), itemStackMotors[1], Character.valueOf('d'), ItemComponent.getItemStack(EnumComponentType.DIFFRACTION_GRATING), Character.valueOf('l'), ItemComponent.getItemStack(EnumComponentType.LENS), Character.valueOf('m'), itemStackMachineCasings[1], Character.valueOf('p'), Items.field_151046_w, Character.valueOf('g'), "paneGlassColorless"}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockLaserTreeFarm), new Object[]{false, "glg", "tlt", "am ", Character.valueOf('t'), itemStackMotors[0], Character.valueOf('l'), ItemComponent.getItemStack(EnumComponentType.LENS), Character.valueOf('m'), itemStackMachineCasings[0], Character.valueOf('a'), Items.field_151056_x, Character.valueOf('g'), "paneGlassColorless"}));
    }

    private static void initDecoration() {
        WarpDrive.register(new ShapedOreRecipe(groupDecorations, BlockDecorative.getItemStackNoCache(EnumDecorativeType.PLAIN, 12), new Object[]{false, "ipi", "pbp", "ipi", Character.valueOf('i'), Items.field_151042_j, Character.valueOf('b'), Blocks.field_150411_aY, Character.valueOf('p'), Items.field_151121_aF}));
        WarpDrive.register(new ShapedOreRecipe(groupDecorations, BlockDecorative.getItemStackNoCache(EnumDecorativeType.PLAIN, 8), new Object[]{false, "sss", "scs", "sss", Character.valueOf('s'), "warpDecorative", Character.valueOf('c'), "dyeWhite"}), "_dye");
        WarpDrive.register(new ShapedOreRecipe(groupDecorations, BlockDecorative.getItemStackNoCache(EnumDecorativeType.GRATED, 8), new Object[]{false, "sss", "sbs", "sss", Character.valueOf('s'), "warpDecorative", Character.valueOf('b'), barsIron}), "_dye");
        WarpDrive.register(new ShapedOreRecipe(groupDecorations, BlockDecorative.getItemStackNoCache(EnumDecorativeType.GLASS, 8), new Object[]{false, "sss", "scs", "sss", Character.valueOf('s'), "warpDecorative", Character.valueOf('c'), "glass"}), "_dye");
        WarpDrive.register(new ShapedOreRecipe(groupDecorations, BlockDecorative.getItemStackNoCache(EnumDecorativeType.STRIPES_BLACK_DOWN, 7), new Object[]{false, "bss", "sss", "ssy", Character.valueOf('s'), "warpDecorative", Character.valueOf('b'), "dyeBlack", Character.valueOf('y'), "dyeYellow"}), "_dye");
        WarpDrive.register(new ShapedOreRecipe(groupDecorations, BlockDecorative.getItemStackNoCache(EnumDecorativeType.STRIPES_BLACK_UP, 7), new Object[]{false, "ssy", "sss", "bss", Character.valueOf('s'), "warpDecorative", Character.valueOf('b'), "dyeBlack", Character.valueOf('y'), "dyeYellow"}), "_dye");
        WarpDrive.register(new ShapedOreRecipe(groupDecorations, BlockDecorative.getItemStackNoCache(EnumDecorativeType.STRIPES_YELLOW_DOWN, 7), new Object[]{false, "yss", "sss", "ssb", Character.valueOf('s'), "warpDecorative", Character.valueOf('b'), "dyeBlack", Character.valueOf('y'), "dyeYellow"}), "_dye");
        WarpDrive.register(new ShapedOreRecipe(groupDecorations, BlockDecorative.getItemStackNoCache(EnumDecorativeType.STRIPES_YELLOW_UP, 7), new Object[]{false, "ssb", "sss", "yss", Character.valueOf('s'), "warpDecorative", Character.valueOf('b'), "dyeBlack", Character.valueOf('y'), "dyeYellow"}), "_dye");
        WarpDrive.register(new ShapelessOreRecipe(groupDecorations, BlockDecorative.getItemStackNoCache(EnumDecorativeType.STRIPES_BLACK_DOWN, 1), new Object[]{BlockDecorative.getItemStackNoCache(EnumDecorativeType.STRIPES_BLACK_UP, 1)}), "_toggle");
        WarpDrive.register(new ShapelessOreRecipe(groupDecorations, BlockDecorative.getItemStackNoCache(EnumDecorativeType.STRIPES_BLACK_UP, 1), new Object[]{BlockDecorative.getItemStackNoCache(EnumDecorativeType.STRIPES_YELLOW_DOWN, 1)}), "_toggle");
        WarpDrive.register(new ShapelessOreRecipe(groupDecorations, BlockDecorative.getItemStackNoCache(EnumDecorativeType.STRIPES_YELLOW_DOWN, 1), new Object[]{BlockDecorative.getItemStackNoCache(EnumDecorativeType.STRIPES_YELLOW_UP, 1)}), "_toggle");
        WarpDrive.register(new ShapelessOreRecipe(groupDecorations, BlockDecorative.getItemStackNoCache(EnumDecorativeType.STRIPES_YELLOW_UP, 1), new Object[]{BlockDecorative.getItemStackNoCache(EnumDecorativeType.STRIPES_BLACK_DOWN, 1)}), "_toggle");
        WarpDrive.register(new ShapedOreRecipe(groupDecorations, WarpDrive.blockLamp_bubble, new Object[]{false, " g ", "glg", "h  ", Character.valueOf('g'), "blockGlass", Character.valueOf('l'), Blocks.field_150379_bu, Character.valueOf('h'), "blockHull1_plain"}));
        WarpDrive.register(new ShapedOreRecipe(groupDecorations, WarpDrive.blockLamp_flat, new Object[]{false, " g ", "glg", " h ", Character.valueOf('g'), "blockGlass", Character.valueOf('l'), Blocks.field_150379_bu, Character.valueOf('h'), "blockHull1_plain"}));
        WarpDrive.register(new ShapedOreRecipe(groupDecorations, WarpDrive.blockLamp_long, new Object[]{false, " g ", "glg", "  h", Character.valueOf('g'), "blockGlass", Character.valueOf('l'), Blocks.field_150379_bu, Character.valueOf('h'), "blockHull1_plain"}));
    }

    private static void initDetection() {
        if (!WarpDriveConfig.ACCELERATOR_ENABLE) {
            WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockBiometricScanner, new Object[]{false, "rDr", "EmE", "rCr", Character.valueOf('r'), rubber, Character.valueOf('m'), itemStackMachineCasings[1], Character.valueOf('E'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL), Character.valueOf('D'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_CRYSTAL), Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE)}));
        } else {
            WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockBiometricScanner, new Object[]{false, "rDr", "EmE", "rCr", Character.valueOf('r'), rubber, Character.valueOf('m'), "blockElectromagnet1", Character.valueOf('E'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL), Character.valueOf('D'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_CRYSTAL), Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE)}));
        }
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockCamera), new Object[]{false, "gtd", "zlm", "gt ", Character.valueOf('t'), itemStackMotors[0], Character.valueOf('z'), ItemComponent.getItemStack(EnumComponentType.ZOOM), Character.valueOf('d'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_CRYSTAL), Character.valueOf('m'), itemStackMachineCasings[0], Character.valueOf('l'), Blocks.field_150453_bW, Character.valueOf('g'), "paneGlassColorless"}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockCloakingCore), new Object[]{false, "ici", "csc", "ipi", Character.valueOf('i'), WarpDrive.blockIridium, Character.valueOf('c'), WarpDrive.blockCloakingCoil, Character.valueOf('s'), WarpDrive.blockShipControllers[EnumTier.SUPERIOR.getIndex()], Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.SUPERCONDUCTOR)}));
        Object oreGoldIngotOrCoil = WarpDriveConfig.getOreOrItemStack("gregtech:wire_coil", 3, "ic2:crafting", 5, "thermalfoundation:material", 515, "immersiveengineering:connector", 8, "enderio:item_power_conduit", 2, "minecraft:gold_ingot", 0);
        Object oreGoldIngotOrTitaniumPlate = WarpDriveConfig.getOreOrItemStack("ore:plateTitanium", 0, "advanced_solar_panels:crafting", 0, "ore:plateDenseSteel", 0, "thermalfoundation:glass", 6, "immersiveengineering:metal_device1", 3, "enderio:item_alloy_ingot", 2, "minecraft:gold_ingot", 0);
        Object oreEmeraldOrIridiumPlate = WarpDriveConfig.getOreOrItemStack("ore:plateIridium", 0, "ore:plateAlloyIridium", 0, "enderio:item_material", 42, "ore:ingotLumium", 0, "ore:gemEmerald", 0);
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockCloakingCoil), new Object[]{false, "iti", "cmc", "iti", Character.valueOf('t'), oreGoldIngotOrTitaniumPlate, Character.valueOf('i'), oreEmeraldOrIridiumPlate, Character.valueOf('c'), oreGoldIngotOrCoil, Character.valueOf('m'), itemStackMachineCasings[3]}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockEnvironmentalSensor, new Object[]{"   ", "dcd", "rCr", Character.valueOf('r'), rubber, Character.valueOf('c'), Items.field_151113_aN, Character.valueOf('d'), Blocks.field_150453_bW, Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE)}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockMonitor), new Object[]{false, "fd ", "fm ", "f  ", Character.valueOf('f'), ItemComponent.getItemStack(EnumComponentType.FLAT_SCREEN), Character.valueOf('d'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_CRYSTAL), Character.valueOf('m'), itemStackMachineCasings[0]}));
        Object oreRadarDish = WarpDriveConfig.getOreOrItemStack("ore:plateTitanium", 0, "ore:plateEnderium", 0, "ore:ingotVibrantAlloy", 0, "ore:plateAlloyIridium", 0, "ore:gemQuartz", 0);
        Object oreRadarSensor = WarpDriveConfig.getOreOrItemStack("ore:stickQuartzite", 0, "ore:ingotSignalum", 0, "ore:nuggetPulsatingIron", 0, "minecraft:ghast_tear", 0);
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockRadar), new Object[]{false, "PAP", "PtP", "pmc", Character.valueOf('t'), itemStackMotors[2], Character.valueOf('P'), oreRadarDish, Character.valueOf('A'), oreRadarSensor, Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE), Character.valueOf('m'), itemStackMachineCasings[2], Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.SUPERCONDUCTOR)}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockSirenIndustrial[EnumTier.BASIC.getIndex()], new Object[]{"pip", "pNp", "pip", Character.valueOf('p'), "plankWood", Character.valueOf('i'), "ingotIron", Character.valueOf('N'), new ItemStack(Blocks.field_150323_B, 1)}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockSirenIndustrial[EnumTier.ADVANCED.getIndex()], new Object[]{" I ", "ISI", " I ", Character.valueOf('I'), "ingotGold", Character.valueOf('S'), WarpDrive.blockSirenIndustrial[EnumTier.BASIC.getIndex()]}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockSirenIndustrial[EnumTier.SUPERIOR.getIndex()], new Object[]{" I ", "ISI", " I ", Character.valueOf('I'), "gemDiamond", Character.valueOf('S'), WarpDrive.blockSirenIndustrial[EnumTier.ADVANCED.getIndex()]}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockSirenMilitary[EnumTier.BASIC.getIndex()], new Object[]{"ppp", "iNi", "ppp", Character.valueOf('p'), "plankWood", Character.valueOf('i'), "ingotIron", Character.valueOf('N'), new ItemStack(Blocks.field_150323_B, 1)}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockSirenMilitary[EnumTier.ADVANCED.getIndex()], new Object[]{" I ", "ISI", " I ", Character.valueOf('I'), "ingotGold", Character.valueOf('S'), WarpDrive.blockSirenMilitary[EnumTier.BASIC.getIndex()]}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockSirenMilitary[EnumTier.SUPERIOR.getIndex()], new Object[]{" I ", "ISI", " I ", Character.valueOf('I'), "gemDiamond", Character.valueOf('S'), WarpDrive.blockSirenMilitary[EnumTier.ADVANCED.getIndex()]}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockSpeaker[EnumTier.BASIC.getIndex()], new Object[]{"BBB", "rDr", "rCr", Character.valueOf('B'), ItemComponent.getItemStack(EnumComponentType.BIOFIBER), Character.valueOf('r'), rubber, Character.valueOf('D'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_CRYSTAL), Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE)}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockSpeaker[EnumTier.ADVANCED.getIndex()], new Object[]{" I ", "ISI", " I ", Character.valueOf('I'), "ingotGold", Character.valueOf('S'), WarpDrive.blockSpeaker[EnumTier.BASIC.getIndex()]}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockSpeaker[EnumTier.SUPERIOR.getIndex()], new Object[]{" I ", "ISI", " I ", Character.valueOf('I'), "gemDiamond", Character.valueOf('S'), WarpDrive.blockSpeaker[EnumTier.ADVANCED.getIndex()]}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockVirtualAssistant[EnumTier.BASIC.getIndex()], new Object[]{"BEB", "rmr", "rCr", Character.valueOf('B'), ItemComponent.getItemStack(EnumComponentType.BIOFIBER), Character.valueOf('m'), itemStackMachineCasings[1], Character.valueOf('r'), rubber, Character.valueOf('E'), ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL), Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE)}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockVirtualAssistant[EnumTier.ADVANCED.getIndex()], new Object[]{"DCD", "CSC", "DCD", Character.valueOf('D'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_CRYSTAL), Character.valueOf('S'), WarpDrive.blockVirtualAssistant[EnumTier.BASIC.getIndex()]}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockVirtualAssistant[EnumTier.SUPERIOR.getIndex()], new Object[]{"EYE", "YSY", "EYE", Character.valueOf('E'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL), Character.valueOf('Y'), Items.field_151061_bv, Character.valueOf('S'), WarpDrive.blockVirtualAssistant[EnumTier.ADVANCED.getIndex()]}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockWarpIsolation), new Object[]{false, "i i", " m ", "i i", Character.valueOf('i'), oreRadarDish, Character.valueOf('m'), itemStackMachineCasings[3]}));
    }

    private static void initEnergy() {
        if (WarpDriveConfig.isIndustrialCraft2Loaded) {
            Object overclockedHeatVent = WarpDriveConfig.getOreOrItemStack("ic2:overclocked_heat_vent", 0, "ic2:itemheatvent", 2);
            Object reactorCoolant = WarpDriveConfig.getOreOrItemStack("ic2:hex_heat_storage", 0, "ic2:itemheatstorage", 2);
            WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.itemIC2reactorLaserFocus), new Object[]{false, "cld", "lhl", "dlc", Character.valueOf('l'), ItemComponent.getItemStack(EnumComponentType.LENS), Character.valueOf('h'), overclockedHeatVent, Character.valueOf('c'), reactorCoolant, Character.valueOf('d'), reactorCoolant}));
            WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockIC2reactorLaserCooler), new Object[]{false, "gCp", "lme", "gC ", Character.valueOf('l'), ItemComponent.getItemStack(EnumComponentType.LENS), Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL), Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('g'), "paneGlassColorless", Character.valueOf('m'), itemStackMachineCasings[1]}));
        }
        if (!WarpDriveConfig.ACCELERATOR_ENABLE) {
            WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockEnanReactorCores[EnumTier.BASIC.getIndex()], new Object[]{false, "CpC", "lml", "CcC", Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.REACTOR_CORE), Character.valueOf('l'), ItemComponent.getItemStack(EnumComponentType.LENS), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE), Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL)}));
        } else {
            WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockEnanReactorCores[EnumTier.BASIC.getIndex()], new Object[]{false, " p ", "lCl", "cpm", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.REACTOR_CORE), Character.valueOf('l'), ItemComponent.getItemStack(EnumComponentType.LENS), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE), Character.valueOf('m'), itemStackMachineCasings[2]}));
        }
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockEnanReactorCores[EnumTier.ADVANCED.getIndex()], new Object[]{false, "lcl", "CRC", "lcl", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.REACTOR_CORE), Character.valueOf('R'), WarpDrive.blockEnanReactorCores[EnumTier.BASIC.getIndex()], Character.valueOf('l'), ItemComponent.getItemStack(EnumComponentType.LENS), Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockEnanReactorCores[EnumTier.SUPERIOR.getIndex()], new Object[]{false, "lSl", "CRC", "lSl", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.REACTOR_CORE), Character.valueOf('R'), WarpDrive.blockEnanReactorCores[EnumTier.ADVANCED.getIndex()], Character.valueOf('l'), ItemComponent.getItemStack(EnumComponentType.LENS), Character.valueOf('S'), ItemComponent.getItemStack(EnumComponentType.SUPERCONDUCTOR)}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockEnanReactorLaser), new Object[]{false, "g h", "ldm", "g c", Character.valueOf('d'), ItemComponent.getItemStack(EnumComponentType.DIFFRACTION_GRATING), Character.valueOf('l'), ItemComponent.getItemStack(EnumComponentType.LENS), Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE), Character.valueOf('m'), itemStackMachineCasings[1], Character.valueOf('g'), "paneGlassColorless", Character.valueOf('h'), "blockHull2_plain"}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockCapacitor[EnumTier.BASIC.getIndex()], new Object[]{false, "iPi", "pcp", "ipi", Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL), Character.valueOf('i'), barsIron, Character.valueOf('p'), "itemBiofiber", Character.valueOf('P'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE)}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockCapacitor[EnumTier.ADVANCED.getIndex()], new Object[]{false, "rir", "cpc", "rir", Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL), Character.valueOf('i'), "ingotIron", Character.valueOf('r'), "itemRubber", Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE)}), "_direct");
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockCapacitor[EnumTier.ADVANCED.getIndex()], new Object[]{false, "r r", "cpc", "r r", Character.valueOf('c'), new ItemStack(WarpDrive.blockCapacitor[EnumTier.BASIC.getIndex()]), Character.valueOf('r'), "itemRubber", Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE)}), "_upgrade");
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockCapacitor[EnumTier.SUPERIOR.getIndex()], new Object[]{false, "psp", "ici", "pgp", Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CLUSTER), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.CARBON_FIBER), Character.valueOf('i'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('g'), "ingotGold", Character.valueOf('s'), ItemComponent.getItemStack(EnumComponentType.SUPERCONDUCTOR)}), "_direct");
        WarpDrive.register(new ShapedOreRecipe(groupMachines, WarpDrive.blockCapacitor[EnumTier.SUPERIOR.getIndex()], new Object[]{false, "p p", "csc", "p p", Character.valueOf('c'), new ItemStack(WarpDrive.blockCapacitor[EnumTier.ADVANCED.getIndex()]), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.CARBON_FIBER), Character.valueOf('s'), ItemComponent.getItemStack(EnumComponentType.SUPERCONDUCTOR)}), "_upgrade");
    }

    private static void initForceField() {
        int index;
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldShape.getItemStack(EnumForceFieldShape.SPHERE), new Object[]{false, "   ", "CmC", "CCC", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldShape.getItemStack(EnumForceFieldShape.CYLINDER_H), new Object[]{false, "C C", " m ", "C C", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldShape.getItemStack(EnumForceFieldShape.CYLINDER_V), new Object[]{false, " C ", "CmC", " C ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldShape.getItemStack(EnumForceFieldShape.CUBE), new Object[]{false, "CCC", "CmC", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldShape.getItemStack(EnumForceFieldShape.PLANE), new Object[]{false, "CCC", " m ", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldShape.getItemStack(EnumForceFieldShape.TUBE), new Object[]{false, "   ", "CmC", "C C", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldShape.getItemStack(EnumForceFieldShape.TUNNEL), new Object[]{false, "C C", "CmC", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.ATTRACTION), new Object[]{false, "CCC", "rir", " m ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('r'), "blockRedstone", Character.valueOf('i'), Blocks.field_150339_S, Character.valueOf('m'), itemStackMotors[1]}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStackNoCache(EnumForceFieldUpgrade.BREAKING, 2), new Object[]{false, "CCC", "sap", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('s'), Items.field_151056_x, Character.valueOf('a'), Items.field_151047_v, Character.valueOf('p'), Items.field_151046_w}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.CAMOUFLAGE), new Object[]{false, "CCC", "zre", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('z'), ItemComponent.getItemStack(EnumComponentType.ZOOM), Character.valueOf('r'), Blocks.field_150453_bW, Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.COOLING), new Object[]{false, "CCC", "imi", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('i'), Blocks.field_150432_aD, Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.PUMP)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.FUSION), new Object[]{false, "CCC", "cec", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE), Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.HEATING), new Object[]{false, "CCC", "bmb", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('b'), Items.field_151072_bj, Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.PUMP)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.INVERSION), new Object[]{false, "rgr", "CCC", "CCC", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('g'), Items.field_151074_bl}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.ITEM_PORT), new Object[]{false, "CCC", "cmc", " c ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('c'), "chestWood", Character.valueOf('m'), itemStackMotors[1]}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.SILENCER), new Object[]{false, "CCC", "www", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('w'), Blocks.field_150325_L}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.PUMPING), new Object[]{false, "CCC", "tmt", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.PUMP), Character.valueOf('t'), ItemComponent.getItemStack(EnumComponentType.GLASS_TANK)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.RANGE), new Object[]{false, "CCC", "RMR", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('M'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL), Character.valueOf('R'), "blockRedstone"}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.REPULSION), new Object[]{false, " m ", "rir", "CCC", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('r'), "blockRedstone", Character.valueOf('i'), Blocks.field_150339_S, Character.valueOf('m'), itemStackMotors[1]}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStackNoCache(EnumForceFieldUpgrade.ROTATION, 2), new Object[]{false, "CCC", " m ", " mc", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('m'), itemStackMotors[1], Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.SHOCK), new Object[]{false, "CCC", " p ", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.SPEED), new Object[]{false, "CCC", "geg", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('g'), Items.field_151073_bk, Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.STABILIZATION), new Object[]{"CCC", "lMl", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('M'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL), Character.valueOf('l'), "blockLapis"}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStack(EnumForceFieldUpgrade.THICKNESS), new Object[]{false, "CCC", "CpC", "   ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.ELECTROMAGNETIC_PROJECTOR)}));
        WarpDrive.register(new ShapedOreRecipe(groupComponents, ItemForceFieldUpgrade.getItemStackNoCache(EnumForceFieldUpgrade.TRANSLATION, 2), new Object[]{false, "CCC", "m m", " c ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('m'), itemStackMotors[1], Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE)}));
        for (EnumTier enumTier : EnumTier.nonCreative()) {
            index = enumTier.getIndex();
            WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockForceFieldProjectors[index], 1, 0), new Object[]{false, " e ", "pm ", " r ", Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.ELECTROMAGNETIC_PROJECTOR), Character.valueOf('m'), itemStackMachineCasings[index], Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL), Character.valueOf('r'), Items.field_151137_ax}), "_left");
            WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockForceFieldProjectors[index], 1, 0), new Object[]{false, " e ", " mp", " r ", Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.ELECTROMAGNETIC_PROJECTOR), Character.valueOf('m'), itemStackMachineCasings[index], Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL), Character.valueOf('r'), Items.field_151137_ax}), "_right");
            WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockForceFieldProjectors[index], 1, 1), new Object[]{false, " e ", "pmp", " r ", Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.ELECTROMAGNETIC_PROJECTOR), Character.valueOf('m'), itemStackMachineCasings[index], Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL), Character.valueOf('r'), Items.field_151137_ax}));
        }
        for (EnumTier enumTier : EnumTier.nonCreative()) {
            index = enumTier.getIndex();
            WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockForceFieldRelays[index]), new Object[]{false, " e ", "CmC", " r ", Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_COIL), Character.valueOf('m'), itemStackMachineCasings[index], Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL), Character.valueOf('r'), Items.field_151137_ax}));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void initHull() {
        void var2_4;
        EnumDyeColor[] enumDyeColorArray = EnumDyeColor.values();
        int n = enumDyeColorArray.length;
        boolean bl = false;
        while (var2_4 < n) {
            EnumDyeColor enumDyeColor = enumDyeColorArray[var2_4];
            int metadataColor = enumDyeColor.func_176765_a();
            if (WarpDriveConfig.isIndustrialCraft2Loaded) {
                ItemStack itemStack = (ItemStack)WarpDriveConfig.getOreOrItemStack("ic2:resource", 11, "ic2:blockutility", 2);
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_plain[EnumTier.BASIC.getIndex()][0], 10, metadataColor), new Object[]{false, "cbc", "bXb", "cbc", Character.valueOf('b'), itemStack, Character.valueOf('c'), Blocks.field_150343_Z, Character.valueOf('X'), oreDyes.get(enumDyeColor)}), "_ic2");
            }
            WarpDrive.register(new ShapedOreRecipe(groupTaintedHulls, new ItemStack(WarpDrive.blockHulls_plain[EnumTier.BASIC.getIndex()][0], 4, metadataColor), new Object[]{false, " b ", "bcb", " C ", Character.valueOf('c'), new ItemStack(Blocks.field_192443_dR, 1, metadataColor), Character.valueOf('b'), barsIron, Character.valueOf('C'), "itemCeramic"}), "_ceramic");
            Object object = WarpDriveConfig.getOreOrItemStack("ore:ingotSteel", 0, "ore:ingotRefinedIron", 0, "ore:ingotIron", 0);
            WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_plain[EnumTier.BASIC.getIndex()][0], 10, metadataColor), new Object[]{false, "cbc", "bXb", "cbc", Character.valueOf('b'), object, Character.valueOf('c'), "stone", Character.valueOf('X'), oreDyes.get(enumDyeColor)}), "_steel");
            if (OreDictionary.doesOreNameExist((String)"ingotBronze") && !OreDictionary.getOres((String)"ingotBronze").isEmpty()) {
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_plain[EnumTier.BASIC.getIndex()][0], 5, metadataColor), new Object[]{false, "cbc", "bXb", "cbc", Character.valueOf('b'), "ingotBronze", Character.valueOf('c'), "stone", Character.valueOf('X'), oreDyes.get(enumDyeColor)}), "_bronze");
            }
            if (OreDictionary.doesOreNameExist((String)"ingotAluminium") && !OreDictionary.getOres((String)"ingotAluminium").isEmpty()) {
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_plain[EnumTier.BASIC.getIndex()][0], 3, metadataColor), new Object[]{false, "cbc", "bXb", "cbc", Character.valueOf('b'), "ingotAluminium", Character.valueOf('c'), "stone", Character.valueOf('X'), oreDyes.get(enumDyeColor)}), "_aluminium");
            } else if (OreDictionary.doesOreNameExist((String)"ingotAluminum") && !OreDictionary.getOres((String)"ingotAluminum").isEmpty()) {
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_plain[EnumTier.BASIC.getIndex()][0], 3, metadataColor), new Object[]{false, "cbc", "bXb", "cbc", Character.valueOf('b'), "ingotAluminum", Character.valueOf('c'), "stone", Character.valueOf('X'), oreDyes.get(enumDyeColor)}), "_aluminum");
            }
            ++var2_4;
        }
        Object oreObsidianTungstenSteelPlate = WarpDriveConfig.getOreOrItemStack("ore:plateTungstenSteel", 0, "ic2:crafting", 15, "ic2:itemmisc", 256, "thermalfoundation:glass", 3, "ore:ingotDarkSteel", 0, "minecraft:obsidian", 0);
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            int n2 = enumDyeColor.func_176765_a();
            WarpDrive.register(new ShapedOreRecipe(groupTaintedHulls, new ItemStack(WarpDrive.blockHulls_plain[EnumTier.ADVANCED.getIndex()][0], 4, n2), new Object[]{false, "cbc", "b b", "cbc", Character.valueOf('b'), new ItemStack(WarpDrive.blockHulls_plain[EnumTier.BASIC.getIndex()][0], 1, n2), Character.valueOf('c'), oreObsidianTungstenSteelPlate}));
            WarpDrive.register(new ShapedOreRecipe(groupTaintedHulls, new ItemStack(WarpDrive.blockHulls_plain[EnumTier.ADVANCED.getIndex()][0], 4, n2), new Object[]{false, "cbc", "bXb", "cbc", Character.valueOf('b'), "blockHull1_plain", Character.valueOf('c'), oreObsidianTungstenSteelPlate, Character.valueOf('X'), oreDyes.get(enumDyeColor)}), "_dye");
        }
        Object oreDiamondOrNaquadahPlate = WarpDriveConfig.getOreOrItemStack("ore:plateNaquadah", 0, "ore:plateAlloyIridium", 0, "ore:itemPulsatingCrystal", 0, "ore:gemDiamond", 0);
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            int metadataColor = enumDyeColor.func_176765_a();
            WarpDrive.register(new ShapedOreRecipe(groupTaintedHulls, new ItemStack(WarpDrive.blockHulls_plain[EnumTier.SUPERIOR.getIndex()][0], 4, metadataColor), new Object[]{false, " b ", "bcb", " b ", Character.valueOf('b'), new ItemStack(WarpDrive.blockHulls_plain[EnumTier.ADVANCED.getIndex()][0], 1, metadataColor), Character.valueOf('c'), oreDiamondOrNaquadahPlate}));
            WarpDrive.register(new ShapedOreRecipe(groupTaintedHulls, new ItemStack(WarpDrive.blockHulls_plain[EnumTier.SUPERIOR.getIndex()][0], 4, metadataColor), new Object[]{false, "Xb ", "bcb", " b ", Character.valueOf('b'), "blockHull2_plain", Character.valueOf('c'), oreDiamondOrNaquadahPlate, Character.valueOf('X'), oreDyes.get(enumDyeColor)}), "_dye");
        }
        for (EnumTier enumTier : EnumTier.nonCreative()) {
            int index = enumTier.getIndex();
            for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
                int metadataColor = enumDyeColor.func_176765_a();
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_glass[index], 4, metadataColor), new Object[]{false, "gpg", "pFp", "gpg", Character.valueOf('g'), "blockGlass", Character.valueOf('p'), new ItemStack(WarpDrive.blockHulls_plain[index][0], 1, metadataColor), Character.valueOf('F'), "dustGlowstone"}));
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_stairs[index][metadataColor], 4), new Object[]{false, "p  ", "pp ", "ppp", Character.valueOf('p'), new ItemStack(WarpDrive.blockHulls_plain[index][0], 1, metadataColor)}));
                WarpDrive.register(new ShapelessOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_plain[index][0], 6, metadataColor), new Object[]{WarpDrive.blockHulls_stairs[index][metadataColor], WarpDrive.blockHulls_stairs[index][metadataColor], WarpDrive.blockHulls_stairs[index][metadataColor], WarpDrive.blockHulls_stairs[index][metadataColor]}));
                GameRegistry.addSmelting((ItemStack)new ItemStack(WarpDrive.blockHulls_plain[index][0], 1, metadataColor), (ItemStack)new ItemStack(WarpDrive.blockHulls_plain[index][1], 1, metadataColor), (float)0.0f);
                WarpDrive.register(new ShapelessOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_plain[index][0], 1, metadataColor), new Object[]{new ItemStack(WarpDrive.blockHulls_plain[index][1], 1, metadataColor)}));
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_omnipanel[index], 16, metadataColor), new Object[]{false, "ggg", "ggg", Character.valueOf('g'), new ItemStack(WarpDrive.blockHulls_glass[index], 1, metadataColor)}));
                WarpDrive.register(new ShapelessOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_glass[index], 3, metadataColor), new Object[]{new ItemStack(WarpDrive.blockHulls_omnipanel[index], 1, metadataColor), new ItemStack(WarpDrive.blockHulls_omnipanel[index], 1, metadataColor), new ItemStack(WarpDrive.blockHulls_omnipanel[index], 1, metadataColor), new ItemStack(WarpDrive.blockHulls_omnipanel[index], 1, metadataColor), new ItemStack(WarpDrive.blockHulls_omnipanel[index], 1, metadataColor), new ItemStack(WarpDrive.blockHulls_omnipanel[index], 1, metadataColor), new ItemStack(WarpDrive.blockHulls_omnipanel[index], 1, metadataColor), new ItemStack(WarpDrive.blockHulls_omnipanel[index], 1, metadataColor)}));
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 6, 0), new Object[]{false, "bbb", Character.valueOf('b'), new ItemStack(WarpDrive.blockHulls_plain[index][0], 1, metadataColor)}));
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 6, 2), new Object[]{false, "b", "b", "b", Character.valueOf('b'), new ItemStack(WarpDrive.blockHulls_plain[index][0], 1, metadataColor)}));
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 6, 6), new Object[]{false, "bbb", Character.valueOf('b'), new ItemStack(WarpDrive.blockHulls_plain[index][1], 1, metadataColor)}));
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 6, 8), new Object[]{false, "b", "b", "b", Character.valueOf('b'), new ItemStack(WarpDrive.blockHulls_plain[index][1], 1, metadataColor)}));
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_plain[index][0], 1, metadataColor), new Object[]{false, "s", "s", Character.valueOf('s'), new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 1, 0)}), "_uncrafting");
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_plain[index][0], 1, metadataColor), new Object[]{false, "ss", Character.valueOf('s'), new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 1, 2)}), "_uncrafting_A");
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_plain[index][1], 1, metadataColor), new Object[]{false, "s", "s", Character.valueOf('s'), new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 1, 6)}), "_uncrafting_B");
                WarpDrive.register(new ShapedOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_plain[index][1], 1, metadataColor), new Object[]{false, "ss", Character.valueOf('s'), new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 1, 8)}), "_uncrafting_C");
                WarpDrive.register(new ShapelessOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 2, 0), new Object[]{new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 1, 12)}), "_uncrafting");
                WarpDrive.register(new ShapelessOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 2, 6), new Object[]{new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 1, 13)}), "_uncrafting_A");
                WarpDrive.register(new ShapelessOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 2, 8), new Object[]{new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 1, 14)}), "_uncrafting_B");
                WarpDrive.register(new ShapelessOreRecipe(groupHulls, new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 2, 8), new Object[]{new ItemStack(WarpDrive.blockHulls_slab[index][metadataColor], 1, 15)}), "_uncrafting_C");
                WarpDrive.register(new ShapelessOreRecipe(groupTaintedHulls, new ItemStack(WarpDrive.blockHulls_plain[index][0], 1, metadataColor), new Object[]{oreDyes.get(enumDyeColor), "blockHull" + index + "_plain"}), "_dye");
                WarpDrive.register(new ShapelessOreRecipe(groupTaintedHulls, new ItemStack(WarpDrive.blockHulls_glass[index], 1, metadataColor), new Object[]{oreDyes.get(enumDyeColor), "blockHull" + index + "_glass"}), "_dye");
                WarpDrive.register(new ShapelessOreRecipe(groupTaintedHulls, new ItemStack(WarpDrive.blockHulls_stairs[index][metadataColor], 1), new Object[]{oreDyes.get(enumDyeColor), "blockHull" + index + "_stairs"}), "_dye");
                WarpDrive.register(new ShapedOreRecipe(groupTaintedHulls, new ItemStack(WarpDrive.blockHulls_plain[index][0], 8, metadataColor), new Object[]{false, "###", "#X#", "###", Character.valueOf('#'), "blockHull" + index + "_plain", Character.valueOf('X'), oreDyes.get(enumDyeColor)}), "_dye");
                WarpDrive.register(new ShapedOreRecipe(groupTaintedHulls, new ItemStack(WarpDrive.blockHulls_glass[index], 8, metadataColor), new Object[]{false, "###", "#X#", "###", Character.valueOf('#'), "blockHull" + index + "_glass", Character.valueOf('X'), oreDyes.get(enumDyeColor)}), "_dye");
                WarpDrive.register(new ShapedOreRecipe(groupTaintedHulls, new ItemStack(WarpDrive.blockHulls_stairs[index][metadataColor], 8), new Object[]{false, "###", "#X#", "###", Character.valueOf('#'), "blockHull" + index + "_stairs", Character.valueOf('X'), oreDyes.get(enumDyeColor)}), "_dye");
            }
        }
    }

    private static void initMovement() {
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockShipCores[EnumTier.BASIC.getIndex()]), new Object[]{"ce ", "pmc", "cCM", Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_CRYSTAL), Character.valueOf('c'), Items.field_151137_ax, Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('M'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL), Character.valueOf('m'), itemStackMachineCasings[0], Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE)}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockShipCores[EnumTier.ADVANCED.getIndex()]), new Object[]{"ce ", "pmc", "cCM", Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL), Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('M'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL), Character.valueOf('m'), itemStackMachineCasings[1], Character.valueOf('C'), new ItemStack(WarpDrive.blockShipCores[EnumTier.BASIC.getIndex()])}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockShipCores[EnumTier.SUPERIOR.getIndex()]), new Object[]{"ce ", "pmc", "cCM", Character.valueOf('e'), Items.field_151156_bN, Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CLUSTER), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.SUPERCONDUCTOR), Character.valueOf('M'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CLUSTER), Character.valueOf('m'), itemStackMachineCasings[2], Character.valueOf('C'), new ItemStack(WarpDrive.blockShipCores[EnumTier.ADVANCED.getIndex()])}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockShipControllers[EnumTier.BASIC.getIndex()]), new Object[]{false, "ce ", "pmc", "cCM", Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_CRYSTAL), Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL), Character.valueOf('p'), Items.field_151079_bi, Character.valueOf('M'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL), Character.valueOf('m'), itemStackMachineCasings[0], Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE)}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockShipControllers[EnumTier.ADVANCED.getIndex()]), new Object[]{false, "ce ", "pmc", "cCM", Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL), Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL), Character.valueOf('p'), Items.field_151079_bi, Character.valueOf('M'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CLUSTER), Character.valueOf('m'), itemStackMachineCasings[1], Character.valueOf('C'), new ItemStack(WarpDrive.blockShipControllers[EnumTier.BASIC.getIndex()])}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockShipControllers[EnumTier.SUPERIOR.getIndex()]), new Object[]{false, "ce ", "pmc", "cCM", Character.valueOf('e'), Items.field_151156_bN, Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL), Character.valueOf('p'), Items.field_151079_bi, Character.valueOf('M'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CLUSTER), Character.valueOf('m'), itemStackMachineCasings[2], Character.valueOf('C'), new ItemStack(WarpDrive.blockShipControllers[EnumTier.ADVANCED.getIndex()])}));
        Object enderPearlOrMagnetizer = WarpDriveConfig.getOreOrItemStack("gregtech:machine", 420, "ic2:te", 37, "ic2:blockmachinelv", 10, "ore:ingotPulsatingIron", 0, "minecraft:ender_pearl", 0);
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockLift), new Object[]{false, "wlw", "per", "glg", Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('w'), Blocks.field_150325_L, Character.valueOf('l'), ItemComponent.getItemStack(EnumComponentType.LENS), Character.valueOf('e'), enderPearlOrMagnetizer, Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE), Character.valueOf('g'), "paneGlassColorless"}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockTransporterBeacon), new Object[]{false, " e ", " m ", "sds", Character.valueOf('e'), Items.field_151079_bi, Character.valueOf('d'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_CRYSTAL), Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL), Character.valueOf('s'), Items.field_151055_y}));
        if (!WarpDriveConfig.ACCELERATOR_ENABLE) {
            WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockTransporterContainment, 2), new Object[]{false, " e ", " m ", " e ", Character.valueOf('m'), itemStackMachineCasings[2], Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL)}));
        } else {
            WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockTransporterContainment, 2), new Object[]{false, " e ", " m ", " e ", Character.valueOf('m'), "blockElectromagnet2", Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL)}));
        }
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockTransporterCore), new Object[]{false, " E ", "pmd", " c ", Character.valueOf('m'), itemStackMachineCasings[2], Character.valueOf('c'), ItemComponent.getItemStack(EnumComponentType.COMPUTER_INTERFACE), Character.valueOf('d'), ItemComponent.getItemStack(EnumComponentType.DIAMOND_CRYSTAL), Character.valueOf('E'), ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL), Character.valueOf('p'), ItemComponent.getItemStack(EnumComponentType.POWER_INTERFACE)}));
        if (!WarpDriveConfig.ACCELERATOR_ENABLE) {
            WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockTransporterScanner), new Object[]{false, " E ", "eme", "CCC", Character.valueOf('m'), itemStackMachineCasings[2], Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL), Character.valueOf('E'), ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL), Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL)}));
        } else {
            WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockTransporterScanner), new Object[]{false, " E ", "eme", "CCC", Character.valueOf('m'), "blockElectromagnet2", Character.valueOf('e'), ItemComponent.getItemStack(EnumComponentType.ENDER_COIL), Character.valueOf('E'), ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL), Character.valueOf('C'), ItemComponent.getItemStack(EnumComponentType.CAPACITIVE_CRYSTAL)}));
        }
    }

    private static void initWeapon() {
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockLaser), new Object[]{false, "gtr", "ldm", "gt ", Character.valueOf('t'), itemStackMotors[2], Character.valueOf('d'), ItemComponent.getItemStack(EnumComponentType.DIFFRACTION_GRATING), Character.valueOf('l'), ItemComponent.getItemStack(EnumComponentType.LENS), Character.valueOf('m'), itemStackMachineCasings[1], Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('g'), "paneGlassColorless"}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockLaserCamera), new Object[]{false, "rlr", "rsr", "rcr", Character.valueOf('r'), rubber, Character.valueOf('s'), goldNuggetOrBasicCircuit, Character.valueOf('l'), WarpDrive.blockLaser, Character.valueOf('c'), WarpDrive.blockCamera}));
        WarpDrive.register(new ShapedOreRecipe(groupMachines, new ItemStack(WarpDrive.blockWeaponController), new Object[]{false, "rwr", "msm", "rcr", Character.valueOf('r'), rubber, Character.valueOf('s'), ItemComponent.getItemStack(EnumComponentType.EMERALD_CRYSTAL), Character.valueOf('m'), ItemComponent.getItemStack(EnumComponentType.MEMORY_CRYSTAL), Character.valueOf('w'), Items.field_151048_u, Character.valueOf('c'), WarpDrive.blockShipControllers[EnumTier.ADVANCED.getIndex()]}));
    }

    private static void removeRecipe(ItemStack itemStackOutputOfRecipeToRemove) {
        ResourceLocation recipeToRemove = null;
        for (Map.Entry entryRecipe : ForgeRegistries.RECIPES.getEntries()) {
            IRecipe recipe = (IRecipe)entryRecipe.getValue();
            ItemStack itemStackRecipeOutput = recipe.func_77571_b();
            if (itemStackRecipeOutput.func_190926_b() || !itemStackRecipeOutput.func_77969_a(itemStackOutputOfRecipeToRemove)) continue;
            recipeToRemove = (ResourceLocation)entryRecipe.getKey();
            break;
        }
        if (recipeToRemove == null) {
            WarpDrive.logger.error(String.format("Unable to find any recipe to remove with output %s", itemStackOutputOfRecipeToRemove));
        } else {
            WarpDrive.logger.info(String.format("Removing recipe %s with output %s", recipeToRemove, itemStackOutputOfRecipeToRemove));
            ((ForgeRegistry)ForgeRegistries.RECIPES).remove(recipeToRemove);
        }
    }

    static {
        oreDyes.put(EnumDyeColor.WHITE, "dyeWhite");
        oreDyes.put(EnumDyeColor.ORANGE, "dyeOrange");
        oreDyes.put(EnumDyeColor.MAGENTA, "dyeMagenta");
        oreDyes.put(EnumDyeColor.LIGHT_BLUE, "dyeLightBlue");
        oreDyes.put(EnumDyeColor.YELLOW, "dyeYellow");
        oreDyes.put(EnumDyeColor.LIME, "dyeLime");
        oreDyes.put(EnumDyeColor.PINK, "dyePink");
        oreDyes.put(EnumDyeColor.GRAY, "dyeGray");
        oreDyes.put(EnumDyeColor.SILVER, "dyeLightGray");
        oreDyes.put(EnumDyeColor.CYAN, "dyeCyan");
        oreDyes.put(EnumDyeColor.PURPLE, "dyePurple");
        oreDyes.put(EnumDyeColor.BLUE, "dyeBlue");
        oreDyes.put(EnumDyeColor.BROWN, "dyeBrown");
        oreDyes.put(EnumDyeColor.GREEN, "dyeGreen");
        oreDyes.put(EnumDyeColor.RED, "dyeRed");
        oreDyes.put(EnumDyeColor.BLACK, "dyeBlack");
    }
}

