/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.EventWarpDrive;
import cr0s.warpdrive.api.computer.IShipController;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumShipMovementType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ShipMovementCosts {
    public final int maximumDistance_blocks;
    public final int energyRequired;
    public final int warmup_seconds;
    public final int sickness_seconds;
    public final int cooldown_seconds;

    public ShipMovementCosts(World world, BlockPos blockPos, IShipController shipController, EnumShipMovementType shipMovementType, int mass, int distance) {
        Factors factorsForJumpParameters = WarpDriveConfig.SHIP_MOVEMENT_COSTS_FACTORS[shipMovementType.ordinal()];
        int maximumDistance_blocks = Commons.clamp(0, 30000000, ShipMovementCosts.evaluate(mass, distance, factorsForJumpParameters.maximumDistance));
        int energyRequired = Commons.clamp(0, Integer.MAX_VALUE, ShipMovementCosts.evaluate(mass, distance, factorsForJumpParameters.energyRequired));
        int warmup_seconds = Commons.clamp(0, 3600, ShipMovementCosts.evaluate(mass, distance, factorsForJumpParameters.warmup));
        int sickness_seconds = Commons.clamp(0, 3600, ShipMovementCosts.evaluate(mass, distance, factorsForJumpParameters.sickness));
        int cooldown_seconds = Commons.clamp(0, 3600, ShipMovementCosts.evaluate(mass, distance, factorsForJumpParameters.cooldown));
        EventWarpDrive.Ship.MovementCosts movementCosts = new EventWarpDrive.Ship.MovementCosts(world, blockPos, shipController, shipMovementType.func_176610_l(), mass, distance, maximumDistance_blocks, energyRequired, warmup_seconds, sickness_seconds, cooldown_seconds);
        MinecraftForge.EVENT_BUS.post((Event)movementCosts);
        this.maximumDistance_blocks = movementCosts.getMaximumDistance_blocks();
        this.energyRequired = movementCosts.getEnergyRequired();
        this.warmup_seconds = movementCosts.getWarmup_seconds();
        this.sickness_seconds = movementCosts.getSickness_seconds();
        this.cooldown_seconds = movementCosts.getCooldown_seconds();
        if (WarpDriveConfig.LOGGING_ENERGY) {
            WarpDrive.logger.info(String.format("Ship movement %s with mass %d over %d blocks is capped to %d blocks, will cost %d EU, %d s warm-up, %d s sickness, %d s cool down", new Object[]{shipMovementType, mass, distance, this.maximumDistance_blocks, this.energyRequired, this.warmup_seconds, this.sickness_seconds, this.cooldown_seconds}));
        }
    }

    private static int evaluate(int mass, int distance, double[] factors) {
        if (factors.length != 5) {
            return Integer.MAX_VALUE;
        }
        double value = factors[0] + factors[1] * (double)mass + factors[2] * (double)distance + factors[3] * Math.log(Math.max(1.0, (double)mass)) * (factors[4] != 0.0 ? Math.exp((double)distance / factors[4]) : 1.0);
        return (int)Math.ceil(value);
    }

    public static class Factors {
        public double[] maximumDistance;
        public double[] energyRequired;
        public double[] warmup;
        public double[] sickness;
        public double[] cooldown;

        Factors(double[] maximumDistanceDefault, double[] energyRequiredDefault, double[] warmupDefault, double[] sicknessDefault, double[] cooldownDefault) {
            this.maximumDistance = maximumDistanceDefault;
            this.energyRequired = energyRequiredDefault;
            this.warmup = warmupDefault;
            this.sickness = sicknessDefault;
            this.cooldown = cooldownDefault;
        }

        public void load(Configuration config, String category, String prefixKey, String comment) {
            String COMMENT_FACTORS = "\nYou need to provide exactly 5 values < A B C D E >. The equation used is A + B * mass + C * distance + D * ln( mass ) * exp( distance / E )\nResult is rounded up to an integer. Use 0 to ignore that part of the equation.";
            this.maximumDistance = WarpDriveConfig.getDoubleList(config, category, prefixKey + "_max_jump_distance", "Maximum jump length value in blocks " + comment + "." + "\nYou need to provide exactly 5 values < A B C D E >. The equation used is A + B * mass + C * distance + D * ln( mass ) * exp( distance / E )\nResult is rounded up to an integer. Use 0 to ignore that part of the equation.", this.maximumDistance);
            this.energyRequired = WarpDriveConfig.getDoubleList(config, category, prefixKey + "_energyRequired_factors", "energy required measured in internal units " + comment + "." + "\nYou need to provide exactly 5 values < A B C D E >. The equation used is A + B * mass + C * distance + D * ln( mass ) * exp( distance / E )\nResult is rounded up to an integer. Use 0 to ignore that part of the equation.", this.energyRequired);
            this.warmup = WarpDriveConfig.getDoubleList(config, category, prefixKey + "_warmup_seconds", "Warmup seconds to wait before starting jump " + comment + "." + "\nYou need to provide exactly 5 values < A B C D E >. The equation used is A + B * mass + C * distance + D * ln( mass ) * exp( distance / E )\nResult is rounded up to an integer. Use 0 to ignore that part of the equation.", this.warmup);
            this.sickness = WarpDriveConfig.getDoubleList(config, category, prefixKey + "_sickness_seconds", "Motion sickness duration measured in seconds " + comment + "." + "\nYou need to provide exactly 5 values < A B C D E >. The equation used is A + B * mass + C * distance + D * ln( mass ) * exp( distance / E )\nResult is rounded up to an integer. Use 0 to ignore that part of the equation.", this.sickness);
            this.cooldown = WarpDriveConfig.getDoubleList(config, category, prefixKey + "_cooldown_interval_seconds", "Cooldown seconds to wait after jumping " + comment + "." + "\nYou need to provide exactly 5 values < A B C D E >. The equation used is A + B * mass + C * distance + D * ln( mass ) * exp( distance / E )\nResult is rounded up to an integer. Use 0 to ignore that part of the equation.", this.cooldown);
        }
    }
}

