/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.config.structures.AbstractStructure;
import cr0s.warpdrive.config.structures.StructureManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class AbstractStructureInstance
extends WorldGenerator {
    protected AbstractStructure structure;
    protected HashMap<String, Double> variables = new HashMap();

    public AbstractStructureInstance(AbstractStructure structure, Random random) {
        this.structure = structure;
        for (Map.Entry<String, String> entry : structure.variables.entrySet()) {
            double value;
            String stringValue = entry.getValue();
            try {
                if (stringValue.contains(",")) {
                    String[] values = stringValue.split(",");
                    stringValue = values[random.nextInt(values.length)];
                }
                value = Double.parseDouble(entry.getValue());
            }
            catch (NumberFormatException exception) {
                throw new RuntimeException(String.format("Invalid expression '%s'%s for variable %s in deployable structure %s: a numeric value is expected. Check the related XML configuration file...", entry.getValue(), stringValue.equalsIgnoreCase(entry.getValue()) ? "" : " in '" + entry.getValue() + "'", entry.getKey(), structure.name));
            }
            this.variables.put(entry.getKey(), value);
        }
    }

    protected String evaluate(String valueOrExpression) {
        if (!valueOrExpression.contains("%")) {
            return valueOrExpression;
        }
        String result = valueOrExpression;
        for (Map.Entry<String, Double> variable : this.variables.entrySet()) {
            result = result.replaceAll(variable.getKey(), "" + variable.getValue());
        }
        return result;
    }

    public AbstractStructureInstance(NBTTagCompound tagCompound) {
        String groupStructure = tagCompound.func_74779_i("group");
        String nameStructure = tagCompound.func_74779_i("name");
        this.structure = StructureManager.getStructure(null, groupStructure, nameStructure);
        NBTTagCompound tagVariables = tagCompound.func_74775_l("variables");
        for (String key : tagVariables.func_150296_c()) {
            double value = tagVariables.func_74769_h(key);
            this.variables.put(key, value);
        }
    }

    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("group", this.structure.group);
        tagCompound.func_74778_a("name", this.structure.name);
        if (!this.variables.isEmpty()) {
            NBTTagCompound tagVariables = new NBTTagCompound();
            for (Map.Entry<String, Double> entry : this.variables.entrySet()) {
                tagVariables.func_74780_a(entry.getKey(), entry.getValue().doubleValue());
            }
            tagCompound.func_74782_a("variables", (NBTBase)tagVariables);
        }
        return tagCompound;
    }
}

