/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.FastSetBlockState;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.GenericSet;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.structures.MetaOrb;
import cr0s.warpdrive.config.structures.OrbInstance;
import cr0s.warpdrive.data.JumpBlock;
import cr0s.warpdrive.data.VectorI;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MetaOrbInstance
extends OrbInstance {
    private static final int CORE_MAX_TRIES = 10;
    protected final MetaShellInstance metaShellInstance;
    protected int radiusTotal;
    private int sizePregen;
    private ArrayList<BlockPos> blockPoses;
    private int xMin;
    private int xMax;
    private int yMin;
    private int yMax;
    private int zMin;
    private int zMax;

    public MetaOrbInstance(MetaOrb metaOrb, Random random) {
        super(metaOrb, random);
        this.metaShellInstance = new MetaShellInstance(metaOrb, random);
        this.constructionFinalizer();
    }

    private void constructionFinalizer() {
        this.radiusTotal = this.totalThickness + this.metaShellInstance.radius + this.metaShellInstance.locations.size();
        this.sizePregen = (int)Math.ceil(4.1887902047863905 * Math.pow(this.radiusTotal + 1, 3.0));
        this.blockPoses = new ArrayList(this.sizePregen);
    }

    @Override
    public boolean func_180709_b(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos blockPos) {
        BlockPos blockPosUpdated;
        if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
            WarpDrive.logger.info(String.format("Generating MetaOrb %s of %d cores with radius of %d (thickness of %d) at %s", this.structure.getFullName(), this.metaShellInstance.count, this.radiusTotal, this.totalThickness, Commons.format(world, blockPos)));
        }
        LocalProfiler.start(String.format("[MetaOrbInstance] Generating %s of %d cores with radius of %d (thickness of %d)", this.structure.getFullName(), this.metaShellInstance.count, this.radiusTotal, this.totalThickness));
        int y2 = Math.min(WarpDriveConfig.SPACE_GENERATOR_Y_MAX_BORDER - this.radiusTotal, Math.max(blockPos.func_177956_o(), WarpDriveConfig.SPACE_GENERATOR_Y_MIN_BORDER + this.radiusTotal));
        BlockPos blockPos2 = blockPosUpdated = y2 == blockPos.func_177956_o() ? blockPos : new BlockPos(blockPos.func_177958_n(), y2, blockPos.func_177952_p());
        if (((MetaOrb)this.structure).metaShell == null) {
            return super.func_180709_b(world, random, blockPosUpdated);
        }
        this.xMin = this.xMax = blockPosUpdated.func_177958_n();
        this.yMin = this.yMax = blockPosUpdated.func_177956_o();
        this.zMin = this.zMax = blockPosUpdated.func_177952_p();
        this.tickScheduleBlocks(world, random, blockPosUpdated);
        if (this.metaShellInstance.block != null) {
            for (VectorI location : this.metaShellInstance.locations) {
                BlockPos blockPosCore = new BlockPos(blockPosUpdated.func_177958_n() + location.x, blockPosUpdated.func_177956_o() + location.y, blockPosUpdated.func_177952_p() + location.z);
                world.func_180501_a(blockPosCore, this.metaShellInstance.block.func_176203_a(this.metaShellInstance.metadata), 2);
            }
        }
        this.updateClient(world);
        this.xMin = blockPosUpdated.func_177958_n() - this.xMin;
        this.xMax -= blockPosUpdated.func_177958_n();
        this.yMin = blockPosUpdated.func_177956_o() - this.yMin;
        this.yMax -= blockPosUpdated.func_177956_o();
        this.zMin = blockPosUpdated.func_177952_p() - this.zMin;
        this.zMax -= blockPosUpdated.func_177952_p();
        if (Math.max(this.xMin, this.xMax) >= this.radiusTotal || Math.max(this.yMin, this.yMax) >= this.radiusTotal || Math.max(this.zMin, this.zMax) >= this.radiusTotal) {
            WarpDrive.logger.warn(String.format("Generated undersized MetaOrb %s of %d cores with radius of %d (thickness of %d) at %s: bounding box(x %d %d y %d %d z %d %d)", this.structure.getFullName(), this.metaShellInstance.count, this.radiusTotal, this.totalThickness, Commons.format(world, blockPos), this.xMin, this.xMax, this.yMin, this.yMax, this.zMin, this.zMax));
        }
        LocalProfiler.stop();
        return false;
    }

    private void tickScheduleBlocks(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos blockPos) {
        LocalProfiler.start("[MetaOrbInstance] Placing blocks");
        double sqRadiusHigh = ((double)this.totalThickness + 0.5) * ((double)this.totalThickness + 0.5);
        double sqRadiusLow = ((double)this.totalThickness - 0.5) * ((double)this.totalThickness - 0.5);
        int radiusCeil = this.radiusTotal;
        for (int x = -radiusCeil; x <= radiusCeil; ++x) {
            for (int y = -radiusCeil; y <= radiusCeil; ++y) {
                for (int z = -radiusCeil; z <= radiusCeil; ++z) {
                    double dSqRangeClosest = sqRadiusHigh + 1.0;
                    double dSqStrength = 0.0;
                    for (VectorI location : this.metaShellInstance.locations) {
                        double dSqRange = ((double)(x - location.x) + 0.5) * ((double)(x - location.x) + 0.5) + ((double)(y - location.y) + 0.5) * ((double)(y - location.y) + 0.5) + ((double)(z - location.z) + 0.5) * ((double)(z - location.z) + 0.5);
                        if (dSqRange < dSqRangeClosest) {
                            dSqRangeClosest = dSqRange;
                        }
                        dSqStrength += Math.max(0.0, 1.0 / dSqRange);
                    }
                    dSqStrength = (double)this.metaShellInstance.locations.size() / dSqStrength;
                    if (dSqStrength > sqRadiusHigh) continue;
                    boolean isSurface = dSqStrength > sqRadiusLow;
                    int intSqRadius = (int)Math.round(dSqStrength);
                    GenericSet<Filler> orbShell = this.getFillerSetFromSquareRange(intSqRadius);
                    this.addBlock(world, isSurface, new JumpBlock(orbShell.getRandomUnit(random), blockPos.func_177958_n() + x, blockPos.func_177956_o() + y, blockPos.func_177952_p() + z));
                }
            }
        }
        if (this.blockPoses != null && this.blockPoses.size() > this.sizePregen) {
            WarpDrive.logger.warn(String.format("[MetaOrbInstance] Saved %s blocks (estimated to %d)", this.blockPoses.size(), this.sizePregen));
        }
        LocalProfiler.stop();
    }

    private void addBlock(@Nonnull World world, boolean isSurface, JumpBlock jumpBlock) {
        if (jumpBlock.y < 0 || jumpBlock.y > 255) {
            return;
        }
        this.xMin = Math.min(this.xMin, jumpBlock.x);
        this.xMax = Math.max(this.xMax, jumpBlock.x);
        this.yMin = Math.min(this.yMin, jumpBlock.y);
        this.yMax = Math.max(this.yMax, jumpBlock.y);
        this.zMin = Math.min(this.zMin, jumpBlock.z);
        this.zMax = Math.max(this.zMax, jumpBlock.z);
        if (world.func_180495_p(new BlockPos(jumpBlock.x, jumpBlock.y, jumpBlock.z)).func_177230_c().func_149667_c((Block)Blocks.field_150355_j) && world.field_73012_v.nextInt(50) != 1) {
            jumpBlock.block = WarpDrive.blockGas;
            jumpBlock.blockMeta = 0;
        }
        BlockPos blockPos = new BlockPos(jumpBlock.x, jumpBlock.y, jumpBlock.z);
        this.blockPoses.add(blockPos);
        if (isSurface && jumpBlock.x % 4 == 0 && jumpBlock.z % 4 == 0) {
            world.func_180501_a(blockPos, jumpBlock.block.func_176203_a(jumpBlock.blockMeta), 2);
        } else {
            FastSetBlockState.setBlockStateNoLight(world, blockPos, jumpBlock.block.func_176203_a(jumpBlock.blockMeta), 2);
        }
    }

    private void updateClient(World world) {
        LocalProfiler.start("[MetaOrbInstance] Updating client for " + this.blockPoses.size() + " blocks");
        for (BlockPos blockPos : this.blockPoses) {
            IBlockState blockState = world.func_180495_p(blockPos);
            world.func_184138_a(blockPos, blockState, blockState, 3);
        }
        LocalProfiler.stop();
    }

    public class MetaShellInstance {
        protected final int count;
        protected final int radius;
        protected ArrayList<VectorI> locations;
        protected final Block block;
        protected final int metadata;

        public MetaShellInstance(MetaOrb metaOrb, Random random) {
            if (metaOrb.metaShell == null) {
                WarpDrive.logger.warn(String.format("Invalid MetalShell instance with no definition for %s", metaOrb.getFullName()));
                this.count = 1;
                this.radius = 0;
                this.block = null;
                this.metadata = 0;
                return;
            }
            this.count = Commons.randomRange(random, metaOrb.metaShell.minCount, metaOrb.metaShell.maxCount);
            double radiusMax = Math.max(metaOrb.metaShell.minRadius, metaOrb.metaShell.relativeRadius * (double)MetaOrbInstance.this.totalThickness);
            this.block = metaOrb.metaShell.block;
            this.metadata = metaOrb.metaShell.metadata;
            this.locations = new ArrayList();
            double diameter = Math.max(1.0, 2.0 * radiusMax);
            double xMin = -radiusMax;
            double yMin = -radiusMax;
            double zMin = -radiusMax;
            int radiusActual = 0;
            for (int index = 0; index < this.count; ++index) {
                boolean found = false;
                for (int step = 0; step < 10 && !found; ++step) {
                    VectorI location = new VectorI((int)Math.round(xMin + diameter * random.nextDouble()), (int)Math.round(yMin + diameter * random.nextDouble()), (int)Math.round(zMin + diameter * random.nextDouble()));
                    if (this.locations.contains(location)) continue;
                    this.locations.add(location);
                    radiusActual = Math.max(radiusActual, Math.max(Math.abs(location.x), Math.max(Math.abs(location.y), Math.abs(location.z))));
                    found = true;
                }
            }
            this.radius = radiusActual;
        }
    }
}

