/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.GenericSet;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.structures.AbstractStructureInstance;
import cr0s.warpdrive.config.structures.Orb;
import cr0s.warpdrive.world.EntitySphereGen;
import cr0s.warpdrive.world.EntityStarCore;
import cr0s.warpdrive.world.WorldGenSmallShip;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class OrbInstance
extends AbstractStructureInstance {
    protected ArrayList<GenericSet<Filler>> orbShellInstances;
    private int[] orbShellThicknesses;
    protected int totalThickness;
    protected int minThickness;
    protected String schematicName;
    private ArrayList<GenericSet<Filler>> sqRadiusToOrbShell;

    public OrbInstance(Orb orb, Random random) {
        super(orb, random);
        this.orbShellInstances = new ArrayList(orb.orbShells.length);
        this.orbShellThicknesses = new int[orb.orbShells.length];
        this.totalThickness = 0;
        this.minThickness = 0;
        int orbShellIndexOut = 0;
        for (int orbShellIndexIn = 0; orbShellIndexIn < orb.orbShells.length; ++orbShellIndexIn) {
            int thickness;
            Orb.OrbShell orbShell = orb.orbShells[orbShellIndexIn].instantiate(random);
            if (orbShell == null) continue;
            this.orbShellInstances.add(orbShell);
            this.orbShellThicknesses[orbShellIndexOut] = thickness = Commons.randomRange(random, orbShell.minThickness, orbShell.maxThickness);
            this.totalThickness += thickness;
            this.minThickness += orbShell.minThickness;
            ++orbShellIndexOut;
        }
        if (this.orbShellThicknesses.length != orbShellIndexOut) {
            this.orbShellThicknesses = Arrays.copyOf(this.orbShellThicknesses, orbShellIndexOut);
        }
        this.schematicName = orb.schematicName;
        this.constructionFinalizer();
    }

    private void constructionFinalizer() {
        int sqRadius = this.totalThickness * this.totalThickness;
        this.sqRadiusToOrbShell = new ArrayList(sqRadius);
        block0: for (int sqRange = 0; sqRange < sqRadius; ++sqRange) {
            int range = 0;
            for (int indexShell = 0; indexShell < this.orbShellInstances.size(); ++indexShell) {
                if (sqRange > (range += this.orbShellThicknesses[indexShell]) * range) continue;
                this.sqRadiusToOrbShell.add(this.orbShellInstances.get(indexShell));
                continue block0;
            }
        }
    }

    public OrbInstance(NBTTagCompound tagCompound) {
        super(tagCompound);
        NBTTagList listOrbShells = tagCompound.func_150295_c("orbShellInstances", 10);
        if (listOrbShells.func_82582_d()) {
            throw new RuntimeException(String.format("Empty orbShellInstances list isn't supported in %s: %s", new Object[]{this, tagCompound}));
        }
        this.orbShellInstances = new ArrayList(listOrbShells.func_74745_c());
        for (int indexOrbShell = 0; indexOrbShell < listOrbShells.func_74745_c(); ++indexOrbShell) {
            NBTTagCompound tagCompoundOrbShell = listOrbShells.func_150305_b(indexOrbShell);
            GenericSet<Filler> orbShell = new GenericSet<Filler>(tagCompoundOrbShell, Filler.DEFAULT, "filler");
            this.orbShellInstances.add(orbShell);
        }
        this.orbShellThicknesses = tagCompound.func_74759_k("orbShellThicknesses");
        if (this.orbShellInstances.size() != this.orbShellThicknesses.length) {
            throw new RuntimeException(String.format("Inconsistent orbShell and thicknesses sizes: %d != %d\n%s", this.orbShellInstances.size(), this.orbShellThicknesses.length, tagCompound));
        }
        this.totalThickness = tagCompound.func_74762_e("totalThickness");
        this.minThickness = tagCompound.func_74762_e("minThickness");
        this.schematicName = tagCompound.func_74764_b("schematicName") ? tagCompound.func_74779_i("schematicName") : null;
        this.constructionFinalizer();
    }

    @Override
    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        NBTTagList listOrbShells = new NBTTagList();
        if (this.orbShellInstances.isEmpty()) {
            throw new RuntimeException(String.format("Empty orbShellInstances list isn't supported in %s", new Object[]{this}));
        }
        for (GenericSet<Filler> orbShellInstance : this.orbShellInstances) {
            NBTTagCompound tagCompoundOrbShell = orbShellInstance.writeToNBT(new NBTTagCompound());
            listOrbShells.func_74742_a((NBTBase)tagCompoundOrbShell);
        }
        tagCompound.func_74782_a("orbShellInstances", (NBTBase)listOrbShells);
        tagCompound.func_74783_a("orbShellThicknesses", this.orbShellThicknesses);
        tagCompound.func_74768_a("totalThickness", this.totalThickness);
        tagCompound.func_74768_a("minThickness", this.minThickness);
        if (this.schematicName != null) {
            tagCompound.func_74778_a("schematicName", this.schematicName);
        }
        return tagCompound;
    }

    public int getTotalThickness() {
        return this.totalThickness;
    }

    public boolean func_180709_b(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos blockPos) {
        BlockPos blockPosUpdated;
        boolean hasShip = this.schematicName != null && !this.schematicName.isEmpty();
        int y2 = Math.min(WarpDriveConfig.SPACE_GENERATOR_Y_MAX_BORDER - this.totalThickness, Math.max(blockPos.func_177956_o(), WarpDriveConfig.SPACE_GENERATOR_Y_MIN_BORDER + this.totalThickness));
        BlockPos blockPos2 = blockPosUpdated = y2 == blockPos.func_177956_o() ? blockPos : new BlockPos(blockPos.func_177958_n(), y2, blockPos.func_177952_p());
        if (hasShip) {
            new WorldGenSmallShip(random.nextFloat() < 0.2f, false).func_180709_b(world, random, blockPosUpdated);
        }
        EntitySphereGen entitySphereGen = new EntitySphereGen(world, blockPos.func_177958_n(), y2, blockPos.func_177952_p(), this, !hasShip);
        world.func_72838_d((Entity)entitySphereGen);
        if (((Orb)this.structure).hasStarCore) {
            return world.func_72838_d((Entity)new EntityStarCore(world, blockPos.func_177958_n(), y2, blockPos.func_177952_p(), this.totalThickness));
        }
        return true;
    }

    public GenericSet<Filler> getFillerSetFromSquareRange(int sqRadius) {
        if (sqRadius < this.sqRadiusToOrbShell.size()) {
            return this.sqRadiusToOrbShell.get(sqRadius);
        }
        return this.sqRadiusToOrbShell.get(this.sqRadiusToOrbShell.size() - 1);
    }
}

