/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.Filler;
import cr0s.warpdrive.config.GenericSet;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.Loot;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.config.XmlFileManager;
import cr0s.warpdrive.config.structures.AbstractStructure;
import cr0s.warpdrive.config.structures.AbstractStructureInstance;
import cr0s.warpdrive.config.structures.SchematicInstance;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.w3c.dom.Element;

public class Schematic
extends AbstractStructure {
    protected String filename;
    protected Replacement[] replacements;
    protected Insertion[] insertions;

    public Schematic(String group, String name) {
        super(group, name);
    }

    @Override
    public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
        super.loadFromXmlElement(element);
        List<Element> listReplacements = XmlFileManager.getChildrenElementByTagName(element, "replacement");
        this.replacements = new Replacement[listReplacements.size()];
        int replacementIndexOut = 0;
        for (Element elementReplacement : listReplacements) {
            String blockState = elementReplacement.getAttribute("blockState");
            this.replacements[replacementIndexOut] = new Replacement(this.getFullName(), blockState);
            try {
                this.replacements[replacementIndexOut].loadFromXmlElement(elementReplacement);
                ++replacementIndexOut;
            }
            catch (InvalidXmlException exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
                WarpDrive.logger.error(String.format("Skipping invalid replacement %s", blockState));
            }
        }
        List<Element> listInsertions = XmlFileManager.getChildrenElementByTagName(element, "insertion");
        this.insertions = new Insertion[listInsertions.size()];
        int insertionIndexOut = 0;
        for (Element elementInsertion : listInsertions) {
            String blockState = elementInsertion.getAttribute("blockState");
            this.insertions[insertionIndexOut] = new Insertion(this.getFullName(), blockState);
            try {
                this.insertions[insertionIndexOut].loadFromXmlElement(elementInsertion);
                ++insertionIndexOut;
            }
            catch (InvalidXmlException exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
                WarpDrive.logger.error(String.format("Skipping invalid insertion %s", blockState));
            }
        }
        return true;
    }

    public boolean func_180709_b(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos blockPos) {
        return this.instantiate(random).func_180709_b(world, random, blockPos);
    }

    @Override
    public AbstractStructureInstance instantiate(Random random) {
        return new SchematicInstance(this, random);
    }

    public class Insertion
    extends GenericSet<Loot> {
        private final String parentFullName;
        private int minQuantity;
        private int maxQuantity;
        protected Block block;
        protected IBlockState blockState;

        public Insertion(String parentFullName, String name) {
            super(null, name, Loot.DEFAULT, "loot");
            this.parentFullName = parentFullName;
        }

        @Override
        public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
            if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                WarpDrive.logger.info(String.format("  + found insertion %s", element.getAttribute("name")));
            }
            super.loadFromXmlElement(element);
            this.minQuantity = 0;
            String stringMinQuantity = element.getAttribute("minQuantity");
            if (!stringMinQuantity.isEmpty()) {
                this.minQuantity = Integer.parseInt(stringMinQuantity);
            }
            this.maxQuantity = 7;
            String stringMaxQuantity = element.getAttribute("minQuantity");
            if (!stringMaxQuantity.isEmpty()) {
                this.maxQuantity = Integer.parseInt(stringMaxQuantity);
            }
            for (String importGroupName : this.getImportGroupNames()) {
                GenericSet<Loot> lootSet = WarpDriveConfig.LootManager.getGenericSet(importGroupName);
                if (lootSet == null) {
                    WarpDrive.logger.warn(String.format("Skipping missing LootSet %s in insertion %s of structure %s", importGroupName, this.name, this.parentFullName));
                    continue;
                }
                this.loadFrom(lootSet);
            }
            for (String importGroup : this.getImportGroups()) {
                if (WarpDriveConfig.LootManager.doesGroupExist(importGroup)) continue;
                WarpDrive.logger.warn(String.format("An invalid LootSet group %s is referenced in insertion %s of structure %s", importGroup, this.name, this.parentFullName));
            }
            return true;
        }

        public Insertion instantiate(Random random) {
            Insertion insertion = new Insertion(this.parentFullName, this.name);
            insertion.minQuantity = this.minQuantity;
            insertion.maxQuantity = this.maxQuantity;
            insertion.block = this.block;
            insertion.blockState = this.blockState;
            try {
                insertion.loadFrom(this);
                for (String importGroup : this.getImportGroups()) {
                    GenericSet<Loot> lootSet = WarpDriveConfig.LootManager.getRandomSetFromGroup(random, importGroup);
                    if (lootSet == null) {
                        WarpDrive.logger.warn(String.format("Ignoring invalid group %s in insertion %s of structure %s", importGroup, this.name, this.parentFullName));
                        continue;
                    }
                    if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                        WarpDrive.logger.info(String.format("Filling %s:%s with %s:%s", this.parentFullName, this.name, importGroup, lootSet.func_176610_l()));
                    }
                    insertion.loadFrom(lootSet);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
                WarpDrive.logger.error(String.format("Failed to instantiate insertion %s from structure %s", this.name, this.parentFullName));
            }
            if (insertion.isEmpty()) {
                if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                    WarpDrive.logger.info(String.format("Ignoring empty insertion %s in structure %s", this.name, this.parentFullName));
                }
                return null;
            }
            return insertion;
        }

        public boolean isMatching(IBlockState blockStateIn) {
            return this.block != null && this.block == blockStateIn.func_177230_c() || this.blockState.equals(blockStateIn);
        }
    }

    public class Replacement
    extends GenericSet<Filler> {
        private final String parentFullName;
        protected Block block;
        protected IBlockState blockState;

        public Replacement(String parentFullName, String name) {
            super(null, name, Filler.DEFAULT, "filler");
            this.parentFullName = parentFullName;
        }

        @Override
        public boolean loadFromXmlElement(Element element) throws InvalidXmlException {
            if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                WarpDrive.logger.info(String.format("  + found replacement %s", element.getAttribute("name")));
            }
            super.loadFromXmlElement(element);
            for (String importGroupName : this.getImportGroupNames()) {
                GenericSet<Filler> fillerSet = WarpDriveConfig.FillerManager.getGenericSet(importGroupName);
                if (fillerSet == null) {
                    WarpDrive.logger.warn(String.format("Skipping missing FillerSet %s in replacement %s of structure %s", importGroupName, this.name, this.parentFullName));
                    continue;
                }
                this.loadFrom(fillerSet);
            }
            for (String importGroup : this.getImportGroups()) {
                if (WarpDriveConfig.FillerManager.doesGroupExist(importGroup)) continue;
                WarpDrive.logger.warn(String.format("An invalid FillerSet group %s is referenced in replacement %s of structure %s", importGroup, this.name, this.parentFullName));
            }
            return true;
        }

        public Replacement instantiate(Random random) {
            Replacement replacement = new Replacement(this.parentFullName, this.name);
            replacement.block = this.block;
            replacement.blockState = this.blockState;
            try {
                replacement.loadFrom(this);
                for (String importGroup : this.getImportGroups()) {
                    GenericSet<Filler> fillerSet = WarpDriveConfig.FillerManager.getRandomSetFromGroup(random, importGroup);
                    if (fillerSet == null) {
                        WarpDrive.logger.warn(String.format("Ignoring invalid group %s in replacement %s of structure %s", importGroup, this.name, this.parentFullName));
                        continue;
                    }
                    if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                        WarpDrive.logger.info(String.format("Filling %s:%s with %s:%s", this.parentFullName, this.name, importGroup, fillerSet.func_176610_l()));
                    }
                    replacement.loadFrom(fillerSet);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(WarpDrive.printStreamError);
                WarpDrive.logger.error(String.format("Failed to instantiate replacement %s from structure %s", this.name, this.parentFullName));
            }
            if (replacement.isEmpty()) {
                if (WarpDriveConfig.LOGGING_WORLD_GENERATION) {
                    WarpDrive.logger.info(String.format("Ignoring empty replacement %s in structure %s", this.name, this.parentFullName));
                }
                return null;
            }
            return replacement;
        }

        public boolean isMatching(IBlockState blockStateIn) {
            return this.block != null && this.block == blockStateIn.func_177230_c() || this.blockState.equals(blockStateIn);
        }
    }
}

