/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.structures.AbstractStructure;
import cr0s.warpdrive.config.structures.AbstractStructureInstance;
import cr0s.warpdrive.config.structures.StructureManager;
import java.util.Random;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureGroup
implements IStringSerializable {
    private static final String NONE = "-none-";
    protected String group;
    protected String name;

    public StructureGroup(String group, String name) {
        this.group = group == null || group.isEmpty() ? NONE : group;
        this.name = name;
    }

    public String func_176610_l() {
        return this.group + ":" + (this.name == null || this.name.isEmpty() ? "*" : this.name);
    }

    public void generate(World world, Random random, int x, int y, int z) {
        if (this.group.equals(NONE)) {
            return;
        }
        AbstractStructure abstractStructure = StructureManager.getStructure(random, this.group, this.name);
        if (abstractStructure == null) {
            WarpDrive.logger.warn(String.format("Celestial object %s refers to unknown structure %s. Probably a bad configuration. Skipping for now.", Commons.format(world, x, y, z), this.func_176610_l()));
            return;
        }
        AbstractStructureInstance abstractStructureInstance = abstractStructure.instantiate(random);
        abstractStructureInstance.func_180709_b(world, random, new BlockPos(x, y, z));
    }

    public String getGroup() {
        return this.group;
    }

    public String toString() {
        return String.format("StructureGroup %s", this.func_176610_l());
    }
}

