/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.config.structures;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.InvalidXmlException;
import cr0s.warpdrive.config.XmlFileManager;
import cr0s.warpdrive.config.XmlRandomCollection;
import cr0s.warpdrive.config.structures.AbstractStructure;
import cr0s.warpdrive.config.structures.AsteroidField;
import cr0s.warpdrive.config.structures.MetaOrb;
import cr0s.warpdrive.config.structures.Orb;
import cr0s.warpdrive.config.structures.Schematic;
import cr0s.warpdrive.config.structures.Star;
import cr0s.warpdrive.data.EnumStructureGroup;
import java.io.File;
import java.util.HashMap;
import java.util.Random;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;

public class StructureManager
extends XmlFileManager {
    private static final StructureManager INSTANCE = new StructureManager();
    private static HashMap<String, XmlRandomCollection<AbstractStructure>> structuresByGroup;

    public static void load(File dir) {
        structuresByGroup = new HashMap();
        INSTANCE.load(dir, "structure", "structure");
        for (EnumStructureGroup group : EnumStructureGroup.values()) {
            if (!group.isRequired() || structuresByGroup.containsKey(group.func_176610_l())) continue;
            WarpDrive.logger.error(String.format("Error: no structure defined for mandatory group %s", group.func_176610_l()));
        }
    }

    @Override
    protected void parseRootElement(String location, Element element) throws InvalidXmlException {
        String group = element.getAttribute("group");
        if (group.isEmpty()) {
            throw new InvalidXmlException(String.format("%s is missing a group attribute!", location));
        }
        String name = element.getAttribute("name");
        if (name.isEmpty()) {
            throw new InvalidXmlException(String.format("%s is missing a name attribute!", location));
        }
        if (!element.getTagName().equals("structure")) {
            throw new InvalidXmlException(String.format("%s contains invalid element %s, expecting structure!", location, element.getTagName()));
        }
        WarpDrive.logger.info(String.format("- found %s %s:%s", element.getTagName(), group, name));
        XmlRandomCollection xmlRandomCollection = structuresByGroup.computeIfAbsent(group, k -> new XmlRandomCollection());
        AbstractStructure abstractStructure = (AbstractStructure)xmlRandomCollection.getNamedEntry(name);
        if (abstractStructure == null) {
            if (group.equals("star")) {
                abstractStructure = new Star(group, name);
            } else if (!StructureManager.getChildrenElementByTagName(element, "schematic").isEmpty()) {
                abstractStructure = new Schematic(group, name);
            } else if (!StructureManager.getChildrenElementByTagName(element, "shell").isEmpty()) {
                abstractStructure = !StructureManager.getChildrenElementByTagName(element, "metaShell").isEmpty() ? new MetaOrb(group, name) : new Orb(group, name);
            } else {
                throw new InvalidXmlException(String.format("%s contains unrecognized structure format, check your configuration!", location));
            }
        }
        xmlRandomCollection.loadFromXML(abstractStructure, element);
    }

    public static AbstractStructure getStructure(Random random, String group, String name) {
        if (group == null || group.isEmpty()) {
            return null;
        }
        if (EnumStructureGroup.byName(group) == EnumStructureGroup.ASTEROIDS_FIELDS) {
            return new AsteroidField(null, null);
        }
        XmlRandomCollection<AbstractStructure> xmlRandomCollection = structuresByGroup.get(group);
        if (xmlRandomCollection == null) {
            return null;
        }
        if (name == null || name.isEmpty()) {
            return (AbstractStructure)xmlRandomCollection.getRandomEntry(random);
        }
        return (AbstractStructure)xmlRandomCollection.getNamedEntry(name);
    }

    public static String getStructureNames(String group) {
        XmlRandomCollection<AbstractStructure> xmlRandomCollection;
        if (group != null && !group.isEmpty() && (xmlRandomCollection = structuresByGroup.get(group)) != null) {
            return xmlRandomCollection.getNames();
        }
        return "Error: group '" + group + "' isn't defined. Try one of: " + StringUtils.join(structuresByGroup.keySet(), (String)", ");
    }

    public static String getGroups() {
        return Commons.format(structuresByGroup.keySet().toArray());
    }
}

