/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.damage;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.network.PacketHandler;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;

public class DamageIrradiation
extends DamageSource {
    public DamageIrradiation() {
        super("warpdrive.irradiation");
        this.func_76348_h();
        this.func_151518_m();
    }

    public void onWorldEffect(World world, Vector3 v3Position, float strength) {
        double radius = Math.sqrt(2.0 * (double)strength);
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(v3Position.x - radius, v3Position.y - radius, v3Position.z - radius, v3Position.x + radius, v3Position.y + radius, v3Position.z + radius);
        List listEntityLivingBase = world.func_72872_a(EntityLivingBase.class, axisAlignedBB);
        if (listEntityLivingBase != null) {
            for (EntityLivingBase entityLivingBase : listEntityLivingBase) {
                float distance = Math.min(1.0f, (float)Math.sqrt(v3Position.distanceTo_square((Entity)entityLivingBase)));
                this.onEntityEffect(strength / (distance * distance), world, v3Position, (Entity)entityLivingBase);
            }
        }
    }

    public void onEntityEffect(float strength, World world, Vector3 v3Source, Entity entity) {
        if (strength <= 0.0f || !(entity instanceof EntityLivingBase) || entity.field_70128_L) {
            return;
        }
        Vector3 v3Entity = new Vector3(entity);
        Vector3 v3Direction = new Vector3(entity).subtract(v3Source).normalize();
        Vector3 v3From = v3Source.clone();
        v3From.translateFactor(v3Direction, 0.6);
        v3Entity.translateFactor(v3Direction, -0.6);
        double speed = Math.abs(strength);
        Vector3 v3Motion = v3Direction.clone().scale(speed);
        if (WarpDriveConfig.LOGGING_ACCELERATOR && WarpDrive.isDev) {
            PacketHandler.sendBeamPacket(world, v3From, v3Entity, 0.25f, 0.75f, 0.38f, 10, 0, 50);
            WarpDrive.logger.info(String.format("%s strength %.1f speed %.3f entity %s source %s direction %s motion %s entity %s", new Object[]{this, Float.valueOf(strength), speed, v3Entity, v3Source, v3Direction, v3Motion, entity}));
        }
        entity.func_70097_a((DamageSource)this, strength);
        v3Direction.scale(0.2);
        PacketHandler.sendSpawnParticlePacket(world, "mobSpell", (byte)Commons.clamp(3.0f, 10.0f, strength), v3Entity, v3Direction, 0.2f + 0.1f * world.field_73012_v.nextFloat(), 0.9f + 0.1f * world.field_73012_v.nextFloat(), 0.4f + 0.15f * world.field_73012_v.nextFloat(), 0.0f, 0.0f, 0.0f, 32);
    }
}

