/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;

public class AcceleratorControlParameter {
    public int controlChannel;
    public boolean isEnabled = true;
    public double threshold = 0.95;
    public String description = "-";

    public AcceleratorControlParameter(int controlChannel) {
        this.controlChannel = controlChannel;
    }

    public AcceleratorControlParameter(@Nonnull NBTTagCompound tagCompound) {
        this.readFromNBT(tagCompound);
    }

    private void readFromNBT(@Nonnull NBTTagCompound tagCompound) {
        this.controlChannel = tagCompound.func_74762_e("controlChannel");
        this.isEnabled = !tagCompound.func_74764_b("isEnabled") || tagCompound.func_74767_n("isEnabled");
        this.threshold = tagCompound.func_74769_h("threshold");
        this.description = tagCompound.func_74779_i("description");
    }

    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("controlChannel", this.controlChannel);
        tagCompound.func_74757_a("isEnabled", this.isEnabled);
        tagCompound.func_74780_a("threshold", this.threshold);
        tagCompound.func_74778_a("description", this.description);
        return tagCompound;
    }

    public int hashCode() {
        return this.controlChannel;
    }

    public boolean equals(Object object) {
        if (object instanceof AcceleratorControlParameter) {
            AcceleratorControlParameter acceleratorControlParameter = (AcceleratorControlParameter)object;
            return this.controlChannel == acceleratorControlParameter.controlChannel && this.isEnabled == acceleratorControlParameter.isEnabled && this.threshold == acceleratorControlParameter.threshold && this.description.equals(acceleratorControlParameter.description);
        }
        return false;
    }

    public String toString() {
        return String.format("%s/%d isEnabled %s threshold %.3f '%s'", this.getClass().getSimpleName(), this.controlChannel, this.isEnabled, this.threshold, this.description);
    }
}

