/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import com.google.common.collect.ImmutableSet;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.LocalProfiler;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IControlChannel;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.block.atomic.BlockAcceleratorControlPoint;
import cr0s.warpdrive.block.atomic.BlockChiller;
import cr0s.warpdrive.block.atomic.BlockElectromagnetPlain;
import cr0s.warpdrive.block.atomic.BlockParticlesCollider;
import cr0s.warpdrive.block.atomic.BlockParticlesInjector;
import cr0s.warpdrive.block.atomic.BlockVoidShellPlain;
import cr0s.warpdrive.block.atomic.TileEntityAcceleratorControlPoint;
import cr0s.warpdrive.block.atomic.TileEntityParticlesInjector;
import cr0s.warpdrive.block.energy.BlockCapacitor;
import cr0s.warpdrive.block.energy.TileEntityCapacitor;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.EnumTier;
import cr0s.warpdrive.data.GlobalPosition;
import cr0s.warpdrive.data.TrajectoryPoint;
import cr0s.warpdrive.data.VectorI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class AcceleratorSetup
extends GlobalPosition {
    private static final int ACCELERATOR_MAX_RANGE_SQUARED = 36864;
    private HashMap<VectorI, TrajectoryPoint> trajectoryAccelerator;
    private HashMap<VectorI, TrajectoryPoint> trajectoryTransfer;
    private boolean isDirty = false;
    private final int[] countMagnets = new int[3];
    private final int[] countChillers = new int[3];
    private final HashMap<VectorI, Integer> controlPoints = new HashMap();
    public final HashSet<BlockPos> setChillers = new HashSet();
    public final HashSet<BlockPos> setCapacitors = new HashSet();
    public final int energy_maxStorage;
    public final Set<VectorI> setJammed = new HashSet<VectorI>();
    public final TreeMap<Integer, VectorI> mapInjectors = new TreeMap();
    public final Integer[] keyInjectors;
    public final ArrayList<TrajectoryPoint> listColliders = new ArrayList();
    private Object[][] matrixControlPoints = new Object[0][];
    private VectorI vMin;
    private VectorI vMax;
    public double temperatureTarget_K;
    public double[] temperatures_cooling_K_perTick = new double[3];
    public double temperature_coolingEnergyCost_perTick;
    public double[] temperatures_sustainEnergyCost_perTick = new double[3];
    public double particleEnergy_energyCost_perTick;
    protected boolean isAssemblyValid = true;
    protected WarpDriveText textValidityIssues = new WarpDriveText(Commons.getStyleWarning(), "-undefined accelerator setup-", new Object[0]);
    private boolean isLoaded = true;

    public AcceleratorSetup(int dimensionId, @Nonnull BlockPos blockPos) {
        super(dimensionId, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        LocalProfiler.start(String.format("[AcceleratorSetup] Scanning @ DIM%d (%d %d %d)", dimensionId, this.x, this.y, this.z));
        WorldServer world = this.getWorldServerIfLoaded();
        if (world == null) {
            if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                WarpDrive.logger.warn(String.format("Accelerator scan cancelled: Dimension %d isn't loaded", dimensionId));
            }
        } else {
            this.refresh(world);
        }
        if (world == null || this.setCapacitors.isEmpty()) {
            this.energy_maxStorage = 0;
        } else {
            int maxStorage = 0;
            for (TileEntityCapacitor tileEntityCapacitor : this.getCapacitors()) {
                maxStorage = (int)((long)maxStorage + tileEntityCapacitor.energy_getMaxStorage());
            }
            this.energy_maxStorage = maxStorage;
        }
        this.keyInjectors = this.mapInjectors.isEmpty() ? null : this.mapInjectors.keySet().toArray(new Integer[0]);
        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
            WarpDrive.logger.info(String.format("Accelerator length: %d + %d including %d + %d + %d magnets, %d chillers and %d capacitors cool down: %.3f %.3f %.3f /t %.3f EU/t sustain: %.3f %.3f %.3f EU/t acceleration: %.3f /particle", this.trajectoryAccelerator == null ? -1 : this.trajectoryAccelerator.size(), this.trajectoryTransfer == null ? -1 : this.trajectoryTransfer.size(), this.countMagnets[0], this.countMagnets[1], this.countMagnets[2], this.setChillers.size(), this.setCapacitors.size(), this.temperatures_cooling_K_perTick[0], this.temperatures_cooling_K_perTick[1], this.temperatures_cooling_K_perTick[2], this.temperature_coolingEnergyCost_perTick, this.temperatures_sustainEnergyCost_perTick[0], this.temperatures_sustainEnergyCost_perTick[1], this.temperatures_sustainEnergyCost_perTick[2], this.particleEnergy_energyCost_perTick));
        }
        LocalProfiler.stop();
    }

    private void addToBoundingBox(@Nonnull VectorI vector, int range) {
        this.vMin.x = Math.min(this.vMin.x, vector.x - range);
        this.vMin.y = Math.min(this.vMin.y, vector.y - range);
        this.vMin.z = Math.min(this.vMin.z, vector.z - range);
        this.vMax.x = Math.max(this.vMax.x, vector.x + range);
        this.vMax.y = Math.max(this.vMax.y, vector.y + range);
        this.vMax.z = Math.max(this.vMax.z, vector.z + range);
    }

    private void refresh(WorldServer world) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            WarpDrive.logger.warn("Accelerator scan cancelled: client side");
            return;
        }
        this.fillTrajectoryPoints(world);
        if (this.trajectoryAccelerator == null) {
            assert (!this.isAssemblyValid);
            return;
        }
        this.computeCountsAndBoundingBox();
        this.computeVectorArrays(world);
        int indexHighest = this.countMagnets[2] > 0 ? 2 : (this.countMagnets[1] > 0 ? 1 : 0);
        this.temperatureTarget_K = WarpDriveConfig.ACCELERATOR_TEMPERATURES_K[indexHighest];
        double coolingFactor = 10.0 / (double)(this.countMagnets[0] + this.countMagnets[1] + this.countMagnets[2]);
        this.temperatures_cooling_K_perTick[0] = ((double)this.countChillers[0] * 1.0 + (double)this.countChillers[1] * 0.75 + (double)this.countChillers[2] * 0.5) * coolingFactor;
        this.temperatures_cooling_K_perTick[1] = ((double)this.countChillers[1] * 1.0 + (double)this.countChillers[2] * 0.75) * coolingFactor;
        this.temperatures_cooling_K_perTick[2] = (double)this.countChillers[2] * 1.0 * coolingFactor;
        this.temperature_coolingEnergyCost_perTick = (double)this.countChillers[0] * 10.0 + (double)this.countChillers[1] * 20.0 + (double)this.countChillers[2] * 40.0;
        this.temperatures_sustainEnergyCost_perTick[0] = (double)this.countChillers[0] * 1.0 + (double)this.countChillers[1] * 2.0 + (double)this.countChillers[2] * 2.0;
        this.temperatures_sustainEnergyCost_perTick[1] = (double)this.countChillers[0] * 0.5 + (double)this.countChillers[1] * 2.0 + (double)this.countChillers[2] * 3.0;
        this.temperatures_sustainEnergyCost_perTick[2] = (double)this.countChillers[0] * 0.25 + (double)this.countChillers[1] * 1.0 + (double)this.countChillers[2] * 4.0;
        this.particleEnergy_energyCost_perTick = (double)this.countMagnets[0] * 1.0 + (double)this.countMagnets[1] * 2.0 + (double)this.countMagnets[2] * 3.0;
    }

    private void fillTrajectoryPoints(WorldServer world) {
        ImmutableSet whitelist = ImmutableSet.of((Object)WarpDrive.blockElectromagnets_plain[1], (Object)WarpDrive.blockElectromagnets_glass[1], (Object)WarpDrive.blockElectromagnets_plain[2], (Object)WarpDrive.blockElectromagnets_glass[2], (Object)WarpDrive.blockElectromagnets_plain[3], (Object)WarpDrive.blockElectromagnets_glass[3], (Object[])new Block[]{WarpDrive.blockVoidShellPlain, WarpDrive.blockVoidShellGlass});
        Set<BlockPos> connections = Commons.getConnectedBlocks((World)world, this.getBlockPos(), Commons.DIRECTIONS_ANY, (Set<Block>)whitelist, 3, new BlockPos[0]);
        VectorI firstVoidShell = null;
        for (BlockPos blockPos : connections) {
            Block block = world.func_180495_p(blockPos).func_177230_c();
            if (!(block instanceof BlockVoidShellPlain)) continue;
            firstVoidShell = new VectorI(blockPos);
            break;
        }
        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
            WarpDrive.logger.info(String.format("First void shell is %s", firstVoidShell));
        }
        if (firstVoidShell == null) {
            this.isAssemblyValid = false;
            this.textValidityIssues = new WarpDriveText(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.missing_void_shell_connection", new Object[0]);
            return;
        }
        whitelist = ImmutableSet.of((Object)WarpDrive.blockVoidShellPlain, (Object)WarpDrive.blockVoidShellGlass);
        TrajectoryPoint trajectoryPoint = null;
        for (EnumFacing direction : EnumFacing.field_176754_o) {
            BlockPos next = new BlockPos(firstVoidShell.x + direction.func_82601_c(), firstVoidShell.y + direction.func_96559_d(), firstVoidShell.z + direction.func_82599_e());
            IBlockState blockStateNext = Commons.getBlockState_noChunkLoading((IBlockAccess)world, next);
            if (blockStateNext == null || !whitelist.contains(blockStateNext.func_177230_c())) continue;
            trajectoryPoint = new TrajectoryPoint((World)world, firstVoidShell.translate(direction), direction);
            break;
        }
        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
            WarpDrive.logger.info(String.format("First one is %s", trajectoryPoint));
        }
        if (trajectoryPoint == null) {
            this.isAssemblyValid = false;
            this.textValidityIssues = new WarpDriveText(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.missing_void_shell_connection", new Object[0]);
            return;
        }
        this.trajectoryAccelerator = new HashMap();
        this.trajectoryTransfer = new HashMap();
        HashSet<TrajectoryPoint> hashSet = new HashSet<TrajectoryPoint>();
        hashSet.add(trajectoryPoint.clone());
        trajectoryPoint = new TrajectoryPoint((World)world, trajectoryPoint.translate(trajectoryPoint.directionBackward), trajectoryPoint.directionBackward);
        hashSet.add(trajectoryPoint);
        HashSet<TrajectoryPoint> transferToAdd = new HashSet<TrajectoryPoint>();
        while (!hashSet.isEmpty()) {
            TrajectoryPoint trajectoryPointToAdd;
            TrajectoryPoint trajectoryToAdd;
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                trajectoryPoint = trajectoryToAdd = (TrajectoryPoint)iterator.next();
                while (trajectoryPoint.hasNoMissingVoidShells() && this.isInRange(trajectoryPoint) && !this.trajectoryAccelerator.containsKey(trajectoryPoint)) {
                    if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                        WarpDrive.logger.info(String.format("Adding accelerator %s", trajectoryPoint));
                    }
                    trajectoryPointToAdd = trajectoryPoint.clone();
                    this.trajectoryAccelerator.put(trajectoryPointToAdd, trajectoryPointToAdd);
                    if (trajectoryPoint.vJunctionForward != null) {
                        transferToAdd.add(new TrajectoryPoint((World)world, trajectoryPoint, true));
                    }
                    if (trajectoryPoint.vJunctionBackward != null) {
                        transferToAdd.add(new TrajectoryPoint((World)world, trajectoryPoint, false));
                    }
                    trajectoryPoint = new TrajectoryPoint((World)world, trajectoryPoint.translate(trajectoryPoint.directionForward), trajectoryPoint.directionForward);
                }
            }
            hashSet.clear();
            iterator = transferToAdd.iterator();
            while (iterator.hasNext()) {
                trajectoryPoint = trajectoryToAdd = (TrajectoryPoint)iterator.next();
                while (trajectoryPoint.hasNoMissingVoidShells() && this.isInRange(trajectoryPoint) && !this.trajectoryTransfer.containsKey(trajectoryPoint) && !trajectoryPoint.needsReevaluation()) {
                    if (WarpDriveConfig.LOGGING_ACCELERATOR) {
                        WarpDrive.logger.info(String.format("Adding transfer %s", trajectoryPoint));
                    }
                    trajectoryPointToAdd = trajectoryPoint.clone();
                    this.trajectoryTransfer.put(trajectoryPointToAdd, trajectoryPointToAdd);
                    trajectoryPoint = new TrajectoryPoint((World)world, trajectoryPoint, true);
                }
                if (!trajectoryPoint.needsReevaluation()) continue;
                trajectoryPoint = new TrajectoryPoint((World)world, trajectoryPoint.translate(trajectoryPoint.directionForward), trajectoryPoint.directionForward);
                hashSet.add(trajectoryPoint.clone());
                trajectoryPoint = new TrajectoryPoint((World)world, trajectoryPoint.translate(trajectoryPoint.directionBackward), trajectoryPoint.directionBackward);
                hashSet.add(trajectoryPoint);
            }
            transferToAdd.clear();
        }
    }

    private boolean isInRange(@Nonnull TrajectoryPoint trajectoryPoint) {
        double distanceSquared = trajectoryPoint.distance2To(this.getBlockPos());
        return distanceSquared <= 36864.0;
    }

    private void computeCountsAndBoundingBox() {
        boolean isFirst = true;
        for (TrajectoryPoint trajectoryPoint : this.trajectoryAccelerator.values()) {
            if (isFirst) {
                this.vMin = trajectoryPoint.getVectorI();
                this.vMax = trajectoryPoint.getVectorI();
                isFirst = false;
            }
            this.addToBoundingBox(trajectoryPoint, 2);
            int indexTier = (trajectoryPoint.type & 3) - 1;
            if ((trajectoryPoint.type & 4) != 0 && indexTier >= 0) {
                int n = indexTier;
                this.countMagnets[n] = this.countMagnets[n] + 2;
            }
            if ((trajectoryPoint.type & 8) != 0 && indexTier >= 0) {
                int n = indexTier;
                this.countMagnets[n] = this.countMagnets[n] + 2;
            }
            if ((trajectoryPoint.type & 0x30) != 0 && indexTier > 0) {
                int n = indexTier - 1;
                this.countMagnets[n] = this.countMagnets[n] + 12;
            }
            if ((trajectoryPoint.type & 0xC0) == 0 || indexTier >= 2) continue;
            int n = indexTier + 1;
            this.countMagnets[n] = this.countMagnets[n] + 12;
        }
        if (WarpDriveConfig.LOGGING_ACCELERATOR) {
            WarpDrive.logger.info(String.format("Bounding box is %s to %s", this.vMin, this.vMax));
        }
    }

    private void computeVectorArrays(@Nonnull WorldServer world) {
        Integer controlChannel;
        Boolean isEnabled;
        Integer tier;
        WarpDriveText textReason = new WarpDriveText();
        boolean isValid = true;
        for (TrajectoryPoint trajectoryPoint : this.trajectoryAccelerator.values()) {
            VectorI vectorI;
            Block blockForward;
            if (!trajectoryPoint.getStatus(textReason)) {
                this.setJammed.add(trajectoryPoint);
                isValid = false;
            }
            if ((blockForward = (vectorI = trajectoryPoint.clone(trajectoryPoint.directionForward.func_176734_d())).getBlock((IBlockAccess)world)) instanceof BlockParticlesInjector) {
                int controlChannel2 = ((TileEntityParticlesInjector)vectorI.getTileEntity((IBlockAccess)world)).getControlChannel();
                this.mapInjectors.put(controlChannel2, vectorI);
                this.addToBoundingBox(vectorI, 1);
            } else {
                VectorI vectorI2 = trajectoryPoint.clone(trajectoryPoint.directionBackward.func_176734_d());
                Block blockBackward = vectorI2.getBlock((IBlockAccess)world);
                if (blockBackward instanceof BlockParticlesInjector) {
                    int controlChannel3 = ((TileEntityParticlesInjector)vectorI2.getTileEntity((IBlockAccess)world)).getControlChannel();
                    this.mapInjectors.put(controlChannel3, vectorI2);
                    this.addToBoundingBox(vectorI2, 1);
                }
            }
            if (trajectoryPoint.vControlPoint != null) {
                this.controlPoints.put(trajectoryPoint.vControlPoint, trajectoryPoint.type);
                this.addToBoundingBox(trajectoryPoint.vControlPoint, 1);
                if (trajectoryPoint.isCollider()) {
                    this.listColliders.add(trajectoryPoint);
                }
            }
            if (trajectoryPoint.vControlPoint != null || (trajectoryPoint.type & 0xC) == 0) continue;
            this.scanCorners(world, trajectoryPoint, trajectoryPoint.directionForward);
            if (trajectoryPoint.directionForward == trajectoryPoint.directionBackward.func_176734_d()) continue;
            this.scanCorners(world, trajectoryPoint, trajectoryPoint.directionBackward);
        }
        if (this.mapInjectors.isEmpty()) {
            isValid = false;
            textReason.append(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.missing_injector", new Object[0]);
        }
        if (this.listColliders.isEmpty()) {
            isValid = false;
            textReason.append(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.missing_collider_node", new Object[0]);
        }
        if (this.countMagnets[2] > 0 && this.countChillers[2] == 0) {
            isValid = false;
            textReason.append(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.missing_superior_chiller", new Object[0]);
        } else if (this.countMagnets[1] > 0 && this.countChillers[1] == 0) {
            isValid = false;
            textReason.append(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.missing_advanced_chiller", new Object[0]);
        } else if (this.countMagnets[0] > 0 && this.countChillers[0] == 0) {
            isValid = false;
            textReason.append(Commons.getStyleWarning(), "warpdrive.accelerator.status_line.missing_basic_chiller", new Object[0]);
        }
        this.matrixControlPoints = new Object[this.controlPoints.size() + this.mapInjectors.size()][];
        int index = 0;
        for (Map.Entry<VectorI, Integer> entry : this.controlPoints.entrySet()) {
            tier = TrajectoryPoint.getTier(entry.getValue());
            String type = TrajectoryPoint.isCollider(entry.getValue()) ? "Collider" : (TrajectoryPoint.isOutput(entry.getValue()) ? "Output" : (TrajectoryPoint.isInput(entry.getValue()) ? "Input" : "?"));
            TileEntity tileEntity = world.func_175625_s(entry.getKey().getBlockPos());
            isEnabled = tileEntity instanceof TileEntityAcceleratorControlPoint && ((TileEntityAcceleratorControlPoint)tileEntity).getIsEnabled();
            controlChannel = tileEntity instanceof IControlChannel ? ((IControlChannel)tileEntity).getControlChannel() : -1;
            this.matrixControlPoints[index++] = new Object[]{entry.getKey().x, entry.getKey().y, entry.getKey().z, tier, type, isEnabled, controlChannel};
        }
        for (Map.Entry<Object, Object> entry : this.mapInjectors.entrySet()) {
            tier = 1;
            String type = "Injector";
            TileEntity tileEntity = world.func_175625_s(((VectorI)entry.getValue()).getBlockPos());
            isEnabled = tileEntity instanceof TileEntityParticlesInjector && ((TileEntityParticlesInjector)tileEntity).getIsEnabled();
            controlChannel = tileEntity instanceof IControlChannel ? ((IControlChannel)tileEntity).getControlChannel() : -1;
            this.matrixControlPoints[index++] = new Object[]{((VectorI)entry.getValue()).x, ((VectorI)entry.getValue()).y, ((VectorI)entry.getValue()).z, tier, "Injector", isEnabled, controlChannel};
        }
        this.isAssemblyValid = isValid;
        this.textValidityIssues = textReason;
    }

    private void scanCorners(@Nonnull WorldServer world, @Nonnull VectorI vCenter, @Nonnull EnumFacing forgeDirection) {
        EnumFacing directionLeft = forgeDirection.func_176735_f();
        EnumFacing directionRight = forgeDirection.func_176746_e();
        for (int indexCorner = 0; indexCorner < 4; ++indexCorner) {
            VectorI vector = new VectorI(vCenter.x + ((indexCorner & 1) != 0 ? directionLeft.func_82601_c() : directionRight.func_82601_c()), vCenter.y + ((indexCorner & 2) != 0 ? 1 : -1), vCenter.z + ((indexCorner & 1) != 0 ? directionLeft.func_82599_e() : directionRight.func_82599_e()));
            Block block = vector.getBlock((IBlockAccess)world);
            if (block instanceof BlockChiller) {
                EnumTier enumTier = ((BlockChiller)block).getTier(ItemStack.field_190927_a);
                this.setChillers.add(vector.getBlockPos());
                int n = enumTier.getIndex() - 1;
                this.countChillers[n] = this.countChillers[n] + 1;
                continue;
            }
            if (!(block instanceof BlockCapacitor)) continue;
            TileEntity tileEntity = vector.getTileEntity((IBlockAccess)world);
            if (tileEntity instanceof TileEntityCapacitor) {
                this.setCapacitors.add(vector.getBlockPos());
                continue;
            }
            WarpDrive.logger.error(String.format("Invalid tile entity detected for subspace capacitor at %s", vector));
        }
    }

    public int getMass() {
        if (this.trajectoryAccelerator == null) {
            return 0;
        }
        return this.trajectoryAccelerator.size() + this.trajectoryTransfer.size() + this.setCapacitors.size() + this.controlPoints.size() + this.countMagnets[0] + this.countMagnets[1] + this.countMagnets[2] + this.countChillers[0] + this.countChillers[1] + this.countChillers[2];
    }

    public boolean isMajorChange(AcceleratorSetup acceleratorSetup) {
        return acceleratorSetup == null || this.trajectoryAccelerator == null || acceleratorSetup.trajectoryAccelerator == null || this.trajectoryAccelerator.size() != acceleratorSetup.trajectoryAccelerator.size() || this.trajectoryTransfer.size() != acceleratorSetup.trajectoryTransfer.size() || this.countMagnets[0] != acceleratorSetup.countMagnets[0] || this.countMagnets[1] != acceleratorSetup.countMagnets[1] || this.countMagnets[2] != acceleratorSetup.countMagnets[2] || this.countChillers[0] != acceleratorSetup.countChillers[0] || this.countChillers[1] != acceleratorSetup.countChillers[1] || this.countChillers[2] != acceleratorSetup.countChillers[2];
    }

    public boolean isBlockUpdated(World world, VectorI vector, Block block) {
        Block blockConnected;
        boolean checkDirectConnection = false;
        boolean checkRangedConnection = false;
        boolean checkCornerConnection = false;
        if (block instanceof BlockChiller) {
            if (this.setChillers.contains(vector.getBlockPos())) {
                return true;
            }
            checkCornerConnection = true;
        } else if (block instanceof BlockVoidShellPlain) {
            if (this.isTrajectoryPoint(vector)) {
                return true;
            }
            checkDirectConnection = true;
        } else if (block instanceof BlockParticlesInjector) {
            checkDirectConnection = true;
        } else if (block instanceof BlockElectromagnetPlain) {
            checkDirectConnection = true;
            checkCornerConnection = true;
        } else if (block instanceof BlockParticlesCollider) {
            checkCornerConnection = true;
        } else if (block instanceof BlockAcceleratorControlPoint) {
            checkRangedConnection = true;
        } else if (block instanceof BlockCapacitor) {
            TileEntity tileEntity = vector.getTileEntity((IBlockAccess)world);
            if (tileEntity instanceof TileEntityCapacitor && this.setCapacitors.contains(vector.getBlockPos())) {
                return true;
            }
            checkCornerConnection = true;
        }
        if (checkDirectConnection || checkCornerConnection) {
            for (EnumFacing forgeDirection : EnumFacing.field_82609_l) {
                blockConnected = vector.translate(forgeDirection).getBlock((IBlockAccess)world);
                if (blockConnected instanceof BlockVoidShellPlain) {
                    if (!this.isTrajectoryPoint(vector)) continue;
                    return true;
                }
                if (!checkCornerConnection || !(blockConnected instanceof BlockElectromagnetPlain)) continue;
                for (EnumFacing forgeDirection2 : EnumFacing.field_82609_l) {
                    Block blockSubConnected = vector.translate(forgeDirection2).getBlock((IBlockAccess)world);
                    if (!(blockSubConnected instanceof BlockVoidShellPlain) || !this.isTrajectoryPoint(vector)) continue;
                    return true;
                }
            }
        }
        if (checkRangedConnection) {
            for (EnumFacing forgeDirection : EnumFacing.field_82609_l) {
                blockConnected = vector.translate(forgeDirection, 2).getBlock((IBlockAccess)world);
                if (!(blockConnected instanceof BlockVoidShellPlain) || !this.isTrajectoryPoint(vector)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isTrajectoryPoint(VectorI vectorI) {
        return this.trajectoryAccelerator.containsKey(vectorI) || this.trajectoryTransfer.containsKey(vectorI);
    }

    public TrajectoryPoint getTrajectoryPoint(VectorI vectorI) {
        TrajectoryPoint trajectoryPoint = this.trajectoryAccelerator.get(vectorI);
        if (trajectoryPoint != null) {
            return trajectoryPoint;
        }
        return this.trajectoryTransfer.get(vectorI);
    }

    public AxisAlignedBB getBoundingBox() {
        if (this.vMin == null || this.vMax == null) {
            return null;
        }
        return new AxisAlignedBB((double)this.vMin.x, (double)this.vMin.y, (double)this.vMin.z, (double)this.vMax.x, (double)this.vMax.y, (double)this.vMax.z);
    }

    public boolean isDirty() {
        if (this.trajectoryAccelerator == null) {
            return false;
        }
        return this.isDirty;
    }

    public boolean isAssemblyValid() {
        return this.isAssemblyValid;
    }

    public boolean getAssemblyStatus(@Nonnull WarpDriveText textReason) {
        textReason.append((ITextComponent)this.textValidityIssues);
        return this.isAssemblyValid;
    }

    @Override
    public boolean isLoaded() {
        return super.isLoaded() && this.isLoaded;
    }

    @Nonnull
    private HashSet<TileEntityCapacitor> getCapacitors() {
        HashSet<TileEntityCapacitor> setTileEntityCapacitors = new HashSet<TileEntityCapacitor>(this.setCapacitors.size());
        WorldServer world = this.getWorldServerIfLoaded();
        if (world == null) {
            WarpDrive.logger.warn(String.format("%s World is no longer loaded, please report to mod author", this));
            if (Commons.throttleMe("AcceleratorSetup.getCapacitors")) {
                new RuntimeException().printStackTrace(WarpDrive.printStreamWarn);
            }
            this.isLoaded = false;
            return setTileEntityCapacitors;
        }
        for (BlockPos blockPosCapacitor : this.setCapacitors) {
            TileEntity tileEntity = world.func_175625_s(blockPosCapacitor);
            if (tileEntity instanceof TileEntityCapacitor) {
                TileEntityCapacitor tileEntityCapacitor = (TileEntityCapacitor)tileEntity;
                tileEntityCapacitor.finishConstruction();
                setTileEntityCapacitors.add(tileEntityCapacitor);
                continue;
            }
            this.isDirty = true;
        }
        this.isLoaded = true;
        return setTileEntityCapacitors;
    }

    public long energy_getEnergyStored() {
        HashSet<TileEntityCapacitor> capacitors = this.getCapacitors();
        if (!this.isLoaded()) {
            return Integer.MAX_VALUE;
        }
        long energyStored = 0L;
        for (TileEntityCapacitor tileEntityCapacitor : capacitors) {
            energyStored += tileEntityCapacitor.energy_getEnergyStored();
        }
        return energyStored;
    }

    public int energy_getPotentialOutput() {
        HashSet<TileEntityCapacitor> capacitors = this.getCapacitors();
        if (!this.isLoaded()) {
            return Integer.MAX_VALUE;
        }
        long potentialOutput = 0L;
        for (TileEntityCapacitor tileEntityCapacitor : capacitors) {
            potentialOutput = Math.min(potentialOutput + (long)tileEntityCapacitor.energy_getPotentialOutput(), Integer.MAX_VALUE);
        }
        return (int)potentialOutput;
    }

    public int energy_getMaxStorage() {
        return this.energy_maxStorage;
    }

    public void energy_consume(int amount_internal) {
        int energyToConsume;
        assert (amount_internal > 0);
        assert (this.isLoaded);
        HashSet<TileEntityCapacitor> setTileEntityCapacitors = this.getCapacitors();
        int countCapacitors = setTileEntityCapacitors.size();
        assert (countCapacitors > 0);
        int energyMean = amount_internal / countCapacitors;
        int energyConsumed = 0;
        int energyLeft = amount_internal - energyMean * countCapacitors;
        for (TileEntityCapacitor tileEntityCapacitor : setTileEntityCapacitors) {
            energyToConsume = Math.min(tileEntityCapacitor.energy_getPotentialOutput(), energyMean + energyLeft);
            tileEntityCapacitor.energy_consume(energyToConsume);
            energyConsumed += energyToConsume;
            energyLeft += energyMean - energyToConsume;
        }
        if (energyConsumed + energyLeft != amount_internal) {
            if (Commons.throttleMe("AcceleratorSetup.energy_consume")) {
                WarpDrive.logger.error(String.format("Inconsistent accelerator energy consumption 1/2 amount %d count %d (%s) mean %d consumed %d left %d", amount_internal, countCapacitors, setTileEntityCapacitors.size(), energyMean, energyConsumed, energyLeft));
            }
            assert (false);
        }
        if (energyLeft > 0) {
            for (TileEntityCapacitor tileEntityCapacitor : setTileEntityCapacitors) {
                energyToConsume = Math.min(tileEntityCapacitor.energy_getPotentialOutput(), energyLeft);
                tileEntityCapacitor.energy_consume(energyToConsume);
                energyConsumed += energyToConsume;
                energyLeft -= energyToConsume;
            }
        }
        if (energyConsumed != amount_internal || energyLeft != 0) {
            if (Commons.throttleMe("AcceleratorSetup.energy_consume")) {
                WarpDrive.logger.error(String.format("Inconsistent accelerator energy consumption 2/2 amount %d count %d (%s) mean %d consumed %d left %d (0)", amount_internal, countCapacitors, setTileEntityCapacitors.size(), energyMean, energyConsumed, energyLeft));
            }
            assert (false);
        }
    }

    @Nonnull
    public Object[][] getControlPoints() {
        return this.matrixControlPoints;
    }

    @Override
    public String toString() {
        if (this.vMin == null || this.vMax == null) {
            return String.format("%s @ DIM%d (%d %d %d) (-null-) -> (-null)", this.getClass().getSimpleName(), this.dimensionId, this.x, this.y, this.z);
        }
        return String.format("%s @ DIM%d (%d %d %d) (%d %d %d) -> (%d %d %d)", this.getClass().getSimpleName(), this.dimensionId, this.x, this.y, this.z, this.vMin.x, this.vMin.y, this.vMin.z, this.vMax.x, this.vMax.y, this.vMax.z);
    }
}

