/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.CameraRegistryItem;
import cr0s.warpdrive.data.EnumCameraType;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CamerasRegistry {
    private LinkedList<CameraRegistryItem> registry = new LinkedList();

    public CameraRegistryItem getCameraByVideoChannel(World world, int videoChannel) {
        if (world == null) {
            return null;
        }
        Iterator it = this.registry.iterator();
        while (it.hasNext()) {
            CameraRegistryItem cam = (CameraRegistryItem)it.next();
            if (cam.videoChannel != videoChannel || cam.dimensionId != world.field_73011_w.getDimension()) continue;
            if (CamerasRegistry.isCamAlive(world, cam)) {
                return cam;
            }
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(String.format("Removing 'dead' camera %s (while searching)", Commons.format(world, cam.blockPos)));
            }
            it.remove();
        }
        this.printRegistry(world);
        return null;
    }

    private CameraRegistryItem getCamByPosition(World world, BlockPos blockPos) {
        for (CameraRegistryItem cam : this.registry) {
            if (cam.blockPos.func_177958_n() != blockPos.func_177958_n() || cam.blockPos.func_177956_o() != blockPos.func_177956_o() || cam.blockPos.func_177952_p() != blockPos.func_177952_p() || cam.dimensionId != world.field_73011_w.getDimension()) continue;
            return cam;
        }
        return null;
    }

    private static boolean isCamAlive(World world, CameraRegistryItem cam) {
        if (world.field_73011_w.getDimension() != cam.dimensionId) {
            WarpDrive.logger.error(String.format("Inconsistent world with camera %s: world %d vs cam %d", cam, world.field_73011_w.getDimension(), cam.dimensionId));
            return false;
        }
        if (!world.func_175726_f(cam.blockPos).func_177410_o()) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(String.format("Reporting an 'unloaded' camera %s", Commons.format(world, cam.blockPos)));
            }
            return false;
        }
        Block block = world.func_180495_p(cam.blockPos).func_177230_c();
        if (block != WarpDrive.blockCamera && block != WarpDrive.blockLaserCamera) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(String.format("Reporting a 'dead' camera %s", Commons.format(world, cam.blockPos)));
            }
            return false;
        }
        return true;
    }

    private void removeDeadCams(World world) {
        Iterator it = this.registry.iterator();
        while (it.hasNext()) {
            CameraRegistryItem cam = (CameraRegistryItem)it.next();
            if (CamerasRegistry.isCamAlive(world, cam)) continue;
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(String.format("Removing 'dead' camera %s", Commons.format(world, cam.blockPos)));
            }
            it.remove();
        }
    }

    public void removeFromRegistry(World world, BlockPos blockPos) {
        CameraRegistryItem cam = this.getCamByPosition(world, blockPos);
        if (cam != null) {
            if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                WarpDrive.logger.info(String.format("Removing camera by request %s", Commons.format(world, cam.blockPos)));
            }
            this.registry.remove(cam);
        }
    }

    public void updateInRegistry(World world, BlockPos blockPos, int videoChannel, EnumCameraType enumCameraType) {
        CameraRegistryItem cam = new CameraRegistryItem(world, blockPos, videoChannel, enumCameraType);
        this.removeDeadCams(world);
        if (CamerasRegistry.isCamAlive(world, cam)) {
            CameraRegistryItem existingCam = this.getCamByPosition(world, cam.blockPos);
            if (existingCam == null) {
                if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                    WarpDrive.logger.info(String.format("Adding 'live' camera %s with video channel %s", Commons.format(world, cam.blockPos), cam.videoChannel));
                }
                this.registry.add(cam);
            } else if (existingCam.videoChannel != cam.videoChannel) {
                if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
                    WarpDrive.logger.info(String.format("Updating 'live' camera %s from video channel %d to video channel %d", Commons.format(world, cam.blockPos), existingCam.videoChannel, cam.videoChannel));
                }
                existingCam.videoChannel = cam.videoChannel;
            }
        } else if (WarpDriveConfig.LOGGING_VIDEO_CHANNEL) {
            WarpDrive.logger.info(String.format("Unable to update 'dead' camera %s", Commons.format(world, cam.blockPos)));
        }
    }

    public void printRegistry(World world) {
        if (world == null) {
            return;
        }
        WarpDrive.logger.info(String.format("Cameras registry for %s:", Commons.format(world)));
        for (CameraRegistryItem cam : this.registry) {
            WarpDrive.logger.info(String.format("- %d (%d %d %d)", cam.videoChannel, cam.blockPos.func_177958_n(), cam.blockPos.func_177956_o(), cam.blockPos.func_177952_p()));
        }
    }
}

