/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.ExceptionChunkNotLoaded;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.AirSpreader;
import cr0s.warpdrive.data.StateAir;
import cr0s.warpdrive.event.ChunkHandler;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public class ChunkData {
    private static final String TAG_CHUNK_MOD_DATA = "warpdrive";
    private static final String TAG_VERSION = "version";
    private static final String TAG_AIR = "air";
    private static final String TAG_AIR_SEGMENT_DATA = "data";
    private static final String TAG_AIR_SEGMENT_DELAY = "delay";
    private static final String TAG_AIR_SEGMENT_Y = "y";
    private static final long RELOAD_DELAY_MIN_MS = 100L;
    private static final long LOAD_UNLOAD_DELAY_MIN_MS = 1000L;
    private static final long SAVE_SAVE_DELAY_MIN_MS = 100L;
    private static final int CHUNK_SIZE_SEGMENTS = 16;
    private static final int SEGMENT_SIZE_BLOCKS = 4096;
    private static final int INVALID_DATA_INDEX = 65407;
    private final int[][] dataAirSegments = new int[16][];
    private final byte[][] tickAirSegments = new byte[16][];
    private int tickCurrent = (int)(Math.random() * 4096.0);
    private final ChunkPos chunkCoordIntPair;
    private boolean isLoaded;
    public long timeLoaded;
    public long timeSaved;
    public long timeUnloaded;
    public boolean isModified;

    public ChunkData(int xChunk, int zChunk) {
        this.chunkCoordIntPair = new ChunkPos(xChunk, zChunk);
        this.isLoaded = false;
        this.timeLoaded = 0L;
        this.timeSaved = 0L;
        this.timeUnloaded = 0L;
    }

    public void load(NBTTagCompound tagCompoundChunk) {
        assert (!this.isLoaded);
        long time = System.currentTimeMillis();
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER && this.timeUnloaded != 0L && time - this.timeUnloaded < 100L) {
            WarpDrive.logger.warn(String.format("Chunk %s (%d %d %d) is reloading after only %d ms", this.chunkCoordIntPair, this.getChunkPosition().func_177958_n(), this.getChunkPosition().func_177956_o(), this.getChunkPosition().func_177952_p(), time - this.timeUnloaded));
        }
        Arrays.fill((Object[])this.dataAirSegments, null);
        Arrays.fill((Object[])this.tickAirSegments, null);
        this.isModified = false;
        if (tagCompoundChunk.func_74764_b(TAG_CHUNK_MOD_DATA)) {
            NBTTagCompound tagCompound = tagCompoundChunk.func_74775_l(TAG_CHUNK_MOD_DATA);
            int version = tagCompound.func_74762_e(TAG_VERSION);
            assert (version == 0 || version == 1);
            if (version == 1) {
                NBTTagList nbtTagList = tagCompound.func_150295_c(TAG_AIR, 10);
                if (nbtTagList.func_74745_c() != 16) {
                    if (nbtTagList.func_74745_c() != 0) {
                        WarpDrive.logger.error(String.format("Chunk %s (%d %d %d) loaded with invalid data, restoring default", this.chunkCoordIntPair, this.getChunkPosition().func_177958_n(), this.getChunkPosition().func_177956_o(), this.getChunkPosition().func_177952_p()));
                    }
                } else {
                    for (byte indexSegment = 0; indexSegment < 16; ++indexSegment) {
                        byte[] byteTick;
                        NBTTagCompound nbtTagCompoundInList = nbtTagList.func_150305_b((int)indexSegment);
                        int[] intData = nbtTagCompoundInList.func_74759_k(TAG_AIR_SEGMENT_DATA);
                        if (intData.length != 4096) {
                            if (intData.length == 0) continue;
                            WarpDrive.logger.error(String.format("Chunk %s (%d %d %d) loaded with invalid segment %d, restoring default", this.chunkCoordIntPair, this.getChunkPosition().func_177958_n(), this.getChunkPosition().func_177956_o(), this.getChunkPosition().func_177952_p(), (int)indexSegment));
                            continue;
                        }
                        byte indexRead = nbtTagCompoundInList.func_74771_c(TAG_AIR_SEGMENT_Y);
                        if (indexRead != indexSegment) {
                            WarpDrive.logger.error(String.format("Error while loading %s: bad index read %d expecting %d", this, (int)indexRead, (int)indexSegment));
                        }
                        if ((byteTick = nbtTagCompoundInList.func_74770_j(TAG_AIR_SEGMENT_DELAY)).length != 4096) {
                            byteTick = new byte[4096];
                            Arrays.fill(byteTick, (byte)0);
                        }
                        this.dataAirSegments[indexSegment] = new int[4096];
                        this.tickAirSegments[indexSegment] = new byte[4096];
                        for (int indexBlock = 0; indexBlock < 4096; ++indexBlock) {
                            this.dataAirSegments[indexSegment][indexBlock] = intData[indexBlock] & 0x77FFFF0F;
                            this.tickAirSegments[indexSegment][indexBlock] = (byte)(byteTick[indexBlock] & 0x7F);
                            if (!WarpDrive.isDev || !WarpDriveConfig.LOGGING_CHUNK_HANDLER || this.dataAirSegments[indexSegment][indexBlock] == 0) continue;
                            BlockPos chunkPosition = this.getPositionFromDataIndex(indexSegment, indexBlock);
                            WarpDrive.logger.info(String.format("Loading %s segment %2d index %4d (%d %d %d) 0x%8x", this, (int)indexSegment, indexBlock, chunkPosition.func_177958_n(), chunkPosition.func_177956_o(), chunkPosition.func_177952_p(), this.dataAirSegments[indexSegment][indexBlock]));
                        }
                    }
                }
            }
        }
        this.timeLoaded = time;
        this.isLoaded = true;
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER) {
            WarpDrive.logger.info(String.format("Chunk %s (%d %d %d) is now loaded", this.chunkCoordIntPair, this.getChunkPosition().func_177958_n(), this.getChunkPosition().func_177956_o(), this.getChunkPosition().func_177952_p()));
        }
    }

    public void onBlockUpdated(int x, int y, int z) {
        int indexData = this.getDataIndex(x, y, z);
        int[] dataAirSegment = this.dataAirSegments[indexData >> 12];
        if (dataAirSegment == null) {
            return;
        }
        dataAirSegment[indexData & 0xFFF] = dataAirSegment[indexData & 0xFFF] & 0x8FFFFFFF;
        byte[] tickAirSegment = this.tickAirSegments[indexData >> 12];
        byte tickAir = tickAirSegment[indexData & 0xFFF];
        int delay = 128 + tickAir - this.tickCurrent & 0x7F;
        if (delay > 15 && delay != WarpDriveConfig.BREATHING_AIR_SIMULATION_DELAY_TICKS + (dataAirSegment[indexData & 0xFFF] & 0x1F)) {
            tickAirSegment[indexData & 0xFFF] = (byte)(this.tickCurrent + delay & 0xF & 0x7F);
        }
    }

    public void save(NBTTagCompound tagCompoundChunk) {
        this.isModified = false;
        long time = System.currentTimeMillis();
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER && this.isLoaded && this.timeSaved != 0L && time - this.timeSaved < 100L) {
            WarpDrive.logger.warn(String.format("Chunk %s (%d %d %d) is saving after only %d ms", this.chunkCoordIntPair, this.getChunkPosition().func_177958_n(), this.getChunkPosition().func_177956_o(), this.getChunkPosition().func_177952_p(), time - this.timeSaved));
        }
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompoundChunk.func_74782_a(TAG_CHUNK_MOD_DATA, (NBTBase)tagCompound);
        tagCompound.func_74768_a(TAG_VERSION, 1);
        NBTTagList nbtTagList = new NBTTagList();
        int countEmptySegments = 0;
        int[] intData = new int[4096];
        byte[] byteTick = new byte[4096];
        for (int indexSegment = 0; indexSegment < 16; ++indexSegment) {
            NBTTagCompound tagCompoundInList = new NBTTagCompound();
            if (this.dataAirSegments[indexSegment] != null) {
                int countEmptyBlocks = 0;
                for (int indexBlock = 0; indexBlock < 4096; ++indexBlock) {
                    int dataAir = this.dataAirSegments[indexSegment][indexBlock];
                    if (StateAir.isEmptyData(dataAir)) {
                        ++countEmptyBlocks;
                        intData[indexBlock] = 0x60000C0;
                        byteTick[indexBlock] = 0;
                        continue;
                    }
                    intData[indexBlock] = dataAir;
                    byteTick[indexBlock] = this.tickAirSegments[indexSegment][indexBlock];
                    if (!WarpDrive.isDev || !WarpDriveConfig.LOGGING_CHUNK_HANDLER) continue;
                    BlockPos chunkPosition = this.getPositionFromDataIndex(indexSegment, indexBlock);
                    WarpDrive.logger.info(String.format("Saving %s segment %2d index %4d (%d %d %d) 0x%8x", this, indexSegment, indexBlock, chunkPosition.func_177958_n(), chunkPosition.func_177956_o(), chunkPosition.func_177952_p(), dataAir));
                }
                if (countEmptyBlocks == 4096) {
                    ++countEmptySegments;
                } else {
                    tagCompoundInList.func_74783_a(TAG_AIR_SEGMENT_DATA, (int[])intData.clone());
                    tagCompoundInList.func_74773_a(TAG_AIR_SEGMENT_DELAY, (byte[])byteTick.clone());
                    tagCompoundInList.func_74774_a(TAG_AIR_SEGMENT_Y, (byte)indexSegment);
                }
            } else {
                ++countEmptySegments;
            }
            nbtTagList.func_74742_a((NBTBase)tagCompoundInList);
        }
        if (countEmptySegments != 16) {
            tagCompound.func_74782_a(TAG_AIR, (NBTBase)nbtTagList);
        }
        this.timeSaved = time;
    }

    public void unload() {
        if (!this.isLoaded && this.timeUnloaded != 0L) {
            if (this.timeLoaded != 0L) {
                WarpDrive.logger.warn(String.format("Chunk %s (%d %d %d) is already unloaded, timings are loaded %d saved %d unloaded %d", this.chunkCoordIntPair, this.getChunkPosition().func_177958_n(), this.getChunkPosition().func_177956_o(), this.getChunkPosition().func_177952_p(), this.timeLoaded, this.timeSaved, this.timeUnloaded));
            }
            return;
        }
        long time = System.currentTimeMillis();
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER && this.timeUnloaded != 0L && time - this.timeUnloaded < 1000L) {
            WarpDrive.logger.warn(String.format("Chunk %s (%d %d %d) is unloading after only %d ms", this.chunkCoordIntPair, this.getChunkPosition().func_177958_n(), this.getChunkPosition().func_177956_o(), this.getChunkPosition().func_177952_p(), time - this.timeUnloaded));
        }
        this.timeUnloaded = time;
        this.isLoaded = false;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public ChunkPos getChunkCoords() {
        return this.chunkCoordIntPair;
    }

    public BlockPos getChunkPosition() {
        return this.chunkCoordIntPair.func_180331_a(8, 128, 8);
    }

    protected boolean isInside(int x, int y, int z) {
        int xInChunk = x - (this.chunkCoordIntPair.field_77276_a << 4);
        int zInChunk = z - (this.chunkCoordIntPair.field_77275_b << 4);
        return xInChunk >= 0 && xInChunk <= 15 && zInChunk >= 0 && zInChunk <= 15;
    }

    private int getDataIndex(int x, int y, int z) {
        int xInChunk = x - (this.chunkCoordIntPair.field_77276_a << 4);
        int yInChunk = Commons.clamp(0, 255, y);
        int zInChunk = z - (this.chunkCoordIntPair.field_77275_b << 4);
        if (xInChunk < 0 || xInChunk > 15 || zInChunk < 0 || zInChunk > 15) {
            WarpDrive.logger.error(String.format("Invalid block position provided (%d %d %d) is outside of chunk %s at (%d %d %d)", x, y, z, this.chunkCoordIntPair, this.getChunkPosition().func_177958_n(), this.getChunkPosition().func_177956_o(), this.getChunkPosition().func_177952_p()));
            return 65407;
        }
        return yInChunk << 8 | xInChunk << 4 | zInChunk;
    }

    private BlockPos getPositionFromDataIndex(int indexSegment, int indexBlock) {
        int x = (this.chunkCoordIntPair.field_77276_a << 4) + ((indexBlock & 0xF0) >> 4);
        int y = (indexSegment << 4) + ((indexBlock & 0xF00) >> 8);
        int z = (this.chunkCoordIntPair.field_77275_b << 4) + (indexBlock & 0xF);
        return new BlockPos(x, y, z);
    }

    public int getDataAir(int x, int y, int z) {
        int[] dataAirSegment;
        int indexData = this.getDataIndex(x, y, z);
        if (WarpDrive.isDev) {
            BlockPos chunkPosition = this.getPositionFromDataIndex(indexData >> 12, indexData & 0xFFF);
            assert (chunkPosition.func_177958_n() == x && chunkPosition.func_177956_o() == y && chunkPosition.func_177952_p() == z);
        }
        if ((dataAirSegment = this.dataAirSegments[indexData >> 12]) == null) {
            return 0x60000C0;
        }
        return dataAirSegment[indexData & 0xFFF];
    }

    public void setDataAir(int x, int y, int z, int dataAirBlock) {
        if (y < 0 || y > 255) {
            return;
        }
        int indexData = this.getDataIndex(x, y, z);
        int[] dataAirSegment = this.dataAirSegments[indexData >> 12];
        byte[] tickAirSegment = this.tickAirSegments[indexData >> 12];
        if (dataAirSegment == null) {
            if (StateAir.isEmptyData(dataAirBlock)) {
                return;
            }
            dataAirSegment = new int[4096];
            this.dataAirSegments[indexData >> 12] = dataAirSegment;
            tickAirSegment = new byte[4096];
            this.tickAirSegments[indexData >> 12] = tickAirSegment;
            this.isModified = true;
        }
        if (dataAirSegment[indexData & 0xFFF] != dataAirBlock) {
            dataAirSegment[indexData & 0xFFF] = dataAirBlock;
            this.isModified = true;
        }
        byte delay = (byte)(WarpDriveConfig.BREATHING_AIR_SIMULATION_DELAY_TICKS + (dataAirBlock & 0x1F));
        tickAirSegment[indexData & 0xFFF] = (byte)(this.tickCurrent + delay & 0x7F);
    }

    public StateAir getStateAir(World world, int x, int y, int z) throws ExceptionChunkNotLoaded {
        StateAir stateAir = new StateAir(this);
        stateAir.refresh(world, x, y, z);
        return stateAir;
    }

    public boolean hasAir() {
        if (this.dataAirSegments == null) {
            return false;
        }
        for (int[] dataAirSegment : this.dataAirSegments) {
            if (dataAirSegment == null) continue;
            for (int dataAirBlock : dataAirSegment) {
                if ((dataAirBlock & 0x1F) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNotEmpty() {
        if (this.dataAirSegments == null) {
            return false;
        }
        for (int[] dataAirSegment : this.dataAirSegments) {
            if (dataAirSegment == null) continue;
            for (int dataAirBlock : dataAirSegment) {
                if (StateAir.isEmptyData(dataAirBlock)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateTick(@Nonnull World world) {
        if (this.dataAirSegments == null) {
            return;
        }
        this.tickCurrent = this.tickCurrent + 1 & 0xFF;
        int countBlocks = 0;
        int countTickingBlocks = 0;
        for (int indexSegment = 0; indexSegment < 16; ++indexSegment) {
            int[] dataAirSegment = this.dataAirSegments[indexSegment];
            byte[] tickAirSegment = this.tickAirSegments[indexSegment];
            if (dataAirSegment == null) continue;
            int countEmpty = 0;
            countBlocks += dataAirSegment.length;
            for (int indexBlock = 0; indexBlock < 4096; ++indexBlock) {
                int dataAirBlock = dataAirSegment[indexBlock];
                byte tickAirBlock = tickAirSegment[indexBlock];
                if (StateAir.isEmptyData(dataAirBlock)) {
                    ++countEmpty;
                    continue;
                }
                if ((this.tickCurrent & 0x7F) != tickAirBlock) continue;
                ++countTickingBlocks;
                int x = (this.chunkCoordIntPair.field_77276_a << 4) + ((indexBlock & 0xF0) >> 4);
                int y = (indexSegment << 4) + ((indexBlock & 0xF00) >> 8);
                int z = (this.chunkCoordIntPair.field_77275_b << 4) + (indexBlock & 0xF);
                try {
                    AirSpreader.execute(world, x, y, z);
                    continue;
                }
                catch (ExceptionChunkNotLoaded exceptionChunkNotLoaded) {
                    if (!WarpDriveConfig.LOGGING_CHUNK_HANDLER) continue;
                    WarpDrive.logger.error(exceptionChunkNotLoaded.getMessage());
                }
            }
            if (countEmpty != dataAirSegment.length) continue;
            this.dataAirSegments[indexSegment] = null;
            this.tickAirSegments[indexSegment] = null;
        }
        AirSpreader.clearCache();
        if (this.isModified) {
            this.isModified = false;
            world.func_72964_e(this.chunkCoordIntPair.field_77276_a, this.chunkCoordIntPair.field_77275_b).func_76630_e();
        }
        if (WarpDriveConfig.LOGGING_CHUNK_HANDLER && ChunkHandler.delayLogging == 0L && countBlocks != 0) {
            WarpDrive.logger.info(String.format("Dimension %d chunk (%d %d) had %d / %d blocks ticked", world.field_73011_w.getDimension(), this.chunkCoordIntPair.field_77276_a, this.chunkCoordIntPair.field_77275_b, countTickingBlocks, countBlocks));
        }
    }

    public int hashCode() {
        return this.chunkCoordIntPair.field_77276_a & 0xFFFF | (this.chunkCoordIntPair.field_77275_b & 0xFFFF) << 16;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ChunkData)) {
            return false;
        }
        ChunkData chunkData = (ChunkData)object;
        return this.chunkCoordIntPair.field_77276_a == chunkData.chunkCoordIntPair.field_77276_a && this.chunkCoordIntPair.field_77275_b == chunkData.chunkCoordIntPair.field_77275_b;
    }

    public String toString() {
        BlockPos chunkPosition = this.getChunkPosition();
        return String.format("%s (%d %d @ %d %d %d) isLoaded %s hasAir %s isNotEmpty %s )", this.getClass().getSimpleName(), this.chunkCoordIntPair.field_77276_a, this.chunkCoordIntPair.field_77275_b, chunkPosition.func_177958_n(), chunkPosition.func_177956_o(), chunkPosition.func_177952_p(), this.isLoaded, this.hasAir(), this.isNotEmpty());
    }
}

