/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cofh.redstoneflux.api.IEnergyContainerItem;
import cr0s.warpdrive.Commons;
import cr0s.warpdrive.api.WarpDriveText;
import cr0s.warpdrive.config.WarpDriveConfig;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IElectricItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

public class EnergyWrapper {
    public static final String TAG_DISPLAY_UNITS = "displayUnits";
    public static final String TAG_ENERGY = "energy";
    public static final double EU_PER_INTERNAL = 1.0;
    public static final double GT_PER_INTERNAL = 1.0;
    public static final double RF_PER_INTERNAL = 4.114285714285714;
    public static final String[] EU_nameTier = new String[]{"ULV", "LV", "MV", "HV", "EV", "IV", "LuV", "ZPMV", "UV", "MaxV"};

    public static int EU_getTierByName(@Nonnull String nameTier) {
        for (int tier = 0; tier < EU_nameTier.length; ++tier) {
            if (!nameTier.equals(EU_nameTier[tier])) continue;
            return tier;
        }
        return -1;
    }

    public static int convertInternalToRF_ceil(long energy) {
        return (int)Math.ceil((double)energy * 4.114285714285714);
    }

    public static int convertInternalToRF_floor(long energy) {
        return (int)Math.floor((double)energy * 4.114285714285714);
    }

    public static long convertRFtoInternal_ceil(int energy) {
        return (long)Math.ceil((double)energy / 4.114285714285714);
    }

    public static long convertRFtoInternal_floor(int energy) {
        return (long)Math.floor((double)energy / 4.114285714285714);
    }

    public static long convertInternalToGT_ceil(long energy) {
        return (long)Math.ceil((double)energy * 1.0);
    }

    public static long convertInternalToGT_floor(long energy) {
        return (long)Math.floor((double)energy * 1.0);
    }

    public static long convertGTtoInternal_ceil(double amount) {
        return (long)Math.ceil(amount / 1.0);
    }

    public static long convertGTtoInternal_floor(double amount) {
        return (long)Math.floor(amount / 1.0);
    }

    public static double convertInternalToEU_ceil(long energy) {
        return Math.ceil((double)energy * 1.0);
    }

    public static double convertInternalToEU_floor(long energy) {
        return Math.floor((double)energy * 1.0);
    }

    public static long convertEUtoInternal_ceil(double amount) {
        return (long)Math.ceil(amount / 1.0);
    }

    public static long convertEUtoInternal_floor(double amount) {
        return (long)Math.floor(amount / 1.0);
    }

    public static String format(long energy, String units) {
        return Commons.format(EnergyWrapper.convert(energy, units));
    }

    public static void formatAndAppendCharge(@Nonnull WarpDriveText warpDriveText, long energyStored, long maxStorage, String units) {
        String unitsToUse = units == null ? WarpDriveConfig.ENERGY_DISPLAY_UNITS : units;
        String energyStored_units = EnergyWrapper.format(energyStored, unitsToUse);
        String energyMaxStorage_units = EnergyWrapper.format(maxStorage, unitsToUse);
        WarpDriveText textRate = new WarpDriveText(null, "warpdrive.energy.status_line.charge", new Object[0]).appendInLine(null, " ", new Object[0]).appendInLine(Commons.getStyleValue(), energyStored_units, new Object[0]).appendInLine(null, " / ", new Object[0]).appendInLine(Commons.getStyleValue(), energyMaxStorage_units, new Object[0]).appendInLine(null, String.format(" %s.", unitsToUse), new Object[0]);
        warpDriveText.append((ITextComponent)textRate);
    }

    public static void formatAndAppendInputRate(@Nonnull WarpDriveText warpDriveText, long amperage, long voltage, int tier, long fluxRate, String units) {
        EnergyWrapper.formatAndAppendRate(warpDriveText, "warpdrive.energy.status_line.input_rate", amperage, voltage, tier, fluxRate, units);
    }

    public static void formatAndAppendOutputRate(@Nonnull WarpDriveText warpDriveText, long amperage, long voltage, int tier, long fluxRate, String units) {
        EnergyWrapper.formatAndAppendRate(warpDriveText, "warpdrive.energy.status_line.output_rate", amperage, voltage, tier, fluxRate, units);
    }

    public static long convert(long energy, String units) {
        String unitsToUse;
        switch (unitsToUse = units == null ? WarpDriveConfig.ENERGY_DISPLAY_UNITS : units) {
            case "EU": {
                return (long)EnergyWrapper.convertInternalToEU_floor(energy);
            }
            case "RF": 
            case "FE": 
            case "\u0230I": 
            case "\u00b5I": {
                return EnergyWrapper.convertInternalToRF_floor(energy);
            }
        }
        return energy;
    }

    private static void formatAndAppendRate(@Nonnull WarpDriveText warpDriveText, @Nonnull String translationKey, long amperage, long voltage, int tier, long fluxRate, String units) {
        String unitsToUse;
        switch (unitsToUse = units == null ? WarpDriveConfig.ENERGY_DISPLAY_UNITS : units) {
            case "EU": {
                EnergyWrapper.formatAndAppendRate(warpDriveText, translationKey, amperage, voltage, tier, unitsToUse);
                break;
            }
            case "RF": 
            case "FE": 
            case "\u0230I": 
            case "\u00b5I": {
                EnergyWrapper.formatAndAppendRate(warpDriveText, translationKey, 6L, fluxRate, tier, unitsToUse);
                break;
            }
        }
    }

    private static void formatAndAppendRate(@Nonnull WarpDriveText warpDriveText, @Nonnull String translationKey, long amperage, long voltage, int tier, @Nonnull String units) {
        WarpDriveText textRate = new WarpDriveText(null, translationKey, new Object[0]).appendInLine(null, " ", new Object[0]).appendInLine(Commons.getStyleValue(), amperage).appendInLine(null, " x ", new Object[0]).appendInLine(Commons.getStyleVoltage(), voltage).appendInLine(null, String.format(" %s/t (", units), new Object[0]).appendInLine(Commons.getStyleVoltage(), EU_nameTier[tier], new Object[0]).appendInLine(null, ").", new Object[0]);
        warpDriveText.append((ITextComponent)textRate);
    }

    public static boolean isEnergyContainer(ItemStack itemStack) {
        boolean bResult = false;
        if (WarpDriveConfig.ENERGY_ENABLE_IC2_EU && WarpDriveConfig.isIndustrialCraft2Loaded) {
            bResult = EnergyWrapper.IC2_isEnergyContainer(itemStack);
        }
        if (!bResult && WarpDriveConfig.ENERGY_ENABLE_GTCE_EU && WarpDriveConfig.isGregtechLoaded) {
            bResult = EnergyWrapper.GT_isEnergyContainer(itemStack);
        }
        if (!bResult && WarpDriveConfig.ENERGY_ENABLE_RF && WarpDriveConfig.isRedstoneFluxLoaded) {
            bResult = EnergyWrapper.RF_isEnergyContainer(itemStack);
        }
        if (!bResult && WarpDriveConfig.ENERGY_ENABLE_FE) {
            bResult = EnergyWrapper.FE_isEnergyContainer(itemStack);
        }
        return bResult;
    }

    public static boolean canInput(ItemStack itemStack) {
        boolean bResult = false;
        if (WarpDriveConfig.ENERGY_ENABLE_IC2_EU && WarpDriveConfig.isIndustrialCraft2Loaded && EnergyWrapper.IC2_isEnergyContainer(itemStack)) {
            bResult = EnergyWrapper.IC2_canInput(itemStack);
        }
        if (WarpDriveConfig.ENERGY_ENABLE_GTCE_EU && WarpDriveConfig.isGregtechLoaded && EnergyWrapper.GT_isEnergyContainer(itemStack)) {
            bResult = EnergyWrapper.GT_canInput(itemStack);
        }
        if (!bResult && WarpDriveConfig.ENERGY_ENABLE_RF && WarpDriveConfig.isRedstoneFluxLoaded && EnergyWrapper.RF_isEnergyContainer(itemStack)) {
            bResult = EnergyWrapper.RF_canInput(itemStack);
        }
        if (!bResult && WarpDriveConfig.ENERGY_ENABLE_FE && EnergyWrapper.FE_isEnergyContainer(itemStack)) {
            bResult = EnergyWrapper.FE_canInput(itemStack);
        }
        return bResult;
    }

    public static boolean canOutput(ItemStack itemStack) {
        boolean bResult = false;
        if (WarpDriveConfig.ENERGY_ENABLE_IC2_EU && WarpDriveConfig.isIndustrialCraft2Loaded && EnergyWrapper.IC2_isEnergyContainer(itemStack)) {
            bResult = EnergyWrapper.IC2_canOutput(itemStack);
        }
        if (WarpDriveConfig.ENERGY_ENABLE_GTCE_EU && WarpDriveConfig.isGregtechLoaded && EnergyWrapper.GT_isEnergyContainer(itemStack)) {
            bResult = EnergyWrapper.GT_canOutput(itemStack);
        }
        if (!bResult && WarpDriveConfig.ENERGY_ENABLE_RF && WarpDriveConfig.isRedstoneFluxLoaded && EnergyWrapper.RF_isEnergyContainer(itemStack)) {
            bResult = EnergyWrapper.RF_canOutput(itemStack);
        }
        if (!bResult && WarpDriveConfig.ENERGY_ENABLE_FE && EnergyWrapper.FE_isEnergyContainer(itemStack)) {
            bResult = EnergyWrapper.FE_canOutput(itemStack);
        }
        return bResult;
    }

    public static long getEnergyStored(ItemStack itemStack) {
        if (WarpDriveConfig.ENERGY_ENABLE_IC2_EU && WarpDriveConfig.isIndustrialCraft2Loaded && EnergyWrapper.IC2_isEnergyContainer(itemStack)) {
            double amount_EU = Commons.clamp(0.0, EnergyWrapper.IC2_getMaxEnergyStorage(itemStack), EnergyWrapper.IC2_getEnergyStored(itemStack));
            return EnergyWrapper.convertEUtoInternal_floor(amount_EU);
        }
        if (WarpDriveConfig.ENERGY_ENABLE_GTCE_EU && WarpDriveConfig.isGregtechLoaded && EnergyWrapper.GT_isEnergyContainer(itemStack)) {
            long amount_EU = Commons.clamp(0L, EnergyWrapper.GT_getMaxEnergyStorage(itemStack), EnergyWrapper.GT_getEnergyStored(itemStack));
            return EnergyWrapper.convertGTtoInternal_floor(amount_EU);
        }
        if (WarpDriveConfig.ENERGY_ENABLE_RF && WarpDriveConfig.isRedstoneFluxLoaded && EnergyWrapper.RF_isEnergyContainer(itemStack)) {
            int amount_RF = Commons.clamp(0, EnergyWrapper.RF_getMaxEnergyStorage(itemStack), EnergyWrapper.RF_getEnergyStored(itemStack));
            return EnergyWrapper.convertRFtoInternal_floor(amount_RF);
        }
        if (WarpDriveConfig.ENERGY_ENABLE_FE && WarpDriveConfig.isRedstoneFluxLoaded && EnergyWrapper.FE_isEnergyContainer(itemStack)) {
            int amount_RF = Commons.clamp(0, EnergyWrapper.FE_getMaxEnergyStorage(itemStack), EnergyWrapper.FE_getEnergyStored(itemStack));
            return EnergyWrapper.convertRFtoInternal_floor(amount_RF);
        }
        return 0L;
    }

    public static long getMaxEnergyStorage(ItemStack itemStack) {
        if (WarpDriveConfig.ENERGY_ENABLE_IC2_EU && WarpDriveConfig.isIndustrialCraft2Loaded && EnergyWrapper.IC2_isEnergyContainer(itemStack)) {
            double amount_EU = EnergyWrapper.IC2_getMaxEnergyStorage(itemStack);
            return EnergyWrapper.convertEUtoInternal_floor(amount_EU);
        }
        if (WarpDriveConfig.ENERGY_ENABLE_GTCE_EU && WarpDriveConfig.isGregtechLoaded && EnergyWrapper.GT_isEnergyContainer(itemStack)) {
            long amount_EU = EnergyWrapper.GT_getMaxEnergyStorage(itemStack);
            return EnergyWrapper.convertGTtoInternal_floor(amount_EU);
        }
        if (WarpDriveConfig.ENERGY_ENABLE_RF && WarpDriveConfig.isRedstoneFluxLoaded && EnergyWrapper.RF_isEnergyContainer(itemStack)) {
            int amount_RF = EnergyWrapper.RF_getMaxEnergyStorage(itemStack);
            return EnergyWrapper.convertRFtoInternal_floor(amount_RF);
        }
        if (WarpDriveConfig.ENERGY_ENABLE_FE && EnergyWrapper.FE_isEnergyContainer(itemStack)) {
            int amount_RF = EnergyWrapper.FE_getMaxEnergyStorage(itemStack);
            return EnergyWrapper.convertRFtoInternal_floor(amount_RF);
        }
        return 0L;
    }

    public static int consume(ItemStack itemStack, int amount, boolean simulate) {
        if (WarpDriveConfig.ENERGY_ENABLE_IC2_EU && WarpDriveConfig.isIndustrialCraft2Loaded && EnergyWrapper.IC2_isEnergyContainer(itemStack)) {
            double amount_EU = EnergyWrapper.convertInternalToEU_ceil(amount);
            return (int)EnergyWrapper.convertEUtoInternal_floor(EnergyWrapper.IC2_consume(itemStack, amount_EU, simulate));
        }
        if (WarpDriveConfig.ENERGY_ENABLE_GTCE_EU && WarpDriveConfig.isGregtechLoaded && EnergyWrapper.GT_isEnergyContainer(itemStack)) {
            long amount_EU = EnergyWrapper.convertInternalToGT_ceil(amount);
            return (int)EnergyWrapper.convertGTtoInternal_floor(EnergyWrapper.GT_consume(itemStack, amount_EU, simulate));
        }
        if (WarpDriveConfig.ENERGY_ENABLE_RF && WarpDriveConfig.isRedstoneFluxLoaded && EnergyWrapper.RF_isEnergyContainer(itemStack)) {
            int amount_RF = EnergyWrapper.convertInternalToRF_ceil(amount);
            return (int)EnergyWrapper.convertRFtoInternal_floor(EnergyWrapper.RF_consume(itemStack, amount_RF, simulate));
        }
        if (WarpDriveConfig.ENERGY_ENABLE_FE && EnergyWrapper.FE_isEnergyContainer(itemStack)) {
            int amount_RF = EnergyWrapper.convertInternalToRF_ceil(amount);
            return (int)EnergyWrapper.convertRFtoInternal_floor(EnergyWrapper.FE_consume(itemStack, amount_RF, simulate));
        }
        return 0;
    }

    public static long charge(ItemStack itemStack, int amount, boolean simulate) {
        if (WarpDriveConfig.ENERGY_ENABLE_IC2_EU && WarpDriveConfig.isIndustrialCraft2Loaded && EnergyWrapper.IC2_isEnergyContainer(itemStack)) {
            double amount_EU = EnergyWrapper.convertInternalToEU_floor(amount);
            return EnergyWrapper.convertEUtoInternal_ceil(EnergyWrapper.IC2_charge(itemStack, amount_EU, simulate));
        }
        if (WarpDriveConfig.ENERGY_ENABLE_GTCE_EU && WarpDriveConfig.isGregtechLoaded && EnergyWrapper.GT_isEnergyContainer(itemStack)) {
            long amount_EU = EnergyWrapper.convertInternalToGT_floor(amount);
            return EnergyWrapper.convertEUtoInternal_ceil(EnergyWrapper.GT_charge(itemStack, amount_EU, simulate));
        }
        if (WarpDriveConfig.ENERGY_ENABLE_RF && WarpDriveConfig.isRedstoneFluxLoaded && EnergyWrapper.RF_isEnergyContainer(itemStack)) {
            int amount_RF = EnergyWrapper.convertInternalToRF_floor(amount);
            return EnergyWrapper.convertRFtoInternal_ceil(EnergyWrapper.RF_charge(itemStack, amount_RF, simulate));
        }
        if (WarpDriveConfig.ENERGY_ENABLE_FE && EnergyWrapper.FE_isEnergyContainer(itemStack)) {
            int amount_RF = EnergyWrapper.convertInternalToRF_floor(amount);
            return EnergyWrapper.convertRFtoInternal_ceil(EnergyWrapper.FE_charge(itemStack, amount_RF, simulate));
        }
        return 0L;
    }

    @Optional.Method(modid="ic2")
    private static IElectricItemManager IC2_getManager(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        if (item instanceof ISpecialElectricItem) {
            return ((ISpecialElectricItem)item).getManager(itemStack);
        }
        if (item instanceof ic2.api.item.IElectricItem) {
            return ElectricItem.rawManager;
        }
        return ElectricItem.getBackupManager((ItemStack)itemStack);
    }

    @Optional.Method(modid="ic2")
    private static boolean IC2_isEnergyContainer(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ic2.api.item.IElectricItem;
    }

    @Optional.Method(modid="ic2")
    private static boolean IC2_canOutput(ItemStack itemStack) {
        return ((ic2.api.item.IElectricItem)itemStack.func_77973_b()).canProvideEnergy(itemStack);
    }

    @Optional.Method(modid="ic2")
    private static boolean IC2_canInput(ItemStack itemStack) {
        IElectricItemManager electricItemManager = EnergyWrapper.IC2_getManager(itemStack);
        if (electricItemManager == null) {
            return false;
        }
        return electricItemManager.getCharge(itemStack) < EnergyWrapper.IC2_getMaxEnergyStorage(itemStack);
    }

    @Optional.Method(modid="ic2")
    private static double IC2_getEnergyStored(ItemStack itemStack) {
        IElectricItemManager electricItemManager = EnergyWrapper.IC2_getManager(itemStack);
        if (electricItemManager == null) {
            return 0.0;
        }
        return electricItemManager.getCharge(itemStack);
    }

    @Optional.Method(modid="ic2")
    private static double IC2_getMaxEnergyStorage(ItemStack itemStack) {
        return ((ic2.api.item.IElectricItem)itemStack.func_77973_b()).getMaxCharge(itemStack);
    }

    @Optional.Method(modid="ic2")
    private static double IC2_consume(ItemStack itemStack, double amount_EU, boolean simulate) {
        IElectricItemManager electricItemManager = EnergyWrapper.IC2_getManager(itemStack);
        if (electricItemManager == null) {
            return 0.0;
        }
        if (amount_EU <= electricItemManager.getCharge(itemStack)) {
            if (!simulate) {
                return electricItemManager.discharge(itemStack, amount_EU, ((ic2.api.item.IElectricItem)itemStack.func_77973_b()).getTier(itemStack), true, true, simulate);
            }
            return amount_EU;
        }
        return 0.0;
    }

    @Optional.Method(modid="ic2")
    private static double IC2_charge(ItemStack itemStack, double amount_EU, boolean simulate) {
        IElectricItemManager electricItemManager = EnergyWrapper.IC2_getManager(itemStack);
        if (electricItemManager == null) {
            return 0.0;
        }
        if (electricItemManager.getCharge(itemStack) < EnergyWrapper.IC2_getMaxEnergyStorage(itemStack)) {
            if (!simulate) {
                return electricItemManager.charge(itemStack, amount_EU, ((ic2.api.item.IElectricItem)itemStack.func_77973_b()).getTier(itemStack), true, simulate);
            }
            return amount_EU;
        }
        return 0.0;
    }

    @Optional.Method(modid="gregtech")
    private static boolean GT_isEnergyContainer(ItemStack itemStack) {
        return itemStack.hasCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
    }

    @Optional.Method(modid="gregtech")
    private static boolean GT_canOutput(ItemStack itemStack) {
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        assert (electricItem != null);
        return electricItem.canProvideChargeExternally();
    }

    @Optional.Method(modid="gregtech")
    private static boolean GT_canInput(ItemStack itemStack) {
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        assert (electricItem != null);
        return electricItem.canUse(1L);
    }

    @Optional.Method(modid="gregtech")
    private static long GT_getEnergyStored(ItemStack itemStack) {
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        assert (electricItem != null);
        return electricItem.discharge(Integer.MAX_VALUE, Integer.MAX_VALUE, true, true, true);
    }

    @Optional.Method(modid="gregtech")
    private static long GT_getMaxEnergyStorage(ItemStack itemStack) {
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        assert (electricItem != null);
        return electricItem.getMaxCharge();
    }

    @Optional.Method(modid="gregtech")
    private static long GT_consume(ItemStack itemStack, long amount_EU, boolean simulate) {
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        assert (electricItem != null);
        return electricItem.discharge(amount_EU, Integer.MAX_VALUE, true, true, simulate);
    }

    @Optional.Method(modid="gregtech")
    private static long GT_charge(ItemStack itemStack, long amount_EU, boolean simulate) {
        IElectricItem electricItem = (IElectricItem)itemStack.getCapability(GregtechCapabilities.CAPABILITY_ELECTRIC_ITEM, null);
        assert (electricItem != null);
        return electricItem.charge(amount_EU, Integer.MAX_VALUE, true, simulate);
    }

    @Optional.Method(modid="redstoneflux")
    private static boolean RF_isEnergyContainer(ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof IEnergyContainerItem;
    }

    @Optional.Method(modid="redstoneflux")
    private static boolean RF_canOutput(ItemStack itemStack) {
        return ((IEnergyContainerItem)itemStack.func_77973_b()).getEnergyStored(itemStack) > 0;
    }

    @Optional.Method(modid="redstoneflux")
    private static boolean RF_canInput(ItemStack itemStack) {
        return ((IEnergyContainerItem)itemStack.func_77973_b()).getEnergyStored(itemStack) < ((IEnergyContainerItem)itemStack.func_77973_b()).getMaxEnergyStored(itemStack);
    }

    @Optional.Method(modid="redstoneflux")
    private static int RF_getEnergyStored(ItemStack itemStack) {
        return (int)Math.floor(((IEnergyContainerItem)itemStack.func_77973_b()).getEnergyStored(itemStack));
    }

    @Optional.Method(modid="redstoneflux")
    private static int RF_getMaxEnergyStorage(ItemStack itemStack) {
        return (int)Math.floor(((IEnergyContainerItem)itemStack.func_77973_b()).getMaxEnergyStored(itemStack));
    }

    @Optional.Method(modid="redstoneflux")
    private static int RF_consume(ItemStack itemStack, int amount_RF, boolean simulate) {
        return ((IEnergyContainerItem)itemStack.func_77973_b()).extractEnergy(itemStack, amount_RF, simulate);
    }

    @Optional.Method(modid="redstoneflux")
    private static int RF_charge(ItemStack itemStack, int amount_RF, boolean simulate) {
        return ((IEnergyContainerItem)itemStack.func_77973_b()).receiveEnergy(itemStack, amount_RF, simulate);
    }

    private static boolean FE_isEnergyContainer(ItemStack itemStack) {
        return itemStack.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    private static boolean FE_canOutput(ItemStack itemStack) {
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
        assert (energyStorage != null);
        return energyStorage.canExtract();
    }

    private static boolean FE_canInput(ItemStack itemStack) {
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
        assert (energyStorage != null);
        return energyStorage.canReceive();
    }

    private static int FE_getEnergyStored(ItemStack itemStack) {
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
        assert (energyStorage != null);
        return (int)Math.floor(energyStorage.getEnergyStored());
    }

    private static int FE_getMaxEnergyStorage(ItemStack itemStack) {
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
        assert (energyStorage != null);
        return (int)Math.floor(energyStorage.getMaxEnergyStored());
    }

    private static int FE_consume(ItemStack itemStack, int amount_RF, boolean simulate) {
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
        assert (energyStorage != null);
        return energyStorage.extractEnergy(amount_RF, simulate);
    }

    private static int FE_charge(ItemStack itemStack, int amount_RF, boolean simulate) {
        IEnergyStorage energyStorage = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
        assert (energyStorage != null);
        return energyStorage.receiveEnergy(amount_RF, simulate);
    }
}

