/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.Commons;
import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IForceFieldShape;
import cr0s.warpdrive.config.WarpDriveConfig;
import cr0s.warpdrive.data.ForceFieldSetup;
import cr0s.warpdrive.data.VectorI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.util.IStringSerializable;

public enum EnumForceFieldShape implements IStringSerializable,
IForceFieldShape
{
    NONE("none"),
    SPHERE("sphere"),
    CYLINDER_H("cylinder_h"),
    CYLINDER_V("cylinder_v"),
    CUBE("cube"),
    PLANE("plane"),
    TUBE("tube"),
    TUNNEL("tunnel");

    private final String name;
    public static final int length;
    private static final HashMap<Integer, EnumForceFieldShape> ID_MAP;

    private EnumForceFieldShape(String name) {
        this.name = name;
    }

    public static EnumForceFieldShape get(int damage) {
        return ID_MAP.get(damage);
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    @Override
    public Map<VectorI, Boolean> getVertexes(ForceFieldSetup forceFieldSetup) {
        int sizeEstimation;
        VectorI vScale = forceFieldSetup.vMax.clone().translateBack(forceFieldSetup.vMin);
        boolean isFusionOrInverted = forceFieldSetup.hasFusion || forceFieldSetup.isInverted;
        float thickness = Commons.clamp(1.0f, 2.0f, forceFieldSetup.thickness);
        if (!isFusionOrInverted) {
            int maxRadius = (int)Math.ceil((float)Math.max(vScale.x, Math.max(vScale.y, vScale.z)) / 2.0f);
            switch (this) {
                case SPHERE: {
                    sizeEstimation = (int)Math.ceil((double)(thickness * 4.0f) * Math.PI * (double)maxRadius * (double)(maxRadius + 1));
                    break;
                }
                case CYLINDER_H: 
                case CYLINDER_V: 
                case TUBE: {
                    sizeEstimation = (int)Math.ceil((double)(thickness * 4.0f) * Math.PI * (double)(maxRadius + 2) * (double)(maxRadius + 2));
                    break;
                }
                case CUBE: {
                    sizeEstimation = (int)Math.ceil((int)thickness * 6 * (2 * maxRadius) * (2 * maxRadius + 1));
                    break;
                }
                case TUNNEL: {
                    sizeEstimation = (int)Math.ceil((int)thickness * 4 * (2 * maxRadius) * (2 * maxRadius + 1));
                    break;
                }
                case PLANE: {
                    sizeEstimation = (int)Math.ceil((int)thickness * 2 * (2 * maxRadius + 1) * (2 * maxRadius + 1));
                    break;
                }
                default: {
                    sizeEstimation = 8;
                    WarpDrive.logger.error(String.format("Invalid object %s for shape %s with size %s. Please report this to the mod author", this, this.name, vScale));
                    break;
                }
            }
        } else {
            sizeEstimation = (vScale.x + 1) * (vScale.y + 1) * (vScale.z + 1);
        }
        HashMap<VectorI, Boolean> mapVertexes = new HashMap<VectorI, Boolean>(sizeEstimation);
        float halfThickness = forceFieldSetup.thickness / 2.0f;
        switch (this) {
            case SPHERE: {
                float radius = forceFieldSetup.vMax.y;
                float radiusInterior2 = (radius - halfThickness) * (radius - halfThickness);
                float radiusPerimeter2 = (radius + halfThickness) * (radius + halfThickness);
                VectorI vCenter = new VectorI(0, 0, 0);
                for (int y = forceFieldSetup.vMin.y; y <= forceFieldSetup.vMax.y; ++y) {
                    int y2 = (y - vCenter.y) * (y - vCenter.y);
                    for (int x = forceFieldSetup.vMin.x; x <= forceFieldSetup.vMax.x; ++x) {
                        int x2 = (x - vCenter.x) * (x - vCenter.x);
                        for (int z = forceFieldSetup.vMin.z; z <= forceFieldSetup.vMax.z; ++z) {
                            boolean isPerimeter;
                            int z2 = (z - vCenter.z) * (z - vCenter.z);
                            if (!((float)(x2 + y2 + z2) <= radiusPerimeter2)) continue;
                            boolean bl = isPerimeter = (float)(x2 + y2 + z2) >= radiusInterior2;
                            if (!isPerimeter && !isFusionOrInverted) continue;
                            mapVertexes.put(new VectorI(x, y, z), isPerimeter);
                        }
                    }
                }
                break;
            }
            case CYLINDER_H: {
                float radius = (float)(forceFieldSetup.vMax.y + forceFieldSetup.vMax.z) / 2.0f;
                float radiusInterior2 = (radius - halfThickness) * (radius - halfThickness);
                float radiusPerimeter2 = (radius + halfThickness) * (radius + halfThickness);
                VectorI vCenter = new VectorI(0, 0, 0);
                for (int y = forceFieldSetup.vMin.y; y <= forceFieldSetup.vMax.y; ++y) {
                    int y2 = (y - vCenter.y) * (y - vCenter.y);
                    for (int z = forceFieldSetup.vMin.z; z <= forceFieldSetup.vMax.z; ++z) {
                        boolean isPerimeter;
                        int z2 = (z - vCenter.z) * (z - vCenter.z);
                        if (!((float)(y2 + z2) <= radiusPerimeter2)) continue;
                        boolean bl = isPerimeter = (float)(y2 + z2) >= radiusInterior2;
                        if (!isPerimeter && !isFusionOrInverted) continue;
                        for (int x = forceFieldSetup.vMin.x; x <= forceFieldSetup.vMax.x; ++x) {
                            mapVertexes.put(new VectorI(x, y, z), isPerimeter);
                        }
                    }
                }
                break;
            }
            case CYLINDER_V: {
                float radius = (float)(forceFieldSetup.vMax.x + forceFieldSetup.vMax.y) / 2.0f;
                float radiusInterior2 = (radius - halfThickness) * (radius - halfThickness);
                float radiusPerimeter2 = (radius + halfThickness) * (radius + halfThickness);
                VectorI vCenter = new VectorI(0, 0, 0);
                for (int x = forceFieldSetup.vMin.x; x <= forceFieldSetup.vMax.x; ++x) {
                    int x2 = (x - vCenter.x) * (x - vCenter.x);
                    for (int y = forceFieldSetup.vMin.y; y <= forceFieldSetup.vMax.y; ++y) {
                        boolean isPerimeter;
                        int y2 = (y - vCenter.y) * (y - vCenter.y);
                        if (!((float)(x2 + y2) <= radiusPerimeter2)) continue;
                        boolean bl = isPerimeter = (float)(x2 + y2) >= radiusInterior2;
                        if (!isPerimeter && !isFusionOrInverted) continue;
                        for (int z = forceFieldSetup.vMin.z; z <= forceFieldSetup.vMax.z; ++z) {
                            mapVertexes.put(new VectorI(x, y, z), isPerimeter);
                        }
                    }
                }
                break;
            }
            case TUBE: {
                float radius = (float)(forceFieldSetup.vMax.x + forceFieldSetup.vMax.z) / 2.0f;
                float radiusInterior2 = (radius - halfThickness) * (radius - halfThickness);
                float radiusPerimeter2 = (radius + halfThickness) * (radius + halfThickness);
                VectorI vCenter = new VectorI(0, 0, 0);
                for (int x = forceFieldSetup.vMin.x; x <= forceFieldSetup.vMax.x; ++x) {
                    int x2 = (x - vCenter.x) * (x - vCenter.x);
                    for (int z = forceFieldSetup.vMin.z; z <= forceFieldSetup.vMax.z; ++z) {
                        boolean isPerimeter;
                        int z2 = (z - vCenter.z) * (z - vCenter.z);
                        if (!((float)(x2 + z2) <= radiusPerimeter2)) continue;
                        boolean bl = isPerimeter = (float)(x2 + z2) >= radiusInterior2;
                        if (!isPerimeter && !isFusionOrInverted) continue;
                        for (int y = forceFieldSetup.vMin.y; y <= forceFieldSetup.vMax.y; ++y) {
                            mapVertexes.put(new VectorI(x, y, z), isPerimeter);
                        }
                    }
                }
                break;
            }
            case CUBE: {
                for (int y = forceFieldSetup.vMin.y; y <= forceFieldSetup.vMax.y; ++y) {
                    boolean yFace = (float)Math.abs(y - forceFieldSetup.vMin.y) <= halfThickness || (float)Math.abs(y - forceFieldSetup.vMax.y) <= halfThickness;
                    for (int x = forceFieldSetup.vMin.x; x <= forceFieldSetup.vMax.x; ++x) {
                        boolean xFace = (float)Math.abs(x - forceFieldSetup.vMin.x) <= halfThickness || (float)Math.abs(x - forceFieldSetup.vMax.x) <= halfThickness;
                        for (int z = forceFieldSetup.vMin.z; z <= forceFieldSetup.vMax.z; ++z) {
                            boolean isPerimeter;
                            boolean zFace = (float)Math.abs(z - forceFieldSetup.vMin.z) <= halfThickness || (float)Math.abs(z - forceFieldSetup.vMax.z) <= halfThickness;
                            boolean bl = isPerimeter = xFace || yFace || zFace;
                            if (!isPerimeter && !isFusionOrInverted) continue;
                            mapVertexes.put(new VectorI(x, y, z), isPerimeter);
                        }
                    }
                }
                break;
            }
            case PLANE: {
                for (int y = forceFieldSetup.vMin.y; y <= forceFieldSetup.vMax.y; ++y) {
                    boolean isPerimeter;
                    boolean bl = isPerimeter = (float)Math.abs(y - forceFieldSetup.vMin.y) <= halfThickness || (float)Math.abs(y - forceFieldSetup.vMax.y) <= halfThickness;
                    if (!isPerimeter && !isFusionOrInverted) continue;
                    for (int x = forceFieldSetup.vMin.x; x <= forceFieldSetup.vMax.x; ++x) {
                        for (int z = forceFieldSetup.vMin.z; z <= forceFieldSetup.vMax.z; ++z) {
                            mapVertexes.put(new VectorI(x, y, z), isPerimeter);
                        }
                    }
                }
                break;
            }
            case TUNNEL: {
                for (int y = forceFieldSetup.vMin.y; y <= forceFieldSetup.vMax.y; ++y) {
                    for (int x = forceFieldSetup.vMin.x; x <= forceFieldSetup.vMax.x; ++x) {
                        boolean xFace = (float)Math.abs(x - forceFieldSetup.vMin.x) <= halfThickness || (float)Math.abs(x - forceFieldSetup.vMax.x) <= halfThickness;
                        for (int z = forceFieldSetup.vMin.z; z <= forceFieldSetup.vMax.z; ++z) {
                            boolean isPerimeter;
                            boolean bl = isPerimeter = xFace || (float)Math.abs(z - forceFieldSetup.vMin.z) <= halfThickness || (float)Math.abs(z - forceFieldSetup.vMax.z) <= halfThickness;
                            if (!isPerimeter && !isFusionOrInverted) continue;
                            mapVertexes.put(new VectorI(x, y, z), isPerimeter);
                        }
                    }
                }
                break;
            }
        }
        if (mapVertexes.size() > sizeEstimation) {
            WarpDrive.logger.warn(String.format("Underestimated memory allocation lag %d > %d for shape %s with size %s, isFusionOrInverted %s, thickness %.2f. Please report this to the mod author", mapVertexes.size(), sizeEstimation, this.name, vScale, isFusionOrInverted, Float.valueOf(forceFieldSetup.thickness)));
        } else if (WarpDriveConfig.LOGGING_PROFILING_MEMORY_ALLOCATION) {
            if ((double)mapVertexes.size() * 1.25 < (double)sizeEstimation) {
                WarpDrive.logger.warn(String.format("Overestimated memory allocation %d < %d for shape %s with size %s, isFusionOrInverted %s, thickness %.2f. Please report this to the mod author", mapVertexes.size(), sizeEstimation, this.name, vScale, isFusionOrInverted, Float.valueOf(forceFieldSetup.thickness)));
            } else {
                WarpDrive.logger.warn(String.format("Memory allocation is good: %d vs %d for shape %s with size %s, isFusionOrInverted %s, thickness %.2f. Please report this to the mod author", mapVertexes.size(), sizeEstimation, this.name, vScale, isFusionOrInverted, Float.valueOf(forceFieldSetup.thickness)));
            }
        }
        return mapVertexes;
    }

    static {
        ID_MAP = new HashMap();
        length = EnumForceFieldShape.values().length;
        for (EnumForceFieldShape forceFieldShape : EnumForceFieldShape.values()) {
            ID_MAP.put(forceFieldShape.ordinal(), forceFieldShape);
        }
    }
}

