/*
 * Decompiled with CFR 0.152.
 */
package cr0s.warpdrive.data;

import cr0s.warpdrive.WarpDrive;
import cr0s.warpdrive.api.IForceFieldUpgrade;
import cr0s.warpdrive.api.IForceFieldUpgradeEffector;
import cr0s.warpdrive.block.TileEntityAbstractBase;
import cr0s.warpdrive.data.Vector3;
import cr0s.warpdrive.item.ItemForceFieldUpgrade;
import cr0s.warpdrive.network.PacketHandler;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityGolem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class EnumForceFieldUpgrade
extends Enum<EnumForceFieldUpgrade>
implements IStringSerializable,
IForceFieldUpgrade,
IForceFieldUpgradeEffector {
    public static final /* enum */ EnumForceFieldUpgrade NONE = new EnumForceFieldUpgrade("none", 0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, "n/a");
    public static final /* enum */ EnumForceFieldUpgrade ATTRACTION = new EnumForceFieldUpgrade("attraction", 0, 1, 1.0f, 4.0f, 0.0f, 0.0f, 0.0f, 0.0f, 50.0f, 0.15f, 0.0f, 8.0f, "value is acceleration");
    public static final /* enum */ EnumForceFieldUpgrade BREAKING = new EnumForceFieldUpgrade("breaking", 0, 1, 1.0f, 25.0f, 0.4f, 0.5f, 0.02f, 0.15f, 700.0f, 0.08f, 4.0f, 0.0f, "value is hardness level");
    public static final /* enum */ EnumForceFieldUpgrade CAMOUFLAGE = new EnumForceFieldUpgrade("camouflage", 0, 1, 1.0f, 3.0f, 0.6f, 0.85f, 0.7f, 0.95f, 1000.0f, 3.0f, 7.0f, 0.0f, "value is boolean");
    public static final /* enum */ EnumForceFieldUpgrade COOLING = new EnumForceFieldUpgrade("cooling", 3, 1, 30.0f, 300.0f, 0.0f, 0.0f, 0.9f, 0.9f, 150.0f, 0.06f, 1.5f, 40.0f, "value is heat units");
    public static final /* enum */ EnumForceFieldUpgrade FUSION = new EnumForceFieldUpgrade("fusion", 1, 1, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1000.0f, 0.04f, 0.15f, 0.0f, "value is boolean");
    public static final /* enum */ EnumForceFieldUpgrade HEATING = new EnumForceFieldUpgrade("heating", 3, 1, 100.0f, 10000.0f, 0.0f, 0.0f, 0.9f, 0.9f, 150.0f, 0.3f, 3.0f, 25.0f, "value is heat units");
    public static final /* enum */ EnumForceFieldUpgrade INVERSION = new EnumForceFieldUpgrade("inversion", 1, 0, 1.0f, 1.0f, 1.25f, 1.25f, 0.0f, 0.0f, 1500.0f, 0.15f, 0.15f, 20.0f, "value is boolean");
    public static final /* enum */ EnumForceFieldUpgrade ITEM_PORT = new EnumForceFieldUpgrade("item_port", 0, 1, 1.0f, 10.0f, 0.0f, 0.0f, 0.95f, 0.9f, 50.0f, 0.12f, 0.5f, 2.0f, "value is boolean");
    public static final /* enum */ EnumForceFieldUpgrade PUMPING = new EnumForceFieldUpgrade("pumping", 0, 1, 2500.0f, 50000.0f, 0.8f, 1.0f, 0.4f, 1.0f, 800.0f, 0.15f, 4.5f, 0.0f, "value is viscosity");
    public static final /* enum */ EnumForceFieldUpgrade RANGE = new EnumForceFieldUpgrade("range", 4, 1, 8.0f, 128.0f, 1.15f, 0.45f, 1.15f, 0.45f, 10.0f, 0.3f, 0.75f, 12.0f, "value is bonus blocks");
    public static final /* enum */ EnumForceFieldUpgrade REPULSION = new EnumForceFieldUpgrade("repulsion", 0, 1, 1.0f, 4.0f, 0.0f, 0.0f, 0.0f, 0.0f, 50.0f, 0.15f, 0.0f, 5.0f, "value is acceleration");
    public static final /* enum */ EnumForceFieldUpgrade ROTATION = new EnumForceFieldUpgrade("rotation", 1, 0, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 100.0f, 0.0f, 0.0f, 0.0f, "value is boolean");
    public static final /* enum */ EnumForceFieldUpgrade SHOCK = new EnumForceFieldUpgrade("shock", 3, 1, 1.0f, 10.0f, 0.8f, 0.8f, 0.8f, 0.8f, 300.0f, 0.6f, 4.0f, 30.0f, "value is damage points");
    public static final /* enum */ EnumForceFieldUpgrade SILENCER = new EnumForceFieldUpgrade("silencer", 1, 0, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.12f, 0.62f, 0.0f, "value is boolean");
    public static final /* enum */ EnumForceFieldUpgrade SPEED = new EnumForceFieldUpgrade("speed", 4, 1, 1.0f, 20.0f, 1.25f, 6.0f, 1.2f, 5.0f, 200.0f, 0.135f, 1.25f, 15.0f, "value is not used (just a counter)");
    public static final /* enum */ EnumForceFieldUpgrade STABILIZATION = new EnumForceFieldUpgrade("stabilization", 0, 1, 1.0f, 9.0f, 0.25f, 0.85f, 0.025f, 0.45f, 400.0f, 0.05f, 73.6f, 0.0f, "value is boolean");
    public static final /* enum */ EnumForceFieldUpgrade THICKNESS = new EnumForceFieldUpgrade("thickness", 5, 1, 0.2f, 1.0f, 0.8f, 1.6f, 0.9f, 1.5f, 100.0f, 0.4f, 2.2f, 5.0f, "value is bonus ratio");
    public static final /* enum */ EnumForceFieldUpgrade TRANSLATION = new EnumForceFieldUpgrade("translation", 1, 0, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 100.0f, 0.0f, 0.0f, 0.0f, "value is boolean");
    private final String name;
    public final int maxCountOnProjector;
    public final int maxCountOnRelay;
    private final float upgradeValue;
    private final float upgradeValueMax;
    private final float scanSpeedOffset;
    private final float scanSpeedSlope;
    private final float placeSpeedOffset;
    private final float placeSpeedSlope;
    private final float startupEnergyCost;
    private final float scanEnergyCost;
    private final float placeEnergyCost;
    private final float entityEffectEnergyCost;
    private TileEntityAbstractBase.UpgradeSlot upgradeSlotProjector = null;
    private TileEntityAbstractBase.UpgradeSlot upgradeSlotRelay = null;
    public static final int length;
    private static final HashMap<Integer, EnumForceFieldUpgrade> ID_MAP;
    private static final /* synthetic */ EnumForceFieldUpgrade[] $VALUES;

    public static EnumForceFieldUpgrade[] values() {
        return (EnumForceFieldUpgrade[])$VALUES.clone();
    }

    public static EnumForceFieldUpgrade valueOf(String name) {
        return Enum.valueOf(EnumForceFieldUpgrade.class, name);
    }

    private EnumForceFieldUpgrade(String name, int allowOnProjector, int maxCountOnRelay, float upgradeValue, float upgradeValueMax, float scanSpeedMinimum, float scanSpeedMaximum, float placeSpeedMinimum, float placeSpeedMaximum, float startupEnergyCost, float scanEnergyCost, float placeEnergyCost, float entityEffectEnergyCost, String comment) {
        this.name = name;
        this.maxCountOnProjector = allowOnProjector;
        this.maxCountOnRelay = maxCountOnRelay;
        this.upgradeValue = upgradeValue;
        this.upgradeValueMax = upgradeValueMax;
        this.scanSpeedSlope = upgradeValueMax == upgradeValue ? 0.0f : (scanSpeedMaximum - scanSpeedMinimum) / (upgradeValueMax - upgradeValue);
        this.scanSpeedOffset = scanSpeedMinimum - this.scanSpeedSlope * upgradeValue;
        this.placeSpeedSlope = upgradeValueMax == upgradeValue ? 0.0f : (placeSpeedMaximum - placeSpeedMinimum) / (upgradeValueMax - upgradeValue);
        this.placeSpeedOffset = placeSpeedMinimum - this.placeSpeedSlope * upgradeValue;
        this.startupEnergyCost = startupEnergyCost / (upgradeValue != 0.0f ? upgradeValue : 1.0f);
        this.scanEnergyCost = scanEnergyCost / (upgradeValue != 0.0f ? upgradeValue : 1.0f);
        this.placeEnergyCost = placeEnergyCost / (upgradeValue != 0.0f ? upgradeValue : 1.0f);
        this.entityEffectEnergyCost = entityEffectEnergyCost / (upgradeValue != 0.0f ? upgradeValue : 1.0f);
        assert (!comment.isEmpty());
    }

    @Nonnull
    public static EnumForceFieldUpgrade get(int damage) {
        EnumForceFieldUpgrade enumForceFieldUpgrade = ID_MAP.get(damage);
        return enumForceFieldUpgrade == null ? NONE : enumForceFieldUpgrade;
    }

    @Nonnull
    public String func_176610_l() {
        return this.name;
    }

    @Nullable
    public TileEntityAbstractBase.UpgradeSlot getProjectorUpgradeSlot() {
        if (this.upgradeSlotProjector == null) {
            this.upgradeSlotProjector = this.maxCountOnProjector == 0 ? null : new TileEntityAbstractBase.UpgradeSlot("force_field." + this.name, ItemForceFieldUpgrade.getItemStackNoCache(this, 1), this.maxCountOnProjector);
        }
        return this.upgradeSlotProjector;
    }

    @Nullable
    public TileEntityAbstractBase.UpgradeSlot getRelayUpgradeSlot() {
        if (this.upgradeSlotRelay == null) {
            this.upgradeSlotRelay = this.maxCountOnRelay == 0 ? null : new TileEntityAbstractBase.UpgradeSlot("force_field." + this.name, ItemForceFieldUpgrade.getItemStackNoCache(this, 1), this.maxCountOnRelay);
        }
        return this.upgradeSlotRelay;
    }

    @Override
    public IForceFieldUpgradeEffector getUpgradeEffector(Object container) {
        return this;
    }

    @Override
    public float getUpgradeValue(Object container) {
        return this.upgradeValue;
    }

    @Override
    public float getScaledValue(float ratio, float upgradeValue) {
        return ratio * Math.min(this.upgradeValueMax, upgradeValue);
    }

    @Override
    public float getScanSpeedFactor(float scaledValue) {
        return this.scanSpeedOffset + this.scanSpeedSlope * scaledValue;
    }

    @Override
    public float getPlaceSpeedFactor(float scaledValue) {
        return this.placeSpeedOffset + this.placeSpeedSlope * scaledValue;
    }

    @Override
    public float getStartupEnergyCost(float scaledValue) {
        return this.startupEnergyCost * scaledValue;
    }

    @Override
    public float getScanEnergyCost(float scaledValue) {
        return this.scanEnergyCost * scaledValue;
    }

    @Override
    public float getPlaceEnergyCost(float scaledValue) {
        return this.placeEnergyCost * scaledValue;
    }

    @Override
    public float getEntityEffectEnergyCost(float scaledValue) {
        return this.entityEffectEnergyCost * scaledValue;
    }

    @Override
    public int onEntityEffect(float scaledValue, World world, int projectorX, int projectorY, int projectorZ, BlockPos blockPos, Entity entity) {
        if (scaledValue == 0.0f) {
            return 0;
        }
        Vector3 v3Projector = new Vector3((double)projectorX + 0.5, (double)projectorY + 0.5, (double)projectorZ + 0.5);
        double distanceCollision = v3Projector.distanceTo_square(new Vector3((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5));
        double distanceEntity = v3Projector.distanceTo_square(entity);
        Vector3 v3Entity = new Vector3(entity);
        Vector3 v3Direction = new Vector3(entity).subtract(v3Projector).normalize();
        v3Projector.translateFactor(v3Direction, 0.6);
        v3Entity.translateFactor(v3Direction, -0.6);
        int entityLevel = 0;
        if (!entity.field_70128_L) {
            if (entity instanceof EntityPlayer) {
                entityLevel = 4;
            } else if (entity instanceof EntityMob || entity instanceof EntityGolem || entity instanceof EntityFireball || entity instanceof EntityTNTPrimed || entity instanceof EntityThrowable || entity instanceof EntityMinecart) {
                entityLevel = 3;
            } else if (entity instanceof EntityLivingBase || entity instanceof EntityXPOrb || entity instanceof EntityBoat) {
                entityLevel = 2;
            } else if (entity instanceof EntityItem || entity instanceof EntityArrow || entity instanceof EntityFallingBlock || entity instanceof EntityFireworkRocket) {
                entityLevel = 1;
            }
        }
        double speed = (double)(Math.abs(scaledValue) / (float)(entityLevel == 0 ? 2 : entityLevel)) * 0.16;
        Vector3 v3Motion = v3Direction.clone().scale(speed);
        switch (this) {
            case ATTRACTION: {
                if (scaledValue <= 0.1f || (float)entityLevel > scaledValue) {
                    return 0;
                }
                v3Motion.invert();
                entity.field_70143_R = 0.0f;
                entity.func_70024_g(v3Motion.x, v3Motion.y, v3Motion.z);
                if (distanceCollision <= distanceEntity) {
                    if (entity instanceof EntityLivingBase) {
                        entity.func_70634_a(entity.field_70165_t - v3Direction.x * 2.0, entity.field_70163_u - v3Direction.y * 2.0, entity.field_70161_v - v3Direction.z * 2.0);
                    } else {
                        entity.func_70107_b(entity.field_70165_t - v3Direction.x * 2.0, entity.field_70163_u - v3Direction.y * 2.0, entity.field_70161_v - v3Direction.z * 2.0);
                    }
                    v3Entity.translateFactor(v3Direction, 2.0);
                } else if (entity instanceof EntityPlayer) {
                    entity.func_70634_a(entity.field_70165_t - v3Direction.x * 0.4, entity.field_70163_u - v3Direction.y * 0.4, entity.field_70161_v - v3Direction.z * 0.4);
                }
                PacketHandler.sendBeamPacket(world, v3Entity, v3Projector, 0.2f, 0.4f, 0.7f, 10, 0, 50);
                return 10;
            }
            case REPULSION: {
                if (scaledValue >= -0.1f || (float)entityLevel > Math.abs(scaledValue)) {
                    return 0;
                }
                entity.field_70143_R = 0.0f;
                entity.func_70024_g(v3Motion.x, v3Motion.y, v3Motion.z);
                if (distanceCollision >= distanceEntity) {
                    if (entity instanceof EntityLivingBase) {
                        entity.func_70634_a(entity.field_70165_t + v3Direction.x * 2.0, entity.field_70163_u + v3Direction.y * 2.0, entity.field_70161_v + v3Direction.z * 2.0);
                    } else {
                        entity.func_70107_b(entity.field_70165_t + v3Direction.x * 2.0, entity.field_70163_u + v3Direction.y * 2.0, entity.field_70161_v + v3Direction.z * 2.0);
                    }
                    v3Entity.translateFactor(v3Direction, 2.0);
                } else if (entity instanceof EntityPlayer) {
                    entity.func_70634_a(entity.field_70165_t + v3Direction.x * 0.4, entity.field_70163_u + v3Direction.y * 0.4, entity.field_70161_v + v3Direction.z * 0.4);
                }
                PacketHandler.sendBeamPacket(world, v3Projector, v3Entity, 0.2f, 0.4f, 0.7f, 10, 0, 50);
                return 10;
            }
            case COOLING: {
                if (scaledValue >= 295.0f || !(entity instanceof EntityLivingBase) || entityLevel <= 0) {
                    return 0;
                }
                entity.func_70097_a((DamageSource)WarpDrive.damageCold, (300.0f - scaledValue) / 10.0f);
                v3Direction.scale(0.2);
                PacketHandler.sendBeamPacket(world, v3Projector, v3Entity, 0.25f, 0.38f, 0.75f, 10, 0, 50);
                PacketHandler.sendSpawnParticlePacket(world, "snowShovel", (byte)5, v3Entity, v3Direction, 0.2f + 0.1f * world.field_73012_v.nextFloat(), 0.25f + 0.25f * world.field_73012_v.nextFloat(), 0.6f + 0.3f * world.field_73012_v.nextFloat(), 0.0f, 0.0f, 0.0f, 32);
                return 10;
            }
            case HEATING: {
                if (scaledValue <= 305.0f || !(entity instanceof EntityLivingBase) || entityLevel <= 0) {
                    return 0;
                }
                if (!entity.func_70045_F()) {
                    entity.func_70015_d(1);
                }
                entity.func_70097_a((DamageSource)WarpDrive.damageWarm, (scaledValue - 300.0f) / 100.0f);
                v3Direction.scale(0.2);
                PacketHandler.sendBeamPacket(world, v3Projector, v3Entity, 0.95f, 0.52f, 0.38f, 10, 0, 50);
                PacketHandler.sendSpawnParticlePacket(world, "snowShovel", (byte)5, v3Entity, v3Direction, 0.9f + 0.1f * world.field_73012_v.nextFloat(), 0.35f + 0.25f * world.field_73012_v.nextFloat(), 0.3f + 0.15f * world.field_73012_v.nextFloat(), 0.0f, 0.0f, 0.0f, 32);
                return 10;
            }
            case SHOCK: {
                if (scaledValue <= 0.0f || !(entity instanceof EntityLivingBase) || entityLevel <= 0) {
                    return 0;
                }
                entity.func_70097_a((DamageSource)WarpDrive.damageShock, Math.abs(scaledValue));
                v3Direction.scale(0.15);
                PacketHandler.sendBeamPacket(world, v3Projector, v3Entity, 0.35f, 0.57f, 0.87f, 10, 0, 50);
                PacketHandler.sendSpawnParticlePacket(world, "fireworksSpark", (byte)5, v3Entity, v3Direction, 0.2f + 0.3f * world.field_73012_v.nextFloat(), 0.5f + 0.15f * world.field_73012_v.nextFloat(), 0.75f + 0.25f * world.field_73012_v.nextFloat(), 0.1f + 0.2f * world.field_73012_v.nextFloat(), 0.1f + 0.3f * world.field_73012_v.nextFloat(), 0.2f + 0.1f * world.field_73012_v.nextFloat(), 32);
                return 10;
            }
        }
        return 0;
    }

    static {
        $VALUES = new EnumForceFieldUpgrade[]{NONE, ATTRACTION, BREAKING, CAMOUFLAGE, COOLING, FUSION, HEATING, INVERSION, ITEM_PORT, PUMPING, RANGE, REPULSION, ROTATION, SHOCK, SILENCER, SPEED, STABILIZATION, THICKNESS, TRANSLATION};
        ID_MAP = new HashMap();
        length = EnumForceFieldUpgrade.values().length;
        for (EnumForceFieldUpgrade forceFieldUpgrade : EnumForceFieldUpgrade.values()) {
            ID_MAP.put(forceFieldUpgrade.ordinal(), forceFieldUpgrade);
        }
    }
}

